#!/bin/bash


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -i|--instance)
        instance="$2"
        ;;

      -e|--enviroment)
        enviroment="$2"
        ;;

      -r|--restart)
        restart="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ----------------------   ------------   ------------------------------------------------------
 -i     | --instance                     каталог версия
 -e     | --enviroment    Production     устанавливаемое окружение:
                                           Production
                                           Staging
 -r     |                                перестартовать сервис

 Примеры вызова:

    ./wsks_set_enviroment.sh -i \"wsks-6.0.9_443\" -e \"Staging\" -r
    ./wsks_set_enviroment.sh -i \"wsks-6.0.9_443\" -e \"Production\"
    ./wsks_set_enviroment.sh --help
"
exit 1;
fi;

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[   ${SuccColor}OK${NoColor}   ] "
wOK="[  ${WarnColor}Инфо${NoColor}  ] "
eRR="[ ${ErrColor}Ошибка${NoColor} ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~                                          "
echo "           ~  WEB-Сервер-КС ${instance}               "
echo "           ~  установка окружения ${enviroment}       "
echo "           ~                                          "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"


if [ -z "${instance}" ]; then
  echo -e "${eRR}Не указан экземпляр WEB-Сервер-КС."
  echo -e "${emptE}Операция установки окружения будет прервана."
  echo -e ""
  exit 1;
fi;

if [ -z "${enviroment}" ]; then
  echo -e "${eRR}Не указан тип устанавливаемого окружения (параметр -e)."
  echo -e "${emptE}Операция установки окружения будет прервана."
  echo -e ""
  exit 1;
fi;

if [ ${enviroment} != "Production" ] && [ ${enviroment} != "Staging" ]; then
  echo -e "${eRR}Некорректный тип устанавливаемого окружения (параметр -e)."
  echo -e "${emptE}Доступные типы: Production, Staging"
  echo -e "${emptE}Операция установки окружения будет прервана."
  echo -e ""
  exit 1;
fi;


if ! [ -d "/opt/${instance}" ]; then
  echo -e "${eRR}Не найден каталог /opt/${instance} экземляра WEB-Сервер-КС."
  echo -e "${emptE}Операция установки окружения будет прервана."
  echo -e ""
  exit 1;
fi;

#
#
#  При установке окружения Staging, находим все установленные приложения и
#  создаем файл appsettings.Staging.json из appsettings.Production.json
#  в корень /opt/${instance} кладем файл информатор staging
#  в контейнере устанавливаем переменную окружения ASPNETCORE_ENVIRONMENT=Staging
#
#
#  При установке окружения Production, находим все установленные приложения
#  удаляем файлы - appsettings.Staging.json
#  из кореня /opt/${instance} удаляем файл информатор staging
#  в контейнере устанавливаем переменную окружения ASPNETCORE_ENVIRONMENT=Production
#
#

if [ -z "${restart}" ]; then
  restart="0"
fi;

dir_all_apps="/opt/${instance}/www/html"
dir_ctl_apps="/opt/${instance}/ctl"

contsoft=$(${dir_ctl_apps}/ws_const_var.sh      contsoft)
dks_cont_name=$(${dir_ctl_apps}/ws_const_var.sh dks_cont_name)
dks_serv_name="${dks_cont_name}.service"

# Проверка, что сервис, а следовательно контейнер запущены
if systemctl -q is-active ${dks_serv_name}; then

  for dir_app in `find ${dir_all_apps} -type d -name "wsks_*" | sort`
  do

    if [ ${enviroment} = "Staging" ]; then

      if ! [ -f "${dir_app}/appsettings.Staging.json" ]; then
        cp ${dir_app}/appsettings.Production.json  ${dir_app}/appsettings.Staging.json
        chown ks-www-data:ks-www-data ${dir_app}/appsettings.Staging.json
      fi;
    fi;

#    if [ ${enviroment} = "Production" ]; then
#      if [ -f "${dir_app}/appsettings.Staging.json" ]; then
#        rm ${dir_app}/appsettings.Staging.json
#      fi;
#    fi;

    echo -e "${sOK}Обработка каталога ${dir_app}."

  done;

  # создаем файл-информатор
  if [ ${enviroment} = "Staging" ]; then
    if ! [ -f "/opt/${instance}/staging" ]; then
      touch /opt/${instance}/staging
    fi;
  fi;

  # удаляем файл информатор
  if [ ${enviroment} = "Production" ]; then
    if [ -f "/opt/${instance}/staging" ]; then
      rm /opt/${instance}/staging
    fi;
  fi;

  # Установка + перестарт

  if [ "${restart}" == "1" ]; then

    set_enviroment_cmd="sed -i '/ASPNETCORE_ENVIRONMENT/d' /root/.bashrc"
    bash ${dir_ctl_apps}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${set_enviroment_cmd}" -noout

    set_enviroment_cmd="echo 'export ASPNETCORE_ENVIRONMENT="${enviroment}"' >> /root/.bashrc"
    bash ${dir_ctl_apps}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${set_enviroment_cmd}" -noout


    echo -e "${sOK}Экспорт ${set_enviroment_cmd} в контейнер."


    systemctl restart ${dks_serv_name}
    echo -e "${sOK}Рестарт сервиса ${dks_serv_name}."
  fi;

  echo ""

else

  echo -e "${eRR}Сервис ${dks_serv_name} не запущен."
  echo -e "${emptE}Операция установки окружения будет прервана."
  echo ""
  exit 1;

fi;

exit 0;
