#!/bin/bash

# Проверяем, что скрипт запущен с правами суперпользователя
if [ "$EUID" -ne 0 ]; then
   echo "Этот скрипт должен быть запущен с правами суперпользователя." 
   exit 1
fi

# Имя нового пользователя
USERNAME=$1
PUBLICKEY=$2

# Проверка наличия аргумента с именем пользователя
if [ -z "$USERNAME" ]; then
    echo "Необходимо указать имя пользователя как первый аргумент."
    exit 1
fi

# Проверка существования пользователя
if ! id "$USERNAME" &>/dev/null; then
    # Создание нового пользователя, если он не существует
    useradd -m -s /bin/bash $USERNAME
fi

# Создание каталога .ssh и установка прав доступа
mkdir -p /home/"$USERNAME"/.ssh && chown "$USERNAME":"$USERNAME" /home/"$USERNAME"/.ssh && chmod 700 /home/"$USERNAME"/.ssh

# Копирование открытого ключа в файл authorized_keys
echo "$PUBLICKEY" >> /home/$USERNAME/.ssh/authorized_keys

# Установка прав доступа к файлу authorized_keys
sudo chmod 600 /home/$USERNAME/.ssh/authorized_keys
sudo chown $USERNAME:$USERNAME /home/$USERNAME/.ssh/authorized_keys

# Разрешаем SSH-авторизацию по сертификату в файле sshdconfig
sed -i 's/#AuthorizedKeysFile/AuthorizedKeysFile/' /etc/ssh/sshd_config

# Добавление пользователя в sudoers без пароля (осторожно, это может быть небезопасно)
echo "$USERNAME ALL=(ALL:ALL) NOPASSWD:ALL" | sudo tee /etc/sudoers.d/$USERNAME

# Перезапуск службы SSH для применения настроек
sudo systemctl restart sshd