﻿# Скрипт создания файла appsettings.Production.json
Write-Host "Создание файла конфига appsettings.Production.json" -ForegroundColor Green
Write-Host ""

# Проверка существования файла
if (Test-Path "appsettings.Production.json") {
    $overwrite = Read-Host "Файл appsettings.Production.json уже существует. Перезаписать? (y/n)"
    if ($overwrite -ne "y" -and $overwrite -ne "Y") {
        Write-Host "Операция отменена." -ForegroundColor Red
        pause
        exit 1
    }
    Write-Host ""
}

Write-Host "Генерация секретного ключа" -ForegroundColor Yellow
Write-Host ""

# Генерация секретного ключа
$bytes = New-Object byte[] 32
[Security.Cryptography.RandomNumberGenerator]::Create().GetBytes($bytes)
$SECRET_KEY = [Convert]::ToBase64String($bytes)

Write-Host "Сгенерированный ключ: $SECRET_KEY" -ForegroundColor Yellow
Write-Host ""

Write-Host "Заполнение данных для обновлений" -ForegroundColor Green
Write-Host ""

# Ввод данных подключения к БД
$dataSourceType = Read-Host "Тип источника данных (0-MSSQL, 3-PGSQL)"
$server = Read-Host "Сервер (для PG указывать с портом)"
$database = Read-Host "База данных"
$userName = Read-Host "Имя пользователя"
$password = Read-Host "Пароль"

# Создание JSON содержимого
$jsonContent = @"
{
  "Serilog": {
    "MinimumLevel": {
      "Default": "Warning",
      "Override": {
        "Microsoft": "Warning",
        "Microsoft.Hosting.Lifetime": "Warning",
        "Microsoft.EntityFrameworkCore.Database.Command": "Warning"
      }
    },
    "WriteTo": [
      {
        "Name": "File",
        "Args": {
          "path": "./logs/log-.txt",
          "rollingInterval": "Day"
        }
      }
    ]
  },

  "SqlClient": {
    "DataSourceType": "",
    "Server": "",
    "DataBase": "",
    "UserName": "",
    "Password": ""
  },

  "Authentication": {
    "AuthenticationMethod": "0",
    "BuiltInJwtBearer": {
      "SecurityKey": "$SECRET_KEY"
    }
  },

  "SystemSettings": {
    "AlternativeUploadService_comment": "Сервис оправдательных документов (переопределяет значение из БД)",
    "AlternativeUploadService": ""
  },

  "AppUpdateSettings_comment": "Настройки для анонимного обновления из БД",
  "AppUpdateSettings": {
    "RequestsMaxCount_comment": "Максимальное число одновременных запросов к сервису для обновления из БД",
    "RequestsMaxCount": 20,

    "DataSourceType_comment": "0 - MSSQL, 3 - PGSQL",
    "DataSourceType": $dataSourceType,
    "Server": "$server",
    "DataBase": "$database",

    "UserName": "$userName",
    "Password": "$password"
  }
}
"@

# Сохранение файла
$jsonContent | Set-Content -Path "appsettings.Production.json" -Encoding UTF8

Write-Host "Настройки заданы. Файл appsettings.Production.json создан успешно!" -ForegroundColor Green
Write-Host ""
pause