﻿///<reference path="chrome-extension://cinbbhdcfmieecfcfbchhipanhahhonb/nmxcrypt_plugin_api.js"/>>
(function() {
    if (typeof (window.nm_xcrypt) !== 'undefined') return;

    function XCrypt_NM_Startup() {
        KS.apply(KS.XCrypt, {
            getXObj: function() {
                return window.chrome_nmxcrypt.CreatePluginObject();
            },

            getVersion: function(fn, scope) {
                chrome_nmxcrypt.async_spawn(function *() {
                    return yield KS.XCrypt.getXObj().GetVersion();
                }).then(fn.bind(scope));
            },

            selectCertificateInternal: function(fn, params) {
                chrome_nmxcrypt.async_spawn(function *() {
                    var ss = KS.XCrypt.signSettings;
                    return yield KS.XCrypt.getXObj().SelectCertificate(ss.nastrKeyId || '', params);
                }).then(fn);
            },

            signInternal: function(fn, text, cert, params, strParams) {
                chrome_nmxcrypt.async_spawn(function *() {
                    return yield KS.XCrypt.getXObj().Sign(text, cert, params, strParams);
                }).then(fn);
            },

            signFileWebInternal: function(fn, text, cert, params, strParams) {
                chrome_nmxcrypt.async_spawn(function *() {
                    return yield KS.XCrypt.getXObj().SignFileWeb(text, cert, params, strParams);
                }).then(fn);
            },

            downloadFileInternal: function(fn, url) {
                chrome_nmxcrypt.async_spawn(function *() {
                    return yield KS.XCrypt.getXObj().DownloadFile(url);
                }).then(fn);
            }
        });
    }

    KS.appendScript("chrome-extension://cinbbhdcfmieecfcfbchhipanhahhonb/nmxcrypt_plugin_api.js", XCrypt_NM_Startup);
})();