function Lavanda(p) {
    // >private
    var _self = this;



    var _setParams = function (options) {
        var updCount = 0;

        var newPort = options.port;
        var currentPort = _params.port;

        if (parseInt(newPort) && parseInt(currentPort) !== newPort) {
            _saveParams(_portParamName, newPort);
            updCount++;
        }

        var newWithLog = options.withLog;
        var currentWithLog = _params.withLog;

        if (typeof newWithLog === "boolean" && newWithLog.toString() !== currentWithLog) {
            _saveParams(_withLogParamName, newWithLog);
            updCount++;
        }

        if (updCount || options.forcedUpdate) {
            _updateParams();
        }
    };

    var _updateParams = function () {
        _params = _getParams();
        _start(_params);
    };

    _getParams = function () {
        return {
            port: _loadParams(_portParamName) || 9090,
            withLog: _loadParams(_withLogParamName) || (typeof DEBUG !== "undefined" && DEBUG)
        };
    };

    var
        _moduleName = "Keysystems.CryptoModule",
        _portParamName = "KSO_KCM_Port",
        _withLogParamName = "KSO_KCM_WithLog",


        _saveParams = (typeof p.saveParams === "function") ? p.saveParams : function (key, params) { },
        _loadParams = (typeof p.loadParams === "function") ? p.loadParams : function (key) { return {}; },
        _params = _getParams(),


        //_add = (p.add) ? p.add : [], // дополнения
        _add = [
            { name: "Mod", cons: lavandaMod, callM: _call },
            { name: "Npx", cons: lavandaNpx, callM: _callupd },
            { name: "Crypto", cons: lavandaCrypto, callM: _callupd }
        ],

        // метод, выводящий инструкцию по установке модуля, с колбеками продолжения выполнения команды, после установки, и отмены
        _install = (typeof p.install === "function") ? function (p2) {
            p.install({
                name: _moduleName,
                resume: p2.resume,
                cancel: p2.cancel,
                afterShow: p2.afterShow
            });
        } : function (p2) {
            alert("Выполнение команды неуспешно, возможно необходимо установить модуль. Установите и нажмите OK");
            if (confirm("Установили?")) {
                p2.resume();
            } else {
                p2.cancel();
            }
        },

        // метод, стартующий модуль
        _start = function () {
            var url = _moduleName + "://start?port=" + _params.port + ";withLog=" + _params.withLog;

            (typeof p.start === "function") ? p.start(url) : window.location = url;

            _log("start module");
        },

        _getServerVersion = (typeof p.getServerVersion === "function") ? p.getServerVersion : function (p) {
            p.onError("Метод получения версии на сервере не определен");
        },

        _sitePrefix = (typeof p.sitePrefix === "string") ? p.sitePrefix : "",

        // метод, выводящий сообщение пользователю
        // _showMsg = (typeof p.showMsg === "function") ? function (msg) {
        //     p.showMsg(msg);
        // } : function (msg) {
        //     alert(msg);
        // },

        // максимальное количество попыток выполнить команду, до вывода сообщения о необходимости установки модуля
        // хотя может и не нужны попытки, просто при неудаче стартуем модуль и пробуем еще один раз
        // _maxTrys = (typeof p.maxTrys === "number") ? p.maxTrys : 1,
        _maxTrys = 1;

    //_paramsStorageKey = "httpModuleParams"; // при нескольких экземплярах, что маловерятно, каждый будет перезаписывать чужие настройки, поэтому лучше снаружи настраивать ключ
    //delete p;

    var _log = function (msg) {
        console.log("[" + new Date().toTimeString().slice(0, 8) + "] " + _moduleName + "(" + _params.port + "): " + msg);
    };

    var _request = function (p) {
        var command = p.command,
            contentType = p.contentType,
            data = p.data,
            timeout = (typeof p.timeout === "number") ? p.timeout : 5000,
            onTimeout = (typeof p.onTimeout === "function") ? p.onTimeout : function () { },
            onProgress = (typeof p.onProgress === "function") ? p.onProgress : function () { },
            onLoad = (typeof p.onLoad === "function") ? p.onLoad : function () { },
            onError = (typeof p.onError === "function") ? p.onError : function () { };
        //delete p;

        if (_params.withLog) _log("request " + command);

        var xhr = ("onload" in new XMLHttpRequest()) ? new XMLHttpRequest : new XDomainRequest;
        //var xhr = new XHR();
        xhr.open("POST", "https://localhost:" + _params.port + "/" + command, true);

        xhr.timeout = timeout;

        var logClbk = function (fname, resp, pe) {
            _log("request " + command + ": " + fname + " [" + pe.loaded + " / " + pe.total + "] status=" + resp.status + " pe.type=" + pe.type);
        };

        // pe = ProgressEvent
        xhr.ontimeout = function (pe) {
            if (_params.withLog) logClbk("ontimeout", this, pe);
            onTimeout(this, pe);
        };
        xhr.onprogress = function (pe) {
            if (_params.withLog) logClbk("onprogress", this, pe);
            onProgress(this, pe);
        };
        xhr.onload = function (pe) {
            if (_params.withLog) logClbk("onload", this, pe);
            onLoad(this, pe);
        };
        xhr.onerror = function (pe) {
            if (_params.withLog) logClbk("onerror", this, pe);
            onError(this, pe);
        };

        if (contentType) {
            xhr.setRequestHeader("Content-type", contentType);
        }
        if (data) {
            xhr.send(data);
        } else {
            xhr.send();
        }
        //} else {
        //    xhr.setRequestHeader("Content-type", "application/json; charset=utf-8");
        //    xhr.send(JSON.stringify(data));
        //}
    };

    function _callupd(p) {
        var onError = (typeof p.onError === "function") ? function (msg) {
            p.onError(msg);
        } : function (msg) { _log(msg); };

        _checkAndUpdate({
            onSuccess: function () { _call(p); },
            onError: onError
        });
    }

    function _call(p) {

        var onError = (typeof p.onError === "function")
                ? function (msg) {
                    p.onError(msg);
                }
                : function (msg) { _log(msg); },
            notStart = (typeof p.notStart === "boolean") ? p.notStart : false;

        var closeInstallWindow = function () { };
        var cancel = false;
        var i = 0;

        function repeatTryCall() {
            if (i === 1) {
                _start(_params);
            } else if (i === 2) {
                _install({
                    resume: function () {
                        i = 0;
                    },
                    cancel: function () {
                        cancel = true;
                        _log("Отмена операции");
                    },
                    afterShow: function (asp) {
                        closeInstallWindow = asp.close;
                    }
                });
            }

            if (!cancel) {
                i++;
                setTimeout(function () { tryCall(); }, 1000);
            }
        }

        function tryCall() {
            //if (_params.withLog) _log("_request cmd " + i + " command=" + p.command);
            _request({
                command: p.command,
                contentType: p.contentType,
                data: p.data,
                timeout: (typeof p.timeout === "number") ? p.timeout : null,
                onTimeout: function (resp, pe) {
                    if (notStart) {
                        onError();
                    } else {
                        //_nextTry(i, cmd, "time is out", pe, onError);
                        repeatTryCall();
                    }
                },
                onProgress: (typeof p.onProgress === "function")
                    ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    }
                    : null,
                onLoad: (typeof p.onSuccess === "function")
                    ? function (response, progressevent) {
                        if (response.status !== 200) {
                            onError(response.status + " - " + response.error + " - " + response.responseText);
                            return;
                        }
                        closeInstallWindow();
                        p.onSuccess(response.response);
                    }
                    : null,
                onError: function (resp, pe) {
                    if (notStart) {
                        onError();
                    } else {
                        //_nextTry(i, cmd, resp.responseText, pe, onError);
                        repeatTryCall();
                    }
                }
            });
        }

        tryCall();
    }


    function _checkAndUpdate(p) {
        function errorHandler(txt) {
            return function (msg) {
                p.onError(txt + msg);
            };
        }

        _self.Mod.GetInfo({
            onError: errorHandler("Ошибка получения версии модуля " + _moduleName + ": "),
            onSuccess: getServerVersion
        });

        var modVer;
        var srvModVer;

        function getServerVersion(cli) {
            if (cli && cli.ver) {
                modVer = cli.ver;
            } else {
                // если модуль работает, но интерфейс получения версии изменился или ответил но не как нам надо, то выводим окно для ручной установки
                _self.InstallWindow({
                    resume: p.onSuccess
                });
                return;
            }

            _getServerVersion({
                moduleName: _moduleName,
                mod: cli.mod,
                shadowObjId: ObjX.idContainer,
                onError: errorHandler("Ошибка получения с сервера номера версии модуля " + _moduleName + ": "),
                onSuccess: checkVersion
            });
        }

        function wait(i) {
            function repeatWait(j) {
                if (j < 60) { // минута на то чтобы скачался модуль и обновился
                    return function () {
                        setTimeout(function () { wait(j); }, 1000);
                    };
                } else {
                    // !!!!! TODO: выводить нормальное сообщение где можно в ручную скачать архив.
                    return errorHandler("Ошибка автоматического обновления");
                }
            }

            _self.Mod.GetInfo({
                onError: repeatWait(i + 1),
                onSuccess: function (cli) {
                    if (cli && cli.ver) {
                        if (isValidVersion(cli.ver, srvModVer)) {
                            p.onSuccess();
                        } else {
                            repeatWait(i + 1)();
                        }
                    }
                },
                notStart: true
            });
        }


        function checkVersion(params) {
            if (!isValidVersion(modVer, params.ver)) { // если нужно обновить модуль, то обновляем
                //fs.progressBarInit("Обновление модуля " + _moduleName + " версии " + modVer + " на версию " + servVer);
                downloadModule(params.filename);
            } else { // обновлять модуль не нужно - делаем дела
                p.onSuccess();
            }
        }

        function downloadModule(filename) {
            FileUtils.DownloadFile(_sitePrefix + Connection.Info.signGetFileHandler,
                { fileName: filename },
                null,
                true,
                null,
                function (blob) { updateModule(blob, filename); },
                "blob");
        }

        function updateModule(blob, filename) {
            if (blob && blob.fail) {
                errorHandler("Ошибка получения файла модуля " + _moduleName + "(" + srvModVer + ") с сервера: ")(Replace(blob.message, "#msg#", ""));
                return;
            }
            if (blob.type != "application/octet-stream") {
                FileUtils.BlobToText(blob,
                    function (txt) {
                        p.onError(txt);
                    });
                return;
            }

            _self.Mod.Update({
                contentType: (filename.toLowerCase().indexOf(".tar.gz") > 0) ? "application/gzip" : "application/zip",
                zipfile: blob,
                onSuccess: function () { // если обновление удачно, то делаем дела
                    //fs.progressBarInit("Модуль " + _moduleName + " обновлен на версию " + srvModVer);
                    //p.onSuccess();
                    wait(0);
                },
                onError: function (errmess) {
                    p.onError("Ошибка обновления модуля " + _moduleName + ": " + errmess);
                }
            });
        }
    }//CheckAndUpdate

    //function isValidVersion(installed, needed) {
    //    if (!needed)
    //        return true;

    //    var ins = installed.split(".");
    //    var nee = needed.split(".");

    //    var iv1 = ins[0];
    //    var iv2 = ins[1];
    //    var iv3 = ins[2];
    //    var iv4 = 0;
    //    if (ins.length === 4)
    //        iv4 = ins[3];

    //    var nv1 = nee[0];
    //    var nv2 = nee[1];
    //    var nv3 = nee[2];
    //    var nv4 = 0;
    //    if (nee.length === 4)
    //        nv4 = nee[3];

    //    return !!(parseInt(iv1) > parseInt(nv1) ||
    //        parseInt(iv1) === parseInt(nv1) &&
    //        (parseInt(iv2) > parseInt(nv2) ||
    //            parseInt(iv2) === parseInt(nv2) &&
    //            (parseInt(iv3) > parseInt(nv3) ||
    //                parseInt(iv3) === parseInt(nv3) &&
    //                (parseInt(iv4) > parseInt(nv4) || parseInt(iv4) === parseInt(nv4)))));
    //}

    var r = /(\d+)[.](\d+)[.](\d+)(?:-(?:([^_.]+)[.]?(\d+)|([^_]+)))?/;

    // installed >= needed
    function isValidVersion(installed, needed) {
        var ins = installed.match(r);
        var nee = (needed || '').match(r);

        if (!ins) {
            return false;
        } else if (!nee) {
            return true;
        }

        for (var i = 1; i < ins.length; ++i) {
            if (!ins[i] && nee[i]) {
                return true;
            } else if (ins[i] && !nee[i]) {
                return false;
            } else if (ins[i] == nee[i]) {
                continue;
            }
            else if (Number.isInteger(parseInt(ins[i])) && Number.isInteger(parseInt(nee[i]))) {
                if (parseInt(ins[i]) > parseInt(nee[i])) {
                    return true;
                } else {
                    return false;
                }
            } else if (ins[i] > nee[i]) {
                return true;
            }
            else {
                return false;
            }
        }

        return true;
    }

    // return true if good tests else return false
    function _Test_isValidVersion() {
        var valid = true,
            tc = [
                ["0.0.0", "0.0.0", true],
                ["", "0.0.0", false],
                ["0.0.0", "", true],
                ["0.0.0", "0.0.1", false],
                ["0.1.0", "0.0.1", true],
                ["0.1.0", "2.0.1", false],
                ["0.10.0", "0.2.0", true],
                ["0.2.0", "0.10.0", false],
                ["0.0.1", "0.0.1-alfa.1", true],
                ["0.0.1-alfa.1", "0.0.1", false],
                ["0.0.2-alfa.1", "0.0.1", true],
                ["0.0.2-alfa.1", "0.0.2", false],
                ["0.0.2-alfa.1", "0.0.2-alfa.0", true],
                ["0.0.2-alfa.1", "0.0.2-alfa.2", false],
                ["0.0.2-alfa.10", "0.0.2-alfa.1", true],
                ["0.0.2-alfa.2", "0.0.2-alfa.10", false],
                ["0.0.2-alfa.10", "0.0.2-alfa.2", true],
                ["0.0.2-a.1", "0.0.2-z.1", false],
                ["0.0.2-z.1", "0.0.2-a.1", true]
            ];

        tc.forEach(function (item, i, arr) {
            if (valid && isValidVersion(item[0], item[1]) !== item[2]) {
                valid = false;
            }
        });

        return valid;
    }

    // добавим дополнения
    _add.forEach(function (item, i, arr) {
        _self[item.name] = item.cons(item.callM);
    });

    if (_params.withLog) _log("created");
    // ^private
    // ------------------------------------------------------------------------------------- //
    // >public
    this.Name = function () { return _moduleName; };

    //this.Call = _call;

    this.SetSettings = function (options) {
        _setParams(options);
    };

    this.GetSettings = function () {
        return _params;
    };

    this.InstallWindow = function (p) {
        _install({
            resume: p.resume,
            cancel: p.cancel
        });
    };
    // ^public

} // function HttpModule