﻿UsersListByRegionView = KS.extend(BaseDictionaryView, {
    select: function() {
        var view = this.parentView || this;
        var grid = view.mainGrid;
        var checkedRows = grid.getCheckedCodes(true);
        if (KS.isEmpty(checkedRows)) return;
        view.serverCall({
            method: 'GenerateEvent',
            params: [checkedRows]
        });
    },

    buildContainerToolbarItemControl: function (tbarItem, schema) {
        switch (tbarItem.code) {
            case 'UsersListByRegion':
                return this.buildPeriodSelectorItems(tbarItem);
        }
        return UsersListByRegionView.superclass.buildContainerToolbarItemControl.call(this, tbarItem, schema);
    },

    buildPeriodSelectorItems: function () {
        var filterItems = [
            { xtype: 'tbspacer', width: 5 },
            { xtype: 'label', text: 'Регионы:' },
            { xtype: 'tbspacer', width: 3 },
            this.regionFilter = new Ext.form.field.Text({
                    value: "",
                    readOnly: true
                }),
            { xtype: 'tbspacer', width: 3 },
            {
                xtype: 'button',
                tooltip: 'Выбрать регион',
                iconCls: 'ks-icon-dict',
                scope: this,
                handler: this.selectRegion
            },
            { xtype: 'tbspacer', width: 3 }, 
            {
                xtype: 'button',
                tooltip: 'Очистить фильтр по региону',
                iconCls: 'ks-icon-clean',
                scope: this,
                handler: this.clearRegionFilter
            }
        ];
        return new Ext.container.ButtonGroup(
            {
                xtype: 'buttongroup',
                items: filterItems
            });
    },

    selectRegion: function() {
        var view = this;
        var regionsGrid = KS.create(view.tpl.controls.regionsGrid);
        var regionFilter = this.regionFilter.getValue();
        Ext.each(regionsGrid.getStore().getRange(), function (rec) {
            if (regionFilter.indexOf(rec.get('region')) !== -1) 
                rec.set('CHECKED', true);
        });
        view.regionSelectWin = KS.showModal(regionsGrid, {
            title: 'Выбор регионов',
            autoHeight: false,
            resizable: true,
            autoScroll: true,
            maximizable: true,
            width: Math.max(400, KS.rootViewport.getWidth() / 2),
            height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
            minWidth: 400,
            minHeight: 300,
            buttonAlign: 'left',
            buttons: new Array('->', {
                    text: 'ОК',
                    cls: 'marked-button',
                    handler: function () {
                        view.regionSelected(regionsGrid.getCheckedRows());
                    }
                }, 
                { xtype: 'tbspacer', width: 8 },
                {
                    text: 'Отмена',
                    cls: 'dim-button',
                    handler: function() {
                        view.regionSelectWin.close();
                    }
                })
        }, true);
    },

    regionSelected: function(checkList) {
        var view = this,
            colNames = [];
        Ext.each(checkList, function(record) {
            colNames.push("'" + KS.Grid.getAnyCase(record, "region") + "'");
        });
        var filter = colNames.join(", ");
        this.setRegionFilter(filter);
        this.regionFilter.setValue(filter.replace(/'/g, ""));
        view.regionSelectWin.close();
    },

    clearRegionFilter: function () {
        this.setRegionFilter("");
        this.regionFilter.setValue("");
    },

    setRegionFilter: function(filter) {
        var view = this;
        view.serverCall({
            method: 'SetRegionFilter',
            params: [filter],
            success: function() {
                view.mainGrid.reload();
            }
        });
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();