﻿UserView = KS.extend(BaseSvodView, { });
var sc = UserView.superclass;

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.cachedValues = [];
            if (this.data.isOnlyDetails) return;
            // При чтении заявки на изменение пароль может быть уже заполнен
            var hasNewPassword = this.changePassword && this.changePassword.checkboxCmp && this.changePassword.checkboxCmp.getValue();
            if (this.data.isNewOutcome || hasNewPassword)
                this.touch();
            this.setNewTreeCheckStyles();
        },

        onValuesSelected: function (arg) {
            var view = this;
            if (arg[0][0]) {
                view.reloadGeneralTabGrids();

                //Выбор из Уровни ЭП -> Организация
                if (arg[0][0]["LINK_BUDGET"] &&
                    arg[0][0]["LINK_BUDGET_HIERARCHY"] &&
                    arg[0][0]["LINK_ORGANIZATION"] &&
                    arg[0][0]["ORGANIZATION_CODE"] &&
                    arg[0][0]["ORGANIZATION_NAME"] &&
                    !arg[0][0]["ROW_NOT_FOUND"]) {
                    view.organization.setValue("[" +  arg[0][0]["ORGANIZATION_CODE"] +
                        "] " + arg[0][0]["ORGANIZATION_NAME"]);
                    return;
                }
                view.touch();
            }
        },

        reloadGeneralTabGrids: function() {
            this.groupsGrid.reload();
            this.subRolesGrid.reload();
            this.usersInGroupGrid.reload();
            this.filesGrid.reload();
            this.edsLevelsGrid.reload();
        },
        
        reloadTab: function(tabPanel) {
            var activeTabId = tabPanel.ctrlId;
            switch (activeTabId) {
                case "generalTab":
                    this.reloadGeneralTabGrids();
                    break;

                case "formRightsTab":
                    this.formRightsGrid.reload();
                    this.tablesGrid.reload();
                    this.columnsGrid.reload();
                    break;

                case "statusesRightsTab":
                    this.statusesRightsGrid.reload();
                    break;

                case "dictionaryRightsTab":
                    this.dictionaryRightsGrid.reload();
                    break;

                case "organizationRightsTab":
                    this.reloadOrganizationsTree();
                    break;
            }
            tabPanel.needRefresh = false;
        },

        beforeGeneralTabActivate: function(tabPanel){
            if (!tabPanel.tabLoaded) {
                tabPanel.tabLoaded = true;
            }
        },

        beforeFormRightsTabActivate: function(tabPanel){
            if (!tabPanel.tabLoaded) {
                var view = this;
                this.serverCall({
                    method: 'LoadFormRightTab',
                    waitMessage: 'Загрузка прав на формы и статусы...',
                    success: function(controls) {
                        view.formRightsPanel.add(view.createTemplateControl(controls.formRightsGrid));
                        view.tablesPanel.add(view.createTemplateControl(controls.tablesGrid));
                        view.tablesPanel.add(view.createTemplateControl(controls.columnsGrid));
                        tabPanel.tabLoaded = true;
                    }
                });
            }
        },

        beforeStatusesRightsTabActivate: function(tabPanel){
            if (!tabPanel.tabLoaded) {
                var view = this;
                this.serverCall({
                    method: 'LoadStatusesRightsTab',
                    waitMessage: 'Загрузка прав на изменение статусов...',
                    success: function(statusesRightsGrid) {
                        view.statusesRightsTab.add(view.createTemplateControl(statusesRightsGrid));
                        tabPanel.tabLoaded = true;
                    }
                });
            }
        },

        beforeDictionaryRightsTabActivate: function(tabPanel){
            if (!tabPanel.tabLoaded) {
                var view = this;
                this.serverCall({
                    method: 'LoadDictionaryRightsTab',
                    waitMessage: 'Загрузка прав на справочники...',
                    success: function(dictionaryRightsGrid) {
                        view.dictionaryRightsTab.add(view.createTemplateControl(dictionaryRightsGrid));
                        tabPanel.tabLoaded = true;
                    }
                });
            }
        },

        // Для поиска по дереву организаций
        searchTree: "organizationsTree",

        hideSearchPanel: function() {
            var view = this.parentView || this;
            view.searchPanel.setHidden(true);
            var searchBtn = view.getToolbarItem(view.organizationRightsPanel, null, "FIND");
            if (searchBtn)
                searchBtn.setPressed(false);
        },

        beforeOrganizationRightsTabActivate: function(tabPanel){
            if (!tabPanel.tabLoaded) {
                var view = this;
                this.serverCall({
                    method: 'LoadOrganizationRightsTab',
                    waitMessage: 'Загрузка дерева организаций и бюджетов...',
                    success: function(organizationRightsPanel) {
                        view.addPanelItems(organizationRightsPanel, view.createTemplateControl(organizationRightsPanel));
                        view.organizationRightsTab.add(view.organizationRightsPanel);
                        view.setCustomComboBoxExpand(view.organizationRightsPanel);
                        tabPanel.tabLoaded = true;
                    }
                });
            }
        },

        activateTabHandler: function(rootTabPanel, tabPanel) {
            if (tabPanel.needRefresh && tabPanel.tabLoaded) {
                var view = this;
                this.serverCall({
                    method: 'RootPanelTabChange',
                    waitMessage: 'Обновление данных вкладки "' + tabPanel.title + '"...',
                    params: [tabPanel.ctrlId],
                    success: function() {
                        view.reloadTab(tabPanel);
                    }
                });
            }
        },

        setNeedRefreshTab: function(tabId) {
            this.eachTabPanel(function(tabPanel) {
                if (tabPanel.ctrlId === tabId)
                    tabPanel.needRefresh = true;
            });
        },

        eachTabPanel: function (fn) {
            Ext.each(this.rootTabPanel.items.items, function (tabPanel) {
                if (tabPanel && fn && typeof (fn) == 'function') {
                    fn.call(tabPanel, tabPanel);
                }
            });
        },

        setStatePasswordOptions: function(checkBoxValue) {
            var fieldCls = checkBoxValue ? "" : "textfield-read-only";
            this.newPassword.changeFieldCls(fieldCls);
            this.newPasswordConfirm.changeFieldCls(fieldCls);

            this.newPassword.setReadOnly(!checkBoxValue);
            this.newPasswordConfirm.setReadOnly(!checkBoxValue);
            this.loginPasswordChange.setDisabled(!checkBoxValue);
        },

        collapseChangePassword: function(fieldSetComp) {
            var view = this;
            var checkBoxValue = fieldSetComp.checkboxCmp.getValue();
            view.setStatePasswordOptions(checkBoxValue);
            view.serverCall({
                method: 'SetPasswordChanged',
                disableFog: true,
                params: [checkBoxValue],
                success: function(passwordChanged) {
                    if (passwordChanged) {
                        view.data.passwordChanged = passwordChanged;
                        view.touch();
                    }
                }
            });

            return false;
        },

        checkLoginPasswordChange: function(comp, newValue) {
            this.serverCall({
                method: 'SetChangePasswordAtNextLogin',
                disableFog: true,
                params: [newValue]
            });
        },

        checkNewPassword: function(values) {
            var newPas = this.newPassword.getValue();
            var newPasConfirm = this.newPasswordConfirm.getValue();
            if (newPas !== newPasConfirm) {
                KS.alert("Введенные пароли не совпадают");
                return false;
            }

            values["NEW_PASSWORD"] = newPas;
            return true;
        },

        collectValues: function() {
            var values = {};

            if (!this.data.isOnlyDetails) {
                values["NOTE"] = this.noteField.getValue().toString();                
            }

            if (this.data.userType !== 2 &&
                !this.data.isTemplate) 
            {
                values["FIO"] = this.fio.getValue().toString();
                values["POST"] = this.post.getValue().toString();
                values["PHONE"] = this.phone.getValue().toString();
                values["EMAIL"] = this.email.getValue().toString();
                values["KEYID"] = this.certEditor.getValue();
                values["CERTISSUER"] = this.issuerEditor.getValue();
                values["KEYID_NOTBEFORE"] = this.generalNotBefore.getValue();
                values["KEYID_NOTAFTER"] = this.generalNotAfter.getValue();
                values["ALLOW_CERT_API"] = this.allowCertApi.getValue() ? 1 : 0;

                if (!this.data.isOnlyDetails) {
                    values["IS_ADMIN_SP"] = this.updateAdmin.getValue();
                }
            }
            if (this.data.loginEditable) 
                values["LOGIN"] = this.userName.getValue().toString();
            
            return values;
        },

        setUserData: function(){
            if (!Ext.isEmpty(this.data.userDataDict)){
                if (!this.data.isOnlyDetails) {
                    this.noteField.setValue(this.data.userDataDict["NOTE"]);
                    this.userRoles.setValue(this.data.userType);
                }

                if (this.data.userType !== 2 &&
                    !this.data.isTemplate)
                {
                    this.fio.setValue(this.data.userDataDict["FIO"]);
                    this.post.setValue(this.data.userDataDict["POST"]);
                    this.phone.setValue(this.data.userDataDict["PHONE"]);
                    this.email.setValue(this.data.userDataDict["EMAIL"]);
                    this.certEditor.setValue(this.data.userDataDict["KEYID"]);
                    this.issuerEditor.setValue(this.data.userDataDict["CERTISSUER"]);
                    this.generalNotBefore.setValue(this.data.userDataDict["KEYID_NOTBEFORE"]);
                    this.generalNotAfter.setValue(this.data.userDataDict["KEYID_NOTAFTER"]);
                    this.allowCertApi.setValue(this.data.userDataDict["ALLOW_CERT_API"]);

                    if (!this.data.isOnlyDetails) {
                        this.updateAdmin.setRawValue(this.data.userDataDict["IS_ADMIN_SP"]);
                    }
                }

                this.discardChanges();
            }
        },

        userRoleChange: function(comp, newValue) {
            var view = this;
            view.serverCall({
                method: 'ChangeUserRole',
                disableFog: true,
                params: [newValue],
                success: function(isAdmin) {
                    if (view.updateAdmin)
                        view.updateAdmin.setHidden(!isAdmin);
                    if (view.groupsGrid &&
                        !view.data.isTemplate)
                        view.groupsGrid.reload();
                    view.touch();
                }
            });
        }
    });
}(UserView.prototype));

// ============= TOOLBAR =======================
(function(viewClass) {
    KS.apply(viewClass, {
        getTbarClickHandler: function(tbarItem) {
            var sc = UserView.superclass;
            switch (tbarItem.code) {
                case "OPERATIONS":
                    return null;
        
                case "NEW_EDS_LEVEL":
                    return this.newEdsLevel;
        
                //из BaseDictionaryView
                case 'NEW':
                    return this.newHandler;
        
                case 'DELETE':
                case 'DELETE_MENU':
                    return this.deleteHandler;
        
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },
        
        processToolbarItemControl: function(ctrl, tbarNode) {
            switch (tbarNode.code) {
                case 'PRINT': 
                case 'PRINT_LIST':
                    var gridPropertyName;
                    if (!Ext.isEmpty(tbarNode.additional) &&
                        tbarNode.additional.gridPropertyName) {
                        gridPropertyName = tbarNode.additional.gridPropertyName;
                    } else {
                        gridPropertyName = "mainGrid";
                    }
                    KS.apply(ctrl,
                        {
                            gridPropertyName: gridPropertyName,
                            parentView: this,
                            scope: undefined,
                            handler: this.exportToExcel
                        });
                    return ctrl;
            }
            return sc.processToolbarItemControl.call(this, ctrl, tbarNode);
        },
        
        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },
        
        saveChanges: function(callback) {
            var view = this.parentView || this;
            var values = view.collectValues();
            var checkPasswordSuccess = true;
            if (view.data.passwordChanged) 
                checkPasswordSuccess = view.checkNewPassword(values);
            if (checkPasswordSuccess)
                view.serverCall({
                    method: 'SetNewValues',
                    waitMessage: 'Сохранение...',
                    params: [values, view.cachedValues],
                    success: (callback && Ext.isFunction(callback)) ? 
                        callback : 
                        view.doSaveChanges
                });
        },
        
        doSaveChanges: function() {
            this.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение...',
                success: this.saveChangesCallback
            });
        },
        
        saveChangesCallback: function(hasError) {
            if (!hasError) {
                if (this.data.isNewOutcome) {
                    this.userName.setReadOnly(true);
                    this.userName.changeFieldCls("textfield-read-only");
                    this.containerPanel.setTitle(this.userName.getValue());
                    var navigatorBtn = this.getToolbarItem(this.rootPanel, null, 'NAVIGATOR');
                    if (navigatorBtn)
                        navigatorBtn.setHidden(false);
                }
                this.cachedValues = [];
                this.discardChanges();
                this.reload();
            }
        },
        
        openNavigatorRights: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'OpenNavigatorRights'
            });
        },
        
        doReload: function () {
            this.cachedValues = [];
            this.serverCall({
                method: 'Reload',
                waitMessage: 'Обновление ...',
                success: this.reloadCallback
            });
        },

        resetView: function () {
            if (!this.data.isOnlyDetails) {
                var activeTab = this.rootTabPanel.getActiveTab();
                this.eachTabPanel(function (tabPanel) {
                    tabPanel.needRefresh = true;
                });
                this.activateTabHandler(null, activeTab);

                if (this.changePassword && this.changePassword.checkboxCmp) {
                    //Триггерит collapseChangePassword
                    this.changePassword.checkboxCmp.setValue(false);
                }
            }

            this.setUserData();
        },
        
        newHandler: function() {
            var view = this.parentView || this,
                gridId = this.gridPropertyName,
                grid = view[gridId];
            if (grid) 
                view.addRow(gridId);
        },
        
        addRow: function(gridId) {
            this.serverCall({
                method: 'AddRow',
                disableFog: true,
                params: [gridId]
            });
        },
        
        deleteHandler: function() {
            var view = this.parentView || this;
            var gridId = this.gridPropertyName;
            if (!view[gridId]) return;
            var ccc = view[gridId].getCheckedCodes();
            if (Ext.isEmpty(ccc)) return;
            KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc, gridId);
            });
        },
        
        deleteHandlerInternal: function (ccc, gridId) {
            var view = this;
            this.serverCall({
                method: 'DeleteRows',
                params: [gridId, ccc],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted) {
                        view[gridId].reload();
                        view.touch();
                    }
                }
            });
        },
        
        formRightsModeChange: function(comp, newValue) {
            var view = this;
            this.saveCachedValues();
            this.serverCall({
                method: 'FormsModeSelectorChange',
                params: [newValue],
                disableFod: true,
                success: function(newControl) {
                    view.rebuildGrid(newControl, "formRightsPanel");
                }
            });
        },
        
        statusesRightsModeChange: function(comp, newValue) {
            var view = this;
            this.saveCachedValues();
            this.serverCall({
                method: 'StatusesModeSelectorChange',
                params: [newValue],
                disableFod: true,
                success: function(newControl) {
                    view.rebuildGrid(newControl, "statusesRightsTab");
                }
            });
        },
        
        dictionaryTypeChange: function() { 
            this.dictionaryModeChange();
        },
        
        dictionaryModeChange: function() {
            var view = this;
            var modeValue = this.getToolbarItem(this.dictionaryRightsTab, null, "dictionaryMode").getValue();
            var typeValue = this.getToolbarItem(this.dictionaryRightsTab, null, "dictionaryType").getValue();
            this.saveCachedValues();
            this.serverCall({
                method: 'DictionarysModeSelectorChange',
                params: [modeValue, typeValue],
                disableFod: true,
                success: function(newControl) {
                    view.rebuildGrid(newControl, "dictionaryRightsTab");
                }
            });
        },
        
        saveCachedValues: function(){
            var view = this;
            if (Ext.isEmpty(view.cachedValues)) return;
            this.serverCall({
                method: 'SaveCachedValues',
                params: [view.cachedValues],
                disableFod: true,
                success: function() {
                    view.cachedValues = [];
                }
            });
        },
        
        selectRightsToAllDicts: function() {
            var view = this.parentView,
                code = this.tbarNode.code,
                msg = " для всех справочников?";
            switch (code) {
                case "ALLOW":
                    msg = "Разрешить" + msg;
                    break;
        
                case "DENY":
                    msg = "Запретить" + msg;
                    break;
        
                case "NULL":
                    msg = "Сбросить" + msg;
                    break;
            }
            KS.confirm(msg, "Подтвердите действие", function(btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'SelectRightsToAllDicts',
                        params: [code],
                        disableFod: true,
                        success: function() {
                            view.dictionaryRightsGrid.reload();
                            view.touch();
                        }
                    });
                }
            });
        },

        selectRightsToAllForms: function() {
            var view = this.parentView,
                code = this.tbarNode.code,
                msg = " для всех форм?";
            switch (code) {
                case "ALLOW":
                    msg = "Разрешить" + msg;
                    break;

                case "DENY":
                    msg = "Запретить" + msg;
                    break;

                case "NULL":
                    msg = "Сбросить" + msg;
                    break;
            }
            KS.confirm(msg, "Подтвердите действие", function(btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'SelectRightsToAllForms',
                        params: [code],
                        disableFod: true,
                        success: function() {
                            view.formRightsGrid.reload();
                            view.touch();
                        }
                    });
                }
            });
        },

        requestToolClick: function() {
            var view = this.parentView;
            view.requestCode = this.tbarNode.code;
            if (view.hasChanges)
                view.saveChanges(view.doRequestToolClick);
            else
                view.doRequestToolClick();
        },

        doRequestToolClick: function() {
            var view = this;
            var code = view.requestCode;
            view.serverCall({
                method: 'RequestToolClick',
                params: [code],
                disableFod: true,
                success: function(dict) {
                    view.requestCode = "";
                    view.rootTabPanel.setActiveTab(1);
                    if (!dict["requestVisible"])
                        view.rootTabPanel.getTabBar().getRefItems()[0].hide();
                        view.saveChangesCallback(dict["hasErrors"]);
                }
            });
        },
        
        openSystemJournal: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'OpenSystemJournal'
            });
        }
    });
}(UserView.prototype));

// ============= FILES =======================
(function(viewClass) {
    KS.apply(viewClass, {
        saveFiles: function(fileKeys, o, fileField) {
            var view = this.parentView || this;
            if (fileField.callback){
                fileField.callback.call(view, fileKeys);
            } else {
                view.serverCall({
                    method: 'DoSaveFiles',
                    params: [fileKeys],
                    waitMessage: 'Сохранение ...',
                    success: view.changeFilesCallback
                });
            }
        },

        changeFilesCallback: function() {
            this.filesGrid.reload();
        },

        openSelectFiles: function() {
            var view = this.parentView,
                links = this.parentView.getCheckedFileRows('LINK_FILE');
            if (Ext.isEmpty(links))
                return;
            view.serverCall({
                method: 'OpenFiles',
                params: [links]
            });
        },

        deleteSelectFiles: function() {
            var view = this.parentView,
                links = this.parentView.getCheckedFileRows('LINK_FILE');
            if (Ext.isEmpty(links))
                return;
            view.serverCall({
                method: 'DeleteFiles',
                params: [links],
                success: view.changeFilesCallback
            });
        },

        getCheckedFileRows: function (field) {
            var recs = this.filesGrid.checkList;
            if (!Ext.isEmpty(field) && Ext.isString(field)) {
                var fields = [];
                Ext.each(recs, function (r) {
                    fields.push(KS.Grid.getAnyCase(r, field));
                });
                return fields;
            }
            return recs;
        }
    });
}(UserView.prototype));

// ============= GRID'S =======================
(function(viewClass) {
    KS.apply(viewClass, {
        gridCellClick: function(gridView, td, cellIndex, record) {
            var grid = gridView.grid;
            var column = grid.getColumns()[cellIndex];
            if (column && column.renderer === tripleCheckboxRenderer &&
                column.dataIndex.toLowerCase().indexOf("read_only") === -1) {
                var gridId = grid.getItemId();
                var dataIndex = column.dataIndex;
                var oldValue = record.get(dataIndex);
                var closeCode;
                switch(gridId) {
                    case "formRightsGrid":
                    case "formRightsGridAdditional":
                        closeCode = record.get("LINK_FORM");
                        break;  
                    case "tablesGrid":
                    case "tablesGridAdditional":
                        closeCode = record.get("LINK_TABLE");
                        break;                        
                    case "columnsGrid":
                    case "columnsGridAdditional":
                        closeCode = record.get("LINK_COL");
                        break;
                    default:
                        closeCode = record.get("ENTITY_CLOSE_CODE");
                        break;
                }
                if (Ext.isEmpty(closeCode)) return;

                var budgetLink = KS.Grid.getAnyCase(record, "LINK_BUDGET");
                var organizationLink = KS.Grid.getAnyCase(record, "LINK_ORGANIZATION");
                
                var newValue = "";
                switch (oldValue.toLowerCase()) {
                    case '':
                        newValue = 'true';
                        break;
                    case 'true':
                        newValue = 'false';
                        break;
                    case 'false':
                        newValue = '';
                        break;
                }

                this.addInCachedValues(gridId, closeCode, dataIndex, newValue, budgetLink, organizationLink);
                record.set(dataIndex, newValue);
                if (!gridId.includes('Additional'))
                    this.touch();
            }
        },

        addInCachedValues: function(gridId, closeCode, dataIndex, newValue, budgetLink, organizationLink) {
            var cvalue = {
                'gridId': gridId,
                'closeCode': closeCode,
                'dataIndex': dataIndex,
                'newValue': newValue,
                'budgetLink': budgetLink || null,
                'organizationLink': organizationLink || null
            };
            this.addNewCachedValues(cvalue);
        },

        //Если меняем одно и то же поля несколько раз подрят, просто меняем последнее chachedValue
        addNewCachedValues: function(newCachedValue) {
            if (!Ext.isEmpty(this.cachedValues)) {
                var lastCachedValue = this.cachedValues[this.cachedValues.length - 1];
                if (lastCachedValue.gridId === newCachedValue.gridId &&
                    lastCachedValue.closeCode === newCachedValue.closeCode &&
                    lastCachedValue.dataIndex === newCachedValue.dataIndex) {
                    lastCachedValue.newValue = newCachedValue.newValue;
                    return;
                }
            }
            this.cachedValues.push(newCachedValue);
        },

        rebuildGrid: function(newControl, parentCompId) {
            if (!Ext.isEmpty(newControl) && !Ext.isEmpty(parentCompId)) {
                this.tpl.controls[newControl.itemId] = newControl;
                var newGrid = this.createTemplateControl(newControl);
                this[parentCompId].remove(newGrid.ctrlId);
                this[parentCompId].insert(0, newGrid);
            }
        },

        formsGridSelectionChange: function(selModel, selected) {
            if (selected && selected.length > 0) {
                var isAdditional = selModel.view.grid.getItemId().indexOf("Additional") !== -1;
                var tablesPanel = isAdditional ? this.tablesPanelAdditional : this.tablesPanel;
                if (tablesPanel && tablesPanel.getCollapsed()) return; // Если "Таблицы" свернуты, то не обновляем их
                var linkForm = KS.Grid.getAnyCase(selected[0], "link_form");
                this.reloadTablesGrid(linkForm, isAdditional);
            }
        },
        
        tablesPanelExpand: function(panel){
            var isAdditional = panel.getItemId().indexOf("Additional") !== -1;
            var formRightsGrid = isAdditional ? this.formRightsGridAdditional : this.formRightsGrid;
            var selected = formRightsGrid.getSelection();
            if (Ext.isEmpty(selected)) return;
            var linkForm = KS.Grid.getAnyCase(selected[0], "link_form");
            this.reloadTablesGrid(linkForm, isAdditional);
        },
        
        reloadTablesGrid: function(linkForm, isAdditional){
            var view = this;
            var nodeId = isAdditional ? view.organizationsTree.getSelNodeId() : "";
            this.serverCall({
                method: 'GetTablesGridData',
                params: [linkForm, nodeId],
                disableFog: true,
                success: function() {
                    if (isAdditional) {
                        view.tablesGridAdditional.reload();
                        view.columnsGridAdditional.getStore().removeAll();
                    } else {
                        view.tablesGrid.reload();
                        view.columnsGrid.getStore().removeAll();
                    }
                }
            });
        },

        tablesGridSelectionChange: function(selModel, selected) {
            if (selected && selected.length > 0) {
                var view = this;
                var isAdditional = selModel.view.grid.getItemId().indexOf("Additional") !== -1;
                var nodeId = "";
                if (isAdditional) 
                    nodeId = view.organizationsTree.getSelNodeId();
                var linkTable = KS.Grid.getAnyCase(selected[0], "link_table");
                this.serverCall({
                    method: 'GetColumnsGridData',
                    params: [linkTable, nodeId],
                    disableFog: true,
                    success: function() {
                        if (isAdditional) {
                            view.columnsGridAdditional.reload();
                        } else {
                            view.columnsGrid.reload();
                        }
                    }
                });
            }
        },

        getAdditionalGetDataParams: function (getDataParams) {
            if (!KS.isEmpty(this.cachedValues)) {
                getDataParams['cachedValues'] = this.cachedValues; // Используется в GetControlDataObject
                this.cachedValues = [];
            }
        },

        groupsGridCellClick: function(gridView, td, cellIndex, record) {
            var grid = gridView.grid;
            var column = grid.getColumns()[cellIndex];
            if (column.dataIndex === "IS_LOCAL_ADMIN") {
                var gridId = grid.getItemId();
                var dataIndex = column.dataIndex;
                var closeCode = record.get(grid.closeCode);
                var newValue = record.get(column.dataIndex);
                this.addInCachedValues(gridId, closeCode, dataIndex, newValue, null, null);
                this.touch();
            }
        },

        headerClick: function(ct, column, e, htmlElement){
            if (column.dataType === "tripleCheckbox"){
                if (!Ext.isEmpty(htmlElement.src)){
                    var oldImageName ="";
                    var imagePath = htmlElement.src;
                    if (imagePath.indexOf('images/checkbox/unchecked.gif') !== -1){
                        oldImageName = 'images/checkbox/unchecked.gif';
                    } else if (imagePath.indexOf('images/ks/success.png') !== -1){
                        oldImageName = 'images/ks/success.png';
                    } else if (imagePath.indexOf('images/ks/fail.png') !== -1){
                        oldImageName = 'images/ks/fail.png';
                    }
                    
                    if (!Ext.isEmpty(oldImageName)){
                        var appUrl = imagePath.substring(0, imagePath.indexOf(oldImageName));
                        var newImageName = "";
                        var newValue = '';
                        switch (oldImageName) {
                            case 'images/checkbox/unchecked.gif':
                                newImageName = 'images/ks/success.png';
                                newValue = 'true';
                                break;
                            case 'images/ks/success.png':
                                newImageName = 'images/ks/fail.png';
                                newValue = 'false';
                                break;
                            case 'images/ks/fail.png':
                                newImageName = 'images/checkbox/unchecked.gif';
                                newValue = '';
                                break;
                        }
                        htmlElement.src = appUrl + newImageName;
                        var grid = column.view.grid;
                        this.setAllRowTripleCheckValue(newValue, grid, [column.dataIndex]);
                        return false;
                    }
                }
                column.sortable = true;
                column.toggleSortState();
                column.sortable = false;
            }
            return true;
        },

        setAllRowTripleCheckValue: function(newValue, grid, dataIndexes){
            var view = this,
                gridId = grid.getItemId();
            if (view.formsAdditionalRightWin)
                view.formsAdditionalRightWin.mask("Загрузка...");
            view.serverCall({
                method: 'SetAllRowTripleCheckValue',
                params: [view.cachedValues, newValue, gridId, dataIndexes],
                success: function() {
                    switch(gridId) {
                        case "formRightsGridAdditional":
                        case "tablesGridAdditional":
                        case "columnsGridAdditional":
                            // Если formsAdditionalRightWin не закрыт
                            if (view.formsAdditionalRightWin) {
                                view.formsAdditionalRightWin.unmask();
                                grid.reload();
                            }
                            break;

                        default:
                            grid.reload();
                            view.touch();
                            break;
                    }
                    view.cachedValues = [];
                }
            });
        },

        // Добавляем нормальные тултипы, т.к. по умолчанию col.tooltip = col.header в configureColumn, а col.header - картинки
        beforeGridRender: function(grid){ 
            var columns = grid.getColumns();
            Ext.each(columns, function(column){
                if (!Ext.isEmpty(column.aspType) && column.aspType.indexOf("rights_editor") !== -1 && 
                    !Ext.isEmpty(column.tag) && !Ext.isEmpty(column.tag.columnTooltip)){
                    column.tooltip = column.tag.columnTooltip;
                }
            });
        }
    });
}(UserView.prototype));

// ============= EDS LEVEL =======================
(function(viewClass) {
    KS.apply(viewClass, {
        newEdsLevel: function() {
            var view = this.parentView || this,
                userType = view.data.userType;
            if (!Ext.isEmpty(userType) && (userType === 0 || userType === 1 || userType === 6)) 
                view.openEdsSelectPanel(-1);
            else 
                this.addRow(this.gridPropertyName);
        },

        edsLevelDblClick: function(gridView, record) {
            var closeCode = KS.Grid.getAnyCase(record, 'ENTITY_CLOSE_CODE');
            if (closeCode) 
                this.openEdsSelectPanel(closeCode);
        },

        openEdsSelectPanel: function(closeCode) {
            this.serverCall({
                method: 'GetEdsLevelSelectPanel',
                params: [closeCode],
                disableFog: true,
                success: this.showEdsSelectPanel
            });
        },
        
        createSelectCertBtn: function(itemId, callback){
            return KS.create({
                    type: 'filefield',
                    parentView: this,
                    itemId: itemId,
                    accept: '.cer,.p7b,.pfx,.crt'
                },
                {
                    buttonConfig: {
                        tooltip : 'Выбрать сертификат',
                        iconCls: 'ks-icon-folder_open',
                        text: '',
                        width: 24
                    },
                    callback: callback,
                    multiple: false,
                    buttonOnly: true,
                    emptyText: 'Выберите файл...',
                    width: 24
                })
        },

        showEdsSelectPanel: function(panel) {
            if (Ext.isEmpty(panel)) return; 
            this.edsLevelsGrid.reload();
            var edsPanel = this.createTemplateControl(panel);
            this.addPanelItems(panel, edsPanel);

            this.selectCertBtn = this.createSelectCertBtn('selectCertBtn', this.loadCertFromFile);
            if (this.certName)
                this.certName.add(this.selectCertBtn);

            this.edsSelectWin = KS.showModal(edsPanel,
                {
                    title: 'Редактирование пользователя',
                    modal: true,
                    width: 500,
                    height: 340,
                    minHeight: 340,
                    plain: true,
                    maximizable: false,
                    resizable: false,
                    parentView: this,
                    listeners: {
                        beforeclose: this.edsSelectWinClose
                    }
                }).show();
        },

        saveEdsSelectLevel: function() {
            var view = this.parentView || this;
            if (Ext.isEmpty(view.edsSelectWin)) return; 
            var closeCode = view.edsSelectPanel.closeCode;
            view.serverCall({
                method: 'SaveEdsLevel',
                disableFog: true,
                params: [closeCode],
                success: function(saveSuccess) {
                    if (saveSuccess) {
                        view.touch();
                        view.edsLevelsGrid.reload();
                        view.edsSelectWin.isCloseButton = false;
                        view.edsSelectWin.close();
                    }
                }
            });
        },            
        
        exitEdsSelectLevel: function() {
            var view = this.parentView || this;
            if (Ext.isEmpty(view.edsSelectWin)) return; 
            var closeCode = view.edsSelectPanel.closeCode;
            var isNew = view.edsSelectPanel.isNew;
            view.serverCall({
                method: 'CloseEdsSelectWin',
                params: [closeCode, isNew],
                disableFog: true,
                success: function() {
                    view.edsLevelsGrid.reload();
                    view.edsSelectWin.isCloseButton = false;
                    view.edsSelectWin.close();
                }
            });
        },

        edsSelectWinClose: function() {
            if (this.isCloseButton !== false) {
                this.parentView.exitEdsSelectLevel();
                this.isCloseButton = true;
            }
        },

        showSelectLevelDictionary: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSelectLevelGrid',
                disableFog: true,
                success: view.doShowSelectLevelDictionary
            });
        },

        doShowSelectLevelDictionary: function(grid) {
            var view = this;
            view.edsLevelDictGrid = this.createTemplateControl(grid);
            view.selectLevelWin = KS.showModal(view.edsLevelDictGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                modal: true,
                height: 600,
                width: 700,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.edsLevelSelected();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectLevelWin.close();
                        }
                    }]
            }, true);
        },

        edsLevelSelected: function() {
            var view = this;
            var selected = view.edsLevelDictGrid.getSelectedRows();
            if (!Ext.isEmpty(selected) && !Ext.isEmpty(selected[0])) {
                var row = selected[0];
                var linkLevel = KS.Grid.getAnyCase(row, 'LINK_LEVEL');
                var name = KS.Grid.getAnyCase(row, 'NAME');
                var closeCode = view.edsSelectPanel.closeCode;
                view.serverCall({
                    method: 'SetSelectLevelEds',
                    disableFog: true,
                    params: [linkLevel, name, closeCode],
                    success: function(name) {
                        view.edsLevelsGrid.reload();
                        view.levelEditor.setValue(name);
                    }
                });
            }
            view.selectLevelWin.close();
        },

        showCertDictionary: function() {
            var view = this.parentView || this;
            view.getOpenData([]);
        },

        getCertificates: function() {
            if (this.isSelectForAuth) // Выбор сертификата для 'Сертификат входа'
                KS.XCrypt.selectCertificate(this.setAuthCertData, this);
            else
                KS.XCrypt.selectCertificate(this.getSelectedCertName, this);

            delete this.isSelectForAuth;
        },

        loadCertFromFile: function(fileKeys) {
            var view = this.parentView || this;
            if (!KS.isEmpty(fileKeys[0]) && !KS.isEmpty(fileKeys[0].fileName) && !KS.isEmpty(fileKeys[0].fileExtension)) {
                view.serverCall({
                    method: 'LoadCertFromFile',
                    params: [fileKeys, ""],
                    waitMessage: 'Загрузка сертификата...',
                    success: function(certData){
                        if (view.isSelectForAuth) // Выбор сертификата для 'Сертификат входа'
                            view.setAuthCertData(certData);
                        else
                            view.getSelectedCertName(certData);

                        delete view.isSelectForAuth;
                    }
                });
            }
        },

        getSelectedCertName: function(certData) {
            if (certData && certData.serial) {
                var certSerial = '#' + certData.serial.toUpperCase();
                this.certName.textField.setRawValue(certSerial);
                this.subject.textField.setRawValue(certData.subject);
                this.issuer.textField.setRawValue(certData.issuer);
                this.notbefore.setRawValue(certData.notbefore);
                this.notafter.setRawValue(certData.notafter);

                this.edsCertDataChange({
                    serial : certSerial,
                    subject : certData.subject,
                    issuer : certData.issuer,
                    notbefore : certData.notbefore,
                    notafter : certData.notafter,
                }, false);
            }
        },

        edsCertNameChange: function(comp, certName){
            this.subject.textField.setRawValue("");
            this.issuer.textField.setRawValue("");
            this.notbefore.setRawValue(null);
            this.notafter.setRawValue(null);
            
            this.edsCertDataChange({
                serial : certName,
                subject : null,
                issuer : null,
                notbefore : null,
                notafter : null,
            }, true);
        },

        edsCertDataChange: function(certData, isCertNameChange) {
            var view = this;
            var closeCode = view.edsSelectPanel.closeCode;
            this.serverCall({
                method: 'EdsCertDataChange',
                params: [closeCode, certData, isCertNameChange],
                disableFog: true,
                success: function() {
                    view.edsLevelsGrid.reload();
                }
            });
        },

        showOrganizationTree: function() {
            var view = this.parentView || this;
            var closeCode = view.edsSelectPanel.closeCode;
            view.serverCall({
                method: 'ShowOrganizationTree',
                params: [closeCode],
                disableFog: true
            });
        },

        edsBlockDateChange: function(comp, newValue) {
            var view = this;
            var closeCode = view.edsSelectPanel.closeCode;
            var isBegin = comp.ctrlId === "beginBlock";
            this.serverCall({
                method: 'EdsBlockDateChange',
                params: [closeCode, newValue, isBegin],
                disableFog: true,
                success: function() {
                    view.edsLevelsGrid.reload();
                }
            });
        }
    });
}(UserView.prototype));

// ============= ORGANIZATION TREE =======================
(function(viewClass) {
    KS.apply(viewClass, {
        reloadOrganizationsTree: function() {
            this.organizationsTree.getRootNode().removeAll(true);
            this.organizationsTree.fullReload();
        },

        setNewTreeCheckStyles: function() {
            if (!window.treeCheckStylesAdded) {
                // После смены картинок нужно будет поменять размеры
                var isClassic = KS.theme === 'Classic';
                $("<style type='text/css'>" +
                    ".user-organization-tree-disabled .x-grid-item{" +
                    "background-color: #F5F5F5;" +
                    "}" +
                    ".user-organization-tree .row-unchecked .x-tree-checkbox, " +
                    ".user-organization-tree-disabled .row-unchecked .x-tree-checkbox {" +
                    "background-image: url(images/checkbox/unchecked.gif);" +
                    "background-size: " + (isClassic ? "13px;" : "15px;") +
                    (isClassic ? "" : "top: 5pt;") +
                    "} " +
                    ".user-organization-tree .row-success .x-tree-checkbox, " +
                    ".user-organization-tree-disabled .row-success .x-tree-checkbox {" +
                    "background-image: url(images/ks/success.png);" +
                    "border: solid 1px;" +
                    "background-size: " + (isClassic ? "12px;" : "14px;") +
                    (isClassic ? "" : "top: 5pt;") +
                    "} " +
                    ".user-organization-tree .row-fail .x-tree-checkbox," +
                    ".user-organization-tree-disabled .row-fail .x-tree-checkbox {" +
                    "background-image: url(images/ks/fail.png);" +
                    "border: solid 1px;" +
                    "background-size: " + (isClassic ? "12px;" : "14px;") +
                    (isClassic ? "" : "top: 5pt;") +
                    "}</style>").appendTo("head");
                window.treeCheckStylesAdded = true;
            }
        },

        organizationRightsModeChange: function(comp, newValue) { //organizationRightsMode change event
            var view = this;
            this.serverCall({
                method: 'OrganizationModeSelectorChange',
                params: [newValue],
                disableFod: true,
                success: function() {
                    view.reloadOrganizationsTree();
                    view.changeOrgTreeByRights(newValue === "READ");
                }
            });
        },

        changeOrgTreeByRights: function(treeReadOnly) {
            this.organizationsTree.removeCls("user-organization-tree");
            this.organizationsTree.removeCls("user-organization-tree-disabled");
            if (treeReadOnly) 
                this.organizationsTree.addCls("user-organization-tree-disabled");
            else 
                this.organizationsTree.addCls("user-organization-tree");
            
            this.setOrgTreeToolbarDisabled(treeReadOnly);
        },

        setOrgTreeToolbarDisabled: function(disabledState) {
            this.setOrgTreeTbarItemDisabled("MARK", disabledState);
            this.setOrgTreeTbarItemDisabled("MARK_CHILD", disabledState);
            this.setOrgTreeTbarItemDisabled("DENY_CHILD", disabledState);
            this.setOrgTreeTbarItemDisabled("UNMARK_ALL", disabledState);
            this.setOrgTreeTbarItemDisabled("ADDITIONAL_RULES", disabledState);
        },

        setOrgTreeTbarItemDisabled: function(code, disabledState) {
            var btn = this.getToolbarItem(this.organizationRightsPanel, null, code);
            if (btn != null && btn.setDisabled)
                btn.setDisabled(disabledState);
        },

        organizationNodesEditable:function() {
            var comboMode = this.getToolbarItem(this.organizationRightsPanel, null, "organizationRightsMode");
            return !(!Ext.isEmpty(comboMode) && comboMode.getValue() === "READ");                
        },

        organizationTreeNodeCheck: function(record) {
            var nodeJson = record.data.json;
            if (nodeJson) {
                if (this.organizationNodesEditable() &&
                    nodeJson.hasOwnProperty("checkState") &&
                    !(nodeJson.hasOwnProperty("nodeEditable") && !nodeJson.nodeEditable)) {
                    this.setTreeNodeNextValue(record);
                    this.treeNodesCheckChange([record]);
                }
            }
            return false;
        },

        setTreeNodeNextValue: function(record) {
            var json = record.data.json;
            var oldValue = json.checkState;
            var newValue = "";
            switch (oldValue.toLowerCase()) {
                case '':
                    newValue = 'true';
                    break;
                case 'true':
                    newValue = 'false';
                    break;
                case 'false':
                    newValue = '';
                    break;
            }
            json.checkState = newValue;
            record.set('json', json);
        },

        markTreeNode: function(record) {
            var json = record.data.json;
            json.checkState = "true";
            record.set('json', json);
        },            
        
        denyTreeNode: function(record) {
            var json = record.data.json;
            json.checkState = 'false';
            record.set('json', json);
        },            
        
        unmarkTreeNode: function(record) {
            var json = record.data.json;
            json.checkState = "";
            record.set('json', json);
        },

        treeNodesCheckChange: function(records) {
            var view = this;
            var newNodesValue = {};
            Ext.each(records, function(record) {
                var nodeId = record.get("id");
                newNodesValue[nodeId] = record.get("json").checkState;
            });
            view.serverCall({
                method: 'TreeNodesCheckChange',
                params: [newNodesValue],
                disableFog: true,
                success: function() {
                    Ext.each(records, function(record) {
                        view.changeNodeStyle(record);
                    });
                    view.touch();
                }
            });
        },

        changeNodeStyle: function(node) {
            var newValue = node.data.json.checkState;
            node.removeCls("row-unchecked");
            node.removeCls("row-success");
            node.removeCls("row-fail");
            switch (newValue.toLowerCase()) {
                case '':
                    node.addCls("row-unchecked");
                    break;
                case 'true':
                    node.addCls("row-success");
                    break;
                case 'false':
                    node.addCls("row-fail");
                    break;
            }
        },

        orgTreeInvers: function() {
            var view = this.parentView || this;
            if (view.organizationNodesEditable()) {
                view.changedTreeNodes = [];
                var node = view.organizationsTree.getRootNode();
                if (!Ext.isEmpty(node)) {
                    view.orgTreeInversNode(node);
                    view.treeNodesCheckChange(view.changedTreeNodes);
                    view.changedTreeNodes = [];
                }
            }
        },

        orgTreeInversNode: function(node) {
            var view = this;
            if (node.id !== 'root') {
                view.setTreeNodeNextValue(node);
                view.changedTreeNodes.push(node);
            }
            Ext.each(node.childNodes, function() {
                view.orgTreeInversNode(this);
            });
        },

        orgTreeMarkChild: function() {
            var view = this.parentView || this;
            if (view.organizationNodesEditable()) {
                view.changedTreeNodes = [];
                var node = view.organizationsTree.getSelNode();
                if (!Ext.isEmpty(node)) {
                    view.orgTreeMarkNode(node);
                    view.treeNodesCheckChange(view.changedTreeNodes);
                    view.changedTreeNodes = [];
                }
            }
        },
        
        orgTreeMarkNode: function(node) {
            var view = this;
            if (node.id !== 'root') {
                view.markTreeNode(node);
                view.changedTreeNodes.push(node);
            }
            Ext.each(node.childNodes, function() {
                view.orgTreeMarkNode(this);
            });
        },
        
        orgTreeMarkChildOneLevel: function() {
            var view = this.parentView || this;
            if (view.organizationNodesEditable()) {
                view.changedTreeNodes = [];
                var node = view.organizationsTree.getSelNode();
                if (!Ext.isEmpty(node)) {
                    view.markTreeNode(node);
                    view.changedTreeNodes.push(node);
                    Ext.each(node.childNodes, function(childNode) {
                        view.markTreeNode(childNode);
                        view.changedTreeNodes.push(childNode);
                    });
                    view.treeNodesCheckChange(view.changedTreeNodes);
                    view.changedTreeNodes = [];
                }
            }
        },   

        orgTreeDenyChild: function() {
            var view = this.parentView || this;
            if (view.organizationNodesEditable()) {
                view.changedTreeNodes = [];
                var node = view.organizationsTree.getSelNode();
                if (!Ext.isEmpty(node)) {
                    view.orgTreeDenyNode(node);
                    view.treeNodesCheckChange(view.changedTreeNodes);
                    view.changedTreeNodes = [];
                }
            }
        },

        orgTreeDenyNode: function(node) {
            var view = this;
            if (node.id !== 'root') {
                view.denyTreeNode(node);
                view.changedTreeNodes.push(node);
            }
            Ext.each(node.childNodes, function() {
                view.orgTreeDenyNode(this);
            });
        },

        orgTreeDenyChildOneLevel: function() {
            var view = this.parentView || this;
            if (view.organizationNodesEditable()) {
                view.changedTreeNodes = [];
                var node = view.organizationsTree.getSelNode();
                if (!Ext.isEmpty(node)) {
                    view.denyTreeNode(node);
                    view.changedTreeNodes.push(node);
                    Ext.each(node.childNodes, function(childNode) {
                        view.denyTreeNode(childNode);
                        view.changedTreeNodes.push(childNode);
                    });
                    view.treeNodesCheckChange(view.changedTreeNodes);
                    view.changedTreeNodes = [];
                }
            }
        },

        orgTreeUnmark: function() {
            var view = this.parentView || this;
            if (view.organizationNodesEditable()) {
                view.changedTreeNodes = [];
                var node = view.organizationsTree.getRootNode();
                if (!Ext.isEmpty(node)) {
                    view.orgTreeUnmarkNode(node);
                    view.treeNodesCheckChange(view.changedTreeNodes);
                    view.changedTreeNodes = [];
                }
            }
        },

        orgTreeUnmarkNode: function(node) {
            var view = this;
            if (node.id !== 'root') {
                view.unmarkTreeNode(node);
                view.changedTreeNodes.push(node);
            }
            Ext.each(node.childNodes, function() {
                view.orgTreeUnmarkNode(this);
            });
        },

        orgTreeCollapseAll: function() {
            var view = this.parentView || this;
            view.organizationsTree.collapseAll();
        },

        orgTreeExpandAll: function() {
            var view = this.parentView || this;
            view.organizationsTree.expandAll();
        },
        
        orgTreeAdditionalRules: function() {
            var view = this.parentView || this;
            var nodeId = view.organizationsTree.getSelNodeId();
            if (view.organizationNodesEditable() && nodeId) {
                view.serverCall({
                    method: 'TryOpenAdditionalRights',
                    params: [nodeId],
                    success: view.openAdditionalRights
                });
            }
        },

        openAdditionalRights: function(formRightsTabItems) {
            var view = this,
                hasChanges = view.hasChanges;
            this.formRightsTabItems = this.createTemplateControl(formRightsTabItems);
            this.addPanelItems(formRightsTabItems, this.formRightsTabItems);
            this.formsAdditionalRightWin = KS.showModal(this.formRightsTabItems, {
                title: 'Редактирование',
                autoHeight: false,
                maximizable: true,
                resizable: true,
                modal: true,
                height: Math.max(700, KS.rootViewport.getHeight() / 1.5),
                width: Math.max(1000, KS.rootViewport.getWidth() / 1.5),
                listeners: {
                    close: function() {
                        if (hasChanges)
                            view.touch();

                        view.cachedValues = [];
                        delete view.formsAdditionalRightWin;
                    }
                },
                tbar: [
                    {
                        text: 'Разрешить все',
                        tooltip: 'Разрешить все',
                        handler: function () {
                            view.additionalRightsToolbarClick('true');
                        }
                    },
                    {
                        text: 'Запретить все',
                        tooltip: 'Запретить все',
                        handler: function () {
                            view.additionalRightsToolbarClick('false');
                        }
                    },
                    {
                        text: 'Сбросить все',
                        tooltip: 'Сбросить все',
                        handler: function () {
                            view.additionalRightsToolbarClick('');
                        }
                    }
                ],
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.additionalRightsSelected(true);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.additionalRightsSelected(false);
                        }
                    }]
            }, true);
        },

        additionalRightsSelected: function(save) {
            var view = this;
            if (save) {
                view.serverCall({
                    method: 'AdditionalRightsAcceptChanges',
                    params: [view.cachedValues],
                    success: function (edited) {
                        if (edited)
                            view.touch();
                    }
                });
            }

            view.formsAdditionalRightWin.close();
            view.setNeedRefreshTab("formRightsTab");
        },

        additionalRightsToolbarClick: function(newValue) {
            var view = this;
            var dataIndexes = [];
            var grid = view.formRightsGridAdditional;
            for (var i = 0; i < grid.columns.length; i++) {
                if (grid.columns[i].dataType === 'tripleCheckbox')
                    dataIndexes.push(grid.columns[i].dataIndex);
            }

            view.formsAdditionalRightWin.mask('Загрузка...');
            view.setAllRowTripleCheckValue(newValue, grid, dataIndexes);
        },

        selectBudgetTreeVersion: function(combo, newValue) {
            var view = this.parentView || this;
            var selectRecord = combo.findRecord(combo.valueField, newValue);
            if (selectRecord) {
                view.serverCall({
                    method: 'SelectBudgetTreeVersion',
                    params: [newValue],
                    waitMessage: 'Загрузка дерева бюджетов...',
                    success: function() {
                        view.reloadOrganizationsTree();
                    }
                });
            }
        },

        orgTreeOnlyAllowCheck: function(comp, newValue) {
            if (newValue) {
                var allowNodes = this.getAllowNodes(this.organizationsTree);
                var allowNodesFilter = new Ext.util.Filter({
                    id: 'allowNodesFilter',
                    property: 'id',
                    value: allowNodes,
                    operator: 'in'
                });
                this.organizationsTree.store.addFilter(allowNodesFilter);
            }
            else {
                this.organizationsTree.store.removeFilter('allowNodesFilter');
            }
        },
        
        getAllowNodes: function(tree){
            var nodes = ['root', '0_0_0'];
            
            var hasCheckedChildNode = function(node) {
                let nodeAdded = false;
                if (node.data.json && node.data.json.checkState === 'true') {
                    nodes.push(node.id);
                    nodeAdded = true;
                }
                if (node.hasChildNodes()) {
                    let childNodeAdded = false;
                    Ext.each(node.childNodes,
                        function(childNode) {
                            childNodeAdded = hasCheckedChildNode(childNode) || childNodeAdded;
                        });
                    if (childNodeAdded) {
                        nodes.push(node.id);
                        nodeAdded = true;
                    }
                }
                return nodeAdded;
            };
            hasCheckedChildNode(tree.getRootNode());
            
            return nodes;
        },

        orgTreeOnlyCheckedPeriod: function(comp, checkValue) {
            var view = this;
            var versionLink = view.getToolbarItem(view.organizationRightsTab, null, 'ComboVersions').getValue();
            this.serverCall({
                method: 'OnlyCheckedPeriod',
                params: [checkValue, versionLink],
                disableFog: true,
                success: function() {
                    view.reloadOrganizationsTree();
                }
            });
        },

        orgTreeHierarchyRights: function() {
            var view = this.parentView || this;
            var node = view.organizationsTree.getSelNode();
            var versionLink = view.getToolbarItem(view.organizationRightsPanel, null, 'ComboVersions').getValue();
            if (node && node.data) {
                view.serverCall({
                    method: 'OnOpenHierarchyRights',
                    params: [node.data.id, node.data.text, versionLink],
                    waitMessage: "Получение списка пользователей..."
                });
            }
        },

        organizationTreeLoad: function() {
            //Если нужно проскролить до выбранного узла после обновления дерева
            if (this.organizationTreeNodeIdToScroll) {
                this.organizationsTree.setSelected(this.organizationTreeNodeIdToScroll);
                this.scrollToActiveNode(this.organizationsTree);
                this.organizationTreeNodeToScroll = null;
            }
        }
    });
}(UserView.prototype));

// ============= AUTH CERT EDITOR =======================
(function(viewClass) {
    KS.apply(viewClass, {
        authCertEditorRendered: function(){
            this.selectAuthCertBtn = this.createSelectCertBtn('selectAuthCertBtn', this.loadAuthCertFromFile);
            this.certEditor.add(this.selectAuthCertBtn);
        },

        loadAuthCertFromFile: function(fileKeys) {
            var view = this.parentView || this;
            view.isSelectForAuth = true;
            view.loadCertFromFile(fileKeys);
        },

        setAuthCertData: function(certData) {
            if (certData && certData.serial) {
                // var certSerial = '#' + certData.serial.toUpperCase();
                this.certEditor.setValue(certData.serial.toUpperCase());
                this.issuerEditor.setValue(certData.issuer);
                this.generalNotBefore.setValue(certData.notbefore);
                this.generalNotAfter.setValue(certData.notafter);
                this.touch();
            }
        },

        authCertEditorChange: function(comp, newValue){
            if (Ext.isEmpty(newValue)) {
                this.issuerEditor.setValue('');
                this.generalNotBefore.setValue('');
                this.generalNotAfter.setValue('');
            }
            this.touch();
        },

        authCertEditorShowDict: function(){
            var view = this.parentView || this;
            view.isSelectForAuth = true;
            view.getOpenData([]);
        }
    });
}(UserView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();