﻿SavedFormStatusesDictionarySettingsView = KS.extend(BaseDictionaryView, {});

(function (viewClass) {
    KS.apply(viewClass, {
        rowDblClickHandler: function(gridView, record, element, rowIndex, e) {
            if (e.position.column.renderer === dictRenderer) {
                var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                var dataIndex = e.position.column.dataIndex;
                this.openDictionary(dataIndex,closeCode);
                return false;
            }
            return true;
        },
        
        openDictionary: function(dataIndex,closeCode){
            this.serverCall({
                method: "OpenDictionary",
                params: [dataIndex,closeCode]
            });
        },
        
        editGridCell: function(plugin, context) {
            if (context.value === context.originalValue) return false;
            var dataIndex = context.field;
            var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
            this.serverCall({
                method: "EditGridCell",
                disableFog: true,
                params: [context.value, dataIndex, closeCode]
            });
            return true;
        }
    });
}(SavedFormStatusesDictionarySettingsView.prototype));