﻿// ============= VIEW =======================
RouteAgreementEditView = KS.extend(BaseSvodView, {
    onTemplateRendered: function () {
        this.setCustomComboBoxExpand(this.budgetTreePanel);
        this.addGeneralPropertyGrid();
    }
});

// ===== MAIN TOOLBAR ======
(function (viewClass) {
    KS.apply(viewClass, {

        saveChanges: function () {
            var view = this.parentView || this;

            view.serverCall({
                method: 'SaveRouteChanges',
                waitMessage: 'Сохранение ...',
                success: view.afterSaveChanges
            });
        },

        afterSaveChanges: function (result) {
            var view = this;
            switch (result.type) {
                case "copy":
                    KS.confirm(result.message, "Создание копии", function (btn) {
                        if (btn === 'yes') 
                            view.makeCopy();
                    });
                    break;

                case "error":
                    KS.showHtmlProtocol(result.message);
                    break;

                case "ok":
                    view.discardChanges();
                    view.reload();
                    break;
            }
        },

        onSetSavedState: function(state) {
            this.getToolbarItem(this.mainPanel, null, 'SAVE').setDisabled(state);
        },

        makeCopy: function() {
            this.serverCall({
                method: 'MakeCopyRoute',
                waitMessage: 'Создание копии ...'
            });
        },

        doReload: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'RefreshRoute',
                waitMessage: 'Обновление ...',
                success: function (result) {
                    view.setValues(result);
                    view.discardChanges();
                }
            });
        }
    });
}(RouteAgreementEditView.prototype));

// ===== BASE ======
(function (viewClass) {
    KS.apply(viewClass, {
        
        addGeneralPropertyGrid: function() { //Добавить propertyGrid в Общие
            var view = this;
            view.serverCall({
                method: 'GetGeneralGridData',
                waitMessage: 'Обновление вкладки "Общие" ...',
                success: function(settings) {
                    var generalPanel = view.generalPanel;
                    var propertyGrid = view.getPropertyGridByOption(settings, "generalPropertyGrid", "Общие");
                    propertyGrid.on("propertychange", view.generalPropertyGridChange, view);
                    generalPanel.add(propertyGrid);
                }
            });
        },

        generalPropertyGridChange: function(source, recordId, newValue, oldValue){
            newValue = this.correctPropValue(newValue);
            if (newValue !== oldValue) {
                var code = recordId.split("#")[1] || "";
                var view = this;
                this.serverCall({
                    method: 'ChangePropertyGridValue',
                    disableFog: true,
                    params: [code, newValue],
                    success: function() {
                        view.touch();
                    }
                });
            }
        },

        propertyGridDictSelect: function(propId) {
            var propName = propId.split("#")[1] || "";
            this.serverCall({
                method: 'OpenPropertyGridDict',
                params: [propName]
            });
        },

        correctPropValue: function(value) {
            var correctValue = "";
            switch(Ext.typeOf(value)) {
                case "array":
                    correctValue = value.join(",");
                    break;
            }
            return !Ext.isEmpty(correctValue) ? correctValue : value;
        },
        
        setValues: function (result) {
            var view = this.parentView || this;

            view.addGeneralPropertyGrid();
            
            view.formsList.reload();
            view.userList.reload();
            view.budgetTree.getRootNode().removeAll(true);
            view.budgetTree.fullReload();

            view.getToolbarItem(view.budgetTreePanel, null, 'ComboVersions').setValue(result.comboValue);
        },

        onValuesSelected: function (data) {
            var arg = data[0][0];
            switch (arg["CLOSE_CODE"]) {
                case "LINK_USER":
                case "LINK_GROUP":
                    this.userList.reload();
                    this.touch();
                    break;

                case "LINK_FORM":
                    this.formsList.reload();
                    this.touch();
                    break;

                case "NASTR_CLOSE":
                    if (arg["HAS_CHANGES"])
                        this.touch();
                    break;

                case "LINK_DICTION_ROW":
                    this.attrSelectGrid.reload();
                    break;
                    
                case "SELECT_FOR_PROPERTY_GRID":
                    this.addGeneralPropertyGrid();
                    this.touch();
                    break;
            }
        },

        gridCellEdit: function(edPlugin, context) {
            if (context.hasOwnProperty("originalValue") &&
                context.originalValue.toString() === context.value.toString()) return;
            var gridId = context.grid.ctrlId;
            var dataIndex = context.field;
            var closeCodeField = context.grid.closeCode;
            var closeCodeValue = KS.Grid.getAnyCase(context.record, closeCodeField);
            var newValue = context.value;
            var view = this;
            view.serverCall({
                method: 'ChangeGridCellValue',
                params: [gridId, dataIndex, closeCodeField, closeCodeValue, newValue],
                disableFog : true,
                success: function(result) {
                    if (result)
                        view.touch();
                }
            });
        }
    });
}(RouteAgreementEditView.prototype));

// ===== OPTIONS ======
(function (viewClass) {
    KS.apply(viewClass, {

        changedValues: function () {
            var view = this.parentView || this;
            view.touch();
        }
    });
}(RouteAgreementEditView.prototype));

// ===== USERS ======
(function (viewClass) {
    KS.apply(viewClass, {

        deleteUser: function () {
            var view = this.parentView || this,
                recs2Del = view.userList.getCheckedRows(),
                userLinks = view.userList.getCheckedCodes();
            if (Ext.isEmpty(userLinks)) return;
            KS.confirm("Удалить отмеченных пользователей?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteUser',
                        params: [userLinks],
                        waitMessage: 'Удаление ...',
                        success: function (hasDeleted) {
                            if (hasDeleted) {
                                Ext.each(recs2Del, function (r) {
                                    view.userList.store.remove(r);
                                });
                                view.touch();
                            }
                        }
                    });
                }
            });
        },

        addUser: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddUser',
                waitMessage: 'Открытие справочника ...'
            });
        },

        addUserGroup: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddUserGroup',
                waitMessage: 'Открытие справочника ...'
            });
        }
    });
}(RouteAgreementEditView.prototype));

// ===== TREE ======
(function (viewClass) {
    KS.apply(viewClass, {

        budgetTreeCheckChange: function(node, checked) {
            this.serverCall({
                method: 'BudgetTreeCheckChange',
                params: [node.id, checked],
                disableFog: true
            });
            this.touch();
        },

        checkChild: function() {
            var view = this.parentView || this;
            var node = view.budgetTree.getSelNode();
            view.checkAllChildNode(node, true, true);
            view.doCheckChild();
        },

        checkAllChildNode: function(node, state, needExpand) {
            var view = this;
            if (!Ext.isEmpty(node)) {
                if (state == null)
                    view.setChecked(node, !node.get("checked"));
                else
                    view.setChecked(node, state);
                view.saveNodeCheckState(node);
                if (node.hasChildNodes()) {
                    if (needExpand) 
                        node.expand();
                    Ext.each(node.childNodes,
                        function(childNode) {
                            view.checkAllChildNode(childNode, state, needExpand);
                        });
                }
            }
        },

        checkChildOneLevel: function() {
            var view = this.parentView || this;
            var node = view.budgetTree.getSelNode();
            if (!Ext.isEmpty(node)) {
                view.setChecked(node, true);
                view.saveNodeCheckState(node);
                if (node.hasChildNodes()) {
                    node.expand();
                    Ext.each(node.childNodes,
                        function(childNode) {
                            view.setChecked(childNode, true);
                            view.saveNodeCheckState(childNode);
                        });
                }
            }
            view.doCheckChild();
        },

        checkPrimary: function() {
            var view = this.parentView || this;
            var node = view.budgetTree.getSelNode();
            view.checkAllPrimaryChildNode(node);
            view.doCheckChild();
        },

        checkAllPrimaryChildNode: function(node) {
            var view = this;
            if (!Ext.isEmpty(node)) {
                if (node.hasChildNodes()) {
                    node.expand();
                    Ext.each(node.childNodes,
                        function(childNode) {
                            view.checkAllPrimaryChildNode(childNode);
                        });
                } else {
                    view.setChecked(node, true);
                    view.saveNodeCheckState(node);
                }
            }
        },

        unmarkAllNodes: function() {
            var view = this.parentView || this;
            var node = view.budgetTree.getRootNode().childNodes[0];
            view.checkAllChildNode(node, false, false);
            view.doCheckChild();
        },

        invertAllNodes: function() {
            var view = this.parentView || this;
            var node = view.budgetTree.getRootNode().childNodes[0];
            view.checkAllChildNode(node, null, false);
            view.doCheckChild();
        },

        doCheckChild: function() {
            var view = this;
            view.serverCall({
                method: 'CheckAllChildNode',
                params: [view.getNodeCheckStates()],
                waitMessage: 'Обновление дерева бюджетов',
                success: function() {
                    view.touch();
                    view.cleanNodeCheckStates();
                }
            });
        },
        
        saveNodeCheckState: function(node){
            if (!this.checkedNodesBudgetTree)
                this.checkedNodesBudgetTree = {};
            this.checkedNodesBudgetTree[node.id] = node.get("checked");
        },
        
        getNodeCheckStates: function(){
            return this.checkedNodesBudgetTree;
        },
        
        cleanNodeCheckStates: function(){
            this.checkedNodesBudgetTree = {};
        },

        setChecked: function(node, checked) {
            if (!Ext.isBoolean(checked)) 
                checked = !node.data.checked;
            node.set('checked', checked);
        },

        collapseAllNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.collapseAll();
        },

        expandAllNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.expandAll();
        },
          
        onlyCheckedChange: function(component, newValue) {
            var view = this.parentView || this;
            var filters = view.budgetTree.store.getFilters();
            if (newValue) 
                filters.add(view.applyFilterToNodes);
            else
                filters.remove(view.applyFilterToNodes);
        },

        applyFilterToNodes: function(node) {
            var isNodeHasCheckedChild = false;
            var hasCheckedChildNodes = function(node) {
                if (node.get("checked") === true) {
                    isNodeHasCheckedChild = true;
                } else {
                    if (node.hasChildNodes()) {
                        Ext.each(node.childNodes,
                            function(childNode) {
                                hasCheckedChildNodes(childNode);
                            });
                    }
                }
            };
            hasCheckedChildNodes(node);
            return !!(node.get("checked") || node.isRoot() || isNodeHasCheckedChild);
        },

        selectBudgetTreeVersion: function(combo, newValue) {
            var view = this.parentView || this;
            var selectRecord = combo.findRecord(combo.valueField, newValue);
            if (selectRecord) {
                view.serverCall({
                    method: 'SelectBudgetTreeVersion',
                    params: [newValue],
                    waitMessage: 'Загрузка дерева бюджетов...',
                    success: function() {
                        view.budgetTree.getRootNode().removeAll(true);
                        view.budgetTree.fullReload();
                    }
                });
            }
        }
    });
}(RouteAgreementEditView.prototype));

// ===== FORMS ======
(function (viewClass) {
    KS.apply(viewClass, {

        addForms: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddForms',
                waitMessage: 'Открытие справочника ...'
            });
        },

        deleteForms: function () {
            var view = this.parentView || this,
                recs2Del = view.formsList.getCheckedRows(),
                formsLinks = view.formsList.getCheckedCodes();
            if (Ext.isEmpty(formsLinks)) return;
            KS.confirm("Удалить отмеченные формы?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteForms',
                        params: [formsLinks],
                        waitMessage: 'Удаление ...',
                        success: function (changed) {
                            if (changed) {
                                view.touch();
                                Ext.each(recs2Del, function (r) {
                                    view.formsList.store.remove(r);
                                });
                            }
                        }
                    });
                }
            });
        },

        formsGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
            var view = this;
            var dataIndex = e.position.column.dataIndex;
            if (dataIndex === "NASTR") {
                view.serverCall({
                    method: 'OpenNastr',
                    params: [rowIndex]
                });
            } else if (dataIndex === "ATTRIBUTES") {
                var formLink = KS.Grid.getAnyCase(record, "LINK_ROUTE_AGREEMENT_FORM");
                view.serverCall({
                    method: 'GetAttrSelectGrid',
                    params: [formLink],
                    success: function(grid) {
                        view.showAttrSelectGrid(grid, formLink);
                    }
                });
            }
        },

        showAttrSelectGrid: function(grid, formLink) {
            if (grid) {
                var view = this;
                this.attrSelectGrid = this.createTemplateControl(grid);
                this.attrSelectWin = KS.showModal(this.attrSelectGrid,
                    {
                        title: 'Справочник атрибутов',
                        autoHeight: false,
                        layout: "fit",
                        minWidth: 400,
                        minHeight: 300,
                        width: Math.max(400, KS.rootViewport.getWidth() / 2),
                        height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function() {
                                    view.setNewAttrValues(formLink);
                                }
                            },
                            { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function() {
                                    view.attrSelectWin.close();
                                }
                            }]
                    },
                    true);
            }
        },

        attrSelectGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
            var view = this;
            var dataIndex = e.position.column.dataIndex;
            if (dataIndex.toLowerCase() === "value") {
                var linkAttribute = KS.Grid.getAnyCase(record, "link_attribute");
                view.serverCall({
                    method: 'OpenAttrDictGrid',
                    params: [linkAttribute]
                });
            }
        },

        setNewAttrValues: function(formLink) {
            var view = this;
            view.serverCall({
                method: 'SetNewAttrForForm',
                params: [formLink],
                success: function() {
                    view.attrSelectWin.close();
                    view.formsList.reload();
                }
            });
        }
    });
}(RouteAgreementEditView.prototype));

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();