﻿// ============= VIEW =======================
NewsView = KS.extend(BaseSvodView, {
    onTemplateRendered: function () {
        if (this.newsGrid) {
            this.newsGrid.moveClass('news-grid', true);
            this.showNews();
        }
    }
});

// ============= GRID =======================
(function (viewClass) {
    KS.apply(viewClass, {
        showGridNews: function () {
            this.newsGrid.getStore().removeAll();
            this.newsForShow = [].slice.call(this.data.news || [], 0);
            this.hasSystemsRows = false;
            this.linx = [];
            KS.defer(this.showNext, [], this, 1);
        },

        showNext: function () {
            var newsGrid = this.newsGrid;
            if (KS.isEmpty(this.newsForShow)) {
                // All rendered
                if (Ext.isEmpty(this.linx)) {
                    this.close();
                } else {
                    this.serverCall({
                        method: 'SetNewsRead',
                        params: [this.linx],
                        disableFog: true
                    });
                    // Expand first 5
                    newsGrid.getStore().each(function (rec) {
                        if (rec.isSystem || !newsGrid.hasSystemsRows) {
                            var rowIdx = newsGrid.getStore().indexOf(rec);
                            if (rowIdx < 5) {
                                newsGrid.expandRow(rowIdx);
                                if (KS.isFunction(newsGrid.scrollTo)) newsGrid.scrollTo(0, 0);
                            }
                        }
                    });
                }
            } else {
                // Render next item
                var newsItem = this.newsForShow.splice(0, 1)[0];
                if (!newsGrid.addRecord) return;
                var ai = (newsItem.Attachments || []).slice(0),
                    newRec = newsGrid.addRecord(newsItem);
                newRec.isSystem = (newsItem.IsSystem === true || newsItem.IsSystem === 'true');
                if (newRec.isSystem) this.hasSystemsRows = true;
                newRec.Attachments = ai;
                this.linx.push(newsItem.NewsLink);
                KS.defer(this.showNext, [], this, 1);
            }
        },

        toWord: function () {
            var view = this.parentView,
                links = view.newsGrid.getCheckedCodes(true);
            view.serverCall({
                method: 'ToWord',
                waitMessage: 'Формирование документа ...',
                params: [links],
                success: KS.openUrl
            });
        }
    });
}(NewsView.prototype));

// ============= VOTE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onBtnClick: function (newsLink, btnId) {
            var parts = btnId.split('_');
            if (parts.length !== 2) return;
            var action = parts[0],
                votingId = parts[1],
                variants = [];
            if (action === 'send') {
                variants = this.collectVariants(votingId);
            } else if (action === 'result') {
            }
            this.serverCall({
                method: 'OnProcessVoting',
                params: [newsLink, votingId, variants],
                success: this.afterProcessVoting
            });
        },

        afterProcessVoting: function (result) {
            var votingId = result.votingId;
            if (KS.isEmpty(votingId)) return;
            var fset = document.getElementById('voting_' + votingId);
            if (!fset) return;
            fset.disabled = true;
            if (result.votingResults) {
                $(fset).find("textarea").css({ display: "none" });
                var voteEls = $(fset).find("*[id*='VOTE_']");

                voteEls.each(function (i, el) {
                    var jel = $(el);
                    jel.css({ display: "" });
                    if (KS.isEmpty(jel.html())) {
                        jel.html(el.id.indexOf('VOTE_PROCENT') >= 0 ? '0%' : '0');
                    }
                });

                for (var vrIdx in result.votingResults) {
                    var vr = result.votingResults[vrIdx];

                    voteEls.each(function (i, el) {
                        if (el.id.indexOf(vr.answer) >= 0) {
                            if (el.id.indexOf('VOTE_COUNT') >= 0) {
                                $(el).html(vr.voteCount);
                            }
                            if (el.id.indexOf('VOTE_PROCENT') >= 0) {
                                if (el.id.indexOf('TABLE') < 0) {
                                    $(el).html(vr.voteProcent + "%");
                                } else {
                                    $(el).width(KS.Svod.normalizeFloatValue(vr.voteProcent, 0) + "%");
                                }
                            }
                        }

                        if (el.id.indexOf(vr.question) >= 0 && el.id.indexOf('ALL_VOTE_COUNT') >= 0) {
                            $(el).html(vr.allCount);
                        }
                    });

                    $(fset).find("ul").each(function (i, ul) {
                        if (ul.id.indexOf(vr.answer) >= 0) {
                            $(ul).css({ display: "" });
                            for (var oaIdx in result.openAnswers) {
                                var openAnswer = result.openAnswers[oaIdx];
                                if (openAnswer.VARIANT_ID === vr.answer)
                                    $(ul).append($("<li>").text(openAnswer.VALUE));
                            }
                        }
                    });
                }
            }
        },

        collectVariants: function (votingId) {
            var variants = [],
                fset = $('#voting_' + votingId);
            fset.find("*[id*='variant_']").each(function (i, el) {
                if (el.value && (el.tagName !== 'INPUT' || el.checked)) {
                    variants.push([
                        el.getAttribute('data-id_question_'),
                        el.getAttribute('data-id_'),
                        el.value
                    ]);
                }
            });
            return variants;
        }
    });
}(NewsView.prototype));

// ============= RENDERERS =======================
function newsReadRenderer(value, metadata, record) {
    var ni = record.newsItem || record.data;
    if (ni.IsSystem) {
        metadata.css += ' news-system';
        setTooltip(metadata, 'Системное');
    } else if (ni.IsImportant) {
        metadata.css += ' news-important';
        setTooltip(metadata, 'Важное');
    } else if (ni.IsOld) {
        metadata.css += ' news-read';
        setTooltip(metadata, 'Прочитанное');
    } else {
        metadata.css += ' news-unread';
        setTooltip(metadata, 'Не прочитанное');
    }
}

function newsTextRenderer(value, metadata, record) {
    var ni = record.newsItem || record.data,
        base = '<div class="news-content"><b>' + ni.Name + '</b></div>',
        add = '';// '<div>' + ni.Body + '</div>';
    return base + add;
}

function newsAttachmentsRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var ni = record.newsItem || record.data,
        html = '',
        view = (store.store || store).grid.parentView;
    if (Ext.isEmpty(record.Attachments)) return '';
    Ext.each(record.Attachments, function (ai, idx) {
        if (idx > 0) {
            html += '</br></br>';
        }
        html += '<span class="like-hypertext" onclick="' +
            "openNewsAttachment('" + view.viewID + "'," + ni.NewsLink + "," + ai.FileLink + ');return false;">' +
            ai.Name + '</span> (' + KS.formatSize(ai.Size, 1) + ')';
        if (!Ext.isEmpty(ai.Comment)) html += ' - ' + ai.Comment;
    });
    return '<div style="white-space:normal !important;word-break:break-word;" class="news-content">' + html + '</div>';
}

function openNewsAttachment(viewId, newsLink, fileLink) {
    var view = KS.getView(viewId);
    if (!view || newsLink <= 0 || fileLink <= 0) return;
    view.serverCall({
        method: 'OpenAttachment',
        params: [newsLink, fileLink],
        waitMessage: 'Получение данных ...',
        success: view.openUrl
    });
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();