﻿NewsEditView = KS.extend(BaseSvodView, {});
var vc = NewsEditView.prototype;

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        printGridPropertyName: 'usersGrid', //Пока единственный грид с кнопкой печати

        onTemplateRendered: function() {
            this.editHtmlEditorToolbar();

            if (!this.data.isNewNews)
                this.discardChanges();
        },

        getTbarClickHandler: function(tbarItem) {
            if (!tbarItem) return null;
            var sc = NewsEditView.superclass;
            switch (tbarItem.code) {
                case "MENU-1239920700": //Меню Добавить
                    return null;

                case "ADD_USER":
                    return this.addUser;

                case "ADD_GROUP":
                    return this.addGroup;

                case "DELETE":
                    return this.deleteUser;
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },

        onValuesSelected: function (arg) {
            var view = this;
            if (arg[0][0]) {
                view.usersGrid.reload();
                view.touch();
            }
        },

        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        saveChanges: function() {
            var view = this.parentView || this;
            var newHtmlValue = view.htmlEditor.getValue();
            var mainProps = view.collectProps();
            view.serverCall({
                method: 'SaveNewsChanges',
                params: [newHtmlValue, mainProps],
                waitMessage: 'Сохранение ...',
                success: view.saveChangesCallback
            });
        },

        saveChangesCallback: function(hasErrors) {
            if (hasErrors !== true) {
                this.discardChanges();
                this.reload();
            }
        },

        resetView: function() {
            this.filesGrid.reload();
            this.sheduleGrid.reload();
            this.usersGrid.reload();

            var mainProps = this.data.dictionaryFromNewsRow;
            this.isActiveEditor.setValue(!mainProps["IS_DISABLED"]);
            this.isGlobalEditor.setValue(mainProps["IS_GLOBAL"]);
            this.isImportantEditor.setValue(mainProps["IS_IMPORTANT"]);
            this.isOperativeEditor.setValue(mainProps["IS_OPERATIVE"]);
            this.nameEditor.setValue(mainProps["NAME"]);
            this.beginDateEditor.setValue(KS.parseAjaxDateTime(mainProps["BEGIN_DATE"]));
            this.endDateEditor.setValue(KS.parseAjaxDateTime(mainProps["END_DATE"]));
            this.infoEditor.setValue(mainProps["INFO"]);
            this.htmlEditor.setValue(mainProps["NEWS"]);
            this.clientTypeEditor.setValue(this.data.clientTypeValues);

            this.discardChanges();
        },

        collectProps: function() {
            var clientTypes = this.clientTypeEditor.getValue();
            var clientType = clientTypes.reduce(function (a, b) {
                return a + b;
            }, 0);
            return {
                IsDisabled:  !(this.isActiveEditor.getValue()),
                IsGlobal:    this.isGlobalEditor.getValue(),
                IsImportant: this.isImportantEditor.getValue(),
                IsOperative: this.isOperativeEditor.getValue(),
                Name:        this.nameEditor.getValue(),
                ClientType:  clientType,
                BeginDate:   this.beginDateEditor.getValue(),
                EndDate:     this.endDateEditor.getValue()
            }
        },

        globalCheckChange: function(comp, checked) {
            if (checked) {
                this.usersTab.tab.hide();
                if (this.tabControlMain.getActiveTab() === this.usersTab) 
                    this.tabControlMain.setActiveTab(0);
            } else {
                this.usersTab.tab.show();
            }
            this.touch();
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DoSaveFiles',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: view.changeFilesCallback
            });
        },

        changeFilesCallback: function() {
            this.filesGrid.reload();
            this.touch();
        },

        deleteFile: function() {
            var view = this.parentView || this;
            var checkedCodes = view.filesGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'DeleteFiles',
                    params: [checkedCodes],
                    waitMessage: 'Удаление ...',
                    success: view.changeFilesCallback
                });
            }
        },

        addUser: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddUser'
            });
        },

        addGroup: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddGroup'
            });
        },

        deleteUser: function() {
            var view = this.parentView || this;
            var checkedRows = view.usersGrid.getCheckedRows();
            var checkedCodes = view.usersGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                KS.confirm('Удалить выделенные строки?', "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.deleteUserInternal(checkedCodes, checkedRows);
                });
            }
        },

        deleteUserInternal: function(checkedCodes, checkedRows) {
            var view = this;
            view.serverCall({
                method: 'DeleteUsers',
                params: [checkedCodes],
                waitMessage: 'Удаление ...',
                success: function() {
                    Ext.each(checkedRows, function (rec2Del) {
                        view.usersGrid.getStore().remove(rec2Del);
                    });
                    view.touch();
                }
            });
        },

        changeClientType: function(comp) {
            if (comp.value.slice(-1)[0] == 0) { // Если выбрали Любой, то сбрасываем остальные
                comp.setValue(0);
            } else if (comp.value.indexOf(0) != -1) {  // Выбрали не "Любой", убираем Любой если есть
                comp.value.splice(comp.value.indexOf(0), 1);
                comp.setValue(comp.value);
            }
            this.touch();
        }
    });
})(vc);

// ============= HTML EDITOR TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        editHtmlEditorToolbar: function() {
            var view = this,
                htmlEditor = view.htmlEditor,
                nodesSettings = htmlEditor.toolbarNodesSettings;

            view.setTooltips();

            if (nodesSettings) {
                Ext.each(nodesSettings, function (settings) {
                    switch (settings.xtype) {
                        case 'button':
                            view.htmlEditorInsertButton(settings);
                            break;

                        case 'tbseparator':
                            view.htmlEditorInsertSeparator(settings);
                            break;

                        case 'widget':
                            switch (settings.itemId) {
                                case 'fontSizeSelect':
                                    view.htmlEditorInsertFontSizeSelector(settings);
                                    break;

                                case 'editMenu':
                                    view.htmlEditorInsertEditMenu(settings);
                                    break;
                            }
                            break;
                    }
                });

                var updToolbarMethod = htmlEditor.updateToolbar;

                // Переопределяем updateToolbar, сохраняя вызов изначального метода
                htmlEditor.updateToolbar = function() {
                    updToolbarMethod.call(htmlEditor);

                    view.updateButton('justifyfull');
                    view.updateSelectedFontSize();
                };
            }

            view.addTableButton();
            view.addVotingButton();
        },

        setTooltips: function() {
            this.htmlEditor.getToolbar().items.each(function(item) {
                if (item.componentCls === 'x-btn' && item.overflowText) {
                    item.el.dom.setAttribute(item.getTipAttr(), item.overflowText);
                }
            });
        },

        updateButton: function(name) {
            var view = this,
                state;

            try {
                state = view.htmlEditor.getDoc().queryCommandState(name);
            } catch (e) {
                state = false;
            }

            view.htmlEditor.getToolbar().items.map[name].toggle(state);
        },

        updateSelectedFontSize: function () {
            var htmlEditor = this.htmlEditor,
                queriedSize = htmlEditor.getDoc().queryCommandValue('fontSize'),
                fontSizeSelect = htmlEditor.fontSizeSelect.dom;

            if (queriedSize !== fontSizeSelect.value) {
                fontSizeSelect.value = queriedSize;
            }
        },

        htmlEditorInsertSeparator: function (settings) {
            this.htmlEditor.getToolbar().insert(settings.insertPosition, {xtype: settings.xtype});
        },

        htmlEditorInsertButton: function (settings) {
            var htmlEditor = this.htmlEditor,
                toolbar = htmlEditor.getToolbar();

            toolbar.insert(settings.insertPosition, {
                xtype: settings.xtype,
                itemId: settings.itemId,
                enableOnSelection: true,
                tooltip: settings.tooltip,
                enableToggle: settings.enableToggle !== undefined ? settings.enableToggle : false,
                iconCls: settings.iconCls,
                handler: function() {
                    htmlEditor.relayCmd(settings.itemId);
                }
            });
        },

        htmlEditorInsertFontSizeSelector: function (settings) {
            var htmlEditor = this.htmlEditor,
                toolbar = htmlEditor.getToolbar();

            var fontSizeSelectItem = Ext.widget('component', {
                itemId: settings.itemId,
                renderTpl: [
                    '<select id="{id}-selectEl" data-ref="selectEl" class="x-font-select">',
                    '</select>'
                ],
                childEls: ['selectEl'],
                afterRender: function() {
                    htmlEditor.fontSizeSelect = this.selectEl;
                    htmlEditor.defaultFontSize = 2;
                    var select = htmlEditor.down('#fontSizeSelect').selectEl.dom;
                    var selIdx = 0;
                    for (var i = 0; i < settings.fontSizes.length; i++) {
                        var fontSize = settings.fontSizes[i];
                        var option = new Option(fontSize, fontSize);
                        if (fontSize === htmlEditor.defaultFontSize) {
                            selIdx = i;
                        }
                        select.options.add(option);
                    }
                    select.options[selIdx].selected = true;
                    Ext.Component.prototype.afterRender.apply(this, arguments);
                },
                onDisable: function() {
                    var selectEl = this.selectEl;
                    if (selectEl) {
                        selectEl.dom.disabled = true;
                    }
                    Ext.Component.prototype.onDisable.apply(this, arguments);
                },
                onEnable: function() {
                    var selectEl = this.selectEl;
                    if (selectEl) {
                        selectEl.dom.disabled = false;
                    }
                    Ext.Component.prototype.onEnable.apply(this, arguments);
                },
                listeners: {
                    change: function() {
                        htmlEditor.win.focus();
                        htmlEditor.relayCmd('FontSize',  htmlEditor.fontSizeSelect.dom.value);
                        htmlEditor.deferFocus();
                    },
                    element: 'selectEl'
                }
            });
            toolbar.insert(settings.insertPosition, fontSizeSelectItem);
        },

        htmlEditorInsertEditMenu: function (settings) {
            var htmlEditor = this.htmlEditor,
                toolbar = htmlEditor.getToolbar(),
                editMenuItems = [];

            Ext.each(settings.items, function(itemSettings) {
                if (!itemSettings.xtype) {
                    editMenuItems.push({
                        text: itemSettings.text,
                        iconCls: itemSettings.iconCls,
                        disabled: itemSettings.disabled,
                        handler: function() {
                            htmlEditor.relayCmd(itemSettings.cmd);
                        }
                    });
                }
                else {
                    editMenuItems.push({
                        xtype: itemSettings.xtype
                    });
                }
            });

            var editMenu = {
                itemId: settings.itemId,
                text: settings.text,
                tabIndex: -1,
                menu: Ext.widget('menu', {
                    items: editMenuItems
                })
            };

            toolbar.insert(settings.insertPosition, editMenu);
        }
    });
})(vc);

// ============= TABLE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        addTableButton: function() {
            var view = this,
                htmlEditor = view.htmlEditor,
                toolbar = htmlEditor.getToolbar();

            toolbar.add(new Ext.toolbar.Separator());

            var tableButton = Ext.create({
                itemId: 'ADD_TABLE',
                xtype: 'splitbutton',
                iconCls: 'ks-icon-grid',
                tooltip: 'Таблица',
                scope: this,
                menu: [
                    {
                        text: 'Вставить таблицу',
                        handler: function() {
                            view.getTablePanel();
                        }
                    },
                    {
                        text: 'Строка',
                        menu: [
                            {
                                text: 'Вставить строку сверху',
                                handler: function() {
                                    view.htmlTableRowsEditHandler('insertAbove');
                                }
                            },
                            {
                                text: 'Вставить строку снизу',
                                handler: function() {
                                    view.htmlTableRowsEditHandler('insertBelow');
                                }
                            },
                            {
                                text: 'Удалить строку',
                                handler: function() {
                                    view.htmlTableRowsEditHandler('remove');
                                }
                            }
                        ]
                    },
                    {
                        text: 'Столбец',
                        menu: [
                            {
                                text: 'Вставить столбец слева',
                                handler: function() {
                                    view.htmlTableColumnsEditHandler('insertLeft');
                                }
                            },
                            {
                                text: 'Вставить столбец справа',
                                handler: function() {
                                    view.htmlTableColumnsEditHandler('insertRight');
                                }
                            },
                            {
                                text: 'Удалить столбец',
                                handler: function() {
                                    view.htmlTableColumnsEditHandler('remove');
                                }
                            }
                        ]
                    }
                ],
                handler: view.getTablePanel
            });

            toolbar.add(tableButton);
        },

        getTablePanel: function() {
            var view = this;
            view.serverCall({
                method: 'GetCreateTablePanel',
                success:  function (panel) {
                    view.showTableCreationPanel(panel);
                }
            });
        },

        showTableCreationPanel: function (panel) {
            if (Ext.isEmpty(panel)) return;
            var view = this;
            view.tableCreationPanel = view.createTemplateControl(panel, "tableCreationPanel");
            view.addPanelItems(panel, view.tableCreationPanel);
            view.tableCreationWin =  KS.showModal(view.tableCreationPanel, {
                title: 'Вставка таблицы',
                autoHeight: false,
                layout: 'anchor',
                height: 365,
                minHeight: 320,
                width: 350,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.createTable();
                    }
                }, { xtype: 'tbspacer', width: 4 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.tableCreationWin.close();
                        }
                    }]
            }, true);
        },

        createTable: function() {
            var view = this,
                colCount = view.columnCountField.getValue(),
                rowCount = view.rowCountField.getValue(),
                borderWeight = view.borderWeightField.getValue();

            if (!colCount || !rowCount || !borderWeight)
                return;

            var htmlTable = '<table class="table_border' + borderWeight +
                '" cellspacing="0" cellpadding="0" width="' + colCount * 100 + '"><tbody>';

            for (var i = 0; i < rowCount; i++) {
                htmlTable += '<tr>';
                for (var j = 0; j < colCount; j++) {
                    htmlTable += '<td class="tableCell_border' + borderWeight + '"><br></td>';
                }
                htmlTable += '</tr>';
            }
            htmlTable += '</tbody></table>';

            view.htmlEditor.insertAtCursor(htmlTable);
            view.createTableStyle(borderWeight);

            view.tableCreationWin.close();
            view.touch();
        },

        createTableStyle: function(borderWeight) {
            var view = this,
                htmlText = view.htmlEditor.getValue();

            var styleTagIndex = htmlText.indexOf('<style>');
            if (styleTagIndex !== -1) {
                if (htmlText.includes('.table_border' + borderWeight) &&
                    htmlText.includes('.tableCell_border' + borderWeight))
                    return;
                styleTagIndex += 7;
            }
            else {
                htmlText = Ext.String.insert(htmlText, '<style></style>', 0);
                styleTagIndex = 7;
            }

            var classes = '.table_border' + borderWeight +
                ' { BORDER-TOP: medium none; BORDER-RIGHT: windowtext ' + borderWeight + 'px solid; ' +
                'BORDER-BOTTOM: windowtext ' + borderWeight + 'px solid; BORDER-LEFT: medium none } ' +
                '.tableCell_border' + borderWeight +
                ' { BORDER-TOP: windowtext ' + borderWeight + 'px solid; BORDER-RIGHT: medium none; ' +
                'BORDER-BOTTOM: medium none; BORDER-LEFT: windowtext ' + borderWeight + 'px solid }';

            htmlText = Ext.String.insert(htmlText, classes, styleTagIndex);

            view.htmlEditor.setValue(htmlText);
        },

        getHtmlEditorElement: function(tagName) {
            var view = this,
                tableSelection = view.htmlEditor.getWin().getSelection();

            if (tableSelection.type === 'None')
                return null;

            var selElement = tableSelection.getRangeAt(0).commonAncestorContainer;
            if (selElement.tagName === tagName) {
                return selElement;
            }

            return view.getParentElementRecursive(selElement, tagName);
        },

        getParentElementRecursive: function(htmlElement, tagName) {
            if (htmlElement.parentElement === null) {
                return null;
            }
            if (htmlElement.parentElement.tagName === tagName) {
                return htmlElement.parentElement;
            }
            else {
                return this.getParentElementRecursive(htmlElement.parentElement, tagName);
            }
        },

        htmlTableRowsEditHandler: function(opCode) {
            var view = this,
                selElement = view.getHtmlEditorElement('TR');

            if (Ext.isEmpty(selElement))
                return;

            var selRowIndex = selElement.sectionRowIndex;
            var htmlTableTbody = selElement.parentElement;

            switch (opCode) {
                case 'insertAbove':
                    view.insertNewRow(selRowIndex, htmlTableTbody, false);
                    break;

                case 'insertBelow':
                    view.insertNewRow(selRowIndex, htmlTableTbody, true);
                    break;

                case 'remove':
                    view.removeRow(selRowIndex, htmlTableTbody);
                    break;
            }
        },

        insertNewRow: function(selRowIndex, htmlTableTbody, insertBelow) {
            var insertIndex = insertBelow ? selRowIndex + 1 : selRowIndex;
            var selectedRowNewIndex = insertBelow ? selRowIndex : selRowIndex + 1;

            htmlTableTbody.insertRow(insertIndex);
            var insertedRow = htmlTableTbody.rows[insertIndex];

            Ext.each(htmlTableTbody.rows[selectedRowNewIndex].cells, function(cell) {
                insertedRow.insertCell();
                insertedRow.cells[insertedRow.cells.length - 1].className = cell.className;
                insertedRow.cells[insertedRow.cells.length - 1].setHTMLUnsafe('<br>');
            });

            this.touch();
        },

        removeRow: function(selRowIndex, htmlTableTbody) {
            htmlTableTbody.deleteRow(selRowIndex);

            // Если строк не осталось, убираем тег table
            if (htmlTableTbody.rows.length === 0) {
                htmlTableTbody.parentElement.remove();
            }

            this.touch();
        },

        htmlTableColumnsEditHandler: function(opCode) {
            var view = this,
                selElement = view.getHtmlEditorElement('TD');

            if (Ext.isEmpty(selElement))
                return;

            var cellIndex = selElement.cellIndex;
            var htmlTableTbody = selElement.parentElement.parentElement;

            switch (opCode) {
                case 'insertLeft':
                    view.insertNewColumn(cellIndex, htmlTableTbody, false);
                    break;

                case 'insertRight':
                    view.insertNewColumn(cellIndex, htmlTableTbody, true);
                    break;

                case 'remove':
                    view.removeColumn(cellIndex, htmlTableTbody);
                    break;
            }
        },

        insertNewColumn: function(cellIndex, htmlTableTbody, insertRight) {
            var insertIndex = insertRight ? cellIndex + 1 : cellIndex;
            var selectedCellNewIndex = insertRight ? cellIndex : cellIndex + 1;

            Ext.each(htmlTableTbody.rows, function(row) {
                row.insertCell(insertIndex);
                row.cells[insertIndex].className = row.cells[selectedCellNewIndex].className;
                row.cells[insertIndex].setHTMLUnsafe('<br>');
            });

            this.touch();
        },

        removeColumn: function(cellIndex, htmlTableTbody) {
            Ext.each(htmlTableTbody.rows, function(row) {
                row.deleteCell(cellIndex);
            });

            // Если в строках не осталось ячеек, убираем тег table
            if (htmlTableTbody.rows.length > 0 && htmlTableTbody.rows[0].cells.length === 0) {
                htmlTableTbody.parentElement.remove();
            }

            this.touch();
        }
    });
})(vc);

// ============= VOTING =======================
(function (viewClass) {
    KS.apply(viewClass, {
        addVotingButton: function() {
            var votingButton = new Ext.Button({
                tooltip: 'Редактор опросов',
                iconCls: 'x-edit-insertorderedlist',
                scope: this,
                itemId: "EDIT_VOTING",
                handler: this.editVoting
            });
            this.htmlEditor.getToolbar().add(votingButton);
        },

        editVoting: function() {
            this.serverCall({
                method: 'GetVotingPanel',
                success: this.getNestedVotingJson
            });
        },

        getNestedVotingJson: function(votingPanel) {
            var view = this;
            view.serverCall({
                method: 'GetNestedVotingJson',
                success: function(votingsJson) {
                    view.showVotingPanel(votingsJson, votingPanel);
                }
            });
        },

        showVotingPanel: function(votingsJson, votingPanel) {
            if (Ext.isEmpty(votingPanel)) return;
            var view = this;

            view.votingPanel = view.createTemplateControl(votingPanel);
            view.addPanelItems(votingPanel, view.votingPanel);

            view.createAndLocateVotingGrid({
                xtype: 'store',
                autoLoad: true,
                data: votingsJson
            });

            view.votingWin = KS.showModal(view.votingPanel,{
                title: 'Редактор опросов',
                autoHeight: false,
                modal: true,
                width: Math.max(600, KS.rootViewport.getWidth() / 4),
                height: Math.max(500, KS.rootViewport.getHeight() / 2),
                buttonAlign: 'left',
                buttons: new Array('->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.editVotingData();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.votingWin.close();
                        }
                    })
            }, true);
        },

        createAndLocateVotingGrid: function(votingStore) {
            var view = this,
                panel = view.votingPanel;

            var variantGrid = {
                xtype: 'grid',
                width: '100%',
                height: 100,
                cls: 'custom-selector-cls',
                bind: {
                    id: '{record.id_question_}',
                    store: '{record.variants}'
                },
                sortableColumns: false,
                columns: [
                    {
                        text: 'Вариант ответа',
                        dataIndex: 'variant_',
                        flex: 1,
                        editor: {
                            allowBlank: false
                        }
                    }],
                listeners: {
                    select: function(grid, record, index) {
                        view.votingWin.selectedVariant = record;
                        view.votingWin.selectedVariantStore = grid.getStore();
                        view.votingWin.selectedLastType = 'variant';
                    },
                    deselect: function() {
                        delete view.votingWin.selectedLastType;
                        delete view.votingWin.selectedVariant;
                    }
                },
                plugins: [{ ptype: 'cellediting', clicksToEdit: 1 }]
            };

            var questionTypes = [
                { "value": 0, "title": 'Выбор одного варианта' },
                { "value": 1, "title": 'Выбор нескольких вариантов' },
                { "value": 2, "title": 'Открытый ответ (нет вариантов)' }
            ];

            var questionGrid = {
                xtype: 'grid',
                width: '100%',
                height: 200,
                bind: {
                    id: '{record.id_voting_}',
                    store: '{record.questions}'
                },
                sortableColumns: false,
                columns: [
                    {
                        text: 'Вопрос',
                        dataIndex: 'question_',
                        flex: 1,
                        editor: {
                            allowBlank: false
                        }
                    },
                    {
                        text: 'Способ ответа',
                        dataIndex: 'question_type',
                        flex: 1,
                        editor: {
                            xtype: 'combo',
                            valueField: 'value',
                            displayField: 'title',
                            allowBlank: false,
                            editable: false,
                            forceSelection: true,
                            flex: 1,
                            store: {
                                xtype: 'store',
                                fields: ['value', 'title'],
                                data: questionTypes
                            }
                        },
                        renderer: function(v) {
                            var record = questionTypes[v];
                            return record.title;
                        }
                    }
                ],
                listeners: {
                    select: function(grid, record, index) {
                        view.votingWin.selectedQuestion = record;
                        view.votingWin.selectedQuestionGrid = grid;
                        view.votingWin.selectedLastType = 'question';
                    },
                    deselect: function() {
                        delete view.votingWin.selectedLastType;
                        delete view.votingWin.selectedQuestion;
                        delete view.votingWin.selectedQuestionGrid;
                    }
                },
                plugins: [
                    { ptype: 'rowwidget', widget: variantGrid },
                    { ptype: 'cellediting', clicksToEdit: 1 }
                ]
            };

            var resultVisibilities = [
                { "value": 0, "title": 'Все пользователи' },
                { "value": 1, "title": 'Создатель опроса' },
                { "value": 2, "title": 'Администратор' }
            ];

            var votingGrid = {
                xtype: 'grid',
                width: '100%',
                height: 300,
                id: 'votingGrid',
                sortableColumns: false,
                store: votingStore,
                columns: [{
                    text: 'Наименование опроса',
                    dataIndex: 'voting_',
                    flex: 1,
                    editor: {
                        allowBlank: false
                    }
                },
                {
                    text: 'Просмотр результатов',
                    dataIndex: 'result_view',
                    flex: 1,
                    editor: {
                        xtype: 'combo',
                        valueField: 'value',
                        displayField: 'title',
                        allowBlank: false,
                        editable: false,
                        forceSelection: true,
                        flex: 1,
                        store: {
                            xtype: 'store',
                            fields: ['value', 'title'],
                            data: resultVisibilities
                        }
                    },
                    renderer: function (v) {
                        var record = resultVisibilities[v];
                        return record.title;
                    }
                }],
                listeners: {
                    select: function (grid, record, index) {
                        view.votingWin.selectedLastType = 'voting';
                    },
                    deselect: function () {
                        delete view.votingWin.selectedLastType;
                    }
                },
                plugins: [
                    { ptype: 'rowwidget', widget: questionGrid },
                    { ptype: 'cellediting', clicksToEdit: 1 }
                ]
            };
            panel.add(votingGrid);
        },

        addVoting: function() {
            var view = this.parentView,
                grid = view.votingPanel.items.items[0];

            var newRec = {
                voting_: '',
                result_view: 0,
                id_voting_: view.newGuid(),
                questions: []
            };

            grid.store.add(newRec);
        },
        
        addQuestion: function() {
            var view = this.parentView,
                grid = view.votingPanel.items.items[0],
                voting = grid.getSelection()[0];

            if (!voting) return;

            var newRec = {
                question_: '',
                question_type: 0,
                variants: [],
                id_voting_: voting.data.id_voting_,
                id_question_: view.newGuid(),
                id_: view.newGuid()
            };

            voting.data.questions.push(newRec);

            var questionGrid = Ext.ComponentQuery.query('grid[id=' + voting.data.id_voting_ + ']')[0];

            if (questionGrid === undefined || questionGrid === null) return;

            questionGrid.getStore().add(newRec);
        },
        
        addVariant: function() {
            var view = this.parentView,
                question = view.votingWin.selectedQuestion;

            if (!question || question.data.question_type === 2) return;

            var newRec = {
                variant_: '',
                id_: view.newGuid(),
                id_question_: question.data.id_question_
            };

            question.data.variants.push(newRec);

            var grid = Ext.ComponentQuery.query('grid[id=' + question.data.id_question_ + ']')[0];

            if (grid === undefined || grid === null) return;

            grid.getStore().add(newRec);
        },
        
        deleteVoting: function() {
            var view = this.parentView,
                grid = view.votingPanel.items.items[0],
                mainStore = grid.getStore(),
                store, selected;

            switch (view.votingWin.selectedLastType) {
                case 'voting':
                    selected = grid.getSelection()[0];
                    mainStore.remove(selected);
                    break;
                case 'question':
                    store = view.votingWin.selectedQuestionGrid.getStore();
                    selected = view.votingWin.selectedQuestion;
                    store.remove(selected); // у каждого widget грида свой отдельный store
                    Ext.each(mainStore.data.items, function (voting) {
                        var shouldContinue = true;
                        Ext.each(voting.data.questions, function (question) {
                            if (question.id_question_ !== selected.data.id_question_) return true;
                            Ext.Array.remove(voting.data.questions, question);
                            shouldContinue = false;
                            return false;
                        });
                        return shouldContinue;
                    });
                    break;
                case 'variant':
                    store = view.votingWin.selectedVariantStore;
                    selected = view.votingWin.selectedVariant;
                    store.remove(selected); // у каждого widget грида свой отдельный store
                    Ext.each(mainStore.data.items, function (voting) {
                        var shouldContinue = true;
                        Ext.each(voting.data.questions, function (question) {
                            Ext.each(question.variants, function (variant) {
                                if (variant.id_ !== selected.data.id_) return true;
                                Ext.Array.remove(question.variants, variant);
                                shouldContinue = false;
                                return false;
                            });
                            return shouldContinue;
                        });
                        return shouldContinue;
                    });
                    break;
            }
        },

        editVotingData: function() {
            var view = this,
                grid = view.votingPanel.items.items[0],
                store = grid.getStore();

            var votings = [],
                questions = [],
                variants = [];

            Ext.each(store.data.items,
                function(voting) {
                    var votingObj = {
                        voting_: voting.data.voting_,
                        result_view: voting.data.result_view,
                        id_voting_: voting.data.id_voting_
                    };
                    votings.push(votingObj);

                    Ext.each(voting.data.questions, function(question) {
                        var questionObj = {
                            question_: question.question_,
                            question_type: question.question_type,
                            id_voting_: question.id_voting_,
                            id_question_: question.id_question_,
                            id_: question.id_
                        };
                        questions.push(questionObj);

                        Ext.each(question.variants, function(variant) {
                            var variantObj = {
                                variant_: variant.variant_,
                                id_: variant.id_,
                                id_question_: variant.id_question_
                            };
                            variants.push(variantObj);
                        });
                    });
                });

            view.serverCall({
                method: 'GetVotingsHtml',
                params: [votings, questions, variants],
                success: function (html) {
                    view.htmlEditor.setValue(html);
                    view.votingWin.close();
                }
            });
        },

        newGuid: function() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }
    });
})(vc);

// ============= SHEDULE =======================
(function (viewClass) {
    KS.apply(viewClass, {

        sheduleGridEdit: function(e, context) {
            if (context.value === context.originalValue) return;
            var value = context.value;
            var linkShedule = KS.Grid.getAnyCase(context.record, "link_schedule");
            var dataIndex = context.column.dataIndex;
            this.serverCall({
                method: 'EditSheduleData',
                params: [linkShedule, dataIndex, value],
                disableFog: true,
                success: this.touch
            });
        },

        createTrigger: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetNewTriggerPanel',
                success: view.showTriggerPanel
            });
        },

        editTrigger: function() {
            var view = this.parentView || this;
            var checkedCodes = view.sheduleGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'GetEditTriggerPanel',
                    params: [checkedCodes[0]],
                    success: view.showTriggerPanel
                });
            }
        },

        showTriggerPanel: function(triggerPanel) {
            if (Ext.isEmpty(triggerPanel)) return;
            var view = this;
            this.triggerPanel = KS.create(triggerPanel);
            this.addPanelItems(triggerPanel, this.triggerPanel);
            this.triggerWin = KS.showModal(this.triggerPanel,{
                title: 'Расписание',
                autoHeight: false,
                modal: true,
                width: Math.max(650, KS.rootViewport.getWidth() / 3),
                height: Math.max(700, KS.rootViewport.getHeight() / 1.5),
                buttonAlign: 'left',
                buttons: new Array('->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.setTriggerValue();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            if (view.triggerPanel.isNewTrigger)
                                view.deleteTempRow();
                            view.triggerWin.close();
                        }
                    })
            }, true);
        },

        setTriggerValue: function() {
            var view = this;
            var description = this.summaryDesc.getValue();
            view.serverCall({
                method: 'SetTriggerValue',
                params: [description],
                success: function() {
                    view.triggerWin.close();
                    view.sheduleGrid.reload();
                    view.touch();
                }
            });
        },

        deleteTempRow: function() {
            this.serverCall({
                method: 'DeleteTempRow',
                disableFog: true
            });
        },

        deleteTrigger: function() {
            var view = this.parentView || this,
                grid = view.sheduleGrid,
                checkedCodes = grid.getCheckedCodes(),
                checkedRows = grid.getCheckedRows();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'DeleteTrigger',
                    params: [checkedCodes[0]],
                    disableFog: true,
                    success: function() {
                        grid.store.remove(checkedRows[0]);
                        view.touch();
                    }
                });
            }
        },

        setNewSheduleValues: function(values) {
            var view = this;
            if (Ext.isEmpty(values)) return;
            view.serverCall({
                method: 'SetNewSheduleValues',
                disableFog: true,
                params: [values],
                success: function(description) {
                    if (!Ext.isEmpty(description)) 
                        view.summaryDesc.setValue(description);
                }
            });
        },

        triggerTypesChange: function(comp, newValue) {
            var isSingle = newValue === 0;
            this.singlePanel.setDisabled(!isSingle);
            this.freqPanel.setDisabled(isSingle);
            this.timesInDayPanel.setDisabled(isSingle);
            this.durationPanel.setDisabled(isSingle);

            var type = isSingle ? 0 : this.freqExecType.getValue();
            if (!Ext.isEmpty(type)) 
                this.setNewSheduleValues({ "TYPE" : type });
        },

        singlePanelDateChange: function(comp, newValue) {
            if (Ext.isDate(newValue))
                this.setNewSheduleValues({ "START_DATE" : newValue });
        },
        
        freqExecTypeChange: function(comp, newValue) {
            this.freqTabPanel.setActiveTab(newValue - 1);

            var newValues = { "TYPE": newValue };
            var newCountValue = null;
            switch (newValue) {
                case 1: //Ежедневно
                    newCountValue = this.freqEveryDayRepeat.getValue();
                    break;

                case 2: //Еженедельно
                    newCountValue = this.freqEveryWeekRepeat.getValue();
                    break;

                case 3: //Ежемесячно
                    newCountValue = this.freqEveryMonthEveryMonth.getValue();
                    break;
            }

            if (newCountValue != null)
                newValues["COUNT"] = newCountValue;
            this.setNewSheduleValues(newValues);
        },

        freqEveryMonthTypeChange: function(comp, newValue) {
            var freqMonthIsDay = newValue.freqMonthType === 0;

            this.freqEveryMonthDayNumber.items.items[0].setDisabled(!freqMonthIsDay);
            this.freqEveryMonthDayMonth.items.items[0].setDisabled(!freqMonthIsDay);

            this.freqEveryMonthNumbers.setDisabled(freqMonthIsDay);
            this.freqEveryMonthDays.setDisabled(freqMonthIsDay);
            this.freqEveryMonthEveryMonth.items.items[0].setDisabled(freqMonthIsDay);

            var newValues = {};
            if (freqMonthIsDay) {
                newValues["MONTH_DAY"] = this.freqEveryMonthDayNumber.getValue();
                newValues["COUNT"] = this.freqEveryMonthDayMonth.getValue();
            } else {
                newValues["MONTH_WEEK"] = this.freqEveryMonthNumbers.getValue();
                newValues["MONTH_WEEK_DAY"] = this.freqEveryMonthDays.getValue();
                newValues["COUNT"] = this.freqEveryMonthEveryMonth.getValue();
                newValues["MONTH_DAY"] = 0;
            }
            
            this.setNewSheduleValues(newValues);
        },

        freqEveryMonthDayNumberChange: function(comp, newValue) {
            this.setNewSheduleValues({ "MONTH_DAY": newValue });
        },

        freqEveryMonthNumbersChange: function(comp, newValue) {
            this.setNewSheduleValues({ "MONTH_WEEK": newValue });
        },

        freqEveryMonthDaysChange: function(comp, newValue) {
            this.setNewSheduleValues({ "MONTH_WEEK_DAY": newValue });
        },

        freqEveryWeekDaysChange: function(comp, newValue) {
            var daysOfWeek = 0;
            Ext.each(newValue.daysOfWeek, function(dayValue) {
                daysOfWeek += dayValue;
            });

            this.setNewSheduleValues({ "DAY_OF_WEEK": daysOfWeek });
        },

        countChange: function(comp, newValue) {
            this.setNewSheduleValues({ "COUNT": newValue });
        },

        timesInDayRepeatTypeChange: function(comp, newValue) {
            var isOneTimeTask = newValue.repeatType === 0;
            // устанавливаем disabled не у FieldContainer, а у самого dateEditor и numberEditor
            this.timesInDayOneTimeTaskTime.items.items[0].setDisabled(!isOneTimeTask);

            this.timesInDayNumber.items.items[0].setDisabled(isOneTimeTask);
            this.timesInDayUnitOfTime.setDisabled(isOneTimeTask);
            this.timesInDayStartTime.items.items[0].setDisabled(isOneTimeTask);
            this.timesInDayEndTime.items.items[0].setDisabled(isOneTimeTask);

            if (isOneTimeTask) {
                this.setNewSheduleValues({ "DAY_PERIOD": 0 });
            } else {
                this.setNewSheduleValues({ "DAY_PERIOD": this.timesInDayNumber.getValue() });
                this.setNewSheduleValues({ "DAY_PERIOD_UNIT": this.timesInDayUnitOfTime.getValue() });
                this.setNewSheduleValues({ "DAY_START_TIME": this.timesInDayStartTime.getValue() });
                this.setNewSheduleValues({ "DAY_END_TIME": this.timesInDayEndTime.getValue() });
            }
        },

        timesInDayOneTimeTaskTimeChange: function(comp, newValue) {
            if (Ext.isDate(newValue))
                this.setNewSheduleValues({ "DAY_START_TIME": newValue });
        },

        timesInDayNumberChange: function(comp, newValue) {
            this.setNewSheduleValues({ "DAY_PERIOD": newValue });
        },

        timesInDayUnitOfTimeChange: function(comp, newValue) {
            this.setNewSheduleValues({ "DAY_PERIOD_UNIT": newValue });
        },

        timesInDayStartTimeChange: function(comp, newValue) {
            if (Ext.isDate(newValue))
                this.setNewSheduleValues({ "DAY_START_TIME": newValue });
        },

        timesInDayEndTimeChange: function(comp, newValue) {
            if (Ext.isDate(newValue))
                this.setNewSheduleValues({ "DAY_END_TIME": newValue });
        },

        durationHasEndDateChange: function(comp, newValue) {
            var hasEndDate = newValue.hasEndDate === 0;
            this.durationEndDate.items.items[0].setDisabled(!hasEndDate);

            if (hasEndDate)
                this.setNewSheduleValues({ "END_DATE": this.durationEndDate.getValue() });
            else
                this.setNewSheduleValues({ "END_DATE": null });
        },

        durationStartDateChange: function(comp, newValue) {
            if (Ext.isDate(newValue))
                this.setNewSheduleValues({ "START_DATE": newValue });
        },

        durationEndDateChange: function(comp, newValue) {
            if (Ext.isDate(newValue))
                this.setNewSheduleValues({ "END_DATE": newValue });
        }
    });
})(vc);

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();