﻿function issuesListRenderer(value, metadata, record/*, rowIndex, colIndex, store*/) {
    setTooltip(metadata, value);
    return record.data.state === "Новая" ? '<span style="font-weight:bold;">' + value + '</span>' : value;
}

IssuesListView = KS.extend(KS.Ext.ClientView, {
    constructor: function(viewId) {
        IssuesListView.superclass.constructor.call(this, viewId);
    },

    pageSize: 100,
    issueStateNames: ["Новая", "Назначена", "Решена"],

    onInit: function() {
        var view = this;

        view.renderToParent(view.grid = new TabListGrid({
            parentView: view,
            viewConfig: { forceFit: true },
            toolbarItems: new Array({
                iconCls: 'ks-icon-refresh',
                tooltip: 'Обновить',
                scope: view,
                handler: view.refresh
            }, '-', {
                iconCls: 'ks-icon-open',
                tooltip: 'Открыть',
                scope: view,
                handler: view.openIssue
            }, {
                iconCls: 'ks-icon-delete',
                tooltip: 'Удалить',
                scope: view,
                handler: view.deleteIssues
            }, '-', {
                iconCls: 'ks-icon-galka',
                tooltip: 'Пометить как прочитанное',
                scope: view,
                handler: view.markAsAccepted
            }, '-', {
                iconCls: 'ks-icon-filter_sys',
                tooltip: 'Отображать только непрочитанные',
                enableToggle: true,
                pressed: true,
                listeners: {
                    'toggle': function(btn, pressed) {
                        view.serverCall({
                            method: 'SetFilter',
                            params: [pressed],
                            waitMessage: 'Обработка ...',
                            success: view.refresh
                        });
                    }
                }
            }, '-'),
            gridSettings: {
                PageSize: view.pageSize,
                Band: new Array({
                    AutoExpandColumn: "details",
                    PageSize: view.pageSize,
                    Column: KS.Grid.ColumnArray(new Array({
                        dataIndex: "CHECKED"
                    }, {
                        dataIndex: "id"
                    }, {
                        dataIndex: "state",
                        header: "Статус",
                        width: 50,
                        align: 2,
                        renderer: 'issuesListRenderer',
                        visibility: true
                    }, {
                        dataIndex: "user",
                        header: "Пользователь",
                        width: 80,
                        align: 2,
                        renderer: 'issuesListRenderer',
                        visibility: true
                    }, {
                        dataIndex: "stamp",
                        header: "Дата",
                        width: 80,
                        align: 2,
                        renderer: 'issuesListRenderer',
                        visibility: true
                    }, {
                        dataIndex: "message",
                        header: "Описание",
                        width: 180,
                        align: 1,
                        renderer: 'issuesListRenderer',
                        visibility: true
                    }, {
                        dataIndex: "details",
                        header: "Подробности",
                        width: 180,
                        align: 1,
                        renderer: 'issuesListRenderer',
                        visibility: true
                    }, {
                        dataIndex: "buglink",
                        header: "Ссылка",
                        width: 110,
                        align: 1,
                        renderer: 'issuesListRenderer',
                        visibility: true
                    }))
                })
            },
            customLoad: true,
            enableFiltering: true,
            stateful: false
        }));

        view.grid.on('rowdblclick', view.openIssue, view);
        view.grid.store.on('beforeload', view.gridLoader, view);

        view.resetGrid();
    },

    resetGrid: function() {
        if (!this.grid.loaded) {
            this.grid.store.load({
                params: {
                    start: 0,
                    limit: this.pageSize
                }
            });
            this.grid.loaded = true;
        } else {
            this.grid.resetPage();
        }
    },

    gridLoader: function(store, o) {
        var view = this, newRow, issue, value,
            json = { total: view.data.length, rows: [] };
        if (store.sortInfo) store.setDefaultSort(o.params.sort, o.params.dir);
        for (var idx = o.params.start; idx < o.params.start + o.params.limit; idx++) {
            issue = view.data[idx];
            if (!issue) continue;
            newRow = {};
            for (var field in issue) {
                value = issue[field];
                switch (field) {
                case 'stamp':
                    var stamp = Ext.decode(issue[field].substring(1, issue[field].length - 1));
                    value = Ext.util.Format.date(stamp, 'Y-m-d H:i:s');
                    break;
                case 'state':
                    value = view.issueStateNames[issue[field]] || '?';
                    break;
                default:
                    if (typeof(value) == 'string') {
                        value = value.replace(/\r\n/g, '');
                        if (value.length > 100) value = value.substring(0, 100) + ' ...';
                    } else if (!value) {
                        value = '';
                    }
                    break;
                }
                newRow[field] = value;
            }
            json.rows.push(newRow);
        }
        var r = store.reader.readRecords(json);
        store.loadRecords(r, Ext.apply({}, store.lastOptions), true);
        return false;
    },

    getSelectedIssuesId: function() {
        var ids = [],
            sm = this.grid.getSelectionModel(),
            recs = sm.getAllChecked();
        if (Ext.isEmpty(recs)) recs = sm.getSelections();
        Ext.each(recs, function(rec) {
            ids.push(rec.data.id);
        });
        return ids;
    },

    refresh: function() {
        var view = this;
        view.serverCall({
            method: 'Reload',
            waitMessage: 'Обновление ...',
            success: function(data) {
                view.data = data;
                view.resetGrid();
            }
        });
    },

    openIssue: function() {
        var view = this,
            ids = view.getSelectedIssuesId();
        if (Ext.isEmpty(ids)) return;
        view.serverCall({
            method: 'OpenIssue',
            params: [ids],
            waitMessage: 'Открывается ...'
        });
    },

    markAsAccepted: function() {
        var ids = this.getSelectedIssuesId();
        if (Ext.isEmpty(ids)) return;
        this.serverCall({
            method: 'MarkAsAccepted',
            params: [ids],
            waitMessage: 'Установка ...',
            success: this.refresh
        });
    },

    deleteIssues: function() {
        var view = this,
            ids = view.getSelectedIssuesId();
        if (Ext.isEmpty(ids)) return;
        KS.confirm('Будет удалено ' + ids.length + ' отчетов. Продолжить?', "Подтвердите удаление", function(btn) {
            if (btn != 'yes') return;
            view.serverCall({
                method: 'DeleteIssues',
                params: [ids],
                waitMessage: 'Удаление ...',
                success: view.refresh
            });
        });
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();