﻿CheckSumsSelectView = KS.extend(BaseSvodView, { });

(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.cachedValues = [];
            this.groupsGrid.getSelectionModel().select(0);
        },

        groupGridRowSelect: function(selModel, record) {
            var groupLink = KS.Grid.getAnyCase(record, "LINK_GROUP");
            this.setActiveGroup(groupLink);
        },

        setActiveGroup: function(groupLink) {
            var view = this;
            if (Ext.isEmpty(groupLink)) {
                var groupLinks = view.groupsGrid.getCheckedCodes();
                if (Ext.isEmpty(groupLinks)) return;
                groupLink = groupLinks[0];
            }
            view.serverCall({
                method: 'SetActiveGroup',
                params: [groupLink],
                disableFog: true,
                success: function() {
                    view.systemRulesGrid.reload();
                    view.userRulesGrid.reload();
                }
            });
        },

        select: function() {
            var view = this.parentView;
            var checkedLinks = []; 
            checkedLinks = checkedLinks.concat(view.systemRulesGrid.getCheckedCodes());
            checkedLinks = checkedLinks.concat(view.userRulesGrid.getCheckedCodes());
            if (Ext.isEmpty(checkedLinks)) {
                KS.confirm("Не выбраны правила для копирования, скопировать все правила ?", "Копирование", function (btn) {
                    if (btn === 'yes') {
                        view.systemRulesGrid.store.each(function(rec) {
                            checkedLinks.push(KS.Grid.getAnyCase(rec, "LINK_RULE"));
                        });
                        view.userRulesGrid.store.each(function(rec) {
                            checkedLinks.push(KS.Grid.getAnyCase(rec, "LINK_RULE"));
                        });
                        view.copySelectedRules(checkedLinks);
                    }
                });
            } else {
                view.copySelectedRules(checkedLinks);
            }
        },

        copySelectedRules: function(checkedLinks) {
            var view = this;
            view.serverCall({
                method: 'CopySelectedRules',
                params: [checkedLinks, view.cachedValues],
                waitMessage: 'Копирование...'
            });
        },

        gridCellEdit: function(e, context) {
            if (context.value === null) return false;
            if (context.value === context.originalValue) return false;
            var grid = context.grid;
            var closeCodeValue = KS.Grid.getAnyCase(context.record, grid.closeCode);
            this.addInCachedValues(grid.ctrlId, closeCodeValue, context.field, context.value);
            return false;
        },

        addInCachedValues: function(gridId, closeCodeValue, dataIndex, newValue) {
            var cvalue = {
                'gridId': gridId,
                'closeCodeValue': closeCodeValue,
                'dataIndex': dataIndex,
                'newValue': newValue
            };
            this.addNewCachedValues(cvalue);
        },

        //Если меняем одно и то же поля несколько раз подрят, просто меняем последнее chachedValue
        addNewCachedValues: function(newCachedValue) {
            if (!Ext.isEmpty(this.cachedValues)) {
                var lastCachedValue = this.cachedValues[this.cachedValues.length - 1];
                if (lastCachedValue.gridId === newCachedValue.gridId &&
                    lastCachedValue.closeCodeValue === newCachedValue.closeCodeValue &&
                    lastCachedValue.dataIndex === newCachedValue.dataIndex) {
                    lastCachedValue.newValue = newCachedValue.newValue;
                    return;
                }
            }
            this.cachedValues.push(newCachedValue);
        }
    });
}(CheckSumsSelectView.prototype));

function checkSumsSelectDateRenderer(value) {
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date") && (Ext.isString(value) &&value.indexOf("GMT") !== -1)) {
        value = new Date(value);
    }
    if (Ext.isString(value) && !Ext.isEmpty(value)) {
        value = value.substring(0, 10);
    } else {
        value = Ext.util.Format.date(value, 'd.m.Y');
    }
    return (value === '06.06.2079') ? '' : value;
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();