﻿Ext.define('Svod.ColorDialogWindow', {
    extend: 'Ext.window.Window',
    alias: 'colordialog.window',
    layout: 'fit',
    title: 'Цвет',
    resizable: false,
    minWidth: 210,
    width: 210,
    minHeight: 260,
    height: 260,
    buttonAlign: 'left',
    padding: 5,

    constructor: function(config) {
        config.colorValue = (config.colorValue || '#ffffff').toLowerCase();

        this.callParent(arguments);
    },

    initComponent: function() {
        this.items = [
            new Svod.ColorDialogPanel(this.initialConfig)
        ];

        this.buttons = [
            { xtype: 'tbspacer', width: 9 },
            {
                text: 'ОК',
                cls: 'dim-button',
                scope: this,
                handler: function() {
                    if (this.selectCallBack) {
                        var selectedColor = this.colorValue;
                        var htmlColorPicker = document.getElementById("extColorPicker");
                        if (htmlColorPicker)
                            selectedColor = htmlColorPicker.value;

                        this.selectCallBack(selectedColor);
                    }
                }
            },
            { xtype: 'tbspacer', width: 7 },
            {
                text: 'Отмена',
                cls: 'dim-button',
                scope: this,
                handler: function() {
                    this.close();
                }
            }
        ];

        this.callParent();
    }
})