// ============= BPMSTreeView =======================
BPMSTreeView = KS.extend(KS.Ext.ClientView,
    {
        constructor: function(viewId) {
            BPMSTreeView.superclass.constructor.call(this, viewId);
        }
    });

// ============= BaseDocumentView =======================
BaseDocumentView = KS.extend(KS.Ext.ClientView,
    {
        constructor: function(viewId) {
            BaseDocumentView.superclass.constructor.call(this, viewId);
        },

        onTemplateRendered: function() {
        },

        templateTbarClickHandler: function () {
            var view = this.parentView,
                confirmation = (this.tbarNode.confirmations) ? this.tbarNode.confirmations[0] : null;

            if (confirmation) {
                var scope = this,
                    args = [].slice.call(arguments, 0);
                KS.confirm(confirmation.text,
                    confirmation.caption,
                    function (btn) {
                        if (confirmation.type === 1) { // ChooseBox
                            scope.confirmResult = {
                                text: confirmation.text,
                                caption: confirmation.caption,
                                btn: btn
                            };
                        }
                        if (btn === 'yes') {
                            view.templateTbarClickHandlerInternal.call(scope, args);
                        }
                    },
                    confirmation.buttons,
                    confirmation.buttonText);
            } else {
                view.templateTbarClickHandlerInternal.call(this, arguments);
            }
        },

        templateTbarClickHandlerInternal: function () {
            var view = this.parentView,
                node = this.tbarNode,
                confirmResult = this.confirmResult,
                additional = node.additional || {};
            if (confirmResult) {
                additional.confirmResults = [confirmResult];
            }
            view.serverCall({
                method: 'ToolbarClickHandler',
                waitMessage: node.waitMessage,
                params: [node.code || null, additional, view.getTemplateState()],
                success: view.checkHandler(node.onSuccess) || view.templateTbarClickHandlerCallback
            });
        }
    });

// ============= DOCUMENT_LIST =========================
// ============= DocumentListView =======================
DocumentListView = KS.extend(BaseDocumentView,
    {
        onRefresh: function() {
            this.listGrid.reload();
        }
    });

// ============= UsersListView =======================
UsersListView = KS.extend(DocumentListView,
    {
    });

// ============= DOCUMENT_EDIT =========================
// ============= BaseDocumentEditView =======================
BaseDocumentEditView = KS.extend(BaseDocumentView,
    {
        onTemplateRendered: function() {
            if (this.data.hasIdentifierChanges) {
                this.serverCall({
                    method: 'FinalizeOpenView',
                    waitMessage: KS.L10n.documentSetUp
                });
            }
            this.refreshList();
        },

        correctItemsSize: function (c, width, height, oldWidth, oldHeight) {
            //debugger;
            var origWidth = this.data.origWidth,
                coefX = width / origWidth * 0.95;
            KS.log(coefX, 'console');
            c.items.each(function (item) {
                if (KS.isFunction(item.setX)) {
                    if (KS.isEmpty(item.origX)) item.origX = item.getX();
                    //item.setX(Math.floor(item.origX * coefX));
                }
                if (KS.isFunction(item.setWidth)) {
                    if (KS.isEmpty(item.origWidth)) item.origWidth = item.getWidth();
                    //item.setWidth(Math.floor(item.origWidth * coefX));
                }
            });
        },

        findListView: function () {
            for (var view in KS.registeredViews) {
                if (KS.registeredViews.hasOwnProperty(view) &&
                    KS.registeredViews[view].data &&
                    KS.registeredViews[view].data.isDocList &&
                    KS.registeredViews[view].data.objCode === this.data.objCode) {
                    return KS.registeredViews[view];
                }
            }
            return null;
        },

        refreshList: function() {
            var docListView = this.findListView();
            if (docListView) {
                docListView.listGrid.reload();
            }
        },

        onServerSetControlAttribute: function(ctrlId, attrName, attrValue) {
            if (KS.isEmpty(this[ctrlId])) return;
            var ctrl = this[ctrlId];
            switch (attrName) {
            case 'value':
                if (KS.isFunction(ctrl.setValue)) {
                    ctrl.setValue(attrValue);
                }
                break;
            case 'fieldCls':
                if (KS.isFunction(ctrl.changeFieldCls)) {
                    ctrl.changeFieldCls(attrValue);
                }
                break;
            case 'readOnly':
                if (KS.isFunction(ctrl.setFieldReadOnly)) {
                    ctrl.setFieldReadOnly(attrValue);
                }
                break;
            }
        }
    });

function ksDictRenderer(value, metadata) {
    metadata.css += ' ks-bkgr-dict-cell';
    return value;
}

// ============= DocumentEditView =======================
DocumentEditView = KS.extend(BaseDocumentEditView,
    {
        fieldCtrlChange: function(field, newValue) {
            this.touch();
            this.serverCall({
                method: 'SaveControlValue',
                params: [field.code, field.objCode, newValue],
                disableFog: true
            });
        },

        onGridCheckboxSelectionChange: function (grid, selected) {
        },

        tabGridSelectRow: function (sm, record) {
            var grid = sm.store.grid,
                cc = grid.getCloseCode(record);
            this.saveGridValue(grid.itemId, cc, 'CHECKED', '1');
        },

        tabGridDeselectRow: function (sm, record) {
            var grid = sm.store.grid,
                cc = grid.getCloseCode(record);
            this.saveGridValue(grid.itemId, cc, 'CHECKED', '0');
        },

        saveGridValue: function (gridId, closeCode, colName, newValue) {
            this.touch();
            this.serverCall({
                method: 'SaveGridValue',
                params: [gridId, closeCode, colName, newValue],
                disableFog: true
            });
        },

        touch: function () {
            if (this.preventChangeHandlers) return;
            this.hasChanges = true;
            this.setSavedState(false);
        },

        discardChanges: function () {
            this.hasChanges = false;
            this.setSavedState(true);
        },

        setSavedState: function (saved) {
            var t = this.containerPanel.title;
            if (KS.isEmpty(t))
                return;
            if (saved === true) {
                if (t.substring(t.length - 1) === '*')
                    this.containerPanel.setTitle(t.substring(0, t.length - 1));
            } else {
                if (t.substring(t.length - 1) !== '*')
                    this.containerPanel.setTitle(t + '*');
            }
            if (typeof (this.onSetSavedState) == 'function') this.onSetSavedState(saved);
        },

        onSetSavedState: function(savedState) {
            //var saveBtn = this.getToolbarItem(this.rootPanel, 'top', 'save');
            //if (saveBtn) saveBtn.setDisabled(savedState);
        },

        onBeforeClose: function () {
            var view = this;
            if (view.hasChanges) {
                Ext.MessageBox.show({
                    icon: Ext.MessageBox.QUESTION,
                    title: KS.L10n.saveChanges,
                    msg: KS.L10n.documentUnsavedChanges + ' <br />' + KS.L10n.saveBeforeClosing,
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: function (btn) {
                        switch (btn) {
                        case 'yes':
                            view.saveDocument(true);
                            break;
                        case 'no':
                            view.close(true);
                            break;
                        }
                    }
                });
                return false;
            }
            return DocumentEditView.superclass.onBeforeClose.call(view);
        },

        saveDocument: function (close) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SaveDocument',
                waitMessage: KS.L10n.saving,
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        KS.alert(KS.L10n.documentNotSaved);
                        return;
                    }
                    view.afterSaveChanges();
                    if (close === true) {
                        view.close(close);
                    }
                }
            });
        },

        afterSaveChanges: function() {
            this.onRefresh();
        },

        onRefresh: function() {
            this.discardChanges();
            this.refreshList();
        }
    });

// ============= BaseDictionaryView =======================
BaseDictionaryView = KS.extend(BaseDocumentView,
    {
    });

// ============= DictionaryView =======================
DictionaryView = KS.extend(BaseDictionaryView,
    {
        fieldCtrlChange: function(field, newValue) {
            this.touch();
            this.serverCall({
                method: 'SaveControlValue',
                params: [field.code, field.objCode, newValue],
                disableFog: true
            });
        },
        chooseAction: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ChooseAction',
                params: [null, view.mainGrid.getCheckedCodes()]
            });
        },
        onBeforeClose: function (ct) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ToolbarClickHandler',
                params: ["CANCEL", {}, view.getTemplateState()],
                success: view.templateTbarClickHandlerCallback
            });
        }
    });

// ============= BPMNView =======================
// Показать на маршруте
BPMNView = KS.extend(BaseDocumentEditView,
    {
        drawRoute: function(chartPanel, width, height) {
            chartPanel.removeAll();

            var els = this.data.Elements,
                sprites = [],
                halfHeight,
                imgWidth = width, 
                imgHeight = height,
                checkWidth = function(w) {
                    if (w > imgWidth) imgWidth = w + 15;
                },
                checkHeight = function(h) {
                    if (h > imgHeight) imgHeight = h + 15;
                },
                createLine = function(fromX, fromY, toX, toY) {
                    checkWidth(fromX);
                    checkWidth(toX);
                    checkHeight(fromY);
                    checkHeight(toY);
                    return {
                        type: 'line',
                        // создаем границу-обводку
                        stroke: 'gray',
                        //толщина обводки
                        'stroke-width': 2,
                        fromX: fromX,
                        fromY: fromY,
                        toX: toX,
                        toY: toY
                    }
                };

            for (var elIdx in els) {
                if (els.hasOwnProperty(elIdx)) {
                    var el = els[elIdx],
                        sprite = {
                            routeElement: el
                        },
                        textX,
                        textY,
                        extSprites = [],
                        title;

                    // Keysystems.Meta.Views.Objects.BPMNElementType
                    switch (el.BPMNElementType) {
                    case 1: // PointRouter
                        KS.apply(sprite,
                            {
                                type: 'rect',
                                x: el.Position.X,
                                y: el.Position.Y,
                                width: el.Size.Width,
                                height: el.Size.Height,
                                strokeStyle: '#339ad4',
                                fillOpacity: '0.5',
                                order: el.ElementProperty.Order,
                                lineWidth: 2
                            });
                        checkWidth(el.Position.X + el.Size.Width);
                        checkHeight(el.Position.Y + el.Size.Height);

                        /*
                        if (el.Title) {
                            //if (el.TitlePosition.IsEmpty) {
                            textX = sprite.x + sprite.width / 2;
                            textY = sprite.y + 20;
                            //} 
                            //Криво рисует
                            /*else {
                                textX = el.TitlePosition.X;
                                textY = el.TitlePosition.Y;
                            }#1#

                            title = {
                                type: 'text',
                                x: textX,
                                y: textY,
                                textAlign: 'center',
                                textBaseline: 'middle',
                                font: '11px',
                                text: el.Title
                            }
                        }

*/

                        if (el.Title) {
                            var fontSize = 12,
                                text = [],
                                textWidth = el.Title.length * fontSize;

                            if (textWidth > el.Size.Width) {
                                text = el.Title.split(' ');
                            } else {
                                text.push(el.Title);
                            }

                            Ext.each(text,
                                function(t, ind) {
                                    extSprites.push({
                                        type: 'text',
                                        x: el.Position.X + el.Size.Width / 2,
                                        y: ((el.Position.Y + el.Size.Height / 2) + ind * fontSize) -
                                            (text.length === 1? 0: text.length * fontSize / 2.4),
                                        textAlign: 'center',
                                        textBaseline: 'middle',
                                        font: fontSize + 'px',
                                        text: t,
                                        order: 999
                                    });
                                });
                        };
                        break;
                    case 3: // StartRouter
                        KS.apply(sprite,
                            {
                                type: 'circle',
                                fillStyle: '#9bffac',
                                cx: el.Position.X + 15,
                                cy: el.Position.Y + 20,
                                strokeStyle: '#9bffac',
                                fillOpacity: '0.5',
                                order: el.ElementProperty.Order,
                                lineWidth: 2,
                                r: el.Size.Height / 1.5
                            });
                        break;

                    case 4: // EndRouter
                        var cx = el.Position.X + 15,
                            cy = el.Position.Y + 20,
                            r = el.Size.Height / 1.5;
                        KS.apply(sprite,
                            {
                                type: 'circle',
                                fillStyle: '#ff9b9b',
                                cx: cx,
                                cy: cy,
                                r: r,
                                fillOpacity: '0.5',
                                strokeStyle: '#ff9b9b',
                                order: el.ElementProperty.Order,
                                lineWidth: 2
                            });
                        checkWidth(cx + r);
                        checkHeight(cy + r);
                        break;

                    case 5: // PointCondXOR1
                        halfHeight = el.Size.Height / 2;
                        KS.apply(sprite,
                            {
                                type: 'diamond',
                                fillStyle: '#c57aff',
                                strokeStyle: '#814ad8',
                                size: halfHeight * 0.9,
                                fillOpacity: '0.3',
                                translationX: el.Position.X + halfHeight,
                                translationY: el.Position.Y + halfHeight
                            });

                        extSprites.push({
                            type: 'plus',
                            fillStyle: '##814ad8',
                            size: halfHeight * 0.3,
                            rotation: 45,
                            translationX: el.Position.X + halfHeight,
                            translationY: el.Position.Y + halfHeight
                        });
                        break;

                    case 6: // PointCondAND
                        halfHeight = el.Size.Height / 2;
                        KS.apply(sprite,
                            {
                                type: 'triangle',
                                fillStyle: '#1F6D91',
                                size: halfHeight,
                                translationX: el.Position.X + halfHeight,
                                translationY: el.Position.Y + halfHeight
                            });
                        break;

                    case 9: // "Структурное подразделение"
                        KS.apply(sprite,
                            {
                                type: 'rect',
                                x: el.Position.X,
                                y: el.Position.Y,
                                width: el.Size.Width,
                                height: el.Size.Height,
                                strokeStyle: '#aed2e3',
                                order: el.ElementProperty.Order,
                                lineWidth: 2
                            });
                        checkWidth(el.Position.X + el.Size.Width);
                        checkHeight(el.Position.Y + el.Size.Height);
                       
                        if (el.Title) {
                            var fontSize = 13,
                                text = [],
                                textWidth = el.Title.length * fontSize;

                            if (textWidth > el.Size.Height) {
                                text = el.Title.split(' ');
                            } else {
                                text.push(el.Title);
                            }

                            Ext.each(text,
                                function(t, ind) {
                                    extSprites.push({
                                        type: 'text',
                                        x: el.Position.X + 8 + ind * 13,
                                        y: el.Position.Y + el.Size.Height / 2,
                                        textAlign: 'center',
                                        textBaseline: 'middle',
                                        font: fontSize + 'px',
                                        text: t,
                                        order: 999,
                                        rotation: {
                                            degrees: 270
                                        }
                                    });
                                });

                            extSprites.push({
                                type: 'rect',
                                x: el.Position.X,
                                y: el.Position.Y,
                                width: 30,
                                height: el.Size.Height,
                                strokeStyle: '#aed2e3',
                                fillStyle: '#e2eff5',
                                fillOpacity: '0.3',
                                order: el.ElementProperty.Order,
                                lineWidth: 2
                            });
                        };
                        break;

                    default:
                        KS.log('Unknown route element: ' + el.BPMNElementType);
                        continue;
                    }

                    sprite.onFocus = function() {

                    };

                    if (el.Highlight) {
                        var c = Ext.clone(sprite);
                        KS.apply(c,
                            {
                                fillStyle: 'yellow',
                                r: sprite.r * 1.5,
                                fillOpacity: '0.5'
                            });

                        sprites.push(c);
                    }

                    sprites.push(sprite);

                    title && sprites.push(title);
                    Ext.each(extSprites,
                        function(spr) {
                            sprites.push(spr);
                        });
                }
            }

            Ext.each(this.data.Connections,
                function(connection) {
                    var lastLine = {};

                    Ext.each(connection.LinePoints,
                        function(lineXY, ind) {
                            var nextLineXY = connection.LinePoints[ind + 1];
                            if (!nextLineXY) {
                                lastLine = lineXY;
                                return false;
                            }

                            sprites.push(
                                createLine(
                                    lineXY.X,
                                    lineXY.Y,
                                    nextLineXY.X,
                                    nextLineXY.Y
                                ));
                            checkWidth(lineXY.X);
                            checkWidth(nextLineXY.X);
                            checkHeight(lineXY.Y);
                            checkHeight(nextLineXY.Y);
                        });

                    var prevLine = connection.LinePoints[connection.LinePoints.length - 2],
                        rotation = 90;


                    if (prevLine) {
                        if (prevLine.X === lastLine.X) {
                            if ((lastLine.Y - prevLine.Y) < 0) {
                                rotation = 0;
                            } else {
                                rotation = 180;
                            }
                        } 

                        if (prevLine.Y === lastLine.Y) {
                            if ((lastLine.X - prevLine.X) < 0) {
                                rotation = 30;
                            }
                        } 
                    }

                    sprites.push(
                        {
                            type: 'triangle',
                            size: 7,
                            translationX: lastLine.X,
                            translationY: lastLine.Y,
                            fillStyle: 'gray',
                            rotation: {
                                degrees: rotation
                            }
                        }
                    );
                });

            var drawCmp = Ext.create('Ext.draw.Container',
                {
                    plugins: {
                        spriteevents: true
                    },
                    layout: 'fit',
                    shrinkWrap: 1,
                    shrinkWrapDock : true,
                    width: imgWidth,
                    height: imgHeight,
                    sprites: sprites,
                    listeners: {
                        spriteclick: function(item, event) {
                            /*var sprite = item && item.sprite;
                            if (sprite) {
                                sprite.setAttributes({ fillStyle: 'red' });
                                sprite.getSurface().renderFrame();
                            }*/
                        }
                    }
                });

            chartPanel.add(drawCmp);
/*

            chartPanel.addDocked(Ext.create('Ext.button.Button',
                {
                    text: '+',
                    handler: function() {
                        /*var mainSurface = drawCmp.getSurface();
                        mainSurface.inverseMatrix.scale(0.5, 0.5);
                        mainSurface.renderFrame();#1#
                    }
                }));*/
        }
    });

// ============= BPMSChooseActionView =======================
BPMSChooseActionView = KS.extend(DocumentEditView,
    {
        chooseAction: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ChooseAction',
                params: [view.note.getValue(), view.table.getCheckedCodes()]
            });
        },
        closeView: function () {
            var view = this.parentView || this;
            view.close(true);
        },
    });

// ============= BPMSChooseExecuterView =======================
BPMSChooseExecuterView = KS.extend(DocumentEditView,
    {
        executerDictionaryCall: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ExecuterDictionaryCall',
                disableFog: true,
            });
        },
        divisionDictionaryCall: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DivisionDictionaryCall',
                disableFog: true,
            });
        },
        onServerSetControlAttribute: function (link, name, value)
        {
            this[link.toLowerCase().replace('_name','')].textField.setValue(value);
        },
        closeView: function () {
            var view = this.parentView || this;
            view.close(true);
        },
        okClick: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'okButtonClick',
                disableFog: true,
            });
        }
    });

// ============= BPMSChooseRouteView =======================
BPMSChooseRouteView = KS.extend(DocumentEditView,
    {
        chooseRoute: function() {
            var view = this.parentView || this;
            var actRowIndex = view.bpmsGrid.getControlState(null, null, null).activeRowIndex;
            view.serverCall({
                method: 'ChooseRoute',
                params: [actRowIndex]
            });
        },

        lastColumnAutofit: function (ct, column) {
            var view = this.parentView || this;

            var columns = view.bpmsGrid.columns;
            var lastColumn;
            var visibleColumns = [];

            for (var i = 0; i < columns.length; i++) {
                var col = columns[i];
                if (!col.hidden) {
                    visibleColumns.push(col);
                    if (!lastColumn || lastColumn.fullColumnIndex < col.fullColumnIndex) {
                        lastColumn = col;
                    }
                }
            }

            // Надежнее проставлять Flex через второй цикл - уменьшит число сработавших триггеров
            for (var i = 0; i < visibleColumns.length; i++) {
                var col = visibleColumns[i];
                col.setFlex(col == lastColumn);
            }
        },

        dictionarySelect:  function (ct, column)
        {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DictionarySelect',
                params: []
            });
        },

        onServerSetControlAttribute: function (link, name)
        {
            var view = this.parentView || this;
            view.bpmsGrid.store.getRange().at(0).set('DEBUG_EXECUTER',link);
            view.bpmsGrid.store.getRange().at(0).set('DEBUG_EXECUTER_NAME',name);
        },

        setComment: function (field) {
            var view = this.parentView || this;
            if (field.value) {
                view.serverCall({
                    method: 'SetComment',
                    params: [field.value]
                });
            }
        }
    });

// ============= BPMSComebackView =======================
BPMSComebackView = KS.extend(DocumentEditView,
    {
        onTemplateRendered: function() {
            var view = this.parentView || this;
            view.importantFields = view.rootEl.query('*').filter(function(c) {
                return c.ctrl && c.ctrl.allowEmpty === false;
            });
        },
        savedoc: function () {
            var view = this.parentView || this;
            for (var field of view.importantFields){
                if (!field.getValue()){
                    KS.alert(KS.L10n.requiredFieldsEmpty);
                    return;
                }
            }

            view.serverCall({
                method: 'DictionarySelect',
                params: []
            });
        },
        closeView: function () {
            var view = this.parentView || this;
            view.close(true);
        }
    });

// ============= EventsLogView =======================
EventsLogView = KS.extend(DocumentEditView,
    {
    });

// ============= ProtocolView =======================
ProtocolView = KS.extend(KS.Ext.ClientView,
    {
        constructor: function(viewId) {
            ProtocolView.superclass.constructor.call(this, viewId);
        },

        getHtmlResult: function() {
            return this.rootPanel.htmlProtocol;
        },

        closeView: function () {
            var view = this.parentView,
                rootPanel = view.rootPanel,
                senderView = KS.getView(rootPanel.senderViewID);

            senderView && senderView[rootPanel.completedHandler] && senderView[rootPanel.completedHandler](true);
            this.parentView.close();
        },

        nextStep: function() {
            var view = this.parentView,
                rootPanel = view.rootPanel,
                senderView = KS.getView(rootPanel.senderViewID);
            if (senderView) {
                senderView[rootPanel.nextBtnHandler] && senderView[rootPanel.nextBtnHandler]();
                senderView[rootPanel.completedHandler] && senderView[rootPanel.completedHandler](false);
            }

            this.parentView.close();
        },

        saveToFile: function() {
            this.parentView.getProtocolAs('html');
        },

        openExcel: function() {
            this.parentView.getProtocolAs('excel');
        },

        openWord: function() {
            this.parentView.getProtocolAs('word');
        },

        getProtocolAs: function(format) {
            this.serverCall({
                method: 'GetProtocolAs',
                params: [format],
                success: KS.openUrl
            });
        },

        printFn: function() {
            var win = window.open('', 'snapshot');

            win.document.open();
            win.document.write(this.parentView.getHtmlResult());
            win.document.close();
            win.print();
        },

        sendMail: function() {
        }
    });

// ============= ClientTasks =======================
(function() {
    KS.apply(KS,
        {
            appActionCompleted: function(sequence) {
                //debugger;
            }
        });
})();

// ============= KS.Ext.ClientView =======================
(function() {
    KS.apply(KS.Ext.ClientView.prototype,
        {
            processTaskResult: function(trc) {
                if (KS.isEmpty(trc) || KS.isEmpty(trc.Arguments)) return;
                if (trc.Arguments.ctrl) {
                    var view = this,
                        ctrlWin = KS.showModal(this.createTemplateControl(trc.Arguments.ctrl),
                            {
                                title: trc.Arguments.caption,
                                autoHeight: false,
                                frame: true,
                                width: 450,
                                height: 350,
                                bbar: [
                                    '->', {
                                        text: 'OK',
                                        cls: 'marked-button',
                                        scope: view,
                                        handler: function() {
                                            if (KS.isEmpty(view.commentFieldValue)) return;
                                            var taskResults = {
                                                method: trc.Arguments.method,
                                                comment: view.commentFieldValue
                                            };
                                            this.afterProcessTaskResult(taskResults);
                                            ctrlWin.close();
                                        }
                                    }
                                ]
                            });
                }
            },

            afterProcessTaskResult: function() {
            },

            commentFieldChanged: function(ed, value) {
                ed.parentView.commentFieldValue = value;
            }
        });
})();

// ============= KS.MacroManager =======================
KS.apply(KS.MacroManager,
    {
        getRepeatCurrentStepView: function(request, params) {
            return request.viewContext;
        },
        repeatCurrentStep: function(request, params) {
            var view = this.getRepeatCurrentStepView(request, params),
                method = params[0], cert, saveRequestContext;
            
            switch (method) {
            case 'SelectCertificate':
                var signSettings = params[3];

                KS.XCrypt.silentMode = params[1];
                KS.XCrypt.allowFromFile = params[2];
                KS.XCrypt.viewContext = view;
                KS.XCrypt.request = request;
                KS.XCrypt.isFilterErroneousCerts = KS.isFilterErroneousCerts;
                
                KS.XCrypt.initialize(signSettings, view.selectCertificate, view);
                break;

            case 'SignText':
                var text = params[1];
                
                cert = params[2];

                KS.XCrypt.viewContext = view;
                KS.XCrypt.request = request;
                
                saveRequestContext = function() {
                    var req = request;
                    
                    return function(hash) {
                        return view.saveSignature(hash, req);
                    } 
                }
                
                KS.XCrypt.sign(text, cert.Serial, 1, 'TspUrl=', saveRequestContext(), view);
                break;
            case 'SignFile':
                cert = params[2];

                saveRequestContext = function() {
                    var req = request;

                    return function(hash) {
                        return view.saveSignature(hash, req);
                    }
                }
                var xhr = new XMLHttpRequest();
                xhr.onreadystatechange = function(){
                    if (this.readyState === 4 && this.status === 200){

                        KS.XCrypt.signBinary(this.response, cert.Serial, 1, 'TspUrl=', saveRequestContext(), view);
                    }
                }
                xhr.open('GET', params[1]);
                xhr.responseType = 'blob';
                xhr.send();
            }
        }
    });

// ============= Sign =======================
KS.apply(KS.ClientView.prototype,
    {
        selectCertificate: function() {
            KS.XCrypt.selectCertificate(this.saveSelectedCert, this);
        },

        saveSelectedCert: function(certData) {
            this.serverCall({
                method: 'SaveSelectedCert',
                params: [KS.XCrypt.signSettings.sessionId, certData],
                success: this.repeatXCryptRequest
            });
        },

        repeatXCryptRequest: function() {
            $.ajax(KS.XCrypt.request);
        },
        
        saveSignature: function(sign, request) {
            this.serverCall({
                method: 'SaveSignature',
                params: [KS.XCrypt.signSettings.sessionId, sign],
                success: function() {
                    $.ajax(request);
                }
            });
        }
    });

// ============= WB ENGINE =======================
(function () {
    Ext.define('HtmlComboBox',
        {
            extend: 'Ext.form.field.ComboBox',
            xtype: 'combohtml',
            cls: 'combohtml',
            fieldSubTpl: [// note: {id} here is really {inputId}, but {cmpId} is available
                '<input id="{id}" style="display: none" data-ref="inputEl" type="{type}" {inputAttrTpl}',
                ' size="1"', // allows inputs to fully respect CSS widths across all browsers
                '<tpl if="name"> name="{name}"</tpl>',
                '<tpl if="value"> value="{[Ext.util.Format.htmlEncode(values.value)]}"</tpl>',
                '<tpl if="placeholder"> placeholder="{placeholder}"</tpl>',
                '{%if (values.maxLength !== undefined){%} maxlength="{maxLength}"{%}%}',
                '<tpl if="readOnly"> readonly="readonly"</tpl>',
                '<tpl if="disabled"> disabled="disabled"</tpl>',
                '<tpl if="tabIdx != null"> tabindex="{tabIdx}"</tpl>',
                '<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
                '<tpl foreach="inputElAriaAttributes"> {$}="{.}"</tpl>',
                ' class="{fieldCls} {typeCls} {typeCls}-{ui} {editableCls} {inputCls}" autocomplete="off"/>',
                // overlay element to show formatted value
                '<div id="{cmpId}-overlayEl" data-ref="overlayEl"<tpl if="name"> name="{name}-overlayEl"</tpl> class="{fieldCls}-overlay {typeCls} {typeCls}-{ui} {inputCls}">{value}</div>',
                {
                    disableFormats: true
                }
            ],
            forceSelection: true,

            childEls: [
                'overlayEl'
            ],

            setRawValue: function (value) {
                var me = this;

                // set value in overlay
                if (me.rendered) {
                    me.overlayEl.update(value);
                }
                return me.callParent([value]);
            }
        });

    Ext.define('overrides.form.field.File', {
        override: 'Ext.form.field.File',
        onRender: function () {
            this.callParent(arguments);
            this.fileInputEl.dom.setAttribute('multiple', this.multiple);
        },
        getFileList: function () {
            return this.fileInputEl.dom.files;
        }
    });

    Ext.define('FileUtils',
        {
            requires: [
                "Ext.form.Panel",
                "Ext.window.Window",
                "Ext.form.field.File"
                //"Ext.ux.IFrame"
            ],
            singleton: true,
            privates: {
                UploadGrid: function (url) {
                    var grid = Ext.widget({
                        xtype: 'grid',
                        anchor: '100% -120',
                        store: {
                            fields: ['name', 'size', 'progress', 'status']
                        },
                        tbar: [
                            {
                                xtype: 'filefield',
                                width: 5,
                                buttonOnly: true,
                                multiple: true,
                                buttonConfig: {
                                    iconCls: 'ks-icon-folder_open',
                                    text: KS.L10n.selectFiles
                                },
                                listeners: {
                                    change: function (s) {
                                        Ext.each(s.fileInputEl.dom.files,
                                            function (f) {
                                                grid.store.add({ name: f.name, size: f.size, status: 'ожидание', file: f });
                                            });
                                    }
                                }
                            }
                        ],
                        columns: [
                            { text: KS.L10n.fileNameLabel, dataIndex: 'name', flex: 1 },
                            { text: KS.L10n.statusLabel, dataIndex: 'status', width: 100 },
                            {
                                text: KS.L10n.progressLabel,
                                xtype: 'widgetcolumn',
                                widget: {
                                    xtype: 'progressbarwidget',
                                    textTpl: [
                                        '{percent:number("0")}%'
                                    ]
                                },
                                dataIndex: 'progress',
                                width: 100
                            },
                            { text: KS.L10n.sizeLabel, dataIndex: 'size', width: 100, renderer: Ext.util.Format.fileSize }
                        ]
                    });

                    grid.Upload = function (callback) {
                        var grid = this;
                        grid.store.each(function (rec) {
                            var f = rec.get('file');
                            //var data = new FormData();
                            //data.append(f.name, f);
                            FileUtils.UploadBlob(url, f,
                                function (res) {
                                    rec.set('status', KS.L10n.completedLabel);
                                    rec.commit();
                                    callback.apply(this, res);
                                },
                                function (e) {
                                    if (e.lengthComputable) {
                                        //var pv = (e.loaded / e.total) * 100;
                                        rec.set('progress', e.loaded / e.total);
                                        rec.set('status', KS.L10n.loadingStatus);
                                        rec.commit();
                                    }
                                });

                            //Ext.Ajax.request({
                            //    url: url,
                            //    rawData: data,
                            //    headers: { 'Content-Type': null }, //to use content type of FormData
                            //    progress: function(e) {
                            //        rec.set('progress', e.loaded / e.total);
                            //        rec.set('status', 'загрузка...');
                            //        rec.commit();
                            //    },
                            //    success: function(res) {
                            //        rec.set('status', 'завершено');
                            //        rec.commit();
                            //    },
                            //    failure: function() {
                            //        rec.set('progress', 0);
                            //        rec.set('status', 'ошибка ' + arguments[0].statusText);
                            //        rec.commit();
                            //    }
                            //});

                        });
                    };

                    return grid;
                },
                StartUpload: function (useGrid, callback) {

                    if (!useGrid) {
                        var form = this.up('form').getForm();
                        if (form.isValid()) {
                            form.submit({
                                url: url,
                                waitMsg: KS.L10n.sendingStatus,
                                success: function () {
                                    Ext.Msg.alert(KS.L10n.successStatus, KS.L10n.documentSaveSuccess);
                                }
                            });
                        }
                        return callback.apply(form);
                    }
                    var grid = this.up('window').down('grid');
                    grid.Upload(callback);
                }
            },
            BlobToBase64: function (blob, cb, scope) {
                var fr = new FileReader();
                fr.onload = function (e) {
                    cb.call(scope, e.target.result);
                };
                fr.readAsDataURL(blob);
            },
            BlobToText: function (blob, cb, scope) {
                var fr = new FileReader();
                fr.onload = function (e) {
                    var text = e.srcElement.result;
                    var obj = Ext.decode(text, true);
                    if (obj && (obj.isError || obj.isInformative))
                        return ShowError(obj);
                    else
                        cb.call(scope, text);
                };
                fr.readAsText(blob);
            },
            GetFileMD5: function (blob, cb, scope) {
                var reader = new FileReader();
                reader.onload = function (event) {
                    var date1 = new Date();
                    var array = event.target.result;
                    var result = SparkMD5.ArrayBuffer.hash(array);
                    var date2 = new Date();
                    console.log(Ext.String.format(KS.L10n.fileCheckSum + " {0} {1} - {2} мс", blob.name, result, date2 - date1));
                    if (cb)
                        cb.call(scope, result);
                };

                reader.readAsArrayBuffer(blob);
            },
            SaveText: function (text, fileName) {
                if (!text) return;
                var blob = new Blob([text], { type: "text/plain;charset=utf-8" });
                window.saveAs(blob, IsEmpty(fileName) ? 'file.txt' : fileName);
            },
            SaveContent: function (fileProps) {
                if (!fileProps)
                    return;
                if (fileProps.Error)
                    ExtUtils.ShowProtocol(fileProps.ShowProtocol);
                var files = fileProps.Files || fileProps;
                //[{Link:282,Name:"",Content:"",Encode:"WIN"}]
                if (!files.length)
                    return;
                files.forEach(function (file) {
                    FileUtils.SaveText(file.Content, file.Name);
                });
            },
            SaveBlob: function (blob, fileName) {
                if (!blob) return;
                if (blob.fail)
                    return ExtAlert(blob.message);
                fileName = IsEmpty(fileName) ? 'file.txt' : fileName;
                if (blob.type === "text/html; charset=utf-8")
                    return FileUtils.BlobToText(blob, window.saveAs.bind(this, blob, fileName));
                window.saveAs(blob, fileName);
            },
            //-------------------------------------//
            // TODO: Сделать IFrame и проверить
            DownloadPost: function (url, data) {
                /*
                var formPost = $('<form></form>').attr('action', url).attr('method', 'post');
                if (data != null) {
                    Object.keys(data).forEach(function(key) {
                        var value = data[key];
        
                        if (value instanceof Array) {
                            value.forEach(function(v) {
                                formPost.append($("<input></input>").attr('type', 'hidden').attr('name', key).attr('value', v));
                            });
                        } else {
                            formPost.append($("<input></input>").attr('type', 'hidden').attr('name', key).attr('value', value));
                        }
                    });
                }
                //send request
                formPost.appendTo('body').submit().remove();*/

                function createInput(key, value) {
                    return {
                        name: Ext.htmlEncode(key),
                        tag: 'input',
                        type: 'hidden',
                        value: Ext.htmlEncode(value)
                    };
                }

                function paramsToInputs(params) {
                    var inputs = [];

                    for (var key in params) {
                        var values = [].concat(params[key]);

                        Ext.each(values,
                            function (value) {
                                inputs.push(createInput(key, value));
                            });
                    }

                    return inputs;
                }

                var removeNode = FileUtils.RemoveDownloadIFrame,
                    frameId = Ext.id(),
                    iframe = Ext.core.DomHelper.append(document.body,
                        {
                            id: frameId,
                            name: frameId,
                            style: 'display:none',
                            tag: 'iframe'
                        }),
                    inputs = paramsToInputs(data);

                // If the download succeeds the load event won't fire but it can in the failure case. We a void using Ext.Element on
                // the iframe element as that could cause a leak. Similarly, the load handler is registered in such a way as to
                // avoid a closure.
                iframe.onload = FileUtils.OnloadFailureHandler;

                var form = Ext.DomHelper.append(document.body,
                    {
                        action: url,
                        cn: inputs,
                        method: 'POST',
                        tag: 'form',
                        target: frameId
                    });

                form.submit();

                removeNode(form);
                Ext.defer(removeNode, 1000 * 60 * 10, null, [iframe]);
            },
            // Declared outside the download function to avoid a closure
            OnloadFailureHandler: function () {
                // Note we only come into here in the failure case, so you'll need to include your own failure handling
                var response = this.contentDocument.body.innerHTML;
            },
            // Declared outside the download function to avoid a closure
            RemoveDownloadIFrame: function (node) {
                node.onload = null;
                node.parentNode.removeChild(node);
            },

            DownloadGet: function (dataurl, filename) {
                var a = document.createElement("a");
                a.href = dataurl;
                a.setAttribute("download", filename);
                var b = document.createEvent("MouseEvents");
                b.initEvent("click", false, true);
                a.dispatchEvent(b);
                return false;
                /*
                var panel = Ext.getBody().component.down("panel");
                var iframe = panel.add({
                    xtype: 'uxiframe',
                    hidden: true,
                    src: url
                });
                //Ext.defer(function() { panel.remove(iframe, true); }, 1000 * 60 * 10);
                setTimeout(function() { panel.remove(iframe, true) }, 1000 * 60 * 2);*/
            },
            //Открыть во внутреннем просмоторщике (на отдельном табе)
            OpenFile: function (params) {
                var iframe = {};
                if (params.fileName) {
                    var ext = params.fileName.split('.').pop();
                    var src = _all.rsa + "/Report/OpenExcelView/";
                    switch (ext) {
                        case 'xls':
                        case 'xlsx':
                            {
                                src = _all.rsa + "/Report/OpenExcelView/";
                            }
                            break;
                        case 'rtf':
                        case 'doc':
                        case 'docx':
                            {
                                src = _all.rsa + "/Report/OpenDocView/";
                            }
                    }
                    iframe = Ext.create('Ext.ux.IFrame',
                        {
                            closable: true,
                            title: params.fileName,
                            iconCls: 'ks-icon-print',
                            flex: 1,
                            src: src + params.fileName,
                            listeners: {
                                afterrender: function (panel) {
                                    this.on('load',
                                        function () {
                                            panel.unmask();
                                        });
                                }
                            }
                        });
                }
                else if (params.Page) {
                    iframe = Ext.create('Ext.ux.IFrame',
                        {
                            ObjX: this.ObjX,
                            closable: true,
                            Task: params.Task,
                            title: params.Task.ReportBaseParameters.FileName,
                            iconCls: 'ks-icon-print',
                            flex: 1,
                            listeners: {
                                afterrender: function (frame) {
                                    var document = frame.iframeEl.dom.contentWindow.document;
                                    document.open();
                                    document.clear();
                                    document.write(params.Page);
                                    document.close();
                                },
                                load: function (frame) {
                                    var f = document[frame.frameName];
                                    if (f && f.spreadsheet)
                                        f.spreadsheet.SetViewMode(1);
                                }
                            }
                        });
                }

                var tab = Dashboard.NavigationTabs.add(iframe);
                Dashboard.NavigationTabs.setActiveTab(tab);
                iframe.mask('Загрузка документа');
            },
            //--------- Download with progress XHR --------------------------------------------------------------//
            // TODO: IDB Cashing
            DownloadFile: function (controller, params, caching, maskContainer, cancel, callback, resultType, scope) {
                var _this = FileUtils;

                var fileName = params && params.fileName ? params.fileName : null;
                if (!fileName && params && params.path)
                    fileName = params.path.replace(/^.*[\\\/]/, '');

                var loaded = 0, total = 100;
                var fprogress = function () {
                    _this.timer = null;
                    if (loaded >= total && Ext.MessageBox.isVisible()) {
                        Ext.MessageBox.hide();
                    } else {
                        Ext.MessageBox.updateProgress(loaded / total,
                            Ext.util.Format.number(Math.round(loaded / 1024), "0,000") +
                            "/" +
                            Ext.util.Format.number(Math.round(total / 1024), "0,000") +
                            " KB",
                            Ext.String.format(KS.L10n.loadingStatus + " {0}%", Math.round(100 * loaded / total)));
                    }
                };

                var updateProgress = function (evt) {
                    if (evt.lengthComputable) {
                        loaded = evt.loaded, total = evt.total;
                        _this.timer = Ext.defer(fprogress, 0);
                    }
                };

                controller = controller.indexOf(Connection.rsa) !== -1 ? controller : Connection.rsa + parsUrl(controller);
                var xhr = new XMLHttpRequest();
                xhr.onprogress = updateProgress;
                xhr.open('POST', controller, true);
                xhr.responseType = "blob";
                xhr.setRequestHeader('Content-type', 'application/json; charset=utf-8');
                xhr.onreadystatechange = function (aEvt) {
                    if (xhr.readyState === 4) {
                        if (Ext.MessageBox.isVisible()) {
                            Ext.MessageBox.hide();
                        }

                        if (xhr.status === 200) {
                            var blob = xhr.response;

                            if (!resultType || resultType === 'url')
                                return callback.call(scope, URL.createObjectURL(blob));

                            if (resultType === 'base64')
                                return _this.BlobToBase64(blob, callback, scope);

                            if (resultType === 'blob')
                                return callback.call(scope, blob, fileName);
                        }
                        if (xhr.status === 410 || xhr.status === 404) {
                            _this.BlobToText(xhr.response,
                                function (text) {
                                    callback.call(this, { fail: true, message: text });
                                },
                                scope);
                        }
                    }
                };

                xhr.send(JSON.stringify(params));

                if (maskContainer) {
                    Ext.MessageBox.show({
                        //renderTo: maskContainer.getEl(),
                        title: KS.L10n.waitMessage,
                        msg: KS.L10n.loadingStatus,
                        progressText: KS.L10n.initializationStatus,
                        width: 300,
                        progress: true,
                        closable: false,
                        buttons: cancel ? Ext.MessageBox.CANCEL : null,
                        fn: function (btn) {
                            if (btn === 'cancel') {
                                xhr.abort();
                                return callback.call(scope, { fail: true, cancel: true });
                            }
                        }
                        //animateTarget: btn
                    });
                }
            },
            //--------- Download with progress and logs from server ---------------------------------//
            ProgressResponse: function (callback, scope, message) {
                if (!this.items) return;
                if (message.complete) {
                    Core.CustomProgress = null;
                    //callback.call(scope, message);
                    return this.close();
                }

                var progressEl = this.progressEl;
                var fileListEl = this.fileListEl;
                var fileNameEl = this.fileNameEl;

                var srcHtml = fileListEl.getValue();
                if (!IsEmpty(srcHtml))
                    srcHtml += '\n<br>';

                if (message.fail) {
                    fileListEl.setValue(srcHtml + "<font color='red'>" + message.message + "</font>");
                }
                var progress = message.progress || 0;
                progressEl.updateProgress(progress / 100, progress + "%");
                fileNameEl.setValue(message.fileName);
                if (progress === 100)
                    fileListEl.setValue(srcHtml + "<font color='green'>" + message.message + "</font>");
            },
            DrawProgressWindow: function (title, cancel, logs) {

                var maskWnd = new Ext.window.Window({
                    autoShow: true,
                    modal: true,
                    layout: 'fit',
                    plain: true,
                    title: title ? title : KS.L10n.filePreparation,
                    closable: false,
                    maximizable: false,
                    width: 500,
                    height: logs ? 500 : 100,
                    buttons: cancel
                        ? [
                            {
                                text: KS.L10n.cancel,
                                itemId: "cancel",
                                handler: function () {
                                    var w = this.up('window');
                                    DelTasks(w.idProcess);
                                    w.close();
                                }
                            }
                        ]
                        : null,
                    items: [
                        {
                            xtype: 'form',
                            itemId: 'progressForm',
                            fieldDefaults: {
                                labelWidth: 60
                            },
                            layout: {
                                type: 'vbox',
                                align: 'stretch'
                            },
                            bodyPadding: 5,
                            border: false,
                            items: [
                                {
                                    xtype: 'displayfield',
                                    itemId: 'fileName',
                                    fieldLabel: KS.L10n.fileLabel,
                                    value: KS.L10n.initializationStatus
                                },
                                {
                                    xtype: 'progressbar',
                                    itemId: 'progressBar',
                                    margin: '0 0 5'
                                }
                            ]
                        }
                    ]
                });

                if (logs) {
                    var htmlEdit = Ext.create('Ext.form.HtmlEditor',
                        {
                            itemId: 'fileList',
                            flex: 1,
                            hideLabel: true,
                            readOnly: true,
                            listeners: {
                                render: {
                                    fn: function () {
                                        arguments[0].toolbar.hide();
                                    }
                                }
                            }
                        });
                    maskWnd.down("#progressForm").add(htmlEdit);
                    maskWnd.fileListEl = htmlEdit;
                }

                maskWnd.progressEl = maskWnd.down("#progressBar");
                maskWnd.fileNameEl = maskWnd.down("#fileName");

                return maskWnd;
            },
            DownloadFileProgressLogs: function (url, params, config, callback, scope) {
                if (config == null)
                    config = {};

                if (Connection.connectionType === "SignalR") {
                    var maskWnd = FileUtils.DrawProgressWindow(config.title, config.cancel, config.logs);
                    Core.CustomProgress = FileUtils.ProgressResponse.bind(maskWnd, callback, scope);
                }

                var id = AjaxRequest({
                    url: url,
                    params: params,
                    success: callback.bind(scope)
                });

                maskWnd.idProcess = id;
            },
            //---------------------------------------------------------------------------------------//
            FineActionHandler: function (grid, i1, i2, column, e, record) {
                var a = 1;
            },
            // url, files, params, validation, onProgress, onAllComplete, onComplete
            UploadFileFine: function (p) {
                // Рисуем окно прогресса
                var grid = Ext.create({
                    xtype: 'grid',
                    store: {
                        data: p.files.map(function (r) {
                            return { name: r.name, progress: 0 };
                        })
                    },
                    columns: [
                        {
                            xtype: 'actioncolumn',
                            width: 40,
                            items: [{
                                iconCls: 'ks-icon-wait',
                                handler: this.FineActionHandler,
                                getClass: function (value, metadata, record) {
                                    if (record.get("error"))
                                        return 'ks-icon-errorX';
                                    if (record.get("success"))
                                        return 'ks-icon-ok';
                                    return 'ks-icon-wait';
                                }
                            }]
                        },
                        { text: KS.L10n.fileNameLabel, dataIndex: 'name', flex: 1 },
                        {
                            text: KS.L10n.progressLabel,
                            xtype: 'widgetcolumn',
                            width: 150,
                            dataIndex: 'progress',
                            widget: {
                                xtype: 'progress'
                            }
                        }
                    ]
                });
                var w = Ext.create('Ext.window.Window', {
                    title: KS.L10n.uploadingToServer,
                    autoShow: true,
                    modal: true,
                    width: 400,
                    layout: 'fit',
                    items: grid,
                    buttonAlign: 'center',
                    buttons: [
                        {
                            text: KS.L10n.cancel,
                            handler: function () {
                                var win = this.up("window");
                                var uploads = win.uploader.getUploads();
                                uploads.forEach(function (file) {
                                    if (file.status == "uploading")
                                        win.uploader.pauseUpload(file.id);
                                });
                                Ext.Msg.confirm(KS.L10n.cancel,
                                    KS.L10n.operationCancelConfirmation + ".<br>" + KS.L10n.operationDeletionConfirmation,
                                    function (answer) {
                                        if (answer === 'yes') {
                                            win.uploader.cancelAll();
                                            win.close();
                                            AjaxRequest({
                                                url: '/File/DeleteTempFiles',
                                                params: {
                                                    files: uploads
                                                }
                                            });
                                            return;
                                        }
                                        uploads.forEach(function (file) {
                                            if (file.status == "uploading")
                                                win.uploader.continueUpload(file.id);
                                        });
                                    }
                                );
                            }
                        }]
                });
                // Events
                var onProgressInner = function (index, fileName, loaded, total) {
                    var rec = grid.store.findRecord("name", fileName);
                    rec.set('progress', loaded / total);
                    if (p.onProgress)
                        p.onProgress.call(this, grid, index, fileName, loaded, total);
                };
                var onCompleteInner = function (id, fileName, response) {
                    var rec = grid.store.findRecord("name", fileName);
                    if (response.success) {
                        rec.set('success', true);
                    } else {
                        rec.set('error', response.error ? response.error : response);
                    }
                    if (p.onComplete)
                        p.onComplete.call(this, grid, id, fileName, response);
                };
                var onAllCompleteInner = function () {
                    var uploadedFiles = this.getUploads();
                    var error = uploadedFiles.findIndex(function (el) {
                        return el.status === "error";
                    });
                    if (error === -1) {
                        w.close();
                        if (p.onAllComplete || p.success)
                            (p.onAllComplete || p.success).call(this, uploadedFiles);
                    }
                };
                // Компонент
                w.uploader = new qq.FineUploaderBasic({
                    request: {
                        endpoint: _all.rsa + (p.url ? p.url : "/File/UploadFileFine"),
                        params: !p.params ? {} : p.params
                    },
                    chunking: {
                        enabled: true,
                        mandatory: true,
                        partSize: 256 * 1024
                    },
                    autoUpload: false,
                    debug: true,
                    callbacks: {
                        onComplete: onCompleteInner,
                        onAllComplete: onAllCompleteInner,
                        onProgress: onProgressInner,
                        onError: function (id, fileName, errorReason, xhrOrXdr) {
                            var rec = grid.store.findRecord("name", fileName);
                            rec.set('error', errorReason);
                        }
                    }
                });
                if (p.validation)
                    w.uploader.validation = p.validation;
                w.uploader.addFiles(p.files);
                w.uploader.uploadStoredFiles();
            },
            Upload: function (url, data, callback) {
                $.ajax({
                    //url: parsUrl(_all.rsa + url),
                    url: _all.rsa + url,
                    data: data,
                    dataType: 'json',
                    type: 'POST',
                    processData: false,
                    contentType: false,
                    converters: { "text json": JSON.parse },
                    xhr: function () {
                        var xhr = new XMLHttpRequest();
                        xhr.upload.addEventListener("progress",
                            function (evt) {
                                if (evt.lengthComputable) {
                                    var percentComplete = Math.round((evt.loaded / evt.total) * 100);
                                    console.log("upload " + percentComplete + "% done");
                                }
                            },
                            false);
                        return xhr;
                    },
                    success: function (data) {
                        console.log("upload done");
                        callback.call(null, data);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(jqXHR, textStatus, errorThrown);
                    }
                });
            },
            UploadBlob: function (url, blobOrFile, callback, onprogress) {
                var xhr = new XMLHttpRequest();
                xhr.open('POST', url, true);
                xhr.onload = callback;

                //var progressBar = document.querySelector('UploadProgress');
                xhr.upload.onprogress = onprogress;
                xhr.send(blobOrFile);
            },

            GetFileExtension: function (filename) {
                var result = '';

                if (filename && filename.split && filename.split('.').length) {
                    result = filename.split('.').pop() || '';
                }

                return result;
            }
        });

    Ext.define('Core.NoSecureConnectPage', {
        extend: 'Ext.Component',

        xtype: 'nosecureconnectionpage',

        baseCls: 'ks-no-secure-connect-page',

        optionName: 'kso_showNoSecureConnectionPage',

        renderData: {
            title: KS.L10n.connectionNotSecure,
            desc: 'Мы обнаружили вероятную угрозу безопасности и не стали открывать сайт <a href="{sitename}" class="{baseCls}__link">{sitename}</a>.<br> Если вы посетите этот сайт, злоумышленники могут пытаться похитить вашу авторизационную информацию, например, пароли, адреса электронной почты или сообщения. Сообщите администратору системы об этой уязвимости.<br><br>Необходимо использовать безопасное подключение в соответствии с <a target="_blank" class="{baseCls}__link" href="{orderLink}">Приказом ФСТЭК России от 11.02.13 г.№17</a>'
        },

        orderLink: 'https://fstec.ru/normotvorcheskaya/akty/53-prikazy/702-prikaz-fstek-rossii-ot-11-fevralya-2013-g-n-17',

        backBtnText: KS.L10n.connectionBackBtn,

        rememberText: KS.L10n.dontShowAgain,

        continueLinkText: KS.L10n.continueAnyway,

        renderTpl: [
            '<div id="{id}-bodyEl" class="{baseCls}__container">',
            '   <div class="{baseCls}__body">',
            '       <div class="{baseCls}__icon"><img src="images/attention_unprotected_connect.png"></div>',
            '       <div class="{baseCls}__content">',
            '           <div class="{baseCls}__title">{title}</div>',
            '           <div class="{baseCls}__desc">{desc}</div>',
            '           <div class="{baseCls}__buttons">{%',
            '               var me=values.$comp, backBtn=me.backBtn, continueLink = me.continueLink;',
            '               backBtn.ownerLayout = continueLink.ownerLayout = me.componentLayout;',
            '               backBtn.ownerCt = continueLink.ownerCt = me;',
            '               Ext.DomHelper.generateMarkup(backBtn.getRenderTree(), out);',
            '               Ext.DomHelper.generateMarkup(continueLink.getRenderTree(), out);',
            '           %}</div>',
            // '           <div>{%',
            // '               var me=values.$comp, cbx=me.rememberCheckbox;',
            // '               cbx.ownerLayout = me.componentLayout;',
            // '               cbx.ownerCt = me;',
            // '               Ext.DomHelper.generateMarkup(cbx.getRenderTree(), out);',
            // '           %}</div>',
            '       </div>',
            '   </div>',
            '</div>'
        ],

        privates: {
            finishRenderChildren: function () {
                var me = this;

                this.callParent(arguments);

                me.backBtn.finishRender();
                me.continueLink.finishRender();
                //me.rememberCheckbox.finishRender();
            }
        },

        initComponent: function () {
            var me = this;

            me.renderData.desc = new Ext.Template(me.renderData.desc).apply({
                orderLink: me.orderLink,
                sitename: window.location.origin,
                baseCls: me.baseCls
            });

            me.backBtn = new Ext.button.Button({
                text: me.backBtnText,
                handler: me.onBackBtnClick,
                cls: me.baseCls + '__back-btn',
                scope: me,
                scale: 'large',
                ui: 'main-button-ks',
            });

            me.continueLink = new Ext.Component({
                autoEl: {
                    tag: 'a',
                    href: '#',
                    cls: me.baseCls + '__continue-link',
                    html: me.continueLinkText,
                },
                listeners: {
                    click: {
                        element: 'el',
                        fn: me.onContinueLinkClick
                    },
                    scope: me
                }
            });

            // me.rememberCheckbox = new Ext.form.field.Checkbox({
            //     boxLabel: me.rememberText,
            //     handler: me.onRemeneberCheckboxChange,
            //     cls: me.baseCls + '__checkbox',
            //     scope: me
            // });

            me.callParent(arguments);
        },

        onBackBtnClick: Ext.emptyFn,

        onContinueLinkClick: Ext.emptyFn,

        onRemeneberCheckboxChange: Ext.emptyFn
    });


    KS.wbe = {
        initEngine: function (view) {
            if (window.Connection) {
                window.Connection.parentView = view;
                return;
            }

            var rsa = window.location.href.split('.aspx')[0];
            rsa = rsa.substring(0, rsa.lastIndexOf('/'));

            KS.apply(window,
                {
                    _all: {
                        rsa: rsa
                    },
                    ObjX: {
                        code: ''
                    },
                    ObjXs: [],
                    IsNullOrEmpty: KS.wbe.isNullOrEmpty,
                    IsEmpty: KS.wbe.isEmpty,
                    Replace: KS.wbe.replace,
                    trim: KS.wbe.trim,
                    ExtAlert: KS.wbe.extAlert,
                    AjaxRequest: KS.wbe.ajaxRequest,
                    GetCmp: KS.wbe.getCmp,
                    ShowError: KS.wbe.showError,
                    Connection: {
                        parentView: view,
                        rsa: rsa,
                        Info: {
                            LoginNewsShow: false,
                            signGetFilePath: "/Modules/",
                            Version: '1.0',
                            signGetFileHandler: '/PlatformHandler.axd?signgetfile=1'
                        }
                    }
                });
        },

        initCryptoModule: function (view) {
            KS.wbe.initEngine(view);
            if (!KS.XCrypt.cmInitor) {
                KS.XCrypt.cmInitor = Ext.create('CryptoModule.Initor',
                    {
                        container: window,
                        sitePrefix: window.Connection.rsa,
                        localStorage: null
                    });
            }
        },

        isNullOrEmpty: function (value) {
            return IsEmpty(value);
        },

        isEmpty: function (value, noTrim) {
            if (value == null) return true;

            if (typeof value === 'object') {
                if (value.lenght > 0) return false;
                if (value.lenght === 0) return true;
                if (Ext.isDate(value)) return false;

                for (var key in value) {
                    if (hasOwnProperty.call(value, key)) return false;
                }

                return true;
            }
            value = !noTrim ? trim(value) : value;

            return (value === 'null' ||
                value === 'NULL' ||
                value === 'undefined' ||
                value + '' === 'undefined' ||
                value === '#empty#' ||
                value === '"#empty#"' ||
                value === 'NA' ||
                value === '!NA!' ||
                value === '' ||
                value === '' ||
                value === 'NaN');
        },

        replace: function (text, inchar, outchar) {
            if (IsEmpty(text)) return '';
            text = text + '';
            var temp = text.split(inchar);
            return temp.join(outchar);
        },

        trim: function (xstr) {
            return $.trim(xstr);
        },

        ajaxRequest: function (p) {
            var view = Connection.parentView,
                urlParts = p.url.split('/'),
                controller = '',
                method = '',
                params = [];
            switch (urlParts.length) {
                case 3:
                    controller = urlParts[1];
                    method = urlParts[2];
                    break;
            }
            for (var paramName in p.params) {
                if (p.params.hasOwnProperty(paramName)) {
                    params.push(p.params[paramName]);
                }
            }
            var cfg = {
                method: controller + '_' + method,
                params: params
            };
            if (p.mask && p.mask.text) {
                cfg.waitMessage = p.mask.text;
            }
            KS.apply(p,
                {
                    parentView: view,
                    reqParams: params
                });
            if (KS.isFunction(p.success)) {
                cfg.success = {
                    scope: p,
                    fn: function (result) {
                        this.success(result, this.reqParams);
                    }
                }
            }
            if (KS.isFunction(p.error)) {
                cfg.error = {
                    scope: p,
                    fn: function (result) {
                        this.error(result);
                    }
                }
            }
            view.serverCall(cfg);
        },

        extAlert: function (msg) {
            var icon = Ext.Msg.WARNING,
                tp = msg.split('#'),
                btnView = true;

            if (tp.length > 2) {
                switch (tp[1]) {
                    case 'msg':
                        icon = Ext.Msg.INFO;
                        msg = msg.replace('#msg#', '');
                        break;
                    case 'err':
                        icon = Ext.Msg.ERROR;
                        msg = msg.replace('#err#', '');
                        break;
                    case 'crit':
                        icon = Ext.Msg.ERROR;
                        msg = msg.replace('#crit#', '');
                        btnView = false;
                        break;
                    default:
                        icon = Ext.Msg.WARNING;
                        break;
                }
            }

            msg = Replace(msg, '\n', '<br>');

            Ext.Msg.show({
                title: KS.L10n.attention,
                message: msg,
                icon: icon,
                buttons: btnView ? Ext.Msg.OK : null,
                closable: false
            });

            return false;
        },

        getCmp: function (id) {
            return Ext.getCmp(id);
        },

        showError: function (ei) {
            if (GetCmp('_msgerr')) GetCmp('_msgerr').destroy();
            var t = 'Ошибка', h = 330;
            _errInfo = ei;
            if (ei.Text.message || ei.Text.msg) {
                ei.AddInfo = ei.Text.stack || (ei.Text.sourceClass + '.' + ei.Text.sourceMethod);
                ei.Text = ei.Text.message || ei.Text.msg;
            }
            if (ei.IsInformative || ei.Text.indexOf('#') === 0) {
                return ExtAlert(ei.Text);
            }
            var st = Ext.String.format('{0}<br><br><b>Дополнительная информация:</b><br>{1}', ei.Text, ei.AddInfo);

            var html =
                '<table style=\'width:99%;height:99%;background-color:#ffffff\'><colgroup><col width=\'40\'><col width=\'*\'></colgroup>' +
                    '<tr><td align=center valign=top><div class=\'ks-icon-valid_error32\' style=\'width: 32px; height: 32px;\'/></td>' +
                    '<td style=\'' +
                    font_sizefamily +
                    '\' valign=top><span>' +
                    st +
                    '</span></td></tr></table>';
            var win = new Ext.Window({
                title: t,
                id: '_msgerr',
                width: 450,
                height: h,
                minWidth: 100,
                minHeight: 50,
                layout: 'fit',
                plain: true,
                modal: true,
                padding: 2,
                html: html,
                buttonAlign: '',
                buttons: [b16, b0, b17, b18],
                maximizable: true,
                autoScroll: true
            });
            win.show();
            return win;
        }
    }
}());

Ext.define('ExtUtils',
    {
        singleton: true,

        SilentAnchorClick: function (href, download) {
            var link = document.createElement('a');

            download && (link.download = true);

            link.href = href;

            link.target = '_blank';

            document.body.appendChild(link);

            link.click();

            document.body.removeChild(link);
        }
    });

(function checkNumberIsInteger() {
    if (Number.isInteger) {
        return;
    }
    Number.isInteger = function (value) {
        return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
    };
})();

// ============= MAIL =======================
KS.apply(KS, {
    findMailGroupView: function () {
        var mailGroupView = null;
        for (var view in KS.registeredViews) {
            if (KS.registeredViews.hasOwnProperty(view) &&
                KS.registeredViews[view].data &&
                KS.registeredViews[view].data.isMailGroupView) {
                mailGroupView = KS.registeredViews[view];
            }
        }
        return mailGroupView;
    },

    findMailListView: function () {
        var mailListView = null;
        for (var view in KS.registeredViews) {
            if (KS.registeredViews.hasOwnProperty(view) &&
                KS.registeredViews[view].data &&
                KS.registeredViews[view].data.isMailListView) {
                mailListView = KS.registeredViews[view];
            }
        }
        return mailListView;
    },

    openMailGroup: function () {
        var mailGroupView = KS.findMailGroupView();
        if (mailGroupView) {
            mailGroupView.openMailGroup();
        }
    },

    mailHyperLinkClick: function(msgId) {
        var mailGroupView = KS.findMailGroupView();
        if (mailGroupView) {
            mailGroupView.serverCall({
                method: 'OpenMailMessage',
                params: [msgId]
            });
        }

    }
});

MailGroupView = KS.extend(KS.Ext.ClientView,
    {
        constructor: function(viewId) {
            MailGroupView.superclass.constructor.call(this, viewId);
            KS.defer(this.updateTask, null, this, 100);
        },

        updateTask: function() {
            var view = this,
                interval = view.data.interval;
            if (interval > 0) {
                this.timerId = setInterval(function () { view.updateMailManager(); }, interval * 1000);
            }
            if (!view._serverClass) {
                var e = document.getElementById(this.controlID + '_class');
                if (e) view._serverClass = eval(e.value);
            }
            view.updateMailManager();
        },

        onBeforeClose: function () {
            if (this.timerId) this.clearInterval(this.timerId);
            return MailGroupView.superclass.onBeforeClose.call(this);
        },

        onNodeClick: function (node) {
            this.serverCall({
                method: 'NodeClickHandler',
                params: [node.id]
            });
        },

        onServerReloadTree: function (nodes) {
            if (this.mailTree) {
                var selNodeId = this.mailTree.getSelNodeId();
                this.mailTree.loadSubTreeInRoot(nodes);
                if (selNodeId)
                    this.mailTree.setSelected(selNodeId);
            }
        },

        updateMailManager: function () {
            this.serverCall({
                method: 'UpdateMailManager',
                waitMessage: KS.L10n.mailCheck
            });
        },

        openMailGroup: function() {
            if (this.containerPanel) {
                this.activate();
            } else {
                var tabIdx = +this.updatePanel.replace('group_panel_', '');
                KS.groupViewport.getLayout().setActiveItem(tabIdx);
            }
            this.serverCall({ method: 'OpenMailGroup' });
        },

        onServerReopenList: function(code) {
            var mailListView = KS.findMailListView();
            if (mailListView) {
                this.reopenCode = code;
                mailListView.close();
            }
        }
    });

MailListView = KS.extend(KS.Ext.ClientView,
    {
        onRefresh: function() {
            // данные уже обновлены, надо только их забрать
            this.updateList();
        },

        updateList: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'UpdateMessagesList',
                progressOnly: true,
                success: view.reloadListCallback
            });
        },

        reloadList: function () {
            var view = this.parentView || this;
            this.lastCodes = view.listGrid.getCheckedCodes(true);
            //Ext.each(view.listGrid.getCheckedCodes(false), function (cc) {
            //    view.listGrid.addCodeToCheckedList(cc);
            //});
            view.serverCall({
                method: 'ReloadMessagesList',
                progressOnly: true,
                success: view.reloadListCallback
            });
        },

        reloadListCallback: function (data) {
            this.listGrid.getStore().loadDataPage(1, data);
        },

        openMessage: function (grid, row) {
            var view = this.parentView || this,
                rec = KS.isObject(row) ? row : grid.getStore().getAt(row),
                msgId = KS.Grid.getAnyCase(rec, 'ID');

            view.serverCall({
                method: 'OpenMessage',
                params: [msgId],
                progressOnly: true,
                success: view.previewMessage
            });
        },

        listClick: function (grid, row) {
            var view = this.parentView || this,
                rec = KS.isObject(row) ? row : grid.getStore().getAt(row),
                msgId = KS.Grid.getAnyCase(rec, 'ID');

            view.serverCall({
                method: 'PreviewMessage',
                params: [msgId],
                progressOnly: true,
                success: view.previewMessage
            });
        },

        previewMessage: function (data) {
            for (var key in data) {
                if (data.hasOwnProperty(key)) {
                    var field = this[key.toLowerCase()];
                    if (field) {
                        var setFn = field.setValue || field.setText || field.loadJsonString;
                        if (setFn) setFn.call(field, data[key]);
                    }
                    switch (key.toLowerCase()) {
                        case 'theme':
                            this.previewPanel.setTitle(data[key]);
                            break;
                        case 'data':
                            this.msgPanel.update(data[key]);
                            break;
                    }
                }
            }
            //this.reloadList();
        },

        deleteMessages: function () {
            var view = this.parentView || this,
                codes = view.listGrid.getCheckedCodes(true);
            if (KS.isEmpty(codes)) return;
            KS.confirm(KS.L10n.mailDeletionConfirmation, KS.L10n.confirm, function (btn) {
                if (btn !== 'yes') return;
                view.serverCall({
                    method: 'RemoveMessages',
                    params: [codes],
                    waitMessage: KS.L10n.deletionWaitMessage,
                    success: view.reloadList
                });
            });
        },

        onAfterClose: function() {
            var mailGroupView = KS.findMailGroupView();
            if (mailGroupView && mailGroupView.reopenCode) {
                mailGroupView.serverCall({
                    method: 'NodeClickHandler',
                    params: [mailGroupView.reopenCode]
                });
                delete mailGroupView.reopenCode;

                KS.groupViewport.setActiveTab(mailGroupView.containerPanel);
            }
        }
    });

MailEditView = KS.extend(KS.Ext.ClientView,
    {
        editorChanged: function (editor, newValue) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'EditorChanged',
                params: [editor.code, newValue],
                disableFog: true,
                success: view.previewMessage
            });
        },

        selectSendTo: function () {
            var view = this.parentView || this;

            view.containerPanel.mask("Пожалуйста, подождите");
            setTimeout(function(){view.containerPanel.unmask()}, 2000);

            view.serverCall({
                method: 'SelectSendTo'
            });
        },

        onServerSetRecipients: function (recipients) {
            this.sendto.setValue(recipients);
        },

        doUpload: function () {
            var view = this,
                attach = this.rootPanel.getTopToolbar().attach;
            if (attach.getForm().isValid()) {
                attach.getForm().submit({
                    url: 'PlatformHandler.axd?upload=1&important=1',
                    method: 'POST',
                    fileUpload: true,
                    waitMsg: KS.L10n.fileLoadingStatus,
                    failure: function (fp, o) {
                        if (Ext.isArray(o.result) && !Ext.isEmpty(o.result)) {
                            view.saveFiles(o.result);
                        } else {
                            KS.msg(KS.L10n.error);
                        }
                    }
                });
            }
        },

        saveFiles: function (fileKeys) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DoSaveFiles',
                params: [fileKeys],
                waitMessage: KS.L10n.saving,
                success: view.saveFilesCallback
            });
        },

        saveFilesCallback: function (fileName) {
            if (this.attachTree.fullReload) {
                this.attachTree.fullReload();
            } else {
                this.attachTree.reload();
            }
            //if (fileName) this.fileName.setValue(fileName);
        },

        attachNodeSelect: function (node, record) {
            var nodeId = !!record.get ? KS.Grid.getAnyCase(record, 'id') : node.id;
            this.serverCall({
                method: 'AttachNodeSelect',
                params: [nodeId],
                success: this.previewMessage
            });
        }
    });

MailNewView = KS.extend(MailEditView,
    {
    });

UsersGroupsView = KS.extend(KS.Ext.ClientView,
    {
        usersCheckChange: function (node, checked) {
            var view = this.parentView || this;
            
            if(node.parentNode) {
                var parentChecked = true;
                Ext.each(node.parentNode.childNodes, function () {
                    parentChecked = parentChecked && this.data.checked;
                });
                view._setChecked(node.parentNode, parentChecked);
            }

            if(!node.isExpanded()) {
                node.expand();
            }
            
            Ext.each(node.childNodes, function() {
                view._setChecked(this, checked);
            });
        },

        _setChecked: function (node, checked) {
            if (!Ext.isBoolean(checked)) {
                checked = !node.data.checked;
            }

            node.set('checked', checked);
        },

        usersNodeLevelLoad: function (node) {
            var view = this.parentView || this;
            if(node.data.checked) {
                Ext.each(node.childNodes, function () {
                    view._setChecked(this, true);
                });
            }
        },

        selectUsers: function () {
            var view = this.parentView || this,
                nodes = view.usersTree.getChecked(),
                ids = [];
            Ext.each(nodes, function (node) {
                ids.push(node.id);
            });
            if (KS.isEmpty(ids)) return;
            view.serverCall({
                method: 'GenerateEvent',
                params: [ids]
            });
        },

        markChildren: function () {
            var view = this.parentView,
                usersTree = view.usersTree;
            usersTree[this.fn].call(usersTree, arguments);
        },

        usersSearch: function (f, e) {
            if (e && e.keyCode === 13) {
                var view = this.parentView || this;
                view.setUserSearchString();
            }
        },

        usersSearchOnButton: function () {
            var view = this;
            view.setUserSearchString();
        },

        clearSearch: function () {
            var view = this.parentView || this,
                searchField = view.getToolbarItem(view.usersTree, null, 'searchField');
            searchField.setValue('');
            view.setUserSearchString();
        },

        setUserSearchString: function () {
            var view = this,
                searchField = view.getToolbarItem(view.usersTree, null, 'searchField'),
                searchValue = searchField.getValue();
            view.serverCall({
                method: 'UsersSearch',
                params: [searchValue],
                success: view.reloadUsersTree
            });
        },

        reloadUsersTree: function () {
            this.usersTree.getRootNode().removeAll();
            this.usersTree.fullReload();
        }
    });

ChooseSignMessageView = KS.extend(KS.Ext.ClientView,
    {
    });

ksiconRenderer = function (value, metadata, record, rowIndex, colIndex, store) {
    var colCfg = store.grid.getColCfgByIndex(colIndex),
        icon = KS.Grid.getAnyCase(record, colCfg.dataIndex);
    return (KS.isString(icon) && !KS.isEmpty(icon))
        ? '<img src="PlatformHandler.axd?icon=' + icon + '.png"/>'
        : '';
}

// ============= AlertView =======================
AlertView = KS.extend(KS.Ext.ClientView,
    {
    });

// ============= NotificationView =======================
NotificationView = KS.extend(KS.Ext.ClientView,
    {
    });

// ============= BPMSTreeView =======================
BPMSTreeView = KS.extend(KS.Ext.ClientView,
    {
        scrollable : true,
        replacer: {
            'q': 'й',
            'w': 'ц',
            'e': 'у',
            'r': 'к',
            't': 'е',
            'y': 'н',
            'u': 'г',
            'i': 'ш',
            'o': 'щ',
            'p': 'з',
            '[': 'х',
            ']': 'ъ',
            'a': 'ф',
            's': 'ы',
            'd': 'в',
            'f': 'а',
            'g': 'п',
            'h': 'р',
            'j': 'о',
            'k': 'л',
            'l': 'д',
            ';': 'ж',
            "'": 'э',
            'z': 'я',
            'x': 'ч',
            'c': 'с',
            'v': 'м',
            'b': 'и',
            'n': 'т',
            'm': 'ь',
            ',': 'б',
            '.': 'ю',
            '/': '.'
        },
        onServerReloadTree: function(data) {
            this.mainTree.getRootNode().removeAll();
            this.mainTree.fullReload();
        },
         
        searchFieldChanged: function(th, newVal, oldVal) {
            newVal = this.replaceKeyLayout(newVal);
            var me = this,
                stringCompare = function(val, filterVal) {
                    return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                },
                store = me.mainTree.store;

            try {
                me.searchRegExp = new RegExp(newVal, 'g' + (me.caseSensitive ? '' : 'i'));
            } catch (e) {
                newVal = newVal.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
                me.searchRegExp = new RegExp(newVal, 'g' + (me.caseSensitive ? '' : 'i'));
            }

            //Фильтрация снизу вверх
            store.filterer = 'bottomup';
            store.filter({
                property: 'text',
                filterFn: function(item) {
                    var ind = stringCompare(item.get('text'), newVal);

                    return Ext.isNumber(ind) && ind !== -1;
                },
                value: newVal
            });

            store.getRoot()[newVal && newVal.length ? 'expand' : 'collapse'](true);
            var searchBtn = this.getToolbarItem(this.mainTree, null, 'search');
            searchBtn && searchBtn.setIconCls('ks-icon-' + (newVal.length ? 'clean' : 'search'));
            
            //Скрытие делаем по таймауту, т.е. пользователь может продолжать вводить значения
            if (me.updateTimeoutId) clearTimeout(me.updateTimeoutId);
            me.updateTimeoutId = setTimeout(function() {
                delete me.updateTimeoutId;
            }, 1500);
        },

        clearSearchField: function() {
            var searchField = this.getToolbarItem(this.navTree, null, 'searchField');
            searchField && searchField.items.first().setValue('');
        },

        //Замена символов с английских на русские при поиске
        replaceKeyLayout: function(str) {
            var me = this;
            return str.replace(/[A-z/,;\'\]\[]/g,
                function(x) {
                    return x == x.toLowerCase() ? (me.replacer[x] || x) : me.replacer[x.toLowerCase()].toUpperCase();
                });
        }
    });