﻿//---------------------------------------------------------------------------------------------
// constructor
MessageListView = function(viewID) {
    Ext.QuickTips.init();
    MessageListView.superclass.constructor.call(this, viewID);
};

//---------------------------------------------------------------------------------------------
//
KS.extend(MessageListView, KS.Ext.ClientView, {
    onInit: function() {
        var me = this;

        me.current = null;

        var toolbar = new Ext.Toolbar({
            enableOverflow: true,
            items: [{
                iconCls: 'ks-icon-message_new',
                text: KS.L10n.create,
                tooltip: KS.L10n.newMail,
                handler: function(s, e) {
                }
            }, {
                ref: 'btnOpen',
                hidden: true,
                icon: me.resources.OpenIcon,
                tooltip: KS.L10n.open,
                handler: function(s, e) {
                    if (!me.current) return;
                    me.serverCall.apply(me, [{
                        method: 'OpenMessage',
                        params: [me.current.ID]
                    }]);
                }
            }, {
                ref: 'btnDelete',
                hidden: true,
                icon: me.resources.DeleteIcon,
                tooltip: KS.L10n.delete,
                handler: function(s, e) {
                }
            }, {
                ref: 'btnForward',
                hidden: true,
                icon: me.resources.ForwardIcon,
                tooltip: KS.L10n.forwardMail,
                handler: function(s, e) {
                }
            }, '-', {
                iconCls: 'ks-icon-group',
                tooltip: KS.L10n.readingArea,
                handler: function(s, e) {
                }
            }]
        });

        me.grid = new TabListGrid({
            region: 'center',
            split: true,
            gridSettings: me.data,
            parentView: me,
            border: false,
            getDataPageMethod: 'GetMessages',
            saveSettingsMethod: 'SaveViewSettings',
            sm: new Ext.grid.ExcelCellSelectionModel(),
            enableFiltering: false,
            stateful: true,
            enableToolbar: true,
            enablePaging: true,
            autoExpandColumn: 'Theme'
        });

        me.preview = new Ext.Panel({
            region: 'south',
            split: true,
            ref: 'Preview',
            height: 200
        });

        me.panel = new Ext.Panel({
            tbar: toolbar,
            border: false,
            layout: 'border',
            items: [me.grid, me.preview]
        });

        me.grid.getSelectionModel().on('selectionchange', function(s) {
            if (s.selections.items.length > 0) {
                me.current = s.selections.items[0].data;
                me.panel.getTopToolbar().btnOpen.setVisible(true);
                me.panel.getTopToolbar().btnDelete.setVisible(true);
                me.panel.getTopToolbar().btnForward.setVisible(true);
            } else {
                me.current = null;
                me.panel.getTopToolbar().btnOpen.setVisible(false);
                me.panel.getTopToolbar().btnDelete.setVisible(false);
                me.panel.getTopToolbar().btnForward.setVisible(false);
            }
        });

        me.renderToParent(me.panel);

        me.grid.getStore().load({ params: { start: 0, limit: me.data.Band[0].PageSize } });
    }, // onInit

    onReloadData: function() {
        this.grid.getStore().reload();
    },

    onRefresh: function() {
        this.grid.getStore().reload();
    }
});
// Ext.extend
