﻿ChangePasswordBySqlView = KS.extend(KS.Ext.ClientView, {
    constructor: function (viewId) {
        ChangePasswordBySqlView.superclass.constructor.call(this, viewId);
    }
});

(function (viewClass) {
    KS.apply(viewClass, {
        onInit: function () {
            var view = this;

            view.redirectRequested = false;

            view.changeButton = new Ext.button.Button({
                text: 'Сменить пароль',
                disabled: true,
                handler: function () {
                    var p1Field = view.formWindow.getComponent('pass1'),
                        p2Field = view.formWindow.getComponent('pass2');
                    if (!p1Field.validate() || !p2Field.validate()) return;
                    var newPass = p1Field.getValue();
                    view.serverCall({
                        method: 'ChangePassword',
                        params: [newPass],
                        success: function (msg) {
                            if (msg) {
                                view.changeButton.enable();
                                KS.warning(msg, 'Ошибка при смене пароля');
                            } else {
                                KS.alert('Пароль успешно изменен',
                                    'Сообщение',
                                    function () {
                                        view.login(newPass);
                                    });
                            }
                        }
                    });
                }
            });

            view.formWindow = new Ext.form.Panel({
                baseCls: 'x-plain',
                layout: 'absolute',
                defaultType: 'textfield',
                padding: 5,
                items: new Array(
                    {
                        x: 10,
                        y: 15,
                        xtype: 'label',
                        text: 'Новый пароль:'
                    },
                    {
                        x: 140,
                        y: 10,
                        itemId: 'pass1',
                        value: '',
                        anchor: '100%',
                        allowBlank: view.data.minPassLength === 0,
                        blankText: 'Пароль не может быть пустым',
                        inputType: 'password',
                        selectOnFocus: true,
                        validator: function (p1) {
                            var p2 = view.formWindow.getComponent('pass1').getValue(),
                                result = view.validate(p1, p2);
                            if (result === true) view.formWindow.getComponent('pass1').clearInvalid();
                            return result;
                        }
                    },
                    {
                        x: 10,
                        y: 55,
                        xtype: 'label',
                        text: 'Повторите пароль:'
                    },
                    {
                        x: 140,
                        y: 50,
                        itemId: 'pass2',
                        value: '',
                        anchor: '100%',
                        allowBlank: false,
                        inputType: 'password',
                        selectOnFocus: true,
                        validator: function (p2) {
                            var p1 = view.formWindow.getComponent('pass1').getValue(),
                                result = view.validate(p1, p2);
                            if (result === true) view.formWindow.getComponent('pass2').clearInvalid();
                            return result;
                        }
                    }),
                buttons: [view.changeButton]
            });

            view.renderToParent(view.formWindow);

            view.formWindow.getComponent('pass1').validate();
            view.formWindow.getComponent('pass2').validate();
        }
    });
}(ChangePasswordBySqlView.prototype));

(function(viewClass) {
    KS.apply(viewClass, {
        validate: function(p1, p2) {
            var me = this,
                result = true;
            if (p2 !== p1) {
                result = 'Введенные значения не совпадают';
            } else if (Ext.isEmpty(p1)) {
                result = 'Пароль не может быть пустым';
            } else if (p1.length < me.data.minPassLength) {
                result = 'Длина пароля должна быть не менее ' + me.data.minPassLength;
            }
            if (result === true) {
                me.changeButton.enable();
                me.formWindow.getComponent('pass1').clearInvalid();
                me.formWindow.getComponent('pass2').clearInvalid();
            } else {
                me.changeButton.disable();
            }
            return result;
        },

        login: function(pass) {
            var loginView = KS.findSingleView('className', 'LoginView');
            if (loginView) {
                // LoginView
                var passwordField = Ext.getCmp('frmPassword');
                if (!passwordField && window.LoginManager.FormLogin) {
                    //NewLoginView
                    passwordField = window.LoginManager.FormLogin.findField('password')
                }
                if (passwordField) {
                    passwordField.setValue(pass);
                    loginView.doLogin();
                }
            }
        }
    });
}(ChangePasswordBySqlView.prototype));
