﻿UserBatchCreationView = KS.extend(BaseDictionaryView, {
    deleteConfirmMsg: 'Удалить выбранных пользователей?'
});
// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.settingMainToolbar();
        },

        saveChanges: function() {
            var view = this.parentView;
            var changePassword = false;
            var passComp = view.getToolbarItem(view.mainGrid, null, 'Container2');
            if (passComp)
                changePassword = passComp.getValue();
            view.serverCall({
                method: 'SaveNewUser',
                params: [changePassword],
                waitMessage: 'Сохранение...',
                success: function(hasError) {
                    if (!hasError) {
                        view.mainGrid.reload();
                        view.discardChanges();
                    }
                }
            });
        },

        deleteCallback: function(deleted) {
            if (deleted) {
                var view = this;
                var recs2Del = this.mainGrid.getCheckedRows();
                Ext.each(recs2Del, function (rec2Del) {
                    view.mainGrid.getStore().remove(rec2Del);
                }); 
            }
        },

        getTbarClickHandler: function(tbarItem) {
            var sc = UserAdmView.superclass;
            switch (tbarItem.code) {
                case "SAVE":
                    return this.saveChanges;                      
                case "NEW":
                case "NEW2":
                    return this.createNewUser;                    
                case "COPY":
                    return this.copyUser;
                case "ADD_DOMAIN_USERS":
                    return this.addDomainUsers;
                case "BATCH_NEW":
                    return this.createNewBatch;
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        settingMainToolbar: function() {
            var saveBtn = this.getToolbarItem(this.mainGrid, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(true);

            var dateCmp = this.getToolbarItem(this.mainGrid, null, 'Container1');
            if (dateCmp)
                dateCmp.setValue(new Date());

            var passComp = this.getToolbarItem(this.mainGrid, null, 'Container2');
            if (passComp)
                passComp.setValue(false);
        },

        createNewUser: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CreateNewUser',
                disableFog: true,
                success: function(dataRow) {
                    this.mainGrid.addRecord(dataRow);
                    view.touch();
                }
            });
        },            
        
        copyUser: function() {
            var view = this.parentView;
            var selectedRows = view.mainGrid.getCheckedRows();
            if (selectedRows && selectedRows.length > 0) {
                var record = selectedRows[selectedRows.length - 1];
                var linkUser = record.get("LINK_USER");
                view.serverCall({
                    method: 'CopyUser',
                    disableFog: true,
                    params: [linkUser],
                    success: function(dataRow) {
                        this.mainGrid.addRecord(dataRow);
                        view.touch();
                    }
                });
            }
        },

        cellDblClickHandler: function (gridView, td, cellIndex, record) {
            var column = this.mainGrid.getColumns()[cellIndex];
            if (column.renderer === dictRenderer) {
                this.mainGrid.checkRecord(record, true, true);
                var checkedCodes = this.mainGrid.getCheckedCodes(true);
                if (checkedCodes == null || checkedCodes.length === 0) return;
                var linkUser = record.get("LINK_USER");
                var date = this.getToolbarItem(this.mainGrid, null, 'Container1').getValue();
                this.serverCall({
                    method: 'OpenDictionary',
                    params: [column.dataIndex, linkUser, checkedCodes, date]
                });
            }
        },

        editTable: function (e, context) {
            var linkUser = context.record.get("LINK_USER");
            var dataIndex = context.column.dataIndex;
            var newValue = context.value;
            this.serverCall({
                method: 'EditTablCell',
                disableFog: true,
                params: [linkUser, dataIndex, newValue],
                success: this.touch
            });
            return true;
        },

        addDomainUsers: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'AddDomainUsers'
            });
        },

        createNewBatch: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetBatchGridData',
                waitMessage: 'Открывается ...',
                success: view.showCreateNewBatch
            });
        },

        showCreateNewBatch: function(settings) {
            var view = this;
            this.batchPanel = this.getPropertyGridByOption(settings, "batchPropertyGrid", "Свойства");
            this.batchPanelWin =  KS.showModal(this.batchPanel, {
                title: 'Параметры пакетного создания',
                autoHeight: false,
                height: 400, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.doCreateNewBatch();
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.batchPanelWin.close();
                        }
                    }]
            }, true);
        },

        doCreateNewBatch: function() {
            var view = this;
            var source = this.batchPanel.source;
            if (source) {
                view.serverCall({
                    method: 'CreateNewBatch',
                    params: [source],
                    waitMessage: 'Создание ...',
                    success: function() {
                        view.mainGrid.reload();
                        view.batchPanelWin.close();
                        view.touch();
                    }
                });
            }
        },

        dateChanged: function() {
        },

        onValuesSelected: function(arg) {
            if (arg[0][0]) {
                this.mainGrid.reload();
                this.touch();
            }
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'PasteFromExcel',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: view.pasteFromExcelCallback
            });
        },

        pasteFromExcelCallback: function (result) {
            if (result === true) {
                this.mainGrid.reload();
                this.touch();
            }
        }
    });
}(UserBatchCreationView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();