﻿SelectionListView = KS.extend(BaseTreeView, {
    deleteConfirmMsg: 'Удалить выделенные выборки?',

    getTbarClickHandler: function (tbarItem) {
        switch (tbarItem.code) {
            case 'SELECT':
            case 'OPEN_IN_EXCEL':
                return this.execute;

            case 'TEMPLATE_ORG':
                return this.openTemplateOrg;

            case "PopupAddGroup":
                return null;
                
            
        }
        return SelectionListView.superclass.getTbarClickHandler.call(this, tbarItem);
    },

    newHandler: function () {
        var view = this.parentView,
            rawAdditional = {
                'GROUP_LINK': view.getSelectedNodeId(),
                'FAKE_LINK': KS.getFakeLink()
            };
        view.backgroundOperation("CREATE_SELECTION", true, 'Создание', null, rawAdditional);
    },

    copyHandler: function () {
        var view = this.parentView,
            ccc = view.mainGrid.getCheckedCodes(true);
        if (Ext.isEmpty(ccc)) return;
        var rawAdditional = {
            'COPY_LINK': ccc[0],
            'GROUP_LINK': view.getSelectedNodeId(),
            'FAKE_LINK': KS.getFakeLink()
        };
        view.backgroundOperation("CREATE_SELECTION", true, 'Копирование', null, rawAdditional);
    },

    execute: function () {
        var view = this.parentView || this,
            grid = view.findOwnerContainer(this, view.isGrid),
            ccc = (grid) ? grid.getCheckedCodes(true) : [];
        if (Ext.isEmpty(ccc)) return;
        this.parentView.backgroundOperation('OPEN_IN_EXCEL', true, 'Выполнение');
    },

    openTemplateOrg: function () {
        var view = this.parentView;
        view.serverCall({
            method: 'OpenTemplateOrg'
        });
    },

    addGroup: function() {
        var view = this.parentView;
        view.showEditGroupPanel(null, true);
    },

    addChildGroup: function() {
        var view = this.parentView;
        var node = view.baseTree.getSelNode();
        if (!Ext.isEmpty(node))
            view.showEditGroupPanel(node.getId(), true);
    },

    editGroup: function() {
        var view = this.parentView;
        var node = view.baseTree.getSelNode();
        if (!Ext.isEmpty(node))
            view.showEditGroupPanel(node.getId(), false);
    },

    showEditGroupPanel: function(groupLink, isNew) {
        var view = this;
        view.serverCall({
            method: 'GetEditGroupProperties',
            params: [groupLink, isNew],
            success: function(settings) {
                view.showEditGroupPanelCallback(settings, groupLink, isNew);
            }
        });
    },

    showEditGroupPanelCallback: function(settings, groupLink, isNew) {
        if (Ext.isEmpty(settings)) return;
        this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "1. Общие");
        var view = this;
        this.formEditPanelWin =  KS.showModal(this.propertyGrid, {
            title: 'Свойства',
            autoHeight: false,
            layout: "anchor",
            height: 400,
            minHeight: 200,
            width: 600,
            minWidth: 300,
            buttonAlign: 'left',
            buttons: ['->', {
                text: 'ОК',
                cls: 'dim-button',
                handler: function () {
                    view.doEditGroup(groupLink, isNew);
                }
            }, { xtype: 'tbspacer', width: 8 },
                {
                    text: 'Отмена',
                    cls: 'dim-button',
                    handler: function() {
                        view.rejectGroup(groupLink, isNew);
                    }
                }]
        }, true);
    },

    doEditGroup: function(groupLink, isNew) {
        var view = this;
        if (!this.propertyGrid.validate()) {
            return;
        }
        var newValues = this.propertyGrid.source;
        view.formEditPanelWin.close();
        view.serverCall({
            method: 'EditGroup',
            params: [newValues, groupLink, isNew],
            waitMessage: isNew ?  'Создание ...' : 'Редактрование ...',
            success: function() {
                view.baseTree.getRootNode().removeAll(true);
                view.baseTree.fullReload();
            }
        });
    },

    rejectGroup: function(groupLink, isNew) {
        var view = this;
        view.serverCall({
            method: 'RejecGroup',
            params: [groupLink, isNew],
            waitMessage: 'Отмена...',
            success: function() {
                view.formEditPanelWin.close();
            }
        });
    },

    deleteGroup: function() {
        var view = this.parentView || this;
        var checkedNodes = view.baseTree.getChecked();
        if (Ext.isEmpty(checkedNodes)) {
            var selNode = view.baseTree.getSelNode();
            if (!Ext.isEmpty(selNode)) {
                checkedNodes.push(selNode);
            }
        }

        if (!Ext.isEmpty(checkedNodes)) {
            var checkedCodes = [];
            Ext.each(checkedNodes, function(node) {
                checkedCodes.push(node.getId());
            });
            KS.confirm("Будет удалено строк: " + checkedNodes.length + ". Продолжить?",
                "Подтвердите удаление", function(btn) {
                    if (btn === 'yes')
                        view.deleteGroupInternal(checkedCodes);
                });
        }
    },

    deleteGroupInternal: function (checkedCodes) {
        this.serverCall({
            method: 'DeleteGroup',
            params: [checkedCodes],
            waitMessage: 'Удаление ...',
            success: this.deleteCallback
        });
    },

    deleteCallback: function(hasSaveErrors) {
        if (!hasSaveErrors) {
            this.baseTree.getRootNode().removeAll(true);
            this.baseTree.fullReload();
            this.mainGrid.reload();
        }
    }
});

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();