﻿ReportStatisticsView = KS.extend(BaseSvodView,
    {
        customName: 'ReportStatisticsView',
        printGridPropertyName: 'detalizeGrid'
});

// ============= BASE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.updateStatistics();

            this.containerPanel.on('activate', this.viewActivated, this);
        },

        viewActivated: function(){
            var rnv = this.getReportNavigationView();
            if (rnv && rnv.containerPanel && rnv.containerPanel.ownerCt)
                rnv.containerPanel.ownerCt.setActiveTab(rnv.containerPanel);
        },
        
        getReportNavigationView: function(){
            return KS.findSingleView('customNameExt', 'ReportNavigationView_Statistics');
        },

        refreshList: function() {
            var view = this.parentView || this;
            if (!view.isActiveTab()) {
                view.needRefresh = true;
                return;
            }
            var rnv = view.getReportNavigationView();
            if (Ext.isEmpty(rnv)) return;
            var viewState = rnv.getFilters();
            if (Ext.isEmpty(viewState)) return;

            this.enableFilters();
        },

        stopRefresh: function() {
            this.isRefreshing = false;
        },

        onBeforeClose: function () {
            var rnv = this.getReportNavigationView();
            if (rnv && rnv.containerPanel && rnv.containerPanel.ownerCt)
                rnv.containerPanel.ownerCt.setActiveTab(rnv.containerPanel)

            ReportStatisticsView.superclass.onBeforeClose.call(this);
        },

        enableFilters: function () {
            this.stopRefresh();
            var rnv = this.getReportNavigationView();
            if (rnv) rnv.refreshTaskListCallBack();
        },

        printChart: function() {
            var view = this.parentView || this;
            var image = view.chart.getImage();
            if (image){
                var title = view.statsModeCombo.getDisplayValue(); // имя файла, если сохранять его в pdf
                KS.Svod.ImageUtils.printFromBase64(image.data, title);
            }
        },

        saveChartInFiles: function() {
            var view = this.parentView || this;
            var image = view.chart.getImage();
            if (image){
                KS.Svod.ImageUtils.downloadFromBase64(image.data, 'chart_image');
            }
        },

        emailChartImage: function() {
//            var view = this.parentView || this;

        },

        showStatistics: function() {
            var view = this.parentView || this;
            view.updateStatistics();
        },

        showInformation: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'OnAbout'
            });
        },

        showSettings: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'OpenSettings'
            });
        },

        statsModeChange: function(combo, newValue) {
            var view = this.parentView || this;
            view.setAdditionalsPanelVisible(newValue);

            view.serverCall({
                method: 'SetStatsMode',
                params: [newValue],
                waitMessage: 'Установка режима...',
                success: function() {
                    view.updateStatistics();
                }
            });
        },

        setAdditionalsPanelVisible: function(mode) {
            switch(mode) {
                case 0:
                    this.statsTabPanel.setActiveTab(0);
                    break;

                case 2:
                case 3:
                    this.statsTabPanel.setActiveTab(1);
                    break;

                case 6:
                    this.statsTabPanel.setActiveTab(2);
                    break;

                case 13:
                    this.statsTabPanel.setActiveTab(3);
                    break;

                default:
                    this.statsTabPanel.setActiveTab(4);
                    break;
            }
        },

        selectStatus: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSelectStatusGrid',
                success: view.showSelectStatusGrid
            });
        },

        showSelectStatusGrid: function(selectStatusGrid) {
            if (Ext.isEmpty(selectStatusGrid)) return;
            var view = this;
            view.selectStatusGrid = KS.create(selectStatusGrid);
            view.selectStatusWin = KS.showModal(view.selectStatusGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(600, KS.rootViewport.getWidth() / 2),
                height: Math.max(600, KS.rootViewport.getHeight() / 1.5),
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doSelectStatus();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectStatusWin.close();
                        }
                    }]
            }, true);
        },

        doSelectStatus: function() {
            var view = this;
            var selectedStatus = [];
            var checkedRows = view.selectStatusGrid.getCheckedRows();
            Ext.each(checkedRows, function(record) {
                selectedStatus.push(KS.Grid.getAnyCase(record, "NAME"));
            });
            var checkedCodes = view.selectStatusGrid.getCheckedCodes();
            view.serverCall({
                method: 'SelectStatus',
                params : [checkedCodes],
                success: function() {
                    view.selectStatusWin.close();
                    view.statusFilter.setValue(selectedStatus.join(", "));
                    view.updateStatistics();
                }
            });
        },

        clearStatusFilter: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SelectStatus',
                params : [[]],
                success: function() {
                    view.statusFilter.setValue("");
                    view.updateStatistics();
                }
            });
        },

        selectUsers: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSelectUsersGrid',
                success: view.showSelectUsersGrid
            });
        },

        showSelectUsersGrid: function(selectUsersGrid) {
            if (Ext.isEmpty(selectUsersGrid)) return;
            var view = this;
            view.selectUsersGrid = KS.create(selectUsersGrid);
            view.selectUsersWin = KS.showModal(view.selectUsersGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(600, KS.rootViewport.getWidth() / 2),
                height: Math.max(600, KS.rootViewport.getHeight() / 1.5),
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doSelectUsers();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectUsersWin.close();
                        }
                    }]
            }, true);
        },

        doSelectUsers: function() {
            var view = this;
            var selectedLogin = [];
            var checkedRows = view.selectUsersGrid.getCheckedRows();
            Ext.each(checkedRows, function(record) {
                selectedLogin.push(KS.Grid.getAnyCase(record, "LOGIN"));
            });
            var checkedCodes = view.selectUsersGrid.getCheckedCodes();
            view.serverCall({
                method: 'SelectUsers',
                params : [checkedCodes],
                success: function() {
                    view.selectUsersWin.close();
                    view.userFilter.setValue(selectedLogin.join(", "));
                    view.updateStatistics();
                }
            });
        },

        clearUserFilter: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SelectUsers',
                params : [[]],
                success: function() {
                    view.userFilter.setValue("");
                    view.updateStatistics();
                }
            });
        },

        selectOperations: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSelectOperationsGrid',
                success: view.showSelectOperationsGrid
            });
        },

        showSelectOperationsGrid: function(selectOperationsGrid) {
            if (Ext.isEmpty(selectOperationsGrid)) return;
            var view = this;
            view.selectOperationsGrid = KS.create(selectOperationsGrid);
            view.selectOperationsWin = KS.showModal(view.selectOperationsGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(600, KS.rootViewport.getWidth() / 2),
                height: Math.max(600, KS.rootViewport.getHeight() / 1.5),
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doSelectOperations();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectOperationsWin.close();
                        }
                    }]
            }, true);
        },

        doSelectOperations: function() {
            var view = this;
            var selectedOperations = [];
            var checkedCodes = [];
            view.selectOperationsGrid.store.each(function(record) {
                if (KS.Grid.getAnyCase(record, "CHECKED")) {
                    checkedCodes.push(KS.Grid.getAnyCase(record, "link_log_mode") + "_" + KS.Grid.getAnyCase(record, "link_log_event"));
                    selectedOperations.push(KS.Grid.getAnyCase(record, "NAME"));
                }
            });
            view.serverCall({
                method: 'SelectOperations',
                params : [checkedCodes],
                success: function() {
                    view.selectOperationsWin.close();
                    view.operationFilter.setValue(selectedOperations.join(", "));
                    view.updateStatistics();
                }
            });
        },

        clearOperationFilter: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SelectOperations',
                params : [[]],
                success: function() {
                    view.operationFilter.setValue("");
                    view.updateStatistics();
                }
            });
        },

        updateStatistics: function() {
            this.serverCall({
                method: 'OnUpdateStatistics',
                waitMessage: 'Обновление статистики...',
                success: this.updateStatisticsCallBack
            });
        },

        updateStatisticsCallBack : function(resultObj) {
            this.chartPanel.removeAll();
            var isDetalize = this.getToolbarItem(this.rootPanel, null, "DETALIZE").getValue();
            if (isDetalize)
                this.createDetalizeGrid(resultObj);
            else
                this.createChart(resultObj);

            var printChartBtn = this.getToolbarItem(this.rootPanel, null, "PRINT_CHART");
            if (printChartBtn)
                printChartBtn.setHidden(isDetalize);            
            var printListBtn = this.getToolbarItem(this.rootPanel, null, "PRINT_LIST");
            if (printListBtn)
                printListBtn.setHidden(!isDetalize);

            this.setMainPanelHeight();

            this.formsTree.getRootNode().removeAll(true);
            this.formsTree.fullReload();
        },

        createChart: function(storeData) {
            var mode = this.statsModeCombo.getValue();

            if (Ext.isEmpty(storeData)) {
                this.addEmptyDataPanel();
                return;
            }

            switch(mode) {
                case 0:
                    this.createPolarChart(storeData, "Статусы", "Статусы созданных отчетов", true);
                    break;

                case 1:
                    this.createPolarChart(storeData, "Проверка КС", "Результаты проверки внутридокументных КС", true);
                    break;

                case 2:
                    this.createPolarChart(storeData, "Операции", "Количество выполненных пользователями операций (на основании журнала событий)", true);
                    break;

                case 3:
                    this.createCartesianChart(storeData, "Даты работы", "Распределение операций по рабочим дням");
                    break;

                case 4:
                    this.createPolarChart(storeData, "Статистика сдачи", "Учитываются только сданные отчеты (определяется настройками приложения)");
                    break;

                case 5:
                    this.createPolarChart(storeData, "Отправка отчета на доработку", "Учитываются все отчеты");
                    break;

                case 6:
                    this.createPolarChart(storeData, "Отправка отчета на доработку после первого подписания", "Учитываются все отчеты");
                    break;

                case 9:
                    this.createPolarChart(storeData, "Дата первого подписания ЭП", "Учитываются все отчеты");
                    break;

                case 11:
                    this.createPolarChart(storeData, "Количество снятий ЭП", "Учитываются все отчеты");
                    break;

                case 13:
                    this.createPolarChart(storeData, "Дата первой установки статуса", "Учитываются все отчеты");
                    break;

                case 12:
                    this.createPolarChart(storeData, "Сверка", "Сверка с учетными данными");
                    break;
            }
        },

        setMainPanelHeight: function() {
            var height = this.rootPanel.getHeight() - (this.statsModeCombo.getHeight() + this.statsTabPanel.getHeight()  + 40);
            this.mainPanel.setHeight(height);
        },

        createPolarChart: function(storeData, title, creditsText, needDblClk) {
            var chart = {
                xtype: 'polar',
                parentView: this,
                border: false,
                theme: 'default-gradients',
                interactions: ['itemhighlight'],
                captions: {
                    title: {
                        text: title,
                        style: {
                            fontSize: this.data.topTitleAppearance.FontSize * 1.2,
                            fontStyle: this.data.topTitleAppearance.Italic ? 'italic' : 'normal',
                            fontWeight: this.data.topTitleAppearance.Bold ? 'bold' : 'normal',
                            textDecorationLine: this.data.topTitleAppearance.Underline ? 'underline' : 'none',
                            fontFamily: this.data.topTitleAppearance.FontName.toLowerCase(),
                            fillStyle: convertToHexString(this.data.topTitleAppearance.ForeColor)
                        }
                    },
                    styledCredits: {
                        text: creditsText +
                            "\n" +
                            (needDblClk ? '(двойной клик по диаграмме для просмотра списка отчетов)' : ''),
                        docked: 'bottom',
                        align: 'center',
                        style: {
                            fontSize: this.data.bottomTitleAppearance.FontSize * 1.2,
                            fontStyle: this.data.bottomTitleAppearance.Italic ? 'italic' : 'normal',
                            fontWeight: this.data.bottomTitleAppearance.Bold ? 'bold' : 'normal',
                            textDecorationLine: this.data.bottomTitleAppearance.Underline ? 'underline' : 'none',
                            fontFamily: this.data.bottomTitleAppearance.FontName.toLowerCase(),
                            fillStyle: convertToHexString(this.data.bottomTitleAppearance.ForeColor),
                            textAlign: 'center'
                        }
                    }
                },
                innerPadding: 30,
                store: {
                    fields: ['name', 'data1'],
                    data: storeData
                },
                legend: {
                    type: 'sprite',
                    docked: 'left'
//                    style: { // не работает с 'sprite', только с 'dom', но 'dom' не отображается при сохранении
//                        width: 200, 
//                        maxWidth: 200 
//                    }
                },
                series: {
                    type: 'pie',
                    highlight: true,
                    angleField: 'data1',
                    label: {
                        field: 'name',
                        display: 'rotate'
                    },
                    donut: 30,
                    tooltip: {
                        trackMouse: true,
                        renderer: function(tooltip, record) {
                            tooltip.setHtml(record.get('name') + ': ' + record.get('data1'));
                        }
                    }
                }
            };

            if (needDblClk) {
                chart.listeners = {
                    itemdblclick: this.chartItemDblClick
                }
                chart.plugins = {
                    chartitemevents: {
                        moveEvents: true
                    }
                }
            }

            this.chart = Ext.create(chart);

            this.chartPanel.add(this.chart);
        },

        chartItemDblClick: function(chart, item) {
            var view = this.parentView;
            var name = KS.Grid.getAnyCase(item.record, "name");
            view.serverCall({
                method: 'OpenReportList',
                params: [name]
            });
        },

        createCartesianChart: function(storeData, title, creditsText) {
            this.chart = Ext.create({
                xtype: 'cartesian',
                parentView: this,
                border: false,
                captions: {
                    title: {
                        text: title,
                        style: {
                            fontSize: this.data.topTitleAppearance.FontSize * 1.2,
                            fontStyle: this.data.topTitleAppearance.Italic ? 'italic' : 'normal',
                            fontWeight: this.data.topTitleAppearance.Bold ? 'bold' : 'normal',
                            textDecorationLine: this.data.topTitleAppearance.Underline ? 'underline' : 'none',
                            fontFamily: this.data.topTitleAppearance.FontName.toLowerCase(),
                            fillStyle: convertToHexString(this.data.topTitleAppearance.ForeColor)
                        }
                    },
                    styledCredits: {
                        text: creditsText + "\n" +
                            '(на основании журнала событий)',
                        docked: 'bottom',
                        align: 'center',
                        style: {
                            fontSize: this.data.bottomTitleAppearance.FontSize * 1.2,
                            fontStyle: this.data.bottomTitleAppearance.Italic ? 'italic' : 'normal',
                            fontWeight: this.data.bottomTitleAppearance.Bold ? 'bold' : 'normal',
                            textDecorationLine: this.data.bottomTitleAppearance.Underline ? 'underline' : 'none',
                            fontFamily: this.data.bottomTitleAppearance.FontName.toLowerCase(),
                            fillStyle: convertToHexString(this.data.bottomTitleAppearance.ForeColor),
                            textAlign: 'center'
                        }
                    }
                },
                store: {
                    fields: ['name', 'data1'],
                    data: storeData
                },
                axes: [{
                    type: 'numeric',
                    position: 'left',
                    grid: true,
                    minimum: 0
                }, {
                    type: 'category',
                    position: 'bottom',
                    grid: true,
                    label: {
                        rotate: {
                            degrees: -90
                        }
                    }
                }],
                series: {
                    type: 'line',
                    xField: 'name',
                    yField: 'data1',
                    curve: {
                        type: 'natural'
                    },
                    marker: true,
                    tooltip: {
                        trackMouse: true,
                        renderer: function (tooltip, record) {
                            tooltip.setHtml(record.get('name') + ': ' + record.get('data1'));
                        }
                    }
                }
            });

            this.chartPanel.add(this.chart);
        },

        addEmptyDataPanel: function() {
            var emptyPanel = Ext.create('Ext.form.Panel',
                {
                    bodyPadding: 10,
                    border: false,
                    items: [
                        {
                            xtype: 'label',
                            text: 'Нет данных',
                            margin: '0 0 0 50',
                            style: {
                                fontSize: '20px',
                                color: 'red'
                            }
                        }
                    ]
                });
            this.chartPanel.add(emptyPanel);
        },

        createDetalizeGrid: function(detalizeGrid) {
            if (Ext.isEmpty(detalizeGrid)) {
                this.addEmptyDataPanel();
                return;
            }
            this.detalizeGrid = this.createTemplateControl(detalizeGrid, "detalizeGrid");
            this.chartPanel.add(this.detalizeGrid);
        },

        changeStatusDate: function(comp, newValue) {
            if (!Ext.isDate(newValue)) return;
            var view = this;
            view.serverCall({
                method: 'ChangeStatusDate',
                params: [newValue],
                success: function() {
                    view.updateStatistics();
                }
            });
        },

        organizationDetalizeChange: function(comp, newValue) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'OrganizationDetalizeChange',
                params: [newValue],
                success: function() {
                    view.updateStatistics();
                }
            });
        },

        urlClick: function(linkSavedForm) {
            if (!Ext.isEmpty(linkSavedForm) && linkSavedForm !== 0) {
                var view = this;
                KS.confirm("Перейти к отчету?", "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            view.serverCall({
                                method: 'UrlClick',
                                params: [linkSavedForm]
                            });
                        }
                    });
            }
        }
    });
}(ReportStatisticsView.prototype));

// ============= TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        formsTreeCheckChange: function(node, checked) {
            this.serverCall({
                method: 'FormsTreeCheckChange',
                params: [node.getId(), checked],
                disableFog: true
            });
        },

        formsTreeInvertAll: function() {
            var view = this.parentView || this;
            view.formsTree.invertAll();
            view.formsTreeSetCheckedNodes();
        },

        formsTreeUnmarkAll: function() {
            var view = this.parentView || this;
            view.formsTree.uncheckAll();
            view.formsTreeSetCheckedNodes();
        },

        formsTreeCheckChild: function() {
            var view = this.parentView || this;
            view.formsTree.checkAllChildren();
            view.formsTreeSetCheckedNodes();
        },

        formsTreeCheckChildOneLevel: function() {
            var view = this.parentView || this;
            view.formsTree.checkDirectChildren();
            view.formsTreeSetCheckedNodes();
        },

        formsTreeSetCheckedNodes: function() {
            var checkedNodes = this.formsTree.getChecked();
            var checkedLikns = [];
            Ext.each(checkedNodes, function(node) {
                checkedLikns.push(node.getId());
            });
            this.serverCall({
                method: 'FormsTreeMultiCheckChange',
                params: [checkedLikns],
                disableFog: true
            });
        },

        searchFieldChange: function() {
            this.doSearchByField(this.formsTree, this.formsTree);
        },

        clearSearchField: function() {
            var view = this.parentView || this;
            var searchBtn = view.getToolbarItem(view.formsTree, null, "searchField");
            if (searchBtn) {
                searchBtn.setValue("");
            }
        }
    });
}(ReportStatisticsView.prototype));

function getPartToReplace(mode) {
    switch(mode) {
        case 0:
            return "link_saved_form_status";

        case 1:
            return "check_error";

        case 4:
            return "ready_count";

        case 5:
        case 6:
        case 7:
            return "correct";

        case 9:
        case 10:
        case 13:
            return "date";

        case 11:
            return "eds_delete_count";

        case 12:
            return "check_warning";
    }
    return "";
}

function statisticsUrlVLRenderer(value, metadata, record, rowIndex, colIndex, store){
    value = valuesListRenderer(value, metadata, record, rowIndex, colIndex, store);

    var view = store.grid.parentView;
    var viewId = view.viewID;
    var dataIndex = metadata.column.dataIndex;
    var mode = view.statsModeCombo.getValue();
    var partToReplace = getPartToReplace(mode);

    if (Ext.isDate(value))
        value = Ext.util.Format.date(value, 'd.m.Y');

    if (!Ext.isEmpty(partToReplace)) {
        if (dataIndex.indexOf(partToReplace) !== -1) {
            var linkSavedFormColumn = dataIndex.replace(partToReplace, "link_saved_form");
            var linkSavedForm = KS.Grid.getAnyCase(record, linkSavedFormColumn);
            return '<span class="like-hypertext" onclick="KS.getView(' + "'" + viewId + "'" + ').urlClick(' + linkSavedForm + ');return false;"/>' + value + '</span>';
        }
        return '<span class="like-hypertext"/>' + value + '</span>';
    }

    return value;
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();