﻿OrganizationTypesDictionaryView = KS.extend(BaseDictionaryView, {
    select: function () {
        var view = this.parentView || this,
            grid = view.mainGrid,
            selectRows = grid.getSelection(),
            organizationParams = [];
        if (Ext.isEmpty(selectRows)) return;
        organizationParams.push(selectRows[0].data);
        view.disable();
        view.doSelectOgranizationType(organizationParams);
    },

    rowDblClickHandler: function(grid, record) {
        if (this.data.isSelecting) {
            var organizationParams = [];
            organizationParams.push(record.data);
            this.doSelectOgranizationType(organizationParams);
        }
    },

    doSelectOgranizationType: function(organizationParams) {
        var view = this;
        view.serverCall({
            method: 'SelectOgranizationType',
            params: [organizationParams],
            success: function(ok) {
                if (ok) {
                    view.destroyContainerItems();
                } else {
                    view.enable();
                }
            },
            error: view.enable
        });
    }
});