﻿CheckSumsMdks125View = KS.extend(BaseDictionaryView, {
    customName: 'CheckSumsMdks125View'
});

(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.discardChanges();
            this.mainGrid.getExcelAdditionals = this.getExcelAdditionals;
        },

        resetView: function() {
            this.mainGrid.resetPage();
        },

        saveChanges: function() {
            var view = this.parentView,
                modifiedRecords = view.mainGrid.getStore().getModifiedRecords(),
                recsChanges = {};

            Ext.each(modifiedRecords, function (rec) {
                var closeCode = view.mainGrid.getCloseCode(rec);
                Ext.Object.each(rec.modified, function(key) {
                    if (key === 'CHECKED' || rec.data[key] === null)
                        return true;
                    else {
                        if (!recsChanges[closeCode])
                            recsChanges[closeCode] = {};
                        recsChanges[closeCode][key] = rec.data[key];
                    }
                });
            });

            view.serverCall({
                method: 'SaveRecordsChanges',
                params: [recsChanges],
                waitMessage: 'Сохранение изменений...',
                success: view.doSaveChanges
            });
        },

        doSaveChanges: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение...',
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        if (!Ext.isEmpty(view.saveErrorMsg))
                            KS.alert(view.saveErrorMsg);
                        return;
                    }
                    view.discardChanges();
                    view.reload();
                }
            });
        },

        editGridCell: function(plugin, context) {
            if (context.value === null || context.value === context.originalValue)
                return;
            this.touch();
        },

        newHandler: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'AddRow',
                disableFog: true,
                success: function(dataRow) {
                    view.addRecordCallback([dataRow]);
                }
            });
        },

        copyHandler: function() {
            var view = this.parentView;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes))
                return;
            var msg = checkedCodes.length === 1
                ? 'Копировать запись?'
                : 'Копировать выделенные записи?';
            KS.confirm(msg, 'Внимание', function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'CopyRows',
                        disableFog: true,
                        params: [checkedCodes],
                        success: view.addRecordCallback
                    });
                }
            });
        },

        addRecordCallback: function(result) {
            var view = this;
            if (result) {
                Ext.each(result, function (dataRow) {
                    view.mainGrid.addRecord(dataRow);
                });
                view.touch();
            }
        },

        deleteHandler: function() {
            var view = this.parentView;
            var selRows = view.mainGrid.getSelection();
            if (Ext.isEmpty(selRows))
                return;
            var checkedCodes = [];
            Ext.Array.each(selRows, function(rec) {
                checkedCodes.push(view.mainGrid.getCloseCode(rec));
            });
            KS.confirm(view.deleteConfirmMsg, "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteTableRows',
                        params: [checkedCodes],
                        success: function () {
                            view.mainGrid.getStore().remove(selRows);
                            view.touch();
                        }
                    });
                }
            });
        }
    });
}(CheckSumsMdks125View.prototype));