﻿Ext.define('Svod.ColorDialogPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'colordialog.panel',
    layout: 'vbox',
    initComponent: function() {
        this.items = [
            // Выбор из готового списка цветов 
            Ext.create('Ext.picker.Color', {
                listeners: {
                    select: function(picker, selColor) {
                        var htmlColorPicker = document.getElementById("extColorPicker");
                        if (htmlColorPicker)
                            htmlColorPicker.value = '#' + selColor; 
                    }
                }
            }),
            // Можно задать цвет самому (HTML5)
            Ext.create('Ext.container.Container', {
                margin: '10 0 10 36',
                html: '<input type="color" id="extColorPicker" style="width: 120px; height: 40px" value="' + this.initialConfig.colorValue + '">',
            })
        ];

        this.callParent();        
    }
})