Ext.define('Svod.chatList.CreatingChatModal', {
    extend: Ext.window.Window,

    xtype: 'creatingChatModal',

    title: 'Создать чат',

    cls: 'creatingChatModal',

    reference: 'creatingChatModal',

    referenceHolder: true,

    width: 250,

    height: 140,

    // основной(родительский) компонент Чат-бота
    chatBotComponent: null,

    // стор чатов
    chatBotChatsStore: null,

    // название чата
    chatNameField: null,

    // кнопка сохранения
    creatingChatModalSave: null,

    // кнопка отмены
    creatingChatModalCancel: null,

    autoShow: true,

    closeAction: 'hide',

    resizable: false,

    draggable: false,

    layout: {
        type: 'vbox',
        align: 'middle',
        pack: 'center'
    },

    items: [],

    buttons: [
        {
            text: 'Сохранить',
            tooltip: 'Сохранить',
            cls: 'creatingChatModalButton',
            reference: 'creatingChatModalSave',
            handler(){
                let component = this.up('creatingChatModal');
                component.parentView.creatingChatModalSaveHandler.call(component);
            },
            margin: '5px 0',
            scale: 'medium'
        },
        '->',
        {
            text: 'Отменить',
            tooltip: 'Отменить',
            cls: 'creatingChatModalButton',
            reference: 'creatingChatModalCancel',
            handler(){
                let component = this.up('creatingChatModal');
                component.parentView.creatingChatModalCancelHandler.call(component);
            },
            margin: '5px 0',
            scale: 'medium'
        }
    ],

    listeners: {
        hide() {
            this.lookupReference('chatNameField').setValue('');
            this.chatBotComponent.unmask();
        }
    },

    initComponent() {
        this.renderTo = Ext.ComponentQuery.query('chatBotPanel')[0].el;

        Ext.window.Window.prototype.initComponent.call(this);

        this.chatNameField = this.add({
            xtype: 'textfield',
            inputType: 'text',
            allowBlank: true,
            maxLength: 1000,
            reference: 'chatNameField',
            fieldLabel: '"Название чата',
            emptyText: 'Введите название вашего чата',
            labelAlign: 'top',
            labelCls: 'chatNameFieldLabel',
            labelSeparator: '',
            width: '90%',
            anchor: '100%',
            name: 'nameField',
            enableKeyEvents: true,
            parentView: this.parentView,
            listeners: {
                keypress(textfield, eventObject){
                    this.parentView.chatNameFieldKeypress.call(this.ownerCt, textfield, eventObject);
                },
                change(){
                    this.parentView.chatNameFieldKeypressChange.call(this.ownerCt);
                },
                afterrender() {
                    this.parentView.setTooltip(this, 'Введите название вашего чата');
                }
            }
        });

        this.creatingChatModalCancel = this.lookupReference(
            'creatingChatModalCancel'
        );
        this.creatingChatModalSave = this.lookupReference(
            'creatingChatModalSave'
        );
    }
});
