// ============= Platform overrides =======================
KS.apply(KS,
    {
        pageSizeLabel: 'Число строк',
        loadAllPages: true,

        logoutComplex: function() {
            WorkspaceView.serverCall({
                method: 'CheckNotSubmittedReports',
                waitMessage: 'Подготовка к выходу...',
                success: function(result) {
                    if (result) {
                        KS.confirm('Вы представили к сдаче не все отчеты. Перейти к просмотру отчетов?', 'Внимание', 
                            function(btn) {
                                if (!KS.isDefined(WorkspaceView)) return;
                                if (btn === 'yes') {
                                    KS.Svod.openPlanningTasks();
                                } else {
                                    KS.baseLogoutComplex();
                                }
                            });
                    } else {
                        KS.baseLogoutComplex();
                    }
                }
            });
        },

        baseLogoutComplex: function() {
            KS.confirm('Выйти из комплекса?', 'Подтверждение выхода',
                function(btn) {
                    if (btn !== 'yes' || !KS.isDefined(WorkspaceView)) return;
                    WorkspaceView.askLeavePage(false);
                    KS.winvoke({ method: 'Logout', async: false, success: KS.esiaLogout });
                });
        },

        error: function(msg, title, handler, details, report) {
            KS.stopWaitingAll();

            title = !!title ? title : KS.L10n.appError;
            if (!msg) {
                if (KS.issueTracking)
                    msg = KS.L10n.operationErrorUnhandled;
                else
                    msg = KS.L10n.operationError;
            }

            KS.log(msg);

            if (KS.showErrorInfoForUsers) {
                if (!!details && !!details.Type)
                    details = KS.describeException(details);

                KS.msgBox(msg, title, handler, details, KS.errorImage, typeof (report) !== 'undefined' ? report : true);
            }
            else
            {
                msg = details.Message + "<br>" + "Обратитесь к администратору.";
                KS.msgBox(msg, title);
            }
        },

        msgBox: function(msg, title, handler, details, icon, report) {
            var h = !details,
                copyBtn,
                d = Ext.create('Ext.Window',
                    {
                        modal: true,
                        frame: true,
                        plain: true,
                        shadow: false,
                        closable: true,
                        closeToolText: 'Закрыть окно',
                        maximizable: true,
                        resizable: true,
                        title: title,
                        width: 450,
                        layout: 'anchor',
                        referenceHolder: true,
                        items: [{
                            layout: 'hbox',
                            items: [{
                                xtype: 'image',
                                width: 32,
                                height: 32,
                                margin: 10,
                                src: icon
                            },
                                {
                                    maxHeight: Math.max(200, KS.rootViewport.getHeight() / 3),
                                    scrollable: true,
                                    flex: 1,
                                    margin: 3,
                                    border: false,
                                    html: msg
                                }]
                        },
                            {
                                xtype: 'fieldset',
                                anchor: '100% 100%',
                                title: 'Подробнее',
                                collapsible: true,
                                collapsed: true,
                                hidden: h,
                                items: new Array({
                                    xtype: 'textarea',
                                    hideLabel: true,
                                    readOnly: true,
                                    autoScroll: true,
                                    height: 150,
                                    anchor: '100% 100%',
                                    border: false,
                                    style: {
                                        'font-family': 'helvetica,tahoma,verdana,sans-serif',
                                        'font-size': '11px'
                                    },
                                    value: details
                                }),
                                listeners: {
                                    expand: function() {
                                        copyBtn.show();
                                        d.updateLayout();
                                    },
                                    collapse: function() {
                                        copyBtn.hide();
                                        d.updateLayout();
                                    }
                                }
                            }],
                        listeners: {
                            'close': function() {
                                if (!!handler) handler();
                            }
                        },
                        dockedItems: new Array({
                            xtype: 'toolbar',
                            dock: 'bottom',
                            ui: 'footer',
                            items: [{
                                text: 'Отправить разработчикам',
                                hidden: !KS.issueTracking || !report,
                                handler: function() {
                                    d.close();
                                    KS.issuePrompt(details);
                                }
                            },
                                '->',
                                copyBtn = Ext.create('Ext.Button',
                                    {
                                        text: 'Скопировать в буфер обмена',
                                        hidden: h,
                                        handler: function() {
                                            KS.copyToClipBoard(details);
                                        }
                                    }),
                                {
                                    text: 'OK',
                                    handler: function() {
                                        d.close();
                                    }
                                }]
                        })
                    }).show();
        }
    });

// ============= KS.Svod =======================
(function () {
    KS.Svod = {
        DICT_IMAGE_TAG: '<img src="images/get_dictionary.png">',

        activateBudgetTreeNode: function (budgetHierarchyLink, path) {
            var navView = KS.findSingleView('customName', 'ReportNavigationView');
            if (navView) navView.activateBudgetTreeNode(budgetHierarchyLink, path);
        },

        processHyperLink: function (lsf) {
            WorkspaceView.serverCall({
                method: 'ProcessHyperLink',
                params: [lsf]
            });
        },

        processReportHyperLink: function (e, viewId) {
            try {
                var view = KS.getView(viewId),
                    a = e.target || e.srcElement;
                if (view && a) {
                    view.serverCall({
                        method: 'ProcessReportHyperLink',
                        params: [a.href + ''],
                        waitMessage: 'Обработка ссылки ...'
                    });
                }
            } catch (e) {
                KS.msg('Ошибка перехода по ссылке');
            }
        },

        processTemplateHyperLink: function (e, viewId, ctrlId, colKey, closeCode, taskType) {
            try {
                var view = KS.getView(viewId);
                if (!view) return;
                var a = e.target || e.srcElement,
                    grid = view[ctrlId];
                if (grid && a) {
                    if (Ext.isEmpty(grid.getSelection()) && grid.closeCode){
                        var clickedRow = grid.findRecord(closeCode, grid.closeCode.toLowerCase()) ||
                                         grid.findRecord(closeCode, grid.closeCode.toUpperCase());
                        if (!Ext.isEmpty(clickedRow))
                            grid.getSelectionModel().select(clickedRow);
                    }
                    var gridContext = grid.getControlState({
                        activeColumn: colKey
                    });
                    view.serverCall({
                        method: 'ProcessTemplateHyperLink',
                        params: [ctrlId, a.href, taskType || 1, colKey, gridContext],
                        waitMessage: 'Обработка ...'
                    });
                }
            } catch (e) {
                KS.msg('Ошибка перехода по ссылке');
            }
        },

        openTableCell: function (savedFormLink, reportTableCell) {
            var reportView = null,
                tableView = null;
            try {
                for (var key in KS.registeredViews) {
                    var view = KS.registeredViews[key];
                    if (view && view.data && view.data.savedForm && view.data.savedForm.LinkSavedForm == savedFormLink && view.eachTable) {
                        reportView = view;
                        reportView.eachTable(function (tv) {
                            var tl = (tv && tv.data && tv.data.tableDescription && tv.data.tableDescription) ? tv.data.tableDescription.TableLink : 0;
                            if (tl > 0 && reportTableCell && tl == reportTableCell.TableLink) {
                                tableView = tv;
                            }
                        });
                    }
                }
                if (reportView) {
                    setTimeout(function () {
                        reportView.activate();
                        reportView.data.reportTableCell = reportTableCell;
                        reportView.processHyperLink();
                    }, 10);
                } else {
                    KS.msg('Отчет не найден');
                    return;
                }
                if (tableView) {
                    tableView.data.reportTableCell = reportTableCell;
                    tableView.processReportTableCell();
                } else {
                    reportView.deferredReportTableCell = reportTableCell;
                }
            } catch (e) {
                KS.msg('Ошибка перехода по ссылке');
            }
        },

        getFormattedDateTime: function (dt, format) {
            try {
                if (Ext.isEmpty(dt)) return '';
                var stamp = Ext.decode(dt.substring(1, dt.length - 1));
                return Ext.util.Format.date(stamp, format);
            } catch (e) {
                return '';
            }
        },

        normalizeFloatValue: function (value, length/*, divider*/) {
            var retValue = value || '0';
            if (typeof (retValue) != 'string') retValue = retValue.toString();
            var fValue = parseFloat(retValue.replace(',', '.'));
            if (isNaN(fValue) === true) fValue = 0;
            //if (divider !== null && divider != 0) fValue = fValue / divider;
            retValue = fValue.toFixed(length).replace('.', ',');
            return retValue;
        },

        isMathesMask: function (value, mask) {
            if (Ext.isEmpty(value) || Ext.isEmpty(mask))
                return true;
            return true;
        },

        formattedMsg: function (clsPostfix, msg, title) {
            KS.msg('<span class="formatted-msg-' + clsPostfix + '">' + msg + '</span>', title);
        },

        showHtmlProtocol: function (h, t, autoClose, icon, autoCloseDelay, actionText, callback, notify) {
            if (!KS.isEmpty(t) && t.indexOf('ShowDesktopAlert:') >= 0) {
                t = t.replace('ShowDesktopAlert:', '');
                KS.showDesktopAlert(h, t, autoClose, icon, autoCloseDelay, actionText, callback, notify);
            } else if (KS.isEmpty(h) && KS.isEmpty(t)) {
                WorkspaceView.serverCall({
                    method: 'GetAutoCreateProtocol',
                    waitMessage: 'Подготовка протокола...',
                    success: KS.showHtmlProtocol
                });
            } else {
                KS.showHtmlProtocol(h, t);
            }
        },

        openSocialNews: function () {
            WorkspaceView.serverCall({
                method: 'OpenSocialNews',
                waitMessage: 'Открывается лента сообщений ...'
            });
        },        
        
        openDocsForCheck: function () {
            WorkspaceView.serverCall({
                method: 'DocumentsForCheck',
                waitMessage: 'Открываются документы для проверки ...'
            });
        },

        reportShowProtocol: function (viewId, dateString, type) {
            try {
                var view = KS.getView(viewId);
                if (view) {
                    Ext.each(view.data.notes, function (note) {
                        if (note.Type == type && note.DateString == dateString) {
                            KS.showHtmlProtocol(note.Protocol);
                        }
                    });
                }
            } catch (e) {
                KS.log('Error show protocol', 'view');
            }
        },

        openPlanningTasks: function() {
            WorkspaceView.serverCall({
                method: 'OpenPlanningTasks'
            });
        },

        customPlanningTaskButton: function(state) {
            if (KS.additionalInfo) {
                var planningTaskButton = KS.additionalInfo.getComponent('planningTaskButton');
                if (!planningTaskButton) {
                    planningTaskButton = Ext.create('Ext.Button',
                        {
                            itemId: 'planningTaskButton',
                            iconCls: 'ks-icon-calendar',
                            border: false,
                            style: {
                                background: 'inherit'
                            },
                            handler: function() {
                                KS.Svod.openPlanningTasks();
                            }
                        });
                    KS.additionalInfo.add(planningTaskButton);
                }
                if (state == 2) {
                    if (!planningTaskButton.hasCls('planningTaskBtn'))
                        planningTaskButton.addCls('planningTaskBtn');
                } else {
                    if (planningTaskButton.hasCls('planningTaskBtn'))
                        planningTaskButton.removeCls('planningTaskBtn');
                }
            }
        },

        addUserContactFormButton: function(){
            if (KS.additionalInfo) {
                var userContactFormButton = KS.additionalInfo.getComponent('userContactFormButton');
                if (!userContactFormButton) {
                    userContactFormButton = Ext.create('Ext.Button',
                        {
                            itemId: 'userContactFormButton',
                            iconCls: 'ks-icon-email1',
                            border: true,
                            text: 'Отправить обращение в СТП',
                            handler: function() {
                                WorkspaceView.serverCall({
                                    method: 'OpenUserContactForm'
                                });
                            }
                        });
                    KS.additionalInfo.add(userContactFormButton);
                }
            }
        },

        doRefreshTokens: function () {
            var p = new KS.Ajax.Request({
                url: 'OpenIdConnect/SillentRefreshTokens',
                success: (response) => {
                    if (!Ext.isEmpty(response) && response.ExpirationSeconds > 0) {
                        //новый таймер на обновление
                        return setTimeout(this.doRefreshTokens.bind(this), response.ExpirationSeconds * 1000);
                    } else {
                        return KS.winvoke({ method: 'Logout', async: false});
                    }
                },
                failure: () => {
                    return KS.winvoke({ method: 'Logout', async: false});
                }
            });

            $.ajax(p);
        }
    };
})();

// ============= Global toolbar =======================
(function () {
    KS.apply(KS.Svod, {
        clearProfile: function () {
            KS.confirm("Удалить профиль? Будут удалены все пользовательские настройки всех окон.", "Подтверждение", function (btn) {
                if (btn != 'yes') return;
                WorkspaceView.serverCall({
                    method: 'ClearProfile',
                    waitMessage: 'Удаление ...'
                });
            });
        },

        editUserDetails: function () {
            WorkspaceView.serverCall({ method: 'EditUserDetails' });
        },

        changePassword: function () {
            WorkspaceView.serverCall({ method: 'ChangePassword' });
        },

        openOptions: function () {
            WorkspaceView.serverCall({ method: 'OpenOptions' });
        },
        
        openSvodMonitor: function () {
            WorkspaceView.serverCall({ method: 'OpenSvodMonitor' });
        },

        openServiceMonitor: function () {
            WorkspaceView.serverCall({ method: 'OpenServiceMonitor' });
        },

        openTemplateManager: function () {
            WorkspaceView.serverCall({ method: 'OpenTemplateManager' });
        },

        openDbList: function () {
            KS.Svod.askConnectionToDbList();
        },

        openComplexActivation: function () {
            WorkspaceView.serverCall({ method: 'OpenComplexActivation' });
        },

        openUserTemplate: function () {
            WorkspaceView.serverCall({ method: 'OpenUserTemplate' });
        },

        openMap: function () {
            WorkspaceView.serverCall({
                method: 'DebugEvent',
                params: ['map']
            });
        },

        helpBtn: function (toc, style) {
            if (KS.isSurDB) return new Ext.Button({
                hidden: true
            });
            var cfg = {
                iconCls: 'ks-icon-help',
                tooltip: 'Справка',
                handler: function () {
                    KS.Svod.help(toc);
                }
            };
            switch (style || '') {
                case 'tbar':
                    return cfg;
                case 'tbar_w_txt':
                    cfg.text = 'Справка';
                    return cfg;
                case 'dlg':
                    cfg.text = 'Справка';
                    cfg.cls = 'help-button';
                    return new Ext.Button(cfg);
                default:
                    return new Ext.Button(cfg);
            }
        },

        help: function (toc) {
            var href = "Docs/html/index.html";
            if (Ext.isString(toc))
                href += '?' + toc + '.htm';
            window.open(href, "_blank", "status=yes,location=yes,toolbar=yes,resizable=yes,menubar=yes,scrollbars=yes");
        },

        setupClient: function () {
            KS.Svod.help('1002');
        },

        setupServer: function () {
            window.open("http://keysystems.ru/files/smeta/install/svod-smart/DOC/WEB/05_Nastroika_servera_web_clienta_Svod_SMART.doc",
                "_blank", "status=yes,location=yes,toolbar=yes,resizable=yes,menubar=yes,scrollbars=yes");
        },

        about: function () {
            WorkspaceView.serverCall({
                method: 'About',
                waitMessage: 'Чтение ...',
                success: function (html) {
                    KS.showHtmlProtocol(html || 'Сведения недоступны', 'Сведения о программе');
                }
            });
        },

        setClassicTheme: function() {
            KS.setCookie('theme', 'Classic', new Date().addDays(30));
            KS.alert('Изменение вступит в силу при следующем входе в комплекс');
        },

        askConnectionToDbList: function () {
            var selectServerPanel = Ext.create('select-server');
            var modal = KS.showModal(selectServerPanel,
                {
                    title: 'Выберите сервер баз данных',
                    autoHeight: true,
                    resizable: true,
                    maximizable: true,
                    layout: 'anchor',
                    width: 650,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function () {
                                var vm = selectServerPanel.getViewModel();
                                var useLocalServer = vm.get('useLocalServer');
                                var dbType = vm.get('dbType');
                                var server = vm.get('dbServer');
                                var userName = vm.get('dbUser');
                                var password = vm.get('dbPassword');

                                WorkspaceView.serverCall({
                                    method: 'OpenDbList',
                                    params: [useLocalServer, dbType, server, userName, password],
                                    success: function () {
                                        modal.close();
                                    }
                                });
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function () {
                                modal.close();
                            }
                        }
                    ]
                },
                true);
        }
    });
})();

// ============= PeriodComponent EXT6 =======================
(function() {
    Ext.define('KS.Svod.PeriodComponent', {
        extend: 'Ext.form.FieldContainer',
        alias: 'widget.periodComponent',

        constructor: function (ctrl, cfg) {
            if (!cfg) {
                cfg = {};
            }
            var types = Ext.create('Ext.data.Store',
                    {
                        fields: ['value', 'name'],
                        data: ctrl.periodTypes
                    });
            
            var years = Ext.create('Ext.data.Store',
                    {
                        fields: ['value', 'name'],
                        data: this.getYearsList()
                    });

            KS.apply(cfg,
                {
                    layout: 'column',
                    fieldLabel: ctrl.label,
                    labelWidth: ctrl.labelWidth,
                    disabled: ctrl.disabled,
                    defaults: {
                        padding: {
                            left: 5
                        },
                        columnWidth: 0.33,
                        listeners: {
                            'change': this.touch
                        }
                    },
                    items: [
                        {
                            xtype: 'combobox',
                            itemId: 'year',
                            padding: 0,
                            minWidth: 65,
                            maxWidth: 65,
                            store: years,
                            queryMode: 'local',
                            displayField: 'name',
                            valueField: 'value',
                            scrollable: true,
                            parentCt: this,
                            listeners: {
                                'change': this.generateWeekList
                            }
                        }, {
                            xtype: 'combobox',
                            minWidth: 95,
                            maxWidth: 110,
                            itemId: 'type',
                            store: types,
                            queryMode: 'local',
                            displayField: 'name',
                            valueField: 'value',
                            parentCt: this
                        }, {
                            xtype: 'combobox',
                            hidden: true,
                            minWidth: 140,
                            maxWidth: 160,
                            itemId: 'number',
                            displayField: 'name',
                            valueField: 'value'
                        }, {
                            xtype: 'datefield',
                            hidden:true,
                            itemId: 'date',
                            minWidth: 140,
                            maxWidth: 160
                        }
                    ]
                });
            KS.Ext.correctSize(cfg, ctrl);
            KS.Svod.PeriodComponent.superclass.constructor.call(this, cfg);
        },

        initComponent: function () {
            this.callParent(arguments);
        },

        touch: function () {
            if (this.rendered && !this.supressChangeEvent)
                this.ownerCt.fireEvent('change');
        },

        getYearsList: function() {
            var years = [];
            for (var i = 1978; i <= 2099; i++) {
                years.push([i, i]);
            }
            return years;
        },

        generateWeekList: function (year) {
            var allcomponent = year.ownerCt;
            var weekComponent = allcomponent.getComponent("number");

            Date.prototype.addDays = function(days) {
                var date = new Date(this.valueOf());
                date.setDate(date.getDate() + days);
                return date;
            }
            function addNull(number) {
                if (number < 10) {
                    number = 0 + String(number);
                }
                return number;
            }
            var arr = [];
            var result = "";
            var firstDate = new Date("1 Jan " + year.value);
            var endDate = new Date("31 Dec " + year.value);
            var firstWeekDay = firstDate.getDay(); //Номер для недели для 1 января
            var date = firstDate.addDays(-firstWeekDay).addDays(firstWeekDay < 5 ? 1 : 8); // Дата начала первой недели
            var weekCount = endDate.getDay() > 3 && endDate.getDay() >= firstWeekDay ? 53 : 52;
            var weekNull, firstdateNull, lastdateNull, firstMonthNull, lastMonthnull;
            for (var i = 1, week = 1; i <= weekCount && endDate > date; i++, week++) {
                weekNull =      addNull(week);
                firstdateNull = addNull(date.getDate());
                lastdateNull = addNull(date.addDays(6).getDate());
                firstMonthNull = addNull(date.getMonth() + 1);
                lastMonthnull = addNull(date.addDays(6).getMonth() + 1);
                result = String(weekNull) + " (" + String(firstdateNull) + "." + String(firstMonthNull) + " - " + String(lastdateNull) + "." + String(lastMonthnull) + ")";
                date = date.addDays(7);
                arr[i - 1] = [week,result];
            }
            if (weekCount < 53) {
            }
            weekComponent.setStore(arr);
            allcomponent.touch.call(this);
        },

        getPeriods: function(pType, year) {
            var res = [[]];
            switch (+pType) {
            case 2:
                res = this.ctrl.quartPeriods;
                break;
            case 4:
                res = this.ctrl.monthPeriods;
                break;
            case 8:
                res = this.getWeeksList(year);
                break;
            default:
                break;
            }
            return res;
        },

        setType: function(rawType) {
                var me = this,
                    ctrl = me.ctrl,
                    type,
                    number,
                    date0 = new Date(me.getYear(), 0);
                switch (ctrl.mode) {
                case 0:
                    type = rawType;
                    me.getComponent("type").setValue(type);
                    if (type == 1 || type == 16) {
                        me.getComponent("number").setHidden(false);
                    } else {
                        me.getComponent("number").getStore().loadData(me.getPeriods(type, me.getYear()));
                        var pt0 = me.getPeriods(type)[0];
                        if (pt0) me.getComponent("number").setValue(pt0[0]);
                        me.getComponent("number").setHidden(true);
                    }
                    break;
                case 1:
                    if (Ext.isString(rawType) && rawType.indexOf('_') > 0) {
                        type = rawType.split('_')[0];
                        number = rawType.split('_')[1];
                    } else {
                        type = rawType;
                        number = me.getNumber();
                    }
                    switch (+type) {
                        case 8:
                            me.getComponent("type").setValue(type);
                            me.getComponent("number").setValue(number);
                            break;
                        case 16:
                            me.getComponent("type").setValue(type);
                            me.getComponent("date").setValue(new Date(date0.setDate(+number)));
                            var year = date0.getFullYear();
                            me.getComponent("year").setValue(year);
                            break;
                        default:
                            me.getComponent("type").setValue(type + '_' + number);
                            break;
                        }
                    me.setHiddenPC(type);
                    break;
                }
        },

        getType: function () {
            var thistype;
            var me = this;
            switch (this.ctrl.mode) {
            case 0:
                    thistype = +this.getComponent("type").getValue();
                break;
            case 1:
                    thistype = this.getCommonType(this.getComponent("type").getValue());
                break;
            }
            me.setHiddenPC(thistype);
            return thistype;
        },

        setHiddenPC: function (type) {
            var me = this;
            switch (+type) {
            case 8:
                me.getComponent("number").setHidden(false);
                me.getComponent("date").setHidden(true);
                me.getComponent("year").setHidden(false);
                break;
            case 16:
                me.getComponent("number").setHidden(true);
                me.getComponent("date").setHidden(false);
                me.getComponent("year").setHidden(true);
                break;
            default:
                me.getComponent("number").setHidden(true);
                me.getComponent("date").setHidden(true);
                me.getComponent("year").setHidden(false);
                break;
            }
        },

        getCommonType: function (rawType) {
            var type = rawType.split('_')[0];
            return +type;
        },

        getCommonNumber: function (rawType) {
            var number = rawType.split('_')[1];
            return +number;
        },

        setYear: function (year) {
            this.getComponent('year').setValue(year);
            this.touch();
        },

        getYear: function () {
            return this.getComponent('year').getValue();
        },

        setNumber: function (number) {
            var me = this,
                ctrl = me.ctrl;
            switch (ctrl.mode) {
            case 0:
                break;
            case 1:
                switch (me.getType()) {
                case 2:
                case 4:
                case 8:
                    me.setType(me.getType() + '_' + number);
                    return;
                case 16:
                    me.setType(me.getType() + '_' + number);
                    return;
                default:
                        if (me.getComponent("number"))
                        number = me.getComponent("number").getValue();
                    break;
                }
            }
            switch (me.getType()) {
            case 2:
                if (number > 4) {
                    number = 1;
                }
                break;
            case 4:
                if (number > 12) {
                    number = 1;
                }
                break;
            }
                switch (me.getType()) {
                case 16:
                    var date0 = new Date(me.getYear(), 0);
                        me.getComponent('data').setValue(new Date(date0.setDate(+number)));
                    break;
                default:
                        this.getComponent("number").setValue(number);
                break;
                }
        },

        getNumber: function () {
            Date.prototype.isLeapYear = function () {
                var year = this.getFullYear();
                if ((year & 3) != 0) return false;
                return ((year % 100) != 0 || (year % 400) == 0);
            };

            Date.prototype.getDayOfYear = function () {
                var dayCount = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
                var mn = this.getMonth();
                var dn = this.getDate();
                var dayOfYear = dayCount[mn] + dn;
                if (mn > 1 && this.isLeapYear()) dayOfYear++;
                return dayOfYear;
            };

            var me = this, n = 1, date, ctrl = me.ctrl;
            switch (ctrl.mode) {
            case 0:
                switch (me.getType()) {
                case 1: // Год
                    n = 1;
                    break;
                case 16: // День
                        date = me.getComponent("date").getValue();
                        n = (date && typeof (date.getDayOfYear) == 'function') ? date.getDayOfYear() + 1 : 0;
                    break;
                default:
                        n = +me.getComponent("number").getValue();
                }
                break;
            case 1:
                switch (me.getType()) {
                case 1: // Год
                    n = 1;
                    break;
                case 2: // Квартал
                case 4: // Месяц
                        n = me.getCommonNumber(me.getComponent("type").getValue());
                    break;
                case 8: // Неделя
                        n = +me.getComponent("number").getValue();
                        if (n === 0) n = 1;
                    me.getComponent("number").setValue(n);
                    break;
                case 16: // День
                    if (me.getComponent("date").getValue() == null) {
                        date = new Date();
                        me.getComponent("date").setValue(date);
                    } else {
                        date = me.getComponent("date").getValue();
                        }
                    me.getComponent("year").setValue(me.getComponent("date").getValue().getFullYear());
                    n = (date && typeof (date.getDayOfYear) == 'function') ? date.getDayOfYear() : 0;
                    break;
                default:
                     n = me.getComponent("number").getValue();
                }
            }
            return (Ext.isNumber(n) ? n : 1);
        },
 
        setAllPeriods: function(checked) {
            var me = this;
            me.getComponent('type').setDisabled(checked);
            me.getComponent('number').setDisabled(checked);
            me.getComponent('date').setDisabled(checked);
            KS.updateLayout(me);
        },

        getPeriod: function () {
            return {
                Year: this.getYear(),
                Type: this.getType(),
                Number: this.getNumber()
            }
        }
    });

    function createPeriodComponent(ctrl, cfg) {
        KS.apply(cfg,
            {
                ctrl: ctrl
            });
        var periodComponent = new KS.Svod.PeriodComponent(ctrl, cfg);
        if (!KS.isEmpty(ctrl.value)) {
            var period = Ext.isArray(ctrl.value) ? ctrl.value[0] : ctrl.value,
                type = period.Type,
                number = period.Number;
            if (period.Year)
                periodComponent.setYear(period.Year);
            if (type > 8) {
                periodComponent.setType(type + '_' + number);
            } else {
                periodComponent.setType(type + '_' + number);
               // periodComponent.setType(type);
                //periodComponent.setNumber(number);
            }
        }
        KS.Ext.setTemplateListeners(periodComponent, ctrl.listeners, ctrl.parentView);
        return periodComponent;
    }

    KS.Ext.registerControlRenderer('periodComponent', createPeriodComponent);
})();

// ============= Xcrypt 1.0.5 =======================
(function () {
    KS.apply(KS, {
        xcryptVersion: null,
        xcryptObjTagName: 'XCrypt',
        maxXcryptChecks: 3,
        xcryptLoadCheckInterval: 500,
        certValidity: 366,

        getXcryptObj: function () {
            return document.getElementById(KS.xcryptObjTagName);
        },

        isXcryptLoaded: function () {
            try {
                if (!KS.xcryptVersion) KS.xcryptVersion = KS.getXcryptObj().Version();
            } catch (e) {
                return false;
            }
            return true;
        },

        loadXcrypt: function (fn, scope, params) {
            if (KS.isXcryptLoaded()) {
                fn.apply(scope, params || []);
                return;
            }
            $('<object id="' + KS.xcryptObjTagName + '" style="DISPLAY: none" codebase="ocx/XCrypt10.cab" ' +
                'classid="CLSID:CF36DAF3-5B42-4BC0-8F1B-43AA7060802D"> </object>').appendTo("form");

            var checkAttemps = KS.maxXcryptChecks;
            KS.showWaitBox('Загрузка XCrypt ...');
            var intervalId = setInterval(function () {
                if (!KS.isXcryptLoaded() && checkAttemps > 0) {
                    checkAttemps--;
                    return;
                }
                clearInterval(intervalId);
                KS.hideWaitBox();
                if (KS.isXcryptLoaded()) {
                    KS.getXcryptObj().SetParams('SecretKeyValidity=' + scope.data.settings.SecretKeyValidity);
                    fn.apply(scope, params || []);
                } else {
                    KS.warning('Не найден компонент XCrypt.</br>Проверьте <a target="_blank" href="Docs/html/index.html?1002.htm">настройки обозревателя</a>');
                }
            }, KS.xcryptLoadCheckInterval);
        }
    });
})();

// ============= Spreadsheet =======================
(function () {
    function onInternalContainerResize(panel, adjWidth, adjHeight) {
        this.SetWidth(adjWidth - 15);
        this.SetHeight(adjHeight);
    }

    function onExternalContainerResize(panel, adjWidth, adjHeight) {
        this.width = adjWidth;
        this.height = adjHeight;
    }

    function syncPanelSize (p) {
        if (KS.isFunction(p.syncSize)) {
            p.syncSize();
        } else {
            var w = p.getEl().getWidth(),
                h = p.getEl().getHeight();
            KS.defer(p.fireEvent, ['resize', p, w, h], p, 100);
        }
    }

    KS.apply(KS, {
        spreadSheetInit: function(s) {
            var spreadEl = document.getElementById(s.name),
                viewId = s.globalName.split('_')[0],
                view = KS.getView(viewId);
            if (view && view.spreadContainer) {
                var containerEl = document.getElementById('spreadContainer_div');
                //var containerEl = view.spreadContainer.body.dom;
                jQuery(spreadEl).detach().appendTo(containerEl);
                view.spreadsheet = s;
                s.parentView = view;
                view.spreadContainer.on('resize', onInternalContainerResize, s);
                syncPanelSize(view.spreadContainer);
                // for parent
                window.globalSpreadsheetView = view;
                if (window.parent.KS.swin) {
                    window.parent.KS.swin.items.first().body.unmask();
                }
            } else {
                // Template is rendering in ~10 ms after container rendered
                KS.defer(KS.spreadSheetInit, arguments, KS, 100);
            }
        },

        spreadSheetInitCore: function(s) {
            var viewId = s.globalName.split('_')[0],
                view = KS.getView(viewId);
            window.globalSpreadsheet = s;
            view.spreadsheet = s;

            if (!view.spreadsheetFrame) {
                view.spreadsheetFrame = new KS.Ext.SpreadsheetFrame();
            }

            view.spreadsheetFrame.initSpreadsheet(s, view);

            if (window.parent.KS.swin) {
                window.parent.KS.swin.items.first().body.unmask();
            }
        },

        openSpreadsheetView: function(url, callerView) {
            //window.location = url;
            KS.swin = KS.showModal({
                    frame: false,
                    border: false,
                    html: '<iframe id="spreadsheet_frame" src="' + encodeURI(url) +
                        '" frameborder="0" width="0" height="0" align="left">' +
                        'Ваш браузер не поддерживает данный режим!</iframe>'
                }, {
                    autoHeight: false,
                    border: false,
                    height: KS.rootViewport.getHeight() * 0.8,
                    width: KS.rootViewport.getWidth() * 0.8,
                    title: 'Просмотр Excel-документа',
                    callerView: callerView,
                    bbar: [
                        '->', {
                            text: 'ОК',
                            width: 90,
                            cls: 'marked-button',
                            handler: KS.spreadsheetViewSelected
                        }
                    ]
                },
                true);
            var spanel = KS.swin.items.first(),
                sframe = document.getElementById('spreadsheet_frame');
            spanel.on('resize', onExternalContainerResize, sframe);
            syncPanelSize(spanel);
            spanel.body.mask('Подготовка документа...');
        },

        spreadsheetViewSelected: function () {
            var sframe = document.getElementById('spreadsheet_frame');
            var spreadsheetView = sframe.contentWindow.globalSpreadsheetView;

            if (spreadsheetView) {
                spreadsheetView.selected(KS.closeSpreadsheetView);
            }
            else {
                KS.spreadsheetCellsSelected();
            }
        },

        spreadsheetCellsSelected: function () {
            var s = window.globalSpreadsheet,
                viewId = s.globalName.split('_')[0],
                view = KS.getView(viewId);
            if (!s) return;
            var spreadsheetState = s.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/GetLastUsedIndexes',
                data: { spreadsheetState: spreadsheetState },
                success: function (lastUsedIndexes) {
                    var region = s.GetSelection();
                    region['sheetIndex'] = s.sheetIndex || 1;

                    if (region.rightColumnIndex > lastUsedIndexes.columnIndex)
                        region.rightColumnIndex = lastUsedIndexes.columnIndex;

                    if (region.bottomRowIndex > lastUsedIndexes.rowIndex)
                        region.bottomRowIndex = lastUsedIndexes.rowIndex;

                    view.serverCall({
                        method: 'SpreadsheetCellsSelected',
                        params: [region],
                        scope: KS,
                        success: KS.closeSpreadsheetView
                    });
                }
            });
        },

        spreadsheetDocumentChanged: function (s, e) {
            var viewId = s.name.split('_')[0],
                view = KS.getView(viewId);
            view.spreadsheetFrame.fireEvent('documentchanged', s, e);
        },

        spreadsheetSelectionChanged: function(s, e) {
            var viewId = s.name.split('_')[0],
                view = KS.getView(viewId);
            view.spreadsheetFrame.fireEvent('selectionchanged', s, e);
        },

        spreadsheetCellEndEdit: function (s, e) {
            var viewId = s.name.split('_')[0],
                view = KS.getView(viewId);
            view.spreadsheetFrame.fireEvent('cellendedit', s, e);
        },

        closeSpreadsheetView: function (ecKey) {
            var callerView = KS.swin.callerView;
            callerView.serverCall({
                method: 'SpreadsheetSelected',
                params: [ecKey],
                scope: KS,
                success: function() {
                    KS.swin.close();
                }
            });
        }
    });
})();

// ============= HANDLER ARGS =======================
(function() {
    KS.apply(KS.Ext,
        {
            createCtrlEventArgs: function(ctrlType, event, nArgs) {
                switch (ctrlType) {
                case 'grid':
                    return KS.Ext.createGridEventArgs(event, nArgs);
                }
                return {};
            },

            createGridEventArgs: function(event, nArgs) {
                var args = {};

                switch (event) {
                case 'cellclick':
                    if (KS.EXT3) {
                        var grid = nArgs[0],
                            iRow = nArgs[1],
                            iCol = nArgs[2];
                        args = {
                            grid: grid,
                            iRow: iRow,
                            iCol: iCol,
                            dataIndex: grid.getColCfgByIndex(iCol).dataIndex,
                            record: grid.store.getAt(iRow),
                            value: grid.processCheckboxClick(grid, iRow, iCol)
                        };
                    } else {
                        args = {
                            grid: nArgs[0].grid,
                            iRow: nArgs[5],
                            iCol: nArgs[2],
                            dataIndex: '',
                            record: nArgs[3]
                        };
                    }
                    break;
                }

                return args;
            }
        });
})();

// ================= KS.Svod.LogDownloader ==================
(function() {
    KS.Svod.LogDownloader = {
        show: function() {
            var me = this;
            WorkspaceView.serverCall({
                method: 'GetSvodLogList',
                success: function(data) {
                    me.initComponents(data);
                }
            });
        },
        
        openLogUrl : function(fileName, isArchive){
            var url = String(window.location.href).replace(/Workspace.*/,
                (isArchive ? 'temp/ArchiveLogs/' : 'temp/Logs/') + fileName);
            KS.openUrl(url);
        },

        downloadFile : function() {
            var me = this;
            if (!KS.isValid(me.logWindow.selectedFile))
                return;
            var fileName = KS.Grid.getAnyCase(me.logWindow.selectedFile, "FileName");
            me.openLogUrl(fileName);
        },

        downloadZipFile : function() {
            var me = this;
            if (!KS.isValid(me.logWindow.selectedFile))
                return;
            var fullPath = KS.Grid.getAnyCase(me.logWindow.selectedFile, "FullName");
            var fileName = KS.Grid.getAnyCase(me.logWindow.selectedFile, "FileName");
            WorkspaceView.serverCall({
                method: 'CreateLogZipFile',
                params: [fullPath, fileName],
                waitMessage: 'Подготовка файла...',
                success: function(zipFileName) {
                    if (!Ext.isEmpty(zipFileName)) {
                        me.openLogUrl(zipFileName, true);
                    }
                }
            })
        },
        
        initComponents: function(data) {
            var me = this;
            if (Ext.isEmpty(data)) {
                KS.alert('Нет данных');
                return;
            }
            
            Ext.create('Ext.data.Store',
                {
                    storeId: 'logDownloaderStore',
                    fields: [{ name: 'FileName' }, { name: 'Size' }, { name: 'FullName' }],
                    data: data
                });

            me.logListGrid = Ext.create('Ext.grid.Panel',
                {
                    store: Ext.data.StoreManager.lookup('logDownloaderStore'),
                    columns: [{
                        header: 'Имя файла',
                        width: 300,
                        dataIndex: 'FileName'
                    },
                    {
                        header: 'Размер',
                        width: 70,
                        dataIndex: 'Size',
                        renderer: function(value) {
                            return KS.formatSize(value, 1);
                        }
                    },
                    {
                        dataIndex: 'FullName',
                        hidden: true
                    }],
                    border: false,
                    height: 350
                });

            me.logWindow = KS.Ext.showAdjustableWindow([me.logListGrid],
                {
                    title: 'Текстовые логи сервера',
                    width: 410,
                    buttons: [{
                            text: 'Скачать в архиве',
                            tooltip: 'Скачать выбранный лог в архиве',
                            scope: me,
                            handler: me.downloadZipFile
                        },{
                            text: 'Скачать',
                            scope: me,
                            handler: me.downloadFile
                        },
                        {
                            text: 'Отмена',
                            handler: function() {
                                me.logWindow.close();
                            }
                        }]
                });
            
            me.logListGrid.on('rowdblclick',
                function(gridView, record) {
                    me.logWindow.selectedFile = record;
                    me.downloadFile();
                });
            
            me.logListGrid.getSelectionModel().on('selectionchange',
                function(sm) {
                    me.logWindow.selectedFile = null;
                    var s = sm.getSelection();
                    if (!Ext.isEmpty(s))
                        me.logWindow.selectedFile = s[0];
                });
            
            me.logWindow.selectedFile = null;
            me.logWindow.show();
        }
    };
})();

// ================= KS.Svod.ConfigViewer ==================
(function() {
    KS.configKeys = [];
    $(document).keydown(function(e) {
        KS.configKeys.push(e.keyCode);
        if (KS.configKeys.toString().indexOf('83,72,79,87,67,79,78,70,73,71,49,49,49') >= 0) {
            KS.configKeys = [];
            KS.Svod.ConfigViewer.show();
        } else if (KS.configKeys.length > 20)
            KS.configKeys = [];
    });

    KS.Svod.ConfigViewer = {
        show: function(){
            var me = this;
            WorkspaceView.serverCall({
                method: 'GetConfigList',
                success: function(data) {
                    me.initComponents(data);
                }
            });
        },

        initComponents: function(data) {
            var me = this;
            if (Ext.isEmpty(data)) {
                KS.alert('Нет данных');
                return;
            }

            me.configTabPanel = Ext.create('Ext.tab.Panel', {
                items: []
            });

            if (!Ext.isEmpty(data.systemSettings)) {
                Ext.create('Ext.data.Store',
                    {
                        storeId: 'configListStore',
                        fields: [{name: 'ConfigKey'}, {name: 'ConfigValue'}],
                        data: data.systemSettings
                    });

                me.configListGrid = Ext.create('Ext.grid.Panel',
                    {
                        title: 'SystemSettings',
                        store: Ext.data.StoreManager.lookup('configListStore'),
                        plugins: {
                            gridfilters: true
                        },
                        columns: [{
                            header: 'Название свойства',
                            flex: 1,
                            dataIndex: 'ConfigKey',
                            filter: {
                                type: 'string',
                                itemDefaults: {
                                    emptyText: 'Search for...'
                                }
                            },
                            renderer: function (v, metadata) {
                                setTooltip(metadata, v);
                                return v;
                            }
                        },
                            {
                                header: 'Значение',
                                flex: 1,
                                dataIndex: 'ConfigValue',
                                filter: {
                                    type: 'string',
                                    itemDefaults: {
                                        emptyText: 'Search for...'
                                    }
                                },
                                renderer: function (v, metadata) {
                                    setTooltip(metadata, v);
                                    return v;
                                }
                            }],
                        border: false
                    });

                me.configTabPanel.add(me.configListGrid);
            }

            if (!Ext.isEmpty(data.appsettings)) {
                me.configTabPanel.add(
                    Ext.create('Ext.panel.Panel', {
                        title: 'appsettings',
                        scrollable: true,
                        html: '<pre>' + data.appsettings.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</pre>'
                    })
                );
            }

            if (!Ext.isEmpty(data.appsettingsEnv)) {
                me.configTabPanel.add(
                    Ext.create('Ext.panel.Panel', {
                        title: 'appsettingsEnv',
                        scrollable: true,
                        html: '<pre>' + data.appsettingsEnv.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</pre>'
                    })
                );
            }

            if (!Ext.isEmpty(data.storageConfig)) {
                me.configTabPanel.add(
                    Ext.create('Ext.panel.Panel', {
                        title: 'storage.config',
                        scrollable: true,
                        html: '<pre>' + data.storageConfig.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</pre>'
                    })
                );
            }

            me.configWindow = KS.Ext.showAdjustableWindow([me.configTabPanel],
                {
                    title: 'Конфиг сервера',
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                    buttons: [
                        {
                            text: 'Закрыть',
                            handler: function() {
                                me.configWindow.close();
                            }
                        }]
                });

            me.configWindow.show();
        }
    };
})();

// ============= Select Server Component ============
(function () {
    Ext.define('KS.Svod.SelectServerPanel', {
        extend: 'Ext.Container',
        alias: 'select-server',
        layout: 'vbox',
        autoWidth: true,

        viewModel: {
            data: {
                useLocal: true,
                dbType: 0,
                dbServer: '',
                dbUser: '',
                dbPassword: ''
            }
        },

        items: [{
            xtype: 'checkbox',
            name: 'useLocalServer',
            boxLabel: 'Использовать текущий сервер',
            margin: '0 0 0 10',
            bind: '{useLocal}'
        }, {
            xtype: 'container',
            name: 'connection',
            layout: {
                type: 'table',
                columns: 2,
                tdAttrs: { style: 'padding: 5px 10px;' }
            },
            defaults: {
                bind: {
                    disabled: '{useLocal}'
                }
            },

            items: [{
                xtype: 'combobox',
                name: 'dbType',
                fieldLabel: 'СУБД',
                store: {
                    fields: ['type', 'display'],
                    data : [
                        {'type': 0, 'display': 'Microsoft SQL Server'},
                        {'type': 3, 'display': 'PostgreSQL'}
                    ]
                },
                queryMode: 'local',
                displayField: 'display',
                valueField: 'type',
                bind: '{dbType}'
            }, {
                xtype: 'textfield',
                name: 'server',
                fieldLabel: 'Сервер',
                bind: '{dbServer}'
            }, {
                xtype: 'textfield',
                name: 'username',
                fieldLabel: 'Имя пользователя',
                bind: '{dbUser}'
            }, {
                xtype: 'textfield',
                inputType: 'password',
                name: 'password',
                fieldLabel: 'Пароль',
                bind: '{dbPassword}'
            }]
        }]
    });
})();