// ============= KitchenSinkView extensions =======================
if (KS.EXT5) {
    // ============= OBJECT VIEWER =======================
    (function(viewClass) {
        KS.apply(viewClass, {
            renderStudentTab: function () {

                var theme = Ext.themeName;
                var toogle = false;

                function onItemCheck(item, checked) {
                    //Ext.example.msg('Item Check', 'You {1} the "{0}" menu item.', item.text, checked ? 'checked' : 'unchecked');
                    Ext.Msg.alert('Item Check', 'You ' + (checked ? 'checked' : 'unchecked') + ' the ' + item.text + ' menu item.');
                }

                function onButtonClick(btn) {
                    //Ext.example.msg('Button Click', 'You clicked the "{0}" button.', btn.displayText || btn.text);
                    Ext.Msg.alert('Button Click', 'You clicked the ' + (btn.DisplayText || btn.text) + ' button.');
                }

                function onItemClick(item) {
                    //Ext.example.msg('Menu Click', 'You clicked the "{0}" menu item.', item.text);
                    Ext.Msg.alert('Menu Click', 'You clicked the ' + item.text + ' menu item.');
                }

                function onItemToggle(item, pressed) {
                    //Ext.example.msg('Button Toggled2', 'Button "{0}" was toggled to {1}.', item.text, pressed);
                    Ext.Msg.alert('Button Toggled2', 'Button ' + item.text + ' was toggled to ' + (toogle ? 'true' : 'false'));
                    //throw 'Lol';
                    toogle = !toogle;
                }

                var dateMenu = Ext.create('Ext.menu.DatePicker', {
                    handler: function (dp, date) {
                        //Ext.example.msg('Date Selected', 'You choose {0}.', Ext.Date.format(date, 'M j, Y'));
                        Ext.Msg.alert('Date Selected', 'You choose ' + Ext.Date.format(date, 'M j, Y') + '.');

                    }
                });

                var colorMenu = Ext.create('Ext.menu.ColorPicker', {
                    handler: function (cm, color) {
                        //Ext.example.msg('Color Selected', '<span style="color:#' + color + ';">You choose {0}.</span>', color);
                        Ext.Msg.alert('Color Selected', '<span style="color:#' + color + ';">You choose ' + color + '.</span>');
                    }
                });


                var store = Ext.create('Ext.data.ArrayStore', {
                    //fields: ['abbr', 'state'],
                    //data: Ext.example.states
                    fields: ['storeElements'],
                    data: [['One'], ['Two'], ['Three']]
                });

                var combo = Ext.create('Ext.form.field.ComboBox', {
                    hideLabel: true,
                    store: store,
                    //displayField: 'state',
                    displayField: 'storeElements',
                    typeAhead: true,
                    queryMode: 'local',
                    triggerAction: 'all',
                    emptyText: 'Select a store...',
                    selectOnFocus: true,
                    width: 135,
                    indent: true
                });

                var menu = Ext.create('Ext.menu.Menu', {
                    id: 'mainMenu',
                    style: {
                        overflow: 'visible' // For the Combo popup
                    },
                    items: [
                        combo,
                        {
                            text: 'I like Ext',
                            checked: true,
                            checkHandler: onItemCheck
                        },
                        '-',
                        {
                            text: 'Radio Options',
                            menu: {
                                items: [
                                    '<b class="menu-title">Choose a Theme</b>',
                                    '-',
                                    {
                                        text: 'Aero Glass',
                                        checked: true,
                                        group: 'theme',
                                        checkHandler: onItemCheck
                                    },
                                    {
                                        text: 'Vista Black',
                                        checked: false,
                                        group: 'theme',
                                        checkHandler: onItemCheck
                                    },
                                    {
                                        text: 'Gray Theme',
                                        checked: false,
                                        group: 'theme',
                                        checkHandler: onItemCheck
                                    },
                                    {
                                        text: 'Default Theme',
                                        checked: false,
                                        group: 'theme',
                                        checkHandler: onItemCheck
                                    }
                                ]
                            }
                        },
                        {
                            text: 'Choose a Date',
                            //iconCls: 'calendar',
                            menu: dateMenu // <-- submenu by reference
                        },
                        {
                            text: 'Choose a Color',
                            menu: colorMenu // <-- submenu by reference
                        }
                    ]
                });

                var user = Ext.create('Ext.menu.Menu', {
                    xtype: 'menu',
                    //plain: true,
                    items: {
                        xtype: 'buttongroup',
                        title: 'User options',
                        columns: 2,
                        defaults: {
                            xtype: 'button',
                            scale: 'large',
                            //iconAlign: 'left',
                            handler: onButtonClick
                        },
                        items: [
                            {
                                text: 'User manager',
                                //iconCls: 'edit',
                                width: theme === 'neptune' ? 130 : 100,
                                displayText: 'User Manager'
                            },
                            {
                                //iconCls: 'add',
                                tooltip: 'Add user',
                                text: 'Add user', 
                                width: 100,
                                displayText: 'Add user'
                            },
                            {
                                colspan: 2,
                                text: 'Import',
                                scale: 'small',
                                width: '100%'
                            },
                            {
                                colspan: 2,
                                text: 'Who is online?',
                                scale: 'small',
                                width: '100%'
                            }
                        ]
                    }
                });

                var scrollMenu = Ext.create('Ext.menu.Menu');
                for (var i = 0; i < 50; ++i) {
                    scrollMenu.add({
                        text: 'Item ' + (i + 1),
                        handler: onItemClick
                    });
                }

                return {
                    content: {
                        xtype: 'panel',
                        tbar: [
                            {
                                text: 'btn1'
                            }, {
                                text: 'btn2'
                            },
                            {
                                text: 'Button w/ Menu',
                                //iconCls: 'bmenu',
                                menu: menu
                            },
                            {
                                text: 'Users',
                                //iconsCls: 'user',
                                menu: user
                            },
                            Ext.create('Ext.button.Split', {
                                text: 'Split Button',
                                handler: onButtonClick,
                                tooltip: { text: 'This is a an example QuickTip for a toolbar item', title: 'Tip Title' },
                                //iconCls: 'blist',
                                // Menus can be built/referenced by using nested menu config objects
                                menu: {
                                    items: [{
                                        text: '<b>Bold</b>', handler: onItemClick
                                    }, {
                                        text: '<i>Italic</i>', handler: onItemClick
                                    }, {
                                        text: '<u>Underline</u>', handler: onItemClick
                                    }, '-', {
                                        text: 'Pick a Color',
                                        handler: onItemClick,
                                        menu: {
                                            showSeparator: false,
                                            items: [
                                                Ext.create('Ext.ColorPalette', {
                                                    listeners: {
                                                        select: function (cp, color) {
                                                            //Ext.example.msg('Color Selected', 'You chose {0}.', color);
                                                            Ext.Msg.alert('Color Selected', 'You chose ' + color + '.');
                                                        }
                                                    }
                                                }), '-',
                                                {
                                                    text: 'More Colors...',
                                                    handler: onItemClick
                                                }
                                            ]
                                        }
                                    }, {
                                        text: 'Extellent!',
                                        handler: onItemClick
                                    }]
                                }
                            }),
                            '-',
                            {
                                text: 'Toggle Me',
                                enableToggle: true,
                                toggleHandler: onItemToggle,
                                pressed: true
                            }, '-',
                            {
                                //icon: 'list-items.gif', // icons can also be specified inline
                                text: 'icon',
                                cls: 'x-btn-icon',
                                tooltip: '<b>Quick Tips</b><br/>Icon only button with tooltip<br><b>Activated on mousedown</b>',
                                clickEvent: 'mousedown',
                                handler: function () {
                                    //Ext.example.msg('Button Click', 'You clicked the "icon only" button.');
                                    Ext.Msg.alert('Button Click', 'You clicked the "icon only" button.');
                                }
                            }, '-',
                            {
                                text: 'Scroll Menu',
                                menu: scrollMenu
                            },
                            {
                                text: 'Link',
                                url: 'http://www.google.com/search',
                                baseParams: {
                                    q: 'html+anchor+tag'
                                },
                                tooltip: 'This is a link. You can right click. You can see where it will take you'
                            },
                            combo
                        ],
                        html: 'student2'
                    }
                }
            }
        });
    }(KitchenSinkView.prototype));
}