﻿MessageBoxView = KS.extend(KS.Ext.ClientView, {
    show: function() {
        var me = this;

        me.init();
        me.forceStopWaiting();

        if (KS.isValid(me.data.exception)) {
            KS.error(me.data.text, me.data.caption, function() {
                me.onCloseBox.apply(me, ['ok']);
            }, KS.describeException(me.data.exception));
        } else {
            Ext.Msg.show({
                title: me.data.caption,
                msg: me.data.text,
                buttons: me.data.buttons,
                buttonText: me.data.buttonText,
                icon: me.data.icon,
                fn: function(btn) {
                    me.onCloseBox.apply(me, [btn]);
                }
            });
        }
    },

    constructor: function(viewID) {
        MessageBoxView.superclass.constructor.call(this, viewID);
    },

    onCloseBox: function(btn) {
        this.serverCall({ method: 'OnCloseBox', params: [btn] });
    }
});