﻿if (KS.browser && KS.browser.name === 'msie' && KS.browser.version <= 8) {
    // since 6.7.0 Ext.js is not parsed in ie8
    var warnHtml = '<p style=\'font-size: 16px\'>Этот браузер устарел и более не поддерживается!<br/>Работа невозможна!<br><br><a href=\'http://keysystems.ru/forum/index.php?showtopic=18727\'>Подробнее</a></p>';
    $(warnHtml).appendTo("body");
}

function getLangsCombo (data, value, handler, view) {
    return {
        xtype: 'combobox',
        parentView: view,
        queryMode: 'local',
        editable: false,
        valueField: 'culture',
        displayField: 'name',
        hidden: !data || data.length < 2,
        width: 100,
        value: value,
        store: {
            proxy: {
                type: 'memory',
                reader: 'array'
            },
            fields: [
                'culture', 'name'
            ],
            data: data
        },
        listeners: {
            change: {
                scope: view,
                fn: handler
            }
        }
    };
}

LoginView = KS.extend(KS.Ext.ClientView, {
    className: 'LoginView',

    constructor: function (viewId) {
        LoginView.superclass.constructor.call(this, viewId);
    },

    onInit: function () {
        var view = this;

        if (!view.checkBrowser()) return;

        if (view.data.mode === 'recoverypassword') {
            view.renderPasswordRecovery();
            return;
        }

        KS.wbe.initEngine(view);
        KS.apply(Connection.Info, view.data);
        view.initLoginManager();

        var isNoSecure = window.LoginManager.CheckProtocol();
        if (isNoSecure  && !view.data.isSafeTout) {
            view.showNoSecureConnectionPage();
            return;
        }

        if (view.isAuthenticatedByService()){
            view.doLoginByToken();
            return;
        }

        view.renderLoginWindow();
    },

    showNoSecureConnectionPage: function () {
        var view = this;

        view.containerPanel.add({
            xtype: 'nosecureconnectionpage',
            parentView: view,
            onContinueLinkClick: view.renderLoginWindow,
            onBackBtnClick: function() {
                history.back();
            }
        });
    },

    renderLoginWindow: function () {
        var view = this.parentView || this;

        view.containerPanel.removeAll();
        if (view.data.LoginBackground) {
            view.containerPanel.update(view.data.LoginBackground);
        }

        var name = KS.requestGet('pg'),
            pgAdmin = name === 'admin';

        // Для включения режима администратора добавялем в адрес ?pg=admin
        if (pgAdmin || view.data.forceAdminForm) {
            view.renderAdminLoginWindow();
        } else {
            view.renderNewLoginWindow();
        }

        view.startReminder();
    },

    //Вход в режиме единого логина/пароля
    isAuthenticatedByService: function () {
        return this.data.useAuthenticationService && this.data.isAuthenticated;
    },
});

//#region LoginView
// ============= ADMIN LOGIN FORM =======================
(function (viewClass) {
    KS.apply(viewClass, {
        renderAdminLoginWindow: function () {
            var view = this,
                c = KS.getCookie('ExpandDb');

            view.isCrisp = (view.data.currentTheme.name === 'Crisp');
            view.isClassic = (view.data.currentTheme.name === 'Classic');

            view.checkHavePassword();
            view.passwordChanged = false;

            view.expandDB = !!c && c == 1;

            view.loginWindow = Ext.create('Ext.window.Window',
                {
                    title: KS.L10n.authCaption,
                    width: 422,
                    layout: 'vbox',
                    closable: false,
                    resizable: false,
                    border: false,
                    buttonAlign: 'right',
                    items: [
                        {
                            xtype: 'ksimage',
                            frame: true,
                            width: 417,
                            height: 75,
                            border: false,
                            margin: '1 1 5 1', // top, right, bottom, left
                            url: view.data.customLogoImage || 'PlatformHandler.axd?logo=1'
                        }, {
                            xtype: 'tabpanel',
                            loginView: view,
                            width: '100%',
                            border: false,
                            flex: 1,
                            listeners: { beforetabchange: view.onBeforeTabChange },
                            items:[
                                {
                                    title: 'Вход в комплекс',
                                    frame: view.isClassic,
                                    border: false,
                                    style: {
                                        'border-style': 'none !important'
                                    },
                                    bodyStyle: 'padding:10px 10px 0;',
                                    items: [
                                        {
                                            xtype: 'fieldset',
                                            border: false,
                                            defaultType: 'textfield',
                                            defaults: {
                                                anchor: '95%',
                                                border: false,
                                                selectOnFocus: true,
                                                labelAlign: 'right',
                                                labelSeparator: '',
                                                labelStyle: 'font-weight:bold;'
                                            },
                                            items: [
                                                {
                                                    fieldLabel: KS.L10n.loginLabel,
                                                    id: 'frmLogin',
                                                    tabIndex: 1,
                                                    allowBlank: false,
                                                    value: KS.getCookie('lastLogin'),
                                                    parentView: view,
                                                    listeners: {
                                                        specialkey: view.specialKeyHandler
                                                    }
                                                }, {
                                                    fieldLabel: KS.L10n.passwordLabel,
                                                    id: 'frmPassword',
                                                    tabIndex: 2,
                                                    inputType: 'password',
                                                    value: view.hasPassCookie ? 'password' : '',
                                                    parentView: view,
                                                    listeners: {
                                                        change: function() {
                                                            view.passwordChanged = true;
                                                        },
                                                        specialkey: view.specialKeyHandler
                                                    }
                                                }, {
                                                    xtype: 'fieldcontainer',
                                                    fieldLabel: '&nbsp',
                                                    layout: {
                                                        type: 'hbox',
                                                        align: 'begin'
                                                    },
                                                    items: [
                                                        {
                                                            xtype: 'checkbox',
                                                            boxLabel: KS.L10n.rememberLabel,
                                                            id: 'frmStorePass',
                                                            tabIndex: 2,
                                                            checked: view.hasPassCookie
                                                        }, {
                                                            xtype: 'label',
                                                            cls: 'recovery-link',
                                                            text: KS.L10n.forgotPassword,
                                                            hidden: !view.data.AllowRecoveryPassword,
                                                            listeners: {
                                                                render: function (c) {
                                                                    c.getEl().on('click', function () {
                                                                        view.sendRecoveryPasswordMail();
                                                                    }, c);
                                                                },

                                                                afterrender: function(c) {
                                                                    KS.util.Overflow.updateTooltip(c.el.dom, c.text);
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            ]
                                        }, {
                                            xtype: 'fieldset',
                                            title: KS.L10n.databaseSettings,
                                            defaultType: 'textfield',
                                            collapsible: true,
                                            collapsed: !view.expandDB,
                                            hidden: !view.data.AllowCustomizing,
                                            defaults: {
                                                anchor: '95%',
                                                labelAlign: 'right',
                                                labelStyle: 'font-weight:bold;'
                                            },
                                            items: view.getCustomizingItems(),
                                            listeners: {
                                                collapse: function() {
                                                    view.saveExpandDbState(0);
                                                },
                                                expand: function() {
                                                    view.saveExpandDbState(1);
                                                }
                                            }
                                        }
                                    ]
                                }, {
                                    title: 'Активация',
                                    xtype: 'component',
                                    isActivationTab: true,
                                    loginActivation: view.loginActivation
                                }
                            ]
                        }
                    ],
                    dockedItems: [view.getStdLoginToolbar()]
                });

            view.loginWindow.on('afterrender', function () {
                var p = $.string('lastLogin').empty() ? 'frmLogin' : 'frmPassword';
                Ext.getCmp(p).focus(true);
            }, view, { delay: 100 });

            view.loginWindow.show();
            view.loginWindow.center();
        },

        getStdLoginToolbar: function() {
            var view = this,
                tbar = {
                    xtype: 'toolbar',
                    dock: 'bottom',
                    border: false,
                    padding: '5 5 5 10', // top, right, bottom, left
                    defaults: {
                        scope: view
                    },
                    items: [
                        {
                            xtype: 'label',
                            hidden: view.data.availableThemes.length < 2,
                            text: KS.L10n.themeSelect+' '
                        }, ' ', this.getThemesCombo(),
                        getLangsCombo (this.data.availableLanguages, this.data.currentLanguage.culture, view.setCulture, view), '->'
                    ]
                },
                loginBtn = {
                    text: KS.L10n.signInLabel,
                    id: 'loginBtn',
                    margin: '3 3 3 0',
                    handleMouseEvents : false,
                    height: 29,
                    width: 93,
                    handler: view.doLogin
                },
                certBtn = {
                    text: KS.L10n.certLogin,
                    scope: view,
                    handler: view.doCertLogin
                },
                esiaBtn = {
                    text: KS.L10n.esia,
                    scope: view,
                    handler: view.openEsiaAuthPage
                };
            if (view.isCrisp) {
                tbar.ui = 'footer';
            }
            if (view.data.hasCertBtn || view.data.hasEsiaBtn) {
                loginBtn.xtype = 'splitbutton';
                var items = [];
                if (view.data.hasCertBtn) {
                    items.push(certBtn);
                }
                if (view.data.hasEsiaBtn) {
                    items.push(esiaBtn);
                }
                loginBtn.menu = new Ext.menu.Menu({
                    items: items
                });
            }
            tbar.items.push(loginBtn);
            return tbar;
        },

        getThemesCombo: function () {
            return {
                xtype: 'combobox',
                hidden: this.data.availableThemes.length < 2,
                parentView: this,
                queryMode: 'local',
                editable: false,
                displayField: 'title',
                valueField: 'name',
                width: 100,
                value: this.data.currentTheme.name,
                store: {
                    proxy: {
                        type: 'memory',
                        reader: 'array'
                    },
                    fields: [
                        'name', 'title'
                    ],
                    data: this.data.availableThemes
                },
                listeners: {
                    change: this.setTheme
                }
            };
        },

        gatherData: function () {
            var view = this,
                o = {
                    user: Ext.getCmp('frmLogin').getValue(),
                    password: Ext.getCmp('frmPassword').getValue(),
                    storePass: Ext.getCmp('frmStorePass').getValue(),
                    dbType: view.dbType,
                    browserName: KS.browser.name,
                    browserVersion: KS.browser.version,
                    appUri: window.location.href,
                    theme: this.data.currentTheme.name,
                    loginCase: 0
                };
            if (this.namedSelectMode) {
                o.server = this.selectedServer;
                o.database = this.selectedDatabase;
            } else if (view.data.AllowCustomizing) {
                o.server = Ext.getCmp('frmServer').getValue();
                o.database = Ext.getCmp('frmBase').getRawValue();
            } else {
                o.server = view.data.DefaultServer;
                o.database = view.data.DefaultBase;
            }
            if (view.hasPassCookie && !view.passwordChanged) {
                o.loginCase = 1;
                o.password = view.storedPassword;
            }
            return o;
        },

        _createWaitBox: function(msg) {
            var p = this.loginWindow;
            if (KS.isValid(p) && p != null && p.rendered) {
                //this.showProgressBar();
                if (p.body.dom) p.body.mask(msg);
            }
        },

        hideWaitBox: function () {
            var p = this.loginWindow;
            if (KS.isValid(p) && p != null && p.rendered) {
                //this.hideProgressBar();
                p.body.unmask();
            }
        },

        specialKeyHandler: function (field, e) {
            if (e.getKey() === e.ENTER)
                this.parentView.doLogin();
        },

        onBeforeTabChange: function(tabs, tab) {
            if (tab.isActivationTab) {
                tab.loginActivation.apply(tabs.loginView);
                return false;
            }
        },

        loginActivation: function() {
            var view = this,
                args = view.gatherData();

            if (KS.isEmpty(args.user)) return;

            KS.setCookie('lastLogin', args.user, new Date().addDays(30));
            KS.setCookie('DbServer', args.server, new Date().addDays(30));
            KS.setCookie('DbBase', args.database, new Date().addDays(30));
            KS.setCookie('DbType', args.dbType, new Date().addDays(30));

            KS.apply(args, {
                browserName: KS.browser.name,
                browserVersion: KS.browser.version,
                appUri: window.location.href,
                theme: this.data.currentTheme.name,
                isActivation: true
            });

            var maskObj = this.loginWindow || this.win;
            maskObj.disable();

            this.serverCall({
                method: 'ExecuteLogin',
                params: [args],
                success: function () {
                    maskObj.enable();
                },
                error: function (message) {
                    maskObj.enable();
                    if (message.Type)
                        message = message.Message;
                    KS.warning(message, KS.L10n.authError, null, false);
                },
                complete: function () {
                    this.checkHavePassword();
                }
            });
        }
    });
}(LoginView.prototype));

// ============= DB CUSTOMIZE ITEMS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        getCustomizingItems: function () {
            var view = this,
                dbList = [],
                selectedDb = undefined;

            view.dbType = KS.isEmpty(view.data.AllowCustomizing)
                ? view.data.DataSourceType
                : KS.getCookie('DbType') || view.data.DataSourceType;

            var server = KS.getCookie('DbServer');
            if (!server) server = view.data.DefaultServer;

            var database = KS.getCookie('DbBase');
            if (!database) database = view.data.DefaultBase;

            Ext.each(view.data.DatabaseList, function (dbDesc) {
                dbList.push([dbDesc.database, dbDesc.name, dbDesc.server, dbDesc.type]);
                if (dbDesc.database === database && dbDesc.server === server) {
                    view.selectedServer = dbDesc.server;
                    view.selectedDatabase = dbDesc.database;
                    view.dbType = dbDesc.type;
                    selectedDb = dbDesc.name;
                }
            });

            if (view.data.AllowCustomizing && dbList.length > 1) {
                view.namedSelectMode = true;
                if (!selectedDb) {
                    view.selectedDatabase = dbList[0][0];
                    selectedDb = dbList[0][1];
                    view.selectedServer = dbList[0][2];
                    view.dbType = dbList[0][3];
                }
                return [
                    {
                        xtype: 'combo',
                        fieldLabel: KS.L10n.databaseLabel,
                        mode: 'local',
                        id: 'frmDb',
                        tabIndex: 4,
                        editable: false,
                        allowBlank: false,
                        value: selectedDb,
                        triggerAction: 'all',
                        store: new Ext.data.ArrayStore({
                            fields: ['database', 'name', 'server', 'type'],
                            data: dbList
                        }),
                        valueField: 'name',
                        displayField: 'name',
                        listeners: {
                            'select': function (combo, record) {
                                view.selectedServer = record.data.server;
                                view.selectedDatabase = record.data.database;
                                view.dbType = record.data.type;
                            }
                        }
                    }
                ];
            } else {
                var dsTypes = [],
                    items = [];
                if (view.data.DataSourceTypes) {
                    for (var dsType in view.data.DataSourceTypes) {
                        if (view.data.DataSourceTypes.hasOwnProperty(dsType)) {
                            dsTypes.push([dsType, view.data.DataSourceTypes[dsType]]);
                        }
                    }
                    if (dsTypes.length > 1) {
                        items.push({
                            tabIndex: 4,
                            xtype: 'combo',
                            fieldLabel: KS.L10n.dbmsLabel,
                            mode: 'local',
                            editable: false,
                            allowBlank: false,
                            value: view.dbType,
                            triggerAction: 'all',
                            store: new Ext.data.ArrayStore({
                                fields: ['type', 'name'],
                                data: dsTypes
                            }),
                            valueField: 'type',
                            displayField: 'name',
                            listeners: {
                                'select': function (combo, record) {
                                    view.dbType = record.data.type;
                                }
                            }
                        });
                    }
                    items.push({
                        tabIndex: 5,
                        fieldLabel: KS.L10n.serverLabel,
                        id: 'frmServer',
                        allowBlank: false,
                        selectOnFocus: true,
                        parentView: view,
                        listeners: {
                            specialkey: view.specialKeyHandler
                        },
                        value: server
                    });
                    items.push({
                        tabIndex: 6,
                        xtype: 'combo',
                        fieldLabel: KS.L10n.databaseLabel,
                        id: 'frmBase',
                        allowBlank: false,
                        selectOnFocus: true,
                        value: database,
                        typeAhead: true,
                        store: Ext.create('Ext.data.Store',
                            {
                                fields: ['db'],
                                data: []
                            }),
                        valueField: 'db',
                        displayField: 'db',
                        lastServer: '+=!@#$',
                        listeners: {
                            beforequery: function (q) {
                                if (q.forceAll) {
                                    var o = view.gatherData();
                                    if (q.combo.lastServer !== o.server) {
                                        view.serverCall({
                                            method: 'GetDatabases',
                                            disableFog: true,
                                            params: [o.user, o.password, o.server, o.dbType],
                                            success: function (data) {
                                                KS.setCookie('lastLogin', o.user, new Date().addDays(30));
                                                q.combo.getStore().loadData(data);
                                                q.combo.lastServer = o.server;
                                                q.combo.lastData = data;
                                            },
                                            error: function (message) {
                                                if (message.Type)
                                                    message = message.Message;
                                                KS.warning(message, KS.L10n.authError, null, false);
                                            },
                                        });
                                    } else
                                        q.combo.getStore().loadData(q.combo.lastData);
                                    return true;
                                }
                                return false;
                            }
                        }
                    });
                    return items;
                }
            }
        }
    });
}(LoginView.prototype));

// ============= LOGIN MANAGER =======================
(function (viewClass) {
    KS.apply(viewClass, {
        initLoginManager: function () {
            var view = this;

            // Implement own interface
            KS.apply(window.LoginManager,
                {
                    parentView: view,
                    GetConfig: view.getConfig,
                    SetConfig: view.setConfig,
                    Login: view.doLogin,
                    LoginCertBin: view.loginCertBin,
                    EsiaRedirect: view.esiaRedirect,
                    RecoveryPassword: view.sendRecoveryPasswordMail
                });
        },

        renderNewLoginWindow: function () {
            var view = this;

            if (KS.edsType === 2 && view.data.hasCertBtn) {
                KS.wbe.initCryptoModule(view);
            }

            // Override std methods
            KS.apply(LoginView.prototype,
                {
                    gatherData: function () {
                        var formLogin = window.LoginManager.FormLogin,
                            o = {
                                user: formLogin.findField('login').getValue(),
                                password: formLogin.findField('password').getValue(),
                                storePass: formLogin.findField('remember-login').getValue(),
                                server: view.data.DefaultServer,
                                database: view.data.DefaultBase,
                                dbType: view.data.DataSourceType,
                                appUri: window.location.href,
                                loginCase: 0,
                                theme: view.data.currentTheme.name
                            };

                        return o;
                    }
                });

            var param = {
                mode: KS.requestGet('pg'),
                adm: KS.requestGet('adm'),
                modal: KS.requestGet('m'),
                open: KS.requestGet('o'),
                supressProtocolCheck: true
            };

            // Own admin form
            if (param.mode === 'admin') delete param.mode;

            window.LoginManager.Launch(param);

            var formLogin = window.LoginManager.FormLogin;
            if (formLogin) {
                formLogin.findField('login').setValue(KS.getCookie('lastLogin'));

                view.loginWindow = window.LoginManager.win;
                view.loginWindow.show();
                view.loginWindow.center();
            }
        },

        loginCertBin: function (hash) {
            var cert = this.FormCert.findField("certs").getValue(),
                certLoginArgs = {
                loginMode: 'certificate',
                text: 'login',
                serial: cert,
                sign: hash
            }
            this.parentView.executeLogin(certLoginArgs);
        },

        esiaRedirect: function() {
            this.parentView.openEsiaAuthPage();
        },

        getConfig: function(key){
            return KS.getCookie(key);
        },

        setConfig: function(key, value){
            KS.setCookie(key, value, new Date().addDays(30));
        }
    });
}(LoginView.prototype));

// ============= LOGIN =======================
(function(viewClass) {
    KS.apply(viewClass, {
        doLogin: function() {
            var view = this.parentView || this,
                args = view.gatherData();

            if (KS.isEmpty(args.user)) return;

            KS.setCookie('lastLogin', args.user, new Date().addDays(30));
            KS.setCookie('DbServer', args.server, new Date().addDays(30));
            KS.setCookie('DbBase', args.database, new Date().addDays(30));
            KS.setCookie('DbType', args.dbType, new Date().addDays(30));

            view.executeLogin(args);
        },

        executeLogin: function (loginArgs) {
            KS.apply(loginArgs, {
                browserName: KS.browser.name,
                browserVersion: KS.browser.version,
                appUri: window.location.href,
                theme: this.data.currentTheme.name
            });

            var maskObj = this.loginWindow || this.win;
            maskObj.disable();

            this.serverCall({
                method: 'ExecuteLogin',
                params: [loginArgs],
                success: function (authenticated) {
                    if (!authenticated) maskObj.enable();
                },
                error: function (message) {
                    maskObj.enable();
                    if (message.Type)
                        message = message.Message;
                    KS.warning(message, KS.L10n.authError, null, false);
                },
                complete: function () {
                    this.checkHavePassword();
                }
            });
        }
    });
}(LoginView.prototype));

// ============= CERT =======================
(function (viewClass) {
    KS.apply(viewClass, {
        doCertLogin: function () {
            var signSettings = this.data.signSettings;
            KS.apply(signSettings, {
                noNeedFilter: true,
                noNeedParams: true,
                noNeedReestr: true,
                onLogin: true,
                NastrKeyId: ''
            });
            KS.XCrypt.viewContext = this;
            KS.XCrypt.initialize(signSettings, this.getCertificates, this, 'login');
        },

        getCertificates: function () {
            KS.XCrypt.selectCertificate(this.certificateSelected, this);
        },

        certificateSelected: function (data) {
            var sessionId = KS.XCrypt.signSettings.sessionId;
            this.certLoginArgs = {
                loginMode: 'certificate',
                text: sessionId,
                serial: data.serial
            }
            KS.XCrypt.sign(sessionId, data.serial, 0, 0, this.afterSigned, this);
        },

        afterSigned: function (sign) {
            KS.apply(this.certLoginArgs, {
                sign: sign
            });
            this.executeLogin(this.certLoginArgs);
        }
    });
}(LoginView.prototype));

// ============= ESIA =======================
(function (viewClass) {
    KS.apply(viewClass, {
        openEsiaAuthPage: function () {
            this.serverCall({
                method: 'GetEsiaAuthorizationUrl',
                params: [this.gatherData()],
                success: function (url) {
                    if (url) {
                        var maskObj = this.loginWindow || this.win;
                        maskObj.disable();
                        document.location = url;
                    } else {
                        KS.error('Не определена страница авторизации');
                    }
                }
            });
        }
    });
}(LoginView.prototype));

// ============= TOKEN =======================
(function (viewClass) {
    KS.apply(viewClass, {
        doLoginByToken: function () {
            var view = this;
            
            view.containerPanel.removeAll();
            if (view.data.LoginBackground) {
                view.containerPanel.update(view.data.LoginBackground);
            }

            view.loginWindow = Ext.create('Ext.window.Window',
                {
                    title: KS.L10n.authCaption,
                    width: 422,
                    autoHeight: true,
                    closable: false,
                    resizable: false,
                    border: false,
                    buttonAlign: 'right',
                    items: [
                        {
                            xtype: 'ksimage',
                            frame: true,
                            width: 417,
                            height: 75,
                            border: false,
                            margin: '1 1 5 1', // top, right, bottom, left
                            url: view.data.customLogoImage || 'PlatformHandler.axd?logo=1'
                        }, {
                            frame: view.isClassic,
                            border: false,
                            autoheight: true,
                            style: {
                                'border-style': 'none !important'
                            },
                            bodyStyle: 'padding:10px 10px 0;'
                        }
                    ]
                });
            
            view.loginWindow.show();
            view.loginWindow.center();

            view.executeLogin({
                loginMode: "token"
            });
        }
    });
}(LoginView.prototype));

// ============= PASS RECOVERY =======================
(function (viewClass) {
    KS.apply(viewClass, {
        sendRecoveryPasswordMail: function () {
            var view = this.parentView || this,
                loginArgs = view.gatherData();
            if (KS.isEmpty(loginArgs.user)) return;

            view.serverCall({
                method: 'SendRecoveryPasswordMail',
                params: [loginArgs],
                waitMessage: 'Отправка ...'
            });
        },

        renderPasswordRecovery: function () {
            var view = this;

            view.formWindow = new Ext.Window({
                title: 'Восстановление пароля',
                width: 350,
                padding: 5,
                labelWidth: 120,
                autoHeight: true,
                plain: true,
                closable: false,
                resizable: false,
                layout: 'form',
                defaultType: 'textfield',
                defaults: {
                    value: '',
                    anchor: '100%',
                    inputType: 'password',
                    selectOnFocus: true,
                    allowBlank: view.data.minPassLength === 0,
                    blankText: 'Пароль не может быть пустым'
                },
                items: [
                    {
                        fieldLabel: 'Новый пароль',
                        itemId: 'pass1',
                        validator: function (p1) {
                            var p2 = view.pass2.getValue(),
                                result = view.validate(p1, p2);
                            if (result === true) view.pass1.clearInvalid();
                            return result;
                        }
                    }, {
                        fieldLabel: 'Повторите пароль',
                        itemId: 'pass2',
                        validator: function (p2) {
                            var p1 = view.pass1.getValue(),
                                result = view.validate(p1, p2);
                            if (result === true) view.pass2.clearInvalid();
                            return result;
                        }
                    }
                ],
                buttons: [view.changeButton = new Ext.Button({
                    text: 'Сменить пароль',
                    disabled: true,
                    scope: view,
                    handler: view.tryChangePassword
                })]
            });

            view.formWindow.show();
            view.formWindow.center();

            view.pass1 = view.formWindow.getComponent('pass1');
            view.pass2 = view.formWindow.getComponent('pass2');

            view.pass1.validate();
            view.pass2.validate();
        },

        validate: function (p1, p2) {
            var view = this,
                result = true;
            if (p2 != p1) {
                result = 'Введенные значения не совпадают';
            } else if (view.data.minPassLength > 0 && Ext.isEmpty(p1)) {
                result = 'Пароль не может быть пустым';
            } else if (p1.length < view.data.minPassLength) {
                result = 'Длина пароля должна быть не менее ' + view.data.minPassLength;
            }
            if (result === true) {
                view.changeButton.enable();
                view.pass1.clearInvalid();
                view.pass2.clearInvalid();
            } else {
                view.changeButton.disable();
            }
            return result;
        },

        tryChangePassword: function () {
            var view = this;
            if (!view.pass1.validate() || !view.pass2.validate()) return;
            var newPass = view.pass1.getValue();
            view.serverCall({
                method: 'SavePasswordRecovery',
                params: [view.data.uid, view.data.aid, newPass],
                success: function (ok) {
                    if (ok) {
                        var location = this.data.loginUri;
                        KS.alert('Пароль успешно изменен', 'Сообщение', function () {
                            document.location = location;
                        });
                    } else {
                        this.changeButton.enable();
                    }
                }
            });
        }
    });
}(LoginView.prototype));

// ============= UTILS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        checkBrowser: function() {
            if (Ext.isIE && !Ext.isIE11) {
                Ext.create('Ext.window.Window',
                    {
                        header: false,
                        closable: false,
                        autoShow: true,
                        html: '<p style=\'font-size: 16px\'>Этот браузер устарел или не поддерживается!<br/>Работа невозможна!<br><br><a href=\'http://keysystems.ru/forum/index.php?showtopic=18727\'>Подробнее</a></p>'
                    });
                return false;
            }
            return true;
        },

        startReminder: function () {
            var view = this;

            $(document).keydown(function () { view.resetReminder(); });

            Ext.on('resize',
                function () {
                    view.loginWindow.center();
                    if (view.waitPanelUpdate && view.waitPanelUpdate.rendered) {
                        view.waitPanelUpdate.alignTo(Ext.getBody(), 'br-br', [10, -10]);
                    }
                });
        },

        resetReminder: function () {
            var view = this;
            if (view.remindTimer) clearTimeout(view.remindTimer);
            if (view.waitPanelUpdate && view.waitPanelUpdate.rendered) {
                view.waitPanelUpdate.close();
                delete view.waitPanelUpdate;
            }
            view.remindTimer = setTimeout(function () { view.showRemind(); }, 30 * 60 * 1000);
        },

        showRemind: function () {
            var view = this;
            view.waitPanelUpdate = Ext.create('Ext.window.Window',
                {
                    width: 250,
                    height: 250,
                    header: false,
                    plain: true,
                    shim: false,
                    shadow: false,
                    border: false,
                    frame: false,
                    style: {
                        border: 0,
                        backgroundColor: 'transparent'
                    },
                    html: ('<img src="' + view.data.waitImage + '"/>')
                });
            view.waitPanelUpdate.show();
            view.waitPanelUpdate.alignTo(Ext.getBody(), 'br-br', [10, -10]);
            view.waitPanelUpdate.el.fadeIn({ endOpacity: 1, duration: 2 });
        },

        setTheme: function (cb, theme) {
            KS.setCookie('theme', theme, new Date().addDays(30));
            window.location.reload();
        },

        setCulture: function (cb, culture) {
            KS.setCookie('culture', culture, new Date().addDays(30));
            window.location.reload();
        },

        saveExpandDbState: function (expandDb) {
            KS.setCookie('ExpandDb', expandDb, new Date().addDays(30));
            this.customDB = (expandDb === 1);
            this.loginWindow.updateLayout();
        },

        checkHavePassword: function () {
            var sp = KS.getCookie('sp');
            this.hasPassCookie = sp != null && !$.string(sp).empty();
            this.storedPassword = sp;
        }
    });
}(LoginView.prototype));
//#endregion LoginView