﻿KitchenSinkView = function (viewId) {
    KitchenSinkView.superclass.constructor.call(this, viewId);
};

////////////////////////////////////////////////////////////////////////////////
// RENDER
(function (viewClass) {
    KS.extend(viewClass, KS.Ext.ClientView, {
        navTreeClick: function(v, node) {
            KS.msg(node.data.id);
        },

        navTreeNodeSelect: function (sm, selected) {
            var view = this;
            Ext.each(selected, function (node) {
                var rendererResult = view.resolveRenderer(node).apply(view);
                if (!rendererResult)
                    return;
                if (Ext.isObject(rendererResult.content)) {
                    try {
                        view.renderNestedItem(rendererResult.content);
                    } catch (e) {
                        view.renderHtml(e.message || 'e.message is empty');
                    }
                }
                if (Ext.isFunction(rendererResult.afterRender)) {
                    rendererResult.afterRender.apply(view);
                }
            });
        },

        selectStartNode: function () {
            var root = this.navTree.getRootNode(),
                ntsm = this.navTree.getSelectionModel(),
                snode = null;
            Ext.each(root.childNodes, function (node) {
                if (!snode && node.data.selected)
                    snode = node;
            });
            if (!snode && !Ext.isEmpty(root.childNodes))
                snode = root.childNodes[0];
            if (snode)
                ntsm.select(snode);
        },

        setNaviTreeVisibility: function () {
            var hidden = this.data.identifier && this.data.identifier.HideNavigationTree,
                root = this.navTree.getRootNode();
            if (root.childNodes.length === 1 && root.childNodes[0].childNodes.length === 1)
                hidden = true;
            if (hidden)
                this.navTree.hide();
        },

        resolveRenderer: function (node) {
            var rname = node.data.tag.renderer;
            if (!Ext.isEmpty(rname) && Ext.isFunction(this[rname]))
                return this[rname];
            return this.dummyRenderer;
        },

        dummyRenderer: function () {
            return {
                content: {
                    html: 'Renderer not found or invalid'
                }
            };
        },

        renderHtml: function (html) {
            this.renderNestedItem({
                html: html
            });
        },

        renderNestedItem: function (p) {
            this.itemsContainer.removeAll();
            this.itemsContainer.add(p);
        }
    });
}(KitchenSinkView));

////////////////////////////////////////////////////////////////////////////////
// MAIN TOOLBAR 
(function (viewClass) {
    KS.apply(viewClass, {
        buildGlobalToolbar: function () {
            this.mainTbar = Ext.create('Ext.toolbar.Toolbar', {
                defaults: {
                    scope: this
                },
                items: new Array({
                    text: 'Close (client)',
                    iconCls: 'ks-icon-close',
                    handler: this.close
                }, {
                    text: 'Close (server)',
                    iconCls: 'ks-icon-close',
                    handler: this.serverClose
                }, '-', {
                    text: 'Break',
                    handler: this.breakPoint
                }, {
                    text: 'Throw',
                    handler: this.throwException
                }, '-', {
                    text: 'Modify identifier',
                    handler: this.modifyIdentifier
                }, '-', {
                    text: 'Temp File',
                    handler: this.openTempFile
                }, '-', {
                    text: 'Fog test',
                    handler: this.fogTest
                }, '-', {
                    text: 'Cancel background',
                    handler: this.cancelBackGroundTest
                }, '-', {
                    text: 'Msg test',
                    handler: this.msgTest
                }, '-', {
                    text: 'Please wait',
                    handler: this.pleaseWaitTest
                })
            });
            return this.mainTbar;
        },

        serverClose: function () {
            this.serverCall({ method: 'DoCloseView' });
        },

        fogTest: function () {
            this.fogTestStage1();
        },

        fogTestStage1: function () {
            var view = this;
            view.serverCall({
                method: 'FogTestStage1',
                waitMessage: 'Fog Test Stage 1',
                success: view.fogTestStage2
            });
        },

        fogTestStage2: function () {
            var view = this;
            view.serverCall({
                method: 'FogTestStage2',
                waitMessage: 'Fog Test Stage 2 (cancellable)',
                cancellable: true,
                success: view.fogTestStage3
            });
        },

        fogTestStage3: function () {
            var view = this;
            view.serverCall({
                method: 'FogTestStage3',
                waitMessage: 'Fog Test Stage 3',
                success: function () {
                    KS.msg('Test finished');
                }
            });
        },

        modifyIdentifier: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'ChangeIdentifier',
                waitMessage: 'Changing Identifier ...',
                success: function (newValue) {
                    KS.msg('new ChangeableValue = ' + newValue);
                }
            });
        },

        openTempFile: function () {
            this.serverCall({
                method: 'OpenTempFile',
                success: function (url) {
                    if (url) {
                        window.open(url);
                    }
                }
            });
        },

        cancelBackGroundTest: function () {
            var view = this;
            KS.msg('Command 1 started', 'BackGroundTest', 1000);
            view.serverCall({
                method: 'ExecuteLongCommand',
                params: ['00:00:05'],
                waitMessage: 'Command 1',
                cancellable: true,
                success: function (completeState) {
                    KS.msg('Command 1 finished with CompleteState.' + completeState, 'BackGroundTest', 1000);
                },
                error: view.stopTimer,
                offline: view.offlineHandler
            });
        },

        msgTest: function () {
            KS.msg('Измеряй микрометром.');
            KS.msg('Отмечай мелом.');
            KS.msg('Отрубай топором.');
        },

        breakPoint: function () {
            debugger;
        },

        throwException: function () {
            throw ("KS Exception!");
        },

        pleaseWaitTest: function () {
            var view = this;
            view.pleaseWait('Тестовое сообщение 1', function () {
                alert('got it 1');
            });
            view.pleaseWait('Тестовое сообщение 2');
            KS.pleaseWait('Тестовое сообщение 3', function () {
                alert('got it 3');
            });
            KS.pleaseWait('Тестовое сообщение 4', function () {
                alert('got it 4');
            });
            setTimeout(function () {
                KS.stopWaiting();
                setTimeout(function () {
                    KS.stopWaiting();
                    setTimeout(function () {
                        view.stopWaiting();
                        setTimeout(function () { view.stopWaiting(); }, 5000);
                    }, 5000);
                }, 5000);
            }, 5000);
        }
    });
}(KitchenSinkView.prototype));

////////////////////////////////////////////////////////////////////////////////
// AJAX PROFILER
(function (viewClass) {
    KS.apply(viewClass, {
        buildDynamicPanel: function () {
            this.dynamicPanel = new Ext.FormPanel({
                layout: {
                    type: 'fit',
                    padding: 2
                },
                frame: true,
                items: new Array({
                    xtype: 'fieldset',
                    title: 'Timeout test',
                    labelWidth: 150,
                    items: new Array({
                        xtype: 'button',
                        text: 'start',
                        scope: view,
                        handler: view.timeoutTest
                    }, view.ajaxTimeout = new Ext.form.NumberField({
                        fieldLabel: 'Ajax timeout (msec)',
                        value: 6000000,
                        width: 200
                    }), view.delay = new Ext.form.TextField({
                        fieldLabel: 'Delay',
                        value: '00:00:30',
                        width: 200
                    }), view.slow = new Ext.form.Checkbox({
                        fieldLabel: 'Potentially slow',
                        checked: true
                    }), view.timeoutLabel = new Ext.form.Label({
                        fieldLabel: 'Time (est.)',
                        text: '-'
                    }))
                })
            });
            return {
                title: 'Dynamic',
                item: this.dynamicPanel
            }
        },

        timeoutTest: function () {
            var view = this,
                isSlow = view.slow.getValue(),
                method = isSlow ? 'ExecutePotentiallySlowLongCommand' : 'ExecuteLongCommand',
                ajaxCfg = {
                    method: method,
                    params: [view.delay.getValue()],
                    waitMessage: 'Timeout Test',
                    timeout: view.ajaxTimeout.getValue(),
                    cancellable: true,
                    abort: view.abortHandler,
                    error: view.errorHandler,
                    offline: view.offlineHandler,
                    complete: view.completeHandler,
                    success: view.timeoutTestSuccess,
                    check: view.backgroundCheck
                };
            if (isSlow) {
                var backgroundCfg = {
                    parentView: view,
                    ajaxCfg: ajaxCfg
                };
                ajaxCfg.background = function (air) {
                    KS.Ajax.defaultBackgroundHandler(air, backgroundCfg);
                };
            }
            view.serverCall(ajaxCfg);
            view.startTimer();
            KS.log('Timeout test started');
        },

        timeoutTestSuccess: function (data) {
            KS.log('Timeout test finished succesfully, result=' + data);
            this.getLongCommandData();
            this.stopTimer();
        },

        backgroundCheck: function (taskId, task, at) {
            KS.log('ajaxBackgroundHandler check (' + taskId + '): state=' + at.State + ', progress=' + at.Progress);
        },

        getLongCommandData: function () {
            this.serverCall({
                method: 'GetLongCommandData',
                waitMessage: 'Get data ...',
                success: this.displayData
            });
        },

        displayData: function (data) {
            KS.alert(data || 'No data');
        },

        startTimer: function () {
            var view = this;
            view.startTime = new Date();
            view.timerId = setInterval(function () {
                view.timeoutLabel.setText((new Date().getTime() - view.startTime.getTime()) / 1000 + '');
            }, 100);
        },

        stopTimer: function () {
            if (this.timerId) {
                clearInterval(this.timerId);
            }
        },

        offlineHandler: function () {
            KS.log('Offline callback invoked');
            this.stopTimer();
        },

        completeHandler: function () {
            KS.log('Complete callback invoked');
        },

        abortHandler: function () {
            KS.msg('Request cancelled !');
        },

        errorHandler: function () {
            KS.error(msg);
            this.stopTimer();
        },

        onBeforeClose: function () {
            this.stopTimer();
            return KitchenSinkView.superclass.onBeforeClose.call(this);
        }
    });
}(KitchenSinkView.prototype));

////////////////////////////////////////////////////////////////////////////////
// RAW GRID
(function (viewClass) {
    KS.apply(viewClass, {
        generateData: function (count) {
            var rows = [];
            for (var rowIdx = 0; rowIdx < count; rowIdx++) {
                rows.push({ "idx": rowIdx + 1, "text": "Record" + (rowIdx + 1) });
            }
            return rows;
        },

        renderRawGrid: function () {
            Ext.define('ForumThread', {
                extend: 'Ext.data.Model',
                fields: ['idx', 'text'],
                idProperty: 'threadid'
            });

            var store = Ext.create('Ext.data.Store', {
                //autoLoad: true,
                model: 'ForumThread',
                remoteSort: true,
                pageSize: 1,
                proxy: {
                    type: 'memory',
                    enablePaging: true,
                    reader: {
                        root: 'topics',
                        totalProperty: 'totalCount'
                    },
                    //data: data,
                    simpleSortMode: true
                }
                //,data: data,
            });

            var view = this;

            var bbar = Ext.create('KS.Ext.Grid.PagingToolbar', {
                store: store,
                displayInfo: true,
                listeners: {
                    beforechange: function (ptb, page) {
                        setTimeout(function () {
                            KS.gs.getProxy().data = view.generateData(4);
                            KS.gs.loadPage(page);
                        }, 1000);
                        return false;
                    }
                }
            });

            store.pagingTool = bbar;

            var grid = Ext.create('Ext.grid.Panel', {
                store: store,
                loadMask: true,
                columns: [
                    {
                        text: "N",
                        dataIndex: 'idx',
                        width: 100,
                        sortable: true
                    }, {
                        text: "Text",
                        dataIndex: 'text',
                        flex: 1,
                        sortable: true
                    }
                ],
                bbar: bbar
            });

            KS.gs = store;

            return {
                content: grid,
                afterRender: this.afterRenderRawGrid
            }
        },

        afterRenderRawGrid: function () {
            KS.gs.getProxy().data = this.generateData(3);
            KS.gs.loadPage(2);
        }
    });
    /*
    getProxy: function() {
        var me = this;
        return {
            type: 'memory',
            read: function(operation, callback, scope) {
                var me1 = this;
                me.baseRefresh(function(data) {
                    if (!data) return;
                    var resultSet = operation.resultSet = me1.getReader().read(data.data),
                        records = resultSet.records,
                        sorters = operation.sorters,
                        groupers = operation.groupers,
                        filters = operation.filters;
    
                    resultSet.total = data.total;
                    scope.totalCount = data.total;
    
                    operation.setCompleted();
    
                    if (resultSet.success) {
                        if (filters && filters.length) {
                            records = resultSet.records = Ext.Array.filter(records, Ext.util.Filter.createFilterFn(filters));
                        }
    
                        if (groupers && groupers.length) {
                            sorters = sorters ? sorters.concat(groupers) : sorters;
                        }
    
                        if (sorters && sorters.length) {
                            resultSet.records = Ext.Array.sort(records, Ext.util.Sortable.createComparator(sorters));
                        }
                    }
    
                    if (resultSet.success) {
                        operation.setSuccessful();
                    } else {
                        // ReSharper disable Html.EventNotResolved
                        me1.fireEvent('exception', me1, null, operation);
                        // ReSharper restore Html.EventNotResolved
                    }
                    Ext.callback(callback, scope || me1, [operation]);
                    me.setChecks(me.checkList, records);
                }, {
                    whereArgs: me.whereArgs,
                    GateCode: me.GateCode,
                    controlName: me.controlName,
                    reload: me.pagingTool.reload,
                    page: operation.page ? operation.page : me.startPage,
                    pageSize: operation.limit ? operation.limit : me.pageSize,
                    order: operation.sorters.length ? JSON.stringify({ name: operation.sorters[0].property, type: operation.sorters[0].direction }) : ''
                });
                me.pagingTool.reload = false;
            }
        };
    },
    */
}(KitchenSinkView.prototype));

////////////////////////////////////////////////////////////////////////////////
// SIMPLE GRID
(function (viewClass) {
    KS.apply(viewClass, {
        renderSimpleGrid: function () {
            if (!this.data.mainGridSettings)
                return null;
            this.mainGrid = Ext.create('KS.Ext.Grid', this, this.data.mainGridSettings, {
                tbarItems: [
                    {
                        iconCls: 'ks-icon-grid',
                        handler: this.btnClick
                    }
                ]
            });
            return {
                content: this.mainGrid
            }
        },

        btnClick: function () {
            KS.msg('Grid toolbar btn clicked!');
        }
    });
}(KitchenSinkView.prototype));

////////////////////////////////////////////////////////////////////////////////
// OBJECT VIEWER
(function (viewClass) {
    KS.apply(viewClass, {
        renderObjectViewer: function () {
            this.storageGrid = Ext.create('KS.Ext.Grid', this, this.data.storageGridSettings, {
                flex: 1,
                tbarItems: [
                    {
                        iconCls: 'ks-icon-refresh',
                        scope: this,
                        handler: this.refreshStorageGrid
                    }
                ]
            });
            this.storageGrid.getSelectionModel().on('selectionchange', this.analyseStorageObject, this);

            this.objTree = Ext.create('KS.Ext.Tree', this, this.data.objectTree, {
                flex: 3,
                border: true,
                split: true
            });
            this.objTree.on('selectionchange', this.analyseObjectProperty, this);

            return {
                content: {
                    layout: {
                        align: 'stretch',
                        type: 'hbox'
                    },
                    defaults: {
                        border: false,
                        layout: {
                            align: 'stretch',
                            type: 'vbox'
                        }
                    },
                    items: [
                        {
                            flex: 1,
                            split: true,
                            items: [this.storageGrid, this.objTree]
                        }, {
                            flex: 2,
                            split: true,
                            items: [
                                this.objDescription = Ext.create('Ext.panel.Panel', {
                                    title: 'Описание объекта',
                                    flex: 1,
                                    autoScroll: true,
                                    split: true
                                }),
                                this.propDescription = Ext.create('Ext.panel.Panel', {
                                    title: 'Описание свойства',
                                    flex: 1,
                                    split: true
                                }),
                                this.propData = Ext.create('Ext.panel.Panel', {
                                    title: 'Предварительный просмотр',
                                    flex: 2,
                                    split: true,
                                    layout: 'fit'
                                })
                            ]
                        }
                    ]
                }
            }
        },

        refreshStorageGrid: function () {
            this.serverCall({
                method: 'GetStorageDataPage',
                waitMessage: 'Обновление ...',
                success: function (json) {
                    this.storageGrid.getStore().loadDataPage(1, json);
                }
            });
        },

        analyseStorageObject: function () {
            var keys = [],
                recs = this.storageGrid.getSelectionModel().getSelection();
            Ext.each(recs, function (rec) {
                keys.push(rec.get('name'));
            });
            if (Ext.isEmpty(keys)) return;
            this.serverCall({
                method: 'AnalyseStorageObject',
                params: [keys[0]],
                waitMessage: 'Чтение ...',
                success: function (desc) {
                    this.objDescription.update(desc || 'N/A');
                    this.objTree.fullReload();
                }
            });
        },

        analyseObjectProperty: function (sm, selected) {
            if (Ext.isEmpty(selected)) return;
            this.serverCall({
                method: 'AnalyseObjectProperty',
                params: [selected[0].id],
                waitMessage: 'Чтение ...',
                success: function (pair) {
                    this.propDescription.update(pair[0] || 'N/A');
                    this.propData.update(pair[1] || 'N/A');
                }
            });
        }
    });
}(KitchenSinkView.prototype));