﻿function lavandaCrypto(lavandaCall) {
    var _call = function (p) {
        p.command = "crypto/" + p.command + "/";

        lavandaCall(p);
    };

    return {

        Clear: function (p) {
            _call({
                command: "clear/v1",
                //data: [{}],
                timeout: (typeof p.timeout === "number") ? p.timeout : 1000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        Sign: function (p) {
            var fd = new FormData();
            fd.append("data", p.blob);
            fd.append("cert", p.name);
            if (p.params == 1) fd.append("b64", "true");

            _call({
                command: "sign/v1",
                //contentType: "multipart/form-data",
                data: fd,
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        // out of date
        SignXml: function (p) {
            var fd = new FormData();
            fd.append("xml", p.xml);
            fd.append("signedInfo", p.signedInfo);
            fd.append("cert", p.name);

            _call({
                command: "signxml/v1",
                data: fd,
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        SignPromise: function (p) {
            return new Promise(function (resolve, reject) {
                var fd = new FormData();
                fd.append("data", p.data);
                fd.append("cert", p.certserial);
                fd.append("b64", true);
                fd.append("signParams", JSON.stringify({
                    Attached: p.signParams && p.signParams.Attached ? p.signParams.Attached : false,
                    CertInclude: p.signParams && p.signParams.CertInclude ? p.signParams.CertInclude : 1
                }));

                _call({
                    command: "sign/v1",
                    data: fd,
                    timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                    onSuccess: resolve,
                    onError: reject
                });
            });
        },

        SignHashPromise: function (p) {
            return new Promise(function (resolve, reject) {
                var fd = new FormData();
                fd.append("hash", p.data);
                fd.append("cert", p.certserial);
                fd.append("b64", true);
                fd.append("signParams", JSON.stringify({
                    Attached: p.signParams && p.signParams.Attached ? p.signParams.Attached : false,
                    CertInclude: p.signParams && p.signParams.CertInclude ? p.signParams.CertInclude : 1
                }));

                _call({
                    command: "sign/v1",
                    data: fd,
                    timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                    onSuccess: resolve,
                    onError: reject
                });
            });
        },

        SignBinaryPromise: function (p) {
            return new Promise(function (resolve, reject) {
                var fd = new FormData();
                fd.append("data", p.blob);
                fd.append("cert", p.certserial);
                fd.append("signParams", JSON.stringify({
                    Attached: p.signParams && p.signParams.Attached ? p.signParams.Attached : false,
                    CertInclude: p.signParams && p.signParams.CertInclude ? p.signParams.CertInclude : 1
                }));

                _call({
                    command: "sign/v1",
                    data: fd,
                    timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                    onSuccess: resolve,
                    onError: reject
                });
            });
        },



        SignSimplePromise: function (p) {
            return new Promise(function (resolve, reject) {
                var fd = new FormData();
                fd.append("data", p.data);
                fd.append("cert", p.certserial);
                fd.append("b64", true);

                _call({
                    command: "signsimple/v1",
                    data: fd,
                    timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                    onSuccess: resolve,
                    onError: reject
                });
            });
        },

        HashPromise: function (p) {
            return new Promise(function (resolve, reject) {
                var fd = new FormData();
                fd.append("data", p.data);
                fd.append("algoid", p.algoid);
                fd.append("b64", true);

                _call({
                    command: "hash/v1",
                    data: fd,
                    timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                    onSuccess: function (value) {
                        resolve(value);
                    },
                    onError: function (msg) {
                        reject(msg);
                    }
                });
            });
        },

        HashBinaryPromise: function (p) {
            return new Promise(function (resolve, reject) {
                var fd = new FormData();
                fd.append("data", p.blob);
                fd.append("algoid", p.algoid);

                _call({
                    command: "hash/v1",
                    data: fd,
                    timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                    onSuccess: function (value) {
                        resolve(value);
                    },
                    onError: function (msg) {
                        reject(msg);
                    }
                });
            });
        },

        SelectCertificates: function (p) {
            var keyId = p.keyId,
                isSerial = keyId.substring(0, 1) === "#";

            var fd = new FormData();

            fd.append('subject', isSerial ? '' : keyId);
            fd.append('serial', isSerial ? keyId : '');
            fd.append('params', p.params ? p.params : '');

            _call({
                command: "selectcertificate/v1",
                data: fd,
                timeout: (typeof p.timeout === "number") ? p.timeout : 3000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },
            
        //SignArray: function (p) {
        //    var data = p.data.map(function (p2) {
        //        return {
        //            id: (typeof p2.id === "number") ? String(p2.id) : null,
        //            text: (typeof p2.text === "string") ? p2.text : null,
        //            cert: (typeof p.name === "string") ? p.name : null,
        //            params: (typeof p.params === "number") ? String(p.params) : null,
        //            strparams: (typeof p.strParams === "string") ? p.strParams : null
        //        };
        //    });

        //    _call({
        //        command: "sign",
        //        data: data,
        //        timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
        //        onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
        //            p.onProgress(response, progressevent);
        //        } : null,
        //        onSuccess: (typeof p.onSuccess === "function") ? function (value) {
        //            alert("call k необходимо сделать метод _call для множественного ответа");
        //            // необходимо сделать метод _call для множественного ответа
        //            p.onSuccess(value);
        //        } : null,
        //        onError: (typeof p.onError === "function") ? function (msg) {
        //            p.onError(msg);
        //        } : null
        //    });
        //}
        CertInfo: function (p) {
            _call({
                command: "cert/info/v1",
                contentType: "application/json; charset=utf-8",
                data: JSON.stringify({"Serial": p.certId}),
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        RunExcelRep2: function (p) {
            var fd = new FormData();
            fd.append('rooturl', p.rootUrl);
            fd.append('archivepath', p.archivePath);
            fd.append('username', p.userName);

            _call({
                command: "runexcelrep2/v1",
                data: fd,
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        }
    };
}