// ============= PeriodComponent EXT3 =======================
(function() {
    KS.apply(KS.Svod, {
        PeriodComponent: KS.extend(Ext.form.CompositeField, {
            constructor: function(config) {
                this.initComponents(config);
                Ext.form.CompositeField.superclass.constructor.call(this, config);
            },

            initComponents: function(config) {
                var me = this,
                    ctrl = config.ctrl,
                    typeControl = {
                        xtype: 'combo',
                        composite: me,
                        store: new Ext.data.ArrayStore({ fields: ['value', 'name'] }),
                        availTypes: ctrl.availableTypes,
                        valueField: 'value',
                        displayField: 'name',
                        itemId: 'type',
                        typeAhead: true,
                        editable: false,
                        mode: 'local',
                        width: 90,
                        hidden: ctrl.dateOnly || ctrl.typeHidden,
                        forceSelection: true,
                        triggerAction: 'all',
                        selectOnFocus: true,
                        iconCls: 'no-icon',
                        listeners: {
                            'select': function(combo, record) {
                                me.setType(record.data.value);
                                if (ctrl.dateOnly !== true && ctrl.typeHidden !== true)
                                    me.fireEvent('change', me, 'type');
                            }
                        }
                    },
                    yearControl = {
                        xtype: 'spinnerfield',
                        composite: me,
                        minValue: 1970,
                        maxValue: 2099,
                        allowDecimals: true,
                        decimalPrecision: 1,
                        incrementValue: 1,
                        alternateIncrementValue: 1,
                        accelerate: true,
                        itemId: 'year',
                        hidden: ctrl.dateOnly,
                        width: 60,
                        value: 0,
                        invalidText: '',
                        listeners: {
                            'beforechange': function(sfield, newValue /*, oldValue*/) {
                                return newValue >= sfield.minValue && newValue <= sfield.maxValue;
                            },
                            'change': function() {
                                if (ctrl.dateOnly !== true)
                                    this.validate();
                            }
                        },
                        validator: function(value) {
                            var isValid = (value >= this.minValue && value <= this.maxValue);
                            if (isValid && ctrl.dateOnly !== true)
                                this.composite.fireEvent('change', this.composite, 'year');
                            return isValid;
                        }
                    },
                    numberControl = {
                        xtype: 'combo',
                        composite: me,
                        store: new Ext.data.ArrayStore({ fields: ['value', 'name'] }),
                        valueField: 'value',
                        displayField: 'name',
                        typeAhead: true,
                        itemId: 'number',
                        mode: 'local',
                        width: 100,
                        editable: false,
                        forceSelection: true,
                        triggerAction: 'all',
                        selectOnFocus: true,
                        iconCls: 'no-icon',
                        listeners: {
                            'select': function() {
                                this.composite.fireEvent('change', this.composite, 'number');
                            }
                        }
                    },
                    dateControl = {
                        xtype: 'datefield',
                        composite: me,
                        itemId: 'date',
                        format: 'd.m.Y',
                        width: 100,
                        emptyText: 'Дата',
                        listeners: {
                            'change': function(df, newValue) {
                                if (newValue) {
                                    var year = newValue.getFullYear();
                                    this.composite.setYear(year);
                                }
                                this.composite.fireEvent('change', this.composite, 'date');
                            }
                        }
                    };

                me.items = [];
                switch (ctrl.mode) {
                    case 0:
                        me.items.push(typeControl);
                        me.items.push(yearControl);
                        break;
                    case 1:
                        me.items.push(yearControl);
                        me.items.push(typeControl);
                        break;
                }
                me.items.push(numberControl);
                me.items.push(dateControl);
            },

            getWeeksList: function (year) {
                var me = this,
                    view = this.ctrl.parentView;
                if (KS.isEmpty(me.cachedWeeks)) me.cachedWeeks = {};
                if (KS.isEmpty(year)) year = me.getYear();
                if (KS.isEmpty(me.cachedWeeks[year])) {
                    view.serverCall({
                        method: 'GetWeeksList',
                        params: [year],
                        disableFog: true,
                        success: function (weekPeriods) {
                            var list = [];
                            $.each(weekPeriods, function (i, key) {
                                list[i] = [i + 1, key];
                            });
                            me.cachedWeeks[year] = list;
                            var store = me.numberField.getStore();
                            store.removeAll();
                            store.loadData(list);
                            me.numberField.setValue(me.getNumber());
                        }
                    });
                    return [];
                } else {
                    return me.cachedWeeks[year];
                }
            },

            listeners: {
                'afterrender': function() {
                    var me = this,
                        ctrl = me.ctrl;

                    switch (ctrl.mode) {
                        case 0:
                            me.typeField = me.items.items[0];
                            me.yearField = me.items.items[1];
                            break;
                        case 1:
                            me.typeField = me.items.items[1];
                            me.yearField = me.items.items[0];
                            break;
                    }

                    me.loadTypes();

                    me.numberField = me.items.items[2];
                    me.dateField = me.items.items[3];

                    if (me.deferredYear) {
                        me.setYear(me.deferredYear);
                        me.deferredYear = null;
                    }
                    if (me.deferredType) {
                        me.setType(me.deferredType);
                        me.deferredType = null;
                    }
                    if (me.deferredNumber) {
                        me.setNumber(me.deferredNumber);
                        me.deferredNumber = null;
                    }
                    if (me.deferredAllPeriods) {
                        me.setAllPeriods(me.deferredAllPeriods);
                        me.deferredAllPeriods = null;
                    }

                    if (!KS.isEmpty(ctrl.listeners)) {
                        var view = ctrl.parentView;
                        for (var event in ctrl.listeners) {
                            if (ctrl.listeners.hasOwnProperty(event)) {
                                var targetParts = ctrl.listeners[event].split('.');
                                me.on(event, view[targetParts[1]], view);
                            }
                        }
                    }
                }
            },

            loadTypes: function() {
                var me = this,
                    ctrl = me.ctrl,
                    store = me.typeField.store,
                    rType = store.recordType,
                    availTypes = ctrl.availableTypes;

                Ext.each(ctrl.periodTypes,
                    function(pt) {
                        var value = pt[0];
                        if (!Ext.isEmpty(availTypes) && (value & availTypes) == 0) {
                            return;
                        }
                        var newRec = new (rType)({});
                        switch (ctrl.mode) {
                            case 0:
                            case 1:
                                newRec.data.value = value;
                                newRec.data.name = pt[1];
                                break;
                        }
                        store.add(newRec);
                    });
            },

            getPeriods: function(pType, year) {
                var res = [[]];
                switch (+pType) {
                    case 2:
                        res = this.ctrl.quartPeriods;
                        break;
                    case 4:
                        res = this.ctrl.monthPeriods;
                        break;
                    case 8:
                        res = this.getWeeksList(year);
                        break;
                    default:
                        break;
                }
                return res;
            },

            setType: function(rawType) {
                var me = this,
                    ctrl = me.ctrl,
                    type,
                    number,
                    date0 = new Date(me.getYear(), 0);
                if (me.rendered !== true) {
                    me.deferredType = rawType;
                    return;
                }
                switch (ctrl.mode) {
                    case 0:
                        type = rawType;
                        me.typeField.setValue(type);
                        if (type == 1 || type == 16) {
                            me.numberField.setVisible(false);
                        } else {
                            me.numberField.getStore().loadData(me.getPeriods(type, me.getYear()));
                            var pt0 = me.getPeriods(type)[0];
                            if (pt0) me.numberField.setValue(pt0[0]);
                            me.numberField.setVisible(true);
                        }
                        break;
                    case 1:
                        if (Ext.isString(rawType) && rawType.indexOf('_') > 0) {
                            type = rawType.split('_')[0];
                            number = rawType.split('_')[1];
                        } else {
                            type = rawType;
                            number = me.getNumber();
                        }
                        me.numberField.setVisible(type == 8);
                        switch (+type) {
                            case 8:
                                me.typeField.setValue(type);
                                me.numberField.getStore().loadData(me.getPeriods(type, me.getYear()));
                                me.numberField.setValue(number);
                                break;
                            case 16:
                                me.typeField.setValue(type);
                                me.dateField.setValue(new Date(date0.setDate(+number)));
                                var year = date0.getFullYear();
                                me.yearField.setValue(year);
                                break;
                            default:
                                me.typeField.setValue(type + '_' + number);
                                break;
                        }
                        break;
                }

                me.dateField.setVisible(type == 16);
                me.yearField.setVisible(type != 16);

                me.syncSize();
                me.doLayout();
            },

            getType: function() {
                if (!this.rendered) {
                    return this.deferredType;
                }
                switch (this.ctrl.mode) {
                    case 0:
                        return +this.typeField.getValue();
                    case 1:
                        return this.getCommonType(this.typeField.getValue());
                }
                return 0;
            },

            getCommonType: function(rawType) {
                var type = KS.isString(rawType) ? rawType.split('_')[0] : rawType;
                return +type;
            },

            getCommonNumber: function(rawType) {
                var number = rawType.split('_')[1];
                return +number;
            },

            setYear: function(year) {
                if (this.rendered) {
                    this.yearField.setValue(year);
                } else {
                    this.deferredYear = year;
                }
            },

            getYear: function() {
                return this.rendered ? this.yearField.getValue() : this.deferredYear;
            },

            setNumber: function(number) {
                var me = this,
                    ctrl = me.ctrl;

                switch (ctrl.mode) {
                    case 0:
                        break;
                    case 1:
                        switch (me.getType()) {
                            case 2:
                            case 4:
                            case 8:
                                me.setType(me.getType() + '_' + number);
                                return;
                            case 16:
                                me.setType(me.getType() + '_' + number);
                                return;
                            default:
                                if (me.numberField)
                                    number = me.numberField.getValue();
                                break;
                        }
                }
                switch (me.getType()) {
                    case 2:
                        if (number > 4) {
                            number = 1;
                        }
                        break;
                    case 4:
                        if (number > 12) {
                            number = 1;
                        }
                        break;
                }
                if (me.rendered) {
                    switch (me.getType()) {
                        case 16:
                            var date0 = new Date(me.getYear(), 0);
                            me.dateField.setValue(new Date(date0.setDate(+number)));
                            break;
                        default:
                            this.numberField.setValue(number);
                            break;
                    }
                } else {
                    me.deferredNumber = number;
                }
            },

            getNumber: function() {
                if (!this.rendered) {
                    return this.deferredNumber;
                }
                var me = this, n = 1, date, ctrl = me.ctrl;
                switch (ctrl.mode) {
                    case 0:
                        switch (me.getType()) {
                            case 1: // Год
                                n = 1;
                                break;
                            case 16: // День
                                date = me.dateField.getValue();
                                n = (date && typeof (date.getDayOfYear) == 'function') ? date.getDayOfYear() + 1 : 0;
                                break;
                            default:
                                n = +me.numberField.getValue();
                        }
                        break;
                    case 1:
                        switch (me.getType()) {
                            case 1: // Год
                                n = 1;
                                break;
                            case 2: // Квартал
                            case 4: // Месяц
                                n = me.getCommonNumber(me.typeField.getValue());
                                break;
                            case 8: // Неделя
                                n = +me.numberField.getValue();
                                if (n === 0) n = 1;
                                break;
                            case 16: // День
                                date = me.dateField.getValue();
                                n = (date && typeof (date.getDayOfYear) == 'function') ? date.getDayOfYear() + 1 : 0;
                                break;
                            default:
                                n = me.numberField.getValue();
                        }
                }
                return (Ext.isNumber(n) ? n : 1);
            },

            setAllPeriods: function(checked) {
                var me = this;
                if (me.rendered !== true) {
                    me.deferredAllPeriods = checked;
                    return;
                }
                me.typeField.setDisabled(checked);
                me.numberField.setDisabled(checked);
                me.dateField.setDisabled(checked);
                me.doLayout();
            },

            getPeriod: function() {
                return {
                    Year: this.getYear(),
                    Type: this.getType(),
                    Number: this.getNumber()
                }
            }
        })
    });

    function createPeriodComponent() {
        var ctrl = arguments[0],
            cfg = KS.apply(arguments[1] || {}, ctrl.json);
        KS.apply(cfg,
            {
                width: 264,
                ctrl: ctrl,
                x: ctrl.x,
                y: ctrl.y
            });
        var periodComponent = new KS.Svod.PeriodComponent(cfg);
        if (!KS.isEmpty(ctrl.value)) {
            var period = Ext.isArray(ctrl.value) ? ctrl.value[0] : ctrl.value,
                type = period.Type,
                number = period.Number;
            if (period.Year)
                periodComponent.setYear(period.Year);
            if (type > 8) {
                periodComponent.setType(type + '_' + number);
            } else {
                periodComponent.setType(type);
                periodComponent.setNumber(number);
            }
        }
        periodComponent.setAllPeriods(ctrl.filterDateOff);
        return periodComponent;
    }

    KS.Ext.registerControlRenderer('periodComponent', createPeriodComponent);
})();

// ============= KS.Ext.ClientView =======================
(function () {
    KS.apply(KS.Ext.ClientView.prototype,
        {
            processTaskResult: function (trc) {
                if (KS.isEmpty(trc) || KS.isEmpty(trc.Arguments)) return;
                if (trc.Arguments.ctrl) {
                    var view = this,
                        ctrlWin = KS.showModal(this.createTemplateControl(trc.Arguments.ctrl),
                            {
                                title: trc.Arguments.caption,
                                autoHeight: false,
                                frame: true,
                                width: 450,
                                height: 350,
                                bbar: [
                                    '->', {
                                        text: 'OK',
                                        cls: 'marked-button',
                                        scope: view,
                                        handler: function () {
                                            if (KS.isEmpty(view.commentFieldValue)) return;
                                            var taskResults = {
                                                method: trc.Arguments.method,
                                                comment: view.commentFieldValue
                                            };
                                            this.afterProcessTaskResult(taskResults);
                                            ctrlWin.close();
                                        }
                                    }
                                ]
                            });
                }
            },

            afterProcessTaskResult: function () {
            },

            commentFieldChanged: function (ed, value) {
                ed.parentView.commentFieldValue = value;
            }
        });
})();

// ============= ESIA =======================
(function () {
    KS.apply(KS, {
        esiaLogout: function() {
            if (KS.isEmpty(KS.esiaLogoutUrl)) return;
            //KS.sendEsiaLogoutRequest(KS.esiaLogoutUrl, {});
            //delete KS.esiaLogoutUrl;
        },

        doEsiaLogout: function () {
            KS.esiaWin = new Ext.Window({
                autoHeight: false,
                maximizable: true,
                x: KS.rootViewport.getWidth() - 455,
                width: 450,
                height: 550,
                layout: 'form',
                labelWidth: 1,
                items: [
                    KS.esiaRequest = new Ext.form.TextArea({
                        height: 100,
                        value: KS.esiaLogoutUrl,
                        anchor: '100%'
                    }),KS.esiaCfg = new Ext.form.TextArea({
                        height: 100,
                        value: '{\r\ntype: "GET"\r\n}',
                        anchor: '100%'
                    }), KS.esiaResult = new Ext.Panel({
                        anchor: '100% -200',
                        autoScroll: true
                    })
                ],
                bbar: ['->', {
                    text: 'Отправить',
                    handler: function () {
                        KS.sendEsiaLogoutRequest(KS.esiaRequest.getValue(), KS.esiaCfg.getValue());
                    }
                }]
            }).show();
        },

        sendEsiaLogoutRequest: function (url, customCfg) {
            var cfg = {
                url: url,
                success: KS.esiaLogoutSuccess,
                error: KS.esiaLogoutError
            };
            if (customCfg) {
                if (KS.isString(customCfg)) {
                    customCfg = Ext.decode(customCfg, true);
                }
                KS.apply(cfg, customCfg);
            }
            $.ajax(cfg);
        },

        esiaLogoutSuccess: function (result) {
            if (KS.esiaResult) KS.esiaResult.update(result);
        },

        esiaLogoutError: function (result) {
            if (KS.esiaResult) KS.esiaResult.update(result);
        }
    });
})();

// ============= PDF.JS =======================
(function() {
    if (!KS.pdfViewer) {
        KS.pdfViewer = Ext.extend(Ext.BoxComponent,
            {
                onRender: function(ct) {
                    this.el = Ext.get(this.canvas);
                    this.cacheSizes = true;
                },

                getWidth: function() {
                    return this.lastSize.width;
                },

                getHeight: function() {
                    return this.lastSize.height;
                },

                onResize: function(w, h) {
                    //this.R.setSize(w, h);
                }
            });
    }
});

// ============= MAIL =======================
KS.apply(KS, {
    findMailGroupView: function() {
        var mailGroupView = null;
        for (var view in KS.registeredViews) {
            if (KS.registeredViews.hasOwnProperty(view) &&
                KS.registeredViews[view].data &&
                KS.registeredViews[view].data.isMailGroupView) {
                mailGroupView = KS.registeredViews[view];
            }
        }
        return mailGroupView;
    },

    openMailGroup: function () {
        var mailGroupView = KS.findMailGroupView();
        if (mailGroupView) {
            mailGroupView.openMailGroup();
        }
    }
});

MailGroupView = KS.extend(KS.Ext.ClientView,
    {
        onTemplateRendered: function () {
            var view = this,
                interval = view.data.interval;
            if (interval > 0) {
                this.timerId = setInterval(function () { view.updateMailManager(); }, interval * 1000);
            }
            // first check on start
            view.updateMailManager();
        },

        onBeforeClose: function () {
            if (this.timerId) this.clearInterval(this.timerId);
            return MailGroupView.superclass.onBeforeClose.call(this);
        },

        onNodeClick: function (node) {
            this.serverCall({
                method: 'NodeClickHandler',
                params: [node.id]
            });
        },

        onServerReloadTree: function (nodes) {
            this.mailTree.loadSubTreeInRoot(nodes);
        },

        updateMailManager: function () {
            this.serverCall({
                method: 'UpdateMailManager',
                waitMessage: 'Проверка почты ...'
            });
        },

        openMailGroup: function () {
            this.serverCall({ method: 'OpenMailGroup' });
        }
    });

MailListView = KS.extend(KS.Ext.ClientView,
    {
        reloadList: function () {
            var view = this.parentView || this;
            this.lastCodes = view.listGrid.getCheckedCodes(true);
            //Ext.each(view.listGrid.getCheckedCodes(false), function (cc) {
            //    view.listGrid.addCodeToCheckedList(cc);
            //});
            view.serverCall({
                method: 'ReloadMessagesList',
                progressOnly: true,
                success: view.reloadListCallback
            });
        },

        reloadListCallback: function (data) {
            this.listGrid.getStore().loadDataPage(1, data);
        },

        openMessage: function (grid, row) {
            var view = this.parentView || this,
                rec = KS.isObject(row) ? row : grid.getStore().getAt(row),
                msgId = KS.Grid.getAnyCase(rec, 'ID');

            view.serverCall({
                method: 'OpenMessage',
                params: [msgId],
                progressOnly: true,
                success: view.previewMessage
            });
        },

        listClick: function (grid, row) {
            var view = this.parentView || this,
                rec = KS.isObject(row) ? row : grid.getStore().getAt(row),
                msgId = KS.Grid.getAnyCase(rec, 'ID');

            view.serverCall({
                method: 'PreviewMessage',
                params: [msgId],
                progressOnly: true,
                success: view.previewMessage
            });
        },

        previewMessage: function (data) {
            for (var key in data) {
                if (data.hasOwnProperty(key)) {
                    var field = this[key.toLowerCase()];
                    if (field) {
                        var setFn = field.setValue || field.setText || field.loadJsonString;
                        if (setFn) setFn.call(field, data[key]);
                    }
                    switch (key.toLowerCase()) {
                        case 'theme':
                            this.previewPanel.setTitle(data[key]);
                            break;
                        case 'data':
                            this.msgPanel.update(data[key]);
                            break;
                    }
                }
            }
            //this.reloadList();
        },

        deleteMessages: function () {
            var view = this.parentView || this,
                codes = view.listGrid.getCheckedCodes(true);
            if (KS.isEmpty(codes)) return;
            KS.confirm("Удалить отмеченные сообщения?", "Подтверждение", function (btn) {
                if (btn !== 'yes') return;
                view.serverCall({
                    method: 'RemoveMessages',
                    params: [codes],
                    waitMessage: 'Удаление',
                    success: view.reloadList
                });
            });
        }
    });

MailEditView = KS.extend(KS.Ext.ClientView,
    {
        editorChanged: function (editor, newValue) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'EditorChanged',
                params: [editor.code, newValue],
                disableFog: true,
                success: view.previewMessage
            });
        },

        selectSendTo: function () {
            var view = this.parentView || this;

            view.serverCall({
                method: 'SelectSendTo',
                success: view.previewMessage
            });
        },

        onServerSetRecipients: function (recipients) {
            this.sendto.setValue(recipients);
        },

        doUpload: function () {
            var view = this,
                attach = this.rootPanel.getTopToolbar().attach;
            if (attach.getForm().isValid()) {
                attach.getForm().submit({
                    url: 'PlatformHandler.axd?upload=1&important=1',
                    method: 'POST',
                    fileUpload: true,
                    waitMsg: 'Загрузка файла ...',
                    failure: function (fp, o) {
                        if (Ext.isArray(o.result) && !Ext.isEmpty(o.result)) {
                            view.saveFiles(o.result);
                        } else {
                            KS.msg('Ошибка загрузки файла');
                        }
                    }
                });
            }
        },

        saveFiles: function (fileKeys) {
            this.serverCall({
                method: 'DoSaveFiles',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: this.saveFilesCallback
            });
        },

        saveFilesCallback: function (fileName) {
            if (this.attachTree.fullReload) {
                this.attachTree.fullReload();
            } else {
                this.attachTree.reload();
            }
            //if (fileName) this.fileName.setValue(fileName);
        },

        attachNodeSelect: function (node, record) {
            var nodeId = !!record.get ? record.get('ID') : node.id;
            this.serverCall({
                method: 'AttachNodeSelect',
                params: [nodeId],
                success: this.previewMessage
            });
        }
    });

UsersGroupsView = KS.extend(KS.Ext.ClientView,
    {
        usersCheckChange: function () {
        },

        usersNodeLevelLoad: function (node) {
        },

        selectUsers: function () {
            var view = this.parentView || this,
                nodes = view.usersTree.getChecked(),
                ids = [];
            Ext.each(nodes, function (node) {
                ids.push(node.id);
            });
            if (KS.isEmpty(ids)) return;
            view.serverCall({
                method: 'GenerateEvent',
                params: [ids]
            });
        },

        markChildren: function () {
            var view = this.parentView,
                usersTree = view.usersTree;
            usersTree[this.fn].call(usersTree, arguments);
        },

        usersSearch: function (f, e) {
            if (e && e.keyCode === 13) {
                var view = this.parentView || this;
                view.setUserSearchString();
            }
        },

        clearSearch: function () {
            var view = this.parentView || this,
                searchField = view.getToolbarItem(view.usersTree, null, 'searchField');
            searchField.setValue('');
            view.setUserSearchString();
        },

        setUserSearchString: function () {
            var view = this,
                searchField = view.getToolbarItem(view.usersTree, null, 'searchField'),
                searchValue = searchField.getValue();
            view.serverCall({
                method: 'UsersSearch',
                params: [searchValue],
                success: view.reloadUsersTree
            });
        },

        reloadUsersTree: function (data) {
            this.usersTree.fullReload();
        }
    });

function ksiconRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var colCfg = store.grid.getColCfgByIndex(colIndex),
        icon = KS.Grid.getAnyCase(record, colCfg.dataIndex);
    return (KS.isString(icon) && !KS.isEmpty(icon))
        ? '<img src="PlatformHandler.axd?icon=' + icon + '.png"/>'
        : '';
}
