﻿UserAdmView = KS.extend(BaseDictionaryView, {
    deleteConfirmMsg: 'Удалить выбранных пользователей?'
});
// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass,{
        getTbarClickHandler: function(tbarItem) {
            var sc = UserAdmView.superclass;
            switch (tbarItem.code) {
                case "NEW":
                case "NEW2":
                case "USER_LIST_BATCH_NEW":
                case "GROUP_LIST_BATCH_NEW":
                case "EDIT":
                case "COPY":
                case "USER_LIST_BLOCK_MENU":
                case "USER_LIST_BLOCK_USER":
                case "USER_LIST_RESTORE_USER":
                case "USER_LIST_BLOCK_LOGIN":
                case "USER_LIST_RESTORE_LOGIN":
                case "USER_LIST_SHOW_USERS":
                case "USER_LIST_SHOW_LOCKS":
                case "REFRESH_PASSWORD_HASH":
                case "USER_LIST_SCHEDULE":
                case "IMPORT_LOGINS":
//                    case "SYNC_WITHOUT_PASSWORD":
//                    case "SYNC_WITH_PASSWORD":
                case "SYSTEM_JOURNAL":
                    return this.executeToolbarOperation;

                case "USER_LIST_CLEAR_RIGHTS":
                    return this.clearUserRights;

                case "EXPORT_LOGINS":
                    return this.exportLogins;

                case "EXPORT_TEMPLATES":
                    return this.exportTemplates;

                case "SETTINGS":
                case "EH_SYNCHRONIZE":
                    return null;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        executeToolbarOperation: function() {
            var view = this.parentView,
                grid = view.mainGrid;
            if (grid && this.tbarNode) {
                var code = this.tbarNode.code || '';
                view.executeOperation(code, grid);
            }
        },

        executeOperation: function (opCode, grid, additional) {
            var operWithoutSelectRows = ["NEW", "NEW2", "USER_LIST_BATCH_NEW",
                    "GROUP_LIST_BATCH_NEW", "USER_LIST_SHOW_LOCKS", "USER_LIST_SCHEDULE", "IMPORT_LOGINS"],
                rows = [];

            if (operWithoutSelectRows.indexOf(opCode) === -1) {
                rows = this.buildChosenRows(grid, true);
                if (Ext.isEmpty(rows)) {
                    KS.alert("Для выполнения операции необходимо выделить одного или нескольких пользователей");
                    return;
                }
            }

            this.serverCall({
                method: 'OnExecuteOperation',
                params: [opCode, rows, additional || {}],
                success: this.afterExecuteOperation
            });
        },

        afterExecuteOperation: function(opCode) {
            switch (opCode) {
                case "USER_LIST_BLOCK_USER":
                case "USER_LIST_RESTORE_USER":
                case "USER_LIST_BLOCK_LOGIN":
                case "USER_LIST_RESTORE_LOGIN":
                case "DELETE":
                    this.resetGrid();
                    break;
            }
        },

        deleteHandlerInternal: function() {
            this.executeOperation("DELETE", this.mainGrid);
        },

        clearUserRights: function() {
            var view = this.parentView || this;
            view.clearRightsGrid = KS.create(view.tpl.controls.clearRightsGrid);
            if (view.clearRightsGrid) {
                view.clearRightsWin = KS.showModal(view.clearRightsGrid,
                    {
                        title: 'Выберите значение...',
                        autoHeight: false,
                        height: 300,
                        resizable: false,
                        autoScroll: false,
                        maximizable: false,
                        buttonAlign: 'left',
                        buttons: ['->', {
                                text: 'ОК',
                                scope: view,
                                handler: function() {
                                    view.doClearUserRights();
                                    view.clearRightsWin.close();
                                }
                            },{ xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function() {
                                    view.clearRightsWin.close();
                                }
                            }]
                    }, true);
            }
        },

        doClearUserRights: function() {
            var grid = this.clearRightsGrid;
            if (grid) {
                var store = grid.getStore();
                var additional = {};
                store.each(function(row) {
                    additional[row.get("TYPE")] = row.get("CHECKED").toString();
                });
                this.executeOperation("USER_LIST_CLEAR_RIGHTS", this.mainGrid, additional);
            }
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'UploadPasswordFields',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: view.uploadPasswordFieldsCallback
            });
        },

        uploadPasswordFieldsCallback: function (result) {
            if (result === true)
                this.mainGrid.reload();
            else
                KS.openSpreadsheetView(result, this);
        },

        exportLogins: function() {
            var view = this.parentView;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (checkedCodes.length > 0) {
                view.serverCall({
                    method: 'ExportLogins',
                    params: [checkedCodes]
                });
            }
        },

        exportTemplates: function() {
            var view = this.parentView;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (checkedCodes.length > 0) {
                view.serverCall({
                    method: 'ExportTemplates',
                    params: [checkedCodes]
                });
            }
        },

        onServerDeleteUsersWithEds: function (dict) {
            var view = this;
            var msg = dict["msg"];
            var links = dict["links"];
            KS.confirm(msg, "Внимание", function (btn) {
                if (btn === 'yes')
                    view.serverCall({
                        method: 'DeleteUsersWithEds',
                        waitMessage: 'Удаление...',
                        params: [links],
                        success: view.resetGrid
                    });
            });
        }
    });
}(UserAdmView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();