﻿UniDictTreeView = KS.extend(BaseSvodView, {
    constructor: function(viewId) {
        UniDictTreeView.superclass.constructor.call(this, viewId);
    }
});

(function (viewClass) {
    var sc = UniDictTreeView.superclass;
    KS.apply(viewClass, {

        select: function () {
            var view = this.parentView || this;
            var node = view.tree.getSelNode();
            if (node) {
                view.disable();
                view.serverCall({
                    method: 'EndSelection',
                    params: [[node.id]],
                    success: function(ok) {
                        if (ok) {
                            view.destroyContainerItems();
                        } else {
                            view.enable();
                        }
                    },
                    error: view.enable
                });
            }
        },
        
        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "Добавить группу":
                case "Добавить справочник":
                case "SETTINGS_MENU":
                    return null;
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },

        nodeLevelLoaded: function(){
            if (this.treeNodeIdToScroll) {
                this.tree.setSelected(this.treeNodeIdToScroll);
                this.scrollToActiveNode(this.tree);
                this.treeNodeIdToScroll = null;
            }
            if (!this.tree.getSelNode())
                this.tree.selectFirstNode();
        },
    
        nodeClick: function(node, record) {
            this.openDictionary(record.id);
        },

        beforeTreeNodeDrop: function(node, data, overModel, dropPosition, dropHandlers){
            var nodes = data.records; // перемещаемый узел
            var checkedNodes = this.tree.getChecked(); // отмеченные узлы
            nodes = nodes.concat(checkedNodes);

            var message = "";
            var code = "";
            switch(dropPosition)
            {
                case "append":
                    message = nodes.length > 1
                        ? "Подчинить отмеченные узлу '" + overModel.data.text + "'?"
                        : "Подчинить узел '" + nodes[0].data.text + "' узлу '" + overModel.data.text + "'?";
                    code = "SET_TO";
                    break;

                case "before":
                    message = nodes.length > 1
                        ? "Переместить отмеченные перед узлом '" + overModel.data.text + "'?"
                        : "Переместить узел '" + nodes[0].data.text + "' перед узлом '" + overModel.data.text + "'?";
                    code = "SET_BEFORE";
                    break;

                case "after":
                    message = nodes.length > 1
                        ? "Переместить отмеченные после узла '" + overModel.data.text + "'?"
                        : "Переместить узел '" + nodes[0].data.text + "' после узла '" + overModel.data.text + "'?";
                    code = "SET_AFTER";
                    break;
            }

            var checkedLinks = [];
            Ext.each(nodes,
                function(checkedNode) {
                    checkedLinks.push(checkedNode.id);
                });

            var view = this;
            dropHandlers.wait = true;

            KS.confirm(message, "Внимание", function(btn) {
                if (btn === 'yes') {
                    // Если переставляем сразу больше 1 узла, то обновляем дерево
                    view.doReplaceNode(checkedLinks, code, overModel);
                    if (checkedLinks.length > 1)
                        dropHandlers.cancelDrop();
                    else
                        dropHandlers.processDrop();
                }
                else {
                    dropHandlers.cancelDrop();
                }
            });
        },
    
        addGroup: function(){
            this.parentView.getCreateGroupPanel(null);
        },

        addChildGroup: function(){
            var view = this.parentView || this;
            var selNodeId = view.tree.getSelNodeId();
            if (Ext.isEmpty(selNodeId)) 
                view.getCreateGroupPanel(null);
            else
                view.getCreateGroupPanel(selNodeId);            
        },

        getCreateGroupPanel: function(link){
            this.serverCall({
                method: 'GetCreateGroupPanel',
                params: [link],
                disableFog: true,
                success: function(createGroupProps) {
                    this.showCreateGroupPanel(createGroupProps, link);
                }
            });
        },

        showCreateGroupPanel: function(createGroupProps, link){
            if (Ext.isEmpty(createGroupProps)) return;
            var view = this;
            this.createGroupPropertyGrid = this.getPropertyGridByOption(createGroupProps, "createGroupPropertyGrid", "1. Общие");
            view.createGroupPropertyWin = KS.showModal(view.createGroupPropertyGrid, {
                title: 'Свойства',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 3),
                height: Math.max(300, KS.rootViewport.getWidth() / 4),
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    scope: this,
                    handler: function () {
                        view.createNewGroup(link);
                    }
                },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.createGroupPropertyWin.close();
                        }
                    }]
            }, true);
        },

        createNewGroup: function(link){
            var source = this.createGroupPropertyGrid.source;
            var view = this;
            this.serverCall({
                method: 'CreateNewGroup',
                params: [source, link],
                success: function(errorMsg) {
                    if (Ext.isEmpty(errorMsg)){
                        view.createGroupPropertyWin.close();
                        view.saveChanges();
                    } else {
                        KS.alert(errorMsg, "Внимание")
                    }
                }
            });
        },

        addDictionary: function(){
            this.parentView.createNewDictionary(null, false);
        },

        addChildDictionary: function(){
            var view = this.parentView || this;
            var selNode = view.tree.getSelNode();
            if (Ext.isEmpty(selNode)) {
                view.createNewDictionary(null, false);
            } else {
                var selfLink = selNode.id;
                view.createNewDictionary(selfLink, selNode.childNodes.length > 0);
            }            
        },

        createNewDictionary: function(selfLink, needFindOrder){
            this.serverCall({
                method: 'CreateNewDictionary',
                params: [selfLink, needFindOrder]
            });
        },

        openDictionary: function(nodeId) {
            var view = this.parentView || this;
            var lightEdit = !Ext.isEmpty(this.tbarNode) && this.tbarNode.code === "EDIT_LIGHT";
            if (typeof (nodeId) != 'string') {
                var node = view.tree.getSelNode();
                if (node) {
                    nodeId = node.id;
                } else {
                    return;
                }
            }
            view.serverCall({
                method: 'DoOpenDictionary',
                params: [nodeId, lightEdit]
            });
        },

        copyDictionary: function(){
            var view = this.parentView || this;
            var selNode = view.tree.getSelNode();
            if (selNode){
                var operationCode = this.tbarNode.code;
                var copyLink = selNode.id;
                var parentNodeId = selNode.parentNode.id === 'root' ? null : selNode.parentNode.id;
                view.serverCall({
                    method: 'CopyDictionary',
                    params: [operationCode, copyLink, parentNodeId],
                    waitMessage: "Копирование справочников..."
                });
            }
        },
        
        deleteDictionary: function(){
            var view = this.parentView || this;// можно передавать еще и linkSelf
            var nodesId = view.getCheckedNodesId(view.tree);
            if (Ext.isEmpty(nodesId)) return;
            view.serverCall({
                method: 'GetDeleteDictionaryGrid',
                params: [nodesId],
                success: view.showDeleteDictionaryGrid
            });
        },

        showDeleteDictionaryGrid: function(grid){
            if (Ext.isEmpty(grid)) return;
            var view = this;
            view.deleteDictionaryGrid = KS.create(grid);
            view.deleteDictionaryWin = KS.showModal(view.deleteDictionaryGrid, {
                title: 'Следующие узлы будут удалены...',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    scope: this,
                    handler: function () {
                        view.doDeleteDictionary();
                    }
                },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.deleteDictionaryWin.close();
                        }
                    }]
            }, true);
        },

        doDeleteDictionary: function(){
            var delLinks = [];
            this.deleteDictionaryGrid.getStore().each(function(record){
                if (KS.Grid.getAnyCase(record, "DELETE")){
                    delLinks.push(KS.Grid.getAnyCase(record, "LINK_DICTION"))
                }    
            });
            this.deleteDictionaryWin.close();
            this.serverCall({
                method: 'DeleteDictionary',
                params: [delLinks],
                waitMessage: "Удаление справочников..."
            });                        
        },
        
        onReloadData: function() {
            var view = this.parentView || this;
            view.clearSearchField();
            view.reloadTree();
        },
        
        reloadTree: function(){
            this.tree.getRootNode().removeAll(true);
            this.tree.fullReload();
        },

        invertAllNodes: function(){
            var tree = this.parentView.tree;
            if (this.tbarNode.additional && this.tbarNode.additional.treeId)
                tree = this.parentView[this.tbarNode.additional.treeId];
            if (tree)
                tree.invertAll()
        },

        checkAllChildrenNodes: function(){
            var tree = this.parentView.tree;
            if (this.tbarNode.additional && this.tbarNode.additional.treeId)
                tree = this.parentView[this.tbarNode.additional.treeId];
            if (tree)
                tree.checkAllChildren()
        },

        checkDirectChildrenNodes: function(){
            var tree = this.parentView.tree;
            if (this.tbarNode.additional && this.tbarNode.additional.treeId)
                tree = this.parentView[this.tbarNode.additional.treeId];
            if (tree)
                tree.checkDirectChildren()
        },

        uncheckAllNodes: function(){
            var tree = this.parentView.tree;
            if (this.tbarNode.additional && this.tbarNode.additional.treeId)
                tree = this.parentView[this.tbarNode.additional.treeId];
            if (tree)
                tree.uncheckAll()
        },

        collapseTree: function(){
            var tree = this.parentView.tree;
            if (this.tbarNode.additional && this.tbarNode.additional.treeId)
                tree = this.parentView[this.tbarNode.additional.treeId];
            if (tree)
                tree.collapseAll();
        },

        expandTree: function(){
            var tree = this.parentView.tree;
            if (this.tbarNode.additional && this.tbarNode.additional.treeId)
                tree = this.parentView[this.tbarNode.additional.treeId];
            if (tree)
                tree.expandAll();
        },

        showFormUsingGrid: function(){
            var view = this.parentView || this;
            var nodesId = view.getCheckedNodesId(view.tree);
            if (Ext.isEmpty(nodesId)){
                KS.alert("Не выбран ни один справочник", "Внимание")
                return;
            }
            view.serverCall({
                method: 'ShowFormUsingGrid',
                params: [nodesId]
            });
        },
        
        showDictUsingGrid: function(){
            var view = this.parentView || this;
            var nodesId = view.getCheckedNodesId(view.tree);
            if (Ext.isEmpty(nodesId)){
                KS.alert("Не выбран ни один справочник", "Внимание")
                return;
            }
            view.serverCall({
                method: 'ShowDictUsingGrid',
                params: [nodesId]
            });
        },

        copyPath: function(){
            var view = this.parentView || this;
            view.copyPathToActiveNode(view.tree);
        },

        clearCache: function(){
            var view = this.parentView || this;
            KS.confirm("Очистить кэш справочников на сервере?", "Внимание",
                function (btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: 'OnClearCache',
                            waitMessage: 'Очистка кэша универсального справочника на сервере...'
                        });
                    }
                });            
        },

        clearCacheFull: function(){
            var view = this.parentView || this;
            KS.confirm("Очистить полностью кэш справочников на сервере?", "Внимание",
                function (btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: 'OnClearCacheFull',
                            waitMessage: 'Полная очистка кэша универсального справочника на сервере...'
                        });
                    }
                });
        },

        replaceNode: function() {
            var view = this.parentView || this;
            var code = this.tbarNode.code;
            var checkedLinks = view.getCheckedNodesId(view.tree);
            if (!Ext.isEmpty(checkedLinks)) {
                view.serverCall({
                    method: 'GetReplaceNodePanel',
                    success: function(replaceNodePanel) {
                        view.showReplaceNodePanel(replaceNodePanel, checkedLinks, code);
                    }
                });
            }
        },

        showReplaceNodePanel: function(replaceNodePanel, checkedLinks, code){
            if (Ext.isEmpty(replaceNodePanel)) return;
            var view = this;
            this.replaceNodePanel = this.createTemplateControl(replaceNodePanel);
            this.addPanelItems(replaceNodePanel, this.replaceNodePanel);
            view.replaceNodeWin = KS.showModal(this.replaceNodePanel, {
                title: 'Выберите значения...',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getWidth() / 3),
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    scope: this,
                    handler: function () {
                        var selNode = view.replaceNodeTree.getSelNode();
                        view.doReplaceNode(checkedLinks, code, selNode);
                    }
                },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.replaceNodeWin.close();
                        }
                    }]
            }, true);
        },

        // checkedLinks - id переставляемых узлов
        // code - выполняемая операция
        // selNode - узел, к которому перемещаем
        doReplaceNode: function(checkedLinks, code, selNode) {
            var view = this;
            if (Ext.isEmpty(selNode)) return;
            var selNodeId = selNode.id;
            if (view.replaceNodeWin)
                view.replaceNodeWin.close();
            view.serverCall({
                method: 'ReplaceNode',
                disableFog: true,
                params: [checkedLinks, selNodeId, code],
                success: function(activeNodeId) {
                    if (!Ext.isEmpty(activeNodeId))
                        view.treeNodeIdToScroll = activeNodeId;
                    view.saveChanges();
                }
            });
        },

        exportDicts: function() {
            var view = this.parentView || this;
            var nodesId = view.getCheckedNodesId(view.tree);
            if (Ext.isEmpty(nodesId)) return;
            view.serverCall({
                method: 'ExportDicts',
                params: [nodesId]
            });
        },

        importDictionary: function(){
            this.parentView.serverCall({
                method: 'ImportDictionary'
            });
        },

        printTreeToExcel: function() {
            var view = this.parentView;
            var treeId = view.tree.itemId;
            view.serverCall({
                method: 'ExportToExcel',
                waitMessage: 'Формирование документа Excel ...',
                params: [treeId, '', '', '', {}],
                success: view.openUrl
            });
        },

        showSystemJournal: function() {
            var view = this.parentView || this;
            var node = view.tree.getSelNode();
            view.serverCall({
                method: 'ShowSystemJournal',
                params: [node ? node.id : null]
            });
        },
        
        getCheckedNodesId: function(tree){
            var nodesId = [];
            var checkedNodes = tree.getChecked();
            var selNode = tree.getSelNode();
            if (selNode && checkedNodes.indexOf(selNode) === -1)
                checkedNodes.push(selNode)
            if (!Ext.isEmpty(checkedNodes)){
                Ext.each(checkedNodes, function(node){
                    nodesId.push(node.id);
                })
            }
            return nodesId;
        }
    });
}(UniDictTreeView.prototype));

// ========== TREE TOOLBAR ===============
(function (viewClass) {
    KS.apply(viewClass, {
        notShowOldDict: function(comp, newValue) {
            var view = this.parentView || this;
            view.getToolbarItem(view.tree, null, "DATE_EDITOR").setDisabled(!newValue);
            view.serverCall({
                method: 'SetNotShowOldDict',
                params: [newValue],
                success: view.reload
            });
        },

        changeDateEditor: function(comp, newValue) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SetShowDate',
                params: [newValue],
                success: view.reload
            });
        },

        getFormsDict: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetFormsDict',
                success: view.showFormsDict
            });
        },
        
        showFormsDict: function(selectFormsPanel){
            if (Ext.isEmpty(selectFormsPanel)) return;
            var view = this;
            this.selectFormsPanel = this.createTemplateControl(selectFormsPanel);
            this.addPanelItems(selectFormsPanel, this.selectFormsPanel);
            view.formsDictWin = KS.showModal(this.selectFormsPanel, {
                title: 'Выберите значения...',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getWidth() / 3),
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    scope: this,
                    handler: function () {
                        view.selectFormsFromDict();
                    }
                },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.formsDictWin.close();
                        }
                    }]
            }, true);
        },

        selectFormsFromDict: function(){
            var checkedNodes = this.formsTree.getChecked();
            var nodeIds = [];
            var nodeNames = [];
            Ext.each(checkedNodes, function(node){
                if (node.isLeaf()){
                    nodeIds.push(node.id);
                    nodeNames.push(node.data.json.formCode);
                }
            });
            if (Ext.isEmpty(nodeIds)){
                KS.alert("Нет выбранных узлов", "Внимание");
                return;
            }
            this.formsDictWin.close();
            this.changeFormFilter(nodeIds, nodeNames)
        },

        changeFormFilter: function(nodeIds, nodeNames){
            var view = this;
            view.serverCall({
                method: 'ChangeFormFilter',
                params: [nodeIds],
                success: function(){
                    view.reload();
                    var formsField = view.getToolbarItem(view.tree, null, "FORM_FILTER");
                    if (formsField)
                        formsField.setValue(nodeNames.join());
                }
            });
        },

        cleanFormFilter: function(){
            var view = this.parentView || this;
            view.changeFormFilter([], [])
        },

        changeIsChecked: function(checkBox, newValue){
            var view = this.parentView || this;
            var tree = view.formsTree;
            if (newValue){
                tree.getStore().filter({
                    id: 'isChecked',
                    filterFn: function(item) {
                        if (!item.isLeaf() && !item.isRoot()){ // Не скрываем узел, если есть хотя бы один отмеченный подузел  
                            var hasCheckedChild = false;
                            Ext.each(item.childNodes, function(childNode){
                                if (childNode.get('checked')){
                                    hasCheckedChild = true;
                                    return false;
                                }
                            })
                            return hasCheckedChild;
                        } else {
                            return item.get('checked') === newValue;
                        }
                    }
                });
            } else {
                tree.getStore().removeFilter('isChecked');
            }
        }
    });
}(UniDictTreeView.prototype));

// ========== SEARCH ===============
(function (viewClass) {
    KS.apply(viewClass, {
        changeSearchPanelVisible: function() {
            var view = this.parentView || this;
            var searchPanel = view["searchPanel_" + this.tbarNode.additional.treeId];
            if (searchPanel){
                if (searchPanel.getHidden())
                    searchPanel.setHidden(false);
                else
                    searchPanel.setHidden(true);
            }
        },

        hideSearchPanel: function() {
            var view = this.parentView || this;
            var searchPanel = view["searchPanel_" + this.tbarNode.additional.treeId];
            if (searchPanel)
                searchPanel.setHidden(true);
        },

        // Поиск запускается только при клике на кнопку поиска, 
        // т.к. слишком много узлов и если делать поиск при каждом изменении, сильно подвисает
        searchFieldChange: function() {
            var view = this.parentView || this;
            var searchPanel = view.searchPanel_tree;
            var searchFieldId = "searchField_tree";
            var treeId = "tree";
            if (this.tbarNode) {
                treeId =  this.tbarNode.additional.treeId;
                searchPanel = view["searchPanel_" + treeId];
                searchFieldId = "searchField_" + treeId;
            }
            var tree = view[treeId];
            var searchField = view.getToolbarItem(searchPanel, null, searchFieldId);
            if (searchField && tree) {
                var newVal = searchField.getValue();

                tree.ksObjs.ksProgressBar.showProgressBar();

                if (newVal.indexOf('/') !== -1) {
                    var splitted = newVal.split('/ ');
                    if (splitted && splitted.length) {
                        newVal = splitted[splitted.length - 1];
                    }
                }

                var stringCompare = function(val, filterVal) {
                        return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                    },
                    store = tree.store;

                //Фильтрация снизу вверх
                store.filterer = 'bottomup';
                store.filter({
                    property: 'text',
                    filterFn: function(item) {
                        var ind = stringCompare(item.get('text'), newVal);
                        return Ext.isNumber(ind) && ind !== -1;
                    },
                    value: newVal
                });

                newVal && newVal.length ? tree.expandAll() : tree.collapseAll();

                if (view.updateTimeoutId) clearTimeout(view.updateTimeoutId);
                view.updateTimeoutId = setTimeout(
                    function() {
                        delete view.updateTimeoutId;
                        if (tree.ksObjs && tree.ksObjs.ksProgressBar)
                            tree.ksObjs.ksProgressBar.hideProgressBar();
                    },
                    1500);
            }
        },

        clearSearchField: function() {
            var view = this.parentView || this;
            var searchPanel = view.searchPanel_tree;
            var searchFieldId = "searchField_tree";
            if (this.tbarNode) {
                var treeId =  this.tbarNode.additional.treeId;
                searchPanel = view["searchPanel_" + treeId];
                searchFieldId = "searchField_" + treeId;
            }
            var searchField = view.getToolbarItem(searchPanel, null, searchFieldId);
            if (searchField) {
                searchField.setValue("");
                view.searchFieldChange.apply(this);
            }
        }
    });
}(UniDictTreeView.prototype));

function deleteDictionaryImageRenderer(value) {
    var altText = value === 'success' ? "&#9989;" : "&#9888;";
    return "<img width='14' height='14' src='images/ks/" + value + ".png' alt='" + altText + "'/>";
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();