UniDictSyncView = KS.extend(BaseDictionaryView, {
    customName: 'UniDictSyncView'
});

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            var view = this;

            if (view.rootEl.needToClose) {
                KS.alert("Изменений не найдено", "Внимание", function () {
                    view.close();
                });
            }
        },

        saveChanges: function () {
            var view = this.parentView || this,
                checkedRows = view.mainGrid.getCheckedRows(),
                checkedRowsData = [];

            Ext.each(checkedRows, function (record) {
                checkedRowsData.push(record.data);
            });

            view.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение ...',
                params: [checkedRowsData],
                success: function(hasSaveErrors) {
                    if (!hasSaveErrors) {
                        view.close();
                    }
                }
            });
        }
    });
}(UniDictSyncView.prototype));