﻿UniDictColumnSelectView = KS.extend(BaseTreeView, {});

(function (viewClass) {
    KS.apply(viewClass, {

        onTemplateRendered: function () {
        },
        
        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "FIND":
                    return this.changeSearchPanelVisible;
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },
        
        resetView: function(){
            if (this.uniDictTree){
                this.uniDictTree.getRootNode().removeAll(true);
                this.uniDictTree.fullReload();
            }
            if (this.systemDictTree){
                this.systemDictTree.getRootNode().removeAll(true);
                this.systemDictTree.fullReload();
            }
            if (this.mainGrid)
                this.mainGrid.getStore().removeAll();
        },

        changeSearchPanelVisible: function() {
            var view = this.parentView || this;
            var treeId = "uniDictTree";
            if (view.data.identifier.AllowSelectSystemDiction){
                var tab = view.dictSelectPanel.getActiveTab();
                if (tab && tab.ctrlId === "systemDictPanel") {
                    treeId = "systemDictTree"
                }
            }
            var searchPanel = view["searchPanel_" + treeId];
            if (searchPanel){
                if (searchPanel.getHidden())
                    searchPanel.setHidden(false);
                else
                    searchPanel.setHidden(true);
            }
        },

        hideSearchPanel: function() {
            var view = this.parentView || this;
            var searchPanel = view["searchPanel_" + this.tbarNode.additional.treeId];
            if (searchPanel)
                searchPanel.setHidden(true);
        },

        // Поиск запускается только при клике на кнопку поиска, 
        // т.к. слишком много узлов и если делать поиск при каждом изменении, сильно подвисает
        searchFieldChange: function() {
            var view = this.parentView || this;
            var searchPanel = view.searchPanel_uniDictTree;
            var searchFieldId = "searchField_uniDictTree";
            var treeId = "uniDictTree";
            if (this.tbarNode) {
                treeId =  this.tbarNode.additional.treeId;
                searchPanel = view["searchPanel_" + treeId];
                searchFieldId = "searchField_" + treeId;
            }
            var tree = view[treeId];
            var searchField = view.getToolbarItem(searchPanel, null, searchFieldId);
            if (searchField && tree) {
                var newVal = searchField.getValue();

                tree.ksObjs.ksProgressBar.showProgressBar();

                if (newVal.indexOf('/') !== -1) {
                    var splitted = newVal.split('/ ');
                    if (splitted && splitted.length) {
                        newVal = splitted[splitted.length - 1];
                    }
                }

                var stringCompare = function(val, filterVal) {
                        return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                    },
                    store = tree.store;

                //Фильтрация снизу вверх
                store.filterer = 'bottomup';
                store.filter({
                    property: 'text',
                    filterFn: function(item) {
                        var ind = stringCompare(item.get('text'), newVal);
                        return Ext.isNumber(ind) && ind !== -1;
                    },
                    value: newVal
                });

                newVal && newVal.length ? tree.expandAll() : tree.collapseAll();

                if (view.updateTimeoutId) clearTimeout(view.updateTimeoutId);
                view.updateTimeoutId = setTimeout(
                    function() {
                        delete view.updateTimeoutId;
                        if (tree.ksObjs && tree.ksObjs.ksProgressBar)
                            tree.ksObjs.ksProgressBar.hideProgressBar();
                    }, 1500);
            }
        },

        clearSearchField: function() {
            var view = this.parentView || this;
            var searchPanel = view.searchPanel_uniDictTree;
            var searchFieldId = "searchField_uniDictTree";
            if (this.tbarNode) {
                var treeId =  this.tbarNode.additional.treeId;
                searchPanel = view["searchPanel_" + treeId];
                searchFieldId = "searchField_" + treeId;
            }
            var searchField = view.getToolbarItem(searchPanel, null, searchFieldId);
            if (searchField) {
                searchField.setValue("");
                view.searchFieldChange.apply(this);
            }
        }
    });
}(UniDictColumnSelectView.prototype));
