﻿SyncOptionsView = KS.extend(BaseSvodView, {
    customName: 'SyncOptionsView'
});

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            var view = this;

            if (view.rootPanel.needToClose) {
                view.rootPanel.mask();
                view.serverCall({
                    method: 'SaveChanges',
                    success: function() {
                        var uniDictItemView = KS.findSingleView('customName', 'UniDictItemView');

                        if (!Ext.isEmpty(uniDictItemView)) {
                            uniDictItemView.afterCloseSyncOptions();
                        }
                    }
                });
            }
        },

        saveOptions: function () {
            var view = this.parentView,
                settings = {};

            view.rootPanel.mask();
            settings.serverField = view.serverField.getValue();
            settings.baseField = view.baseField.getValue();
            settings.loginField = view.loginField.getValue();
            settings.passwordField = view.passwordField.getValue();
            settings.savePasswordCheckbox = view.savePasswordCheckbox.getValue();

            if (view.additionalTab) {
                settings.codeField = view.codeField.getValue();
                settings.otherField = view.otherField.getValue();
            }
            else {
                settings.codeField = view.mainTab.codeFieldValue;
                settings.otherField = view.mainTab.otherFieldValue;
            }

            view.serverCall({
                method: 'SaveOptions',
                waitMessage: 'Сохранение ...',
                params: [settings],
                success: function() {
                    if (!view.additionalTab) {
                        var uniDictItemView = KS.findSingleView('customName', 'UniDictItemView');

                        if (!Ext.isEmpty(uniDictItemView)) {
                            uniDictItemView.afterCloseSyncOptions();
                        }
                    }
                }
            });
        }
    });
}(SyncOptionsView.prototype));