﻿SpreadsheetView = KS.extend(KS.Ext.ClientView, {});

// =============== COMMON =================
(function (viewClass) {
    KS.apply(viewClass, {
        onBeforeClose: function () {
            var view = this;
            view.spreadsheetFrame.closeSession(); // ajax
            return SpreadsheetView.superclass.onBeforeClose.call(view);
        }
    });
}(SpreadsheetView.prototype));

// =============== IFRAME =================
(function (viewClass) {
    KS.apply(viewClass, {
        openNewDocument: function (documentPath) {
            var view = this;
            view.serverCall({
                method: 'GetNewDocumentSource',
                params: [documentPath],
                success: function (source) {
                    view.spreadsheetFrame.setSrc(source);
                }
            });
        },

        reloadFrame: function () {
            this.spreadsheetFrame.reloadFrame();
        },
    });
}(SpreadsheetView.prototype));

// ============ DxSpreadsheet =============
(function (viewClass) {
    KS.apply(viewClass, {
        getSelection: function () {
            return this.spreadsheetFrame.spreadsheet.GetSelection();
        },

        selected: function (callback) {
            var view = this.parentView || this,
                s = view.spreadsheetFrame.spreadsheet;
            if (!s) return;
            var region = s.GetSelection();
            region['sheetIndex'] = s.sheetIndex || 1;
            view.serverCall({
                method: 'Selected',
                params: [region],
                scope: KS,
                success: callback
            });
        },

        onSpreadsheetDocumentChanged: function (s, e) {
            var view = this;

            if (view.parentView && view.parentView.onSpreadsheetDocumentChanged)
                view.parentView.onSpreadsheetDocumentChanged(s, e);
        },

        onSpreadsheetSelectionChanged: function (s, e) {
            var view = this;
            setTimeout(() => view.getFormulaBar().setValue(s.GetActiveCellFormula()), 0);
        },

        getFormulaBar: function () {
            var view = this;
            var formulaBarCmp = view.getToolbarItem(view.spreadsheetPanel, null, 'formulaBar');
            return formulaBarCmp;
        },

        onCellEndEdit: function (s, e) {
            var view = this;

            if (view.parentView && view.parentView.onSpreadsheetCellEndEdit)
                view.parentView.onSpreadsheetCellEndEdit(s, e);
        },

        saveDocument: function (callback, context) {
            this.spreadsheetFrame.saveDocument(callback, context);
        },

        saveDocumentCopy: function (tempFileKey, callback, context) {
            this.spreadsheetFrame.saveDocumentCopy(tempFileKey, callback, context);
        },

        downloadFile: function () {
            this.spreadsheetFrame.downloadFile();
        }
    });
}(SpreadsheetView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();