﻿ShowMDKSProtocolView = KS.extend(BaseDictionaryView, {
    getTbarClickHandler: function (tbarItem) {
        switch (tbarItem.code) {
            case 'SHOW_PROTOCOL':
                return this.showProtocol;

            default:
                return ShowMDKSProtocolView.superclass.getTbarClickHandler.call(this, tbarItem);
        }
    },

    rowDblClickHandler: function () {
        this.showProtocol();
    },

    showProtocol: function () {
        var view = this.parentView || this,
            grid = view.mainGrid || view.findOwnerContainer(this, view.isGrid),
            selRows = grid.getSelectedRows();
        if (Ext.isEmpty(selRows)) return;
        var nmg,
            selectLinks = [];
        Ext.each(selRows, function(rec) {
            selectLinks.push(KS.Grid.getAnyCase(rec, 'LINK_SAVED_FORM') || 0);
            selectLinks.push(KS.Grid.getAnyCase(rec, 'LINK_MDKS_GROUP') || 0);
            nmg = KS.Grid.getAnyCase(rec, 'NAME_MDKS_GROUP') || null;
        });
        view.serverCall({
            method: 'OnBackgroundOperation',
            params: ['SHOW_PROTOCOL', selectLinks, { 'NAME': nmg }],
            waitMessage: 'Получение протокола ...'
        });
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();