﻿ServiceMonitorView = KS.extend(BaseTreeView, {});

//========================COMMON========================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            var view = this;

            view.setupToolbarVisibilty();
            view.getDataSeriesCommon(null, 0, null, null);
            view.getCommonTextInfoPanel(null);
        },

        setupToolbarVisibilty: function() {
            var view = this;
            view.setTreeToolbarVisibilty(false);
            view.setGridToolbarVisibilty(false);
        }
    });
}(ServiceMonitorView.prototype));

//=========================TREE=========================
(function (viewClass) {
    KS.apply(viewClass, {
        baseTreeNodeSelect: function (treeModel, selected) {
            var view = this;

            if (Ext.isEmpty(selected)) {
                selected.id = 'filter_off';
                view.setTreeFilter(selected);
                view.analyticsPanelRenderByTree(null);
            } else {
                view.setTreeFilter(selected[0]);
                view.analyticsPanelRenderByTree(selected[0].data.id);
            }

            view.setTreeToolbarVisibilty(selected.id !== 'filter_off');
        },

        analyticsPanelRenderByTree: function (serverLink) {
            var view = this;
            view.selectedServerLink = serverLink;
            view.selectedAppLink = null;
            var typeValue = view.getToolbarItem(view.chartPanel, null, 'chartTypeEditor').getValue();
            view.getDataSeriesCommon(serverLink, typeValue);
            view.getCommonTextInfoPanel(serverLink);
        },

        setTreeToolbarVisibilty: function(isNodeSelected) {
            var view = this,
                buttons = view.getTbarDepOnTree();
            Ext.each(buttons,
                function (btn) {
                    if (btn)
                        btn.setDisabled(!isNodeSelected);
                });
        },

        getTbarDepOnTree: function () {
            var view = this;
            return [
                view.getToolbarItem(view.baseTree, null, 'EDIT_SERVER'),
                view.getToolbarItem(view.baseTree, null, 'DELETE_SERVER'),
                view.getToolbarItem(view.gridPanel, null, 'ADD_APP')
            ];
        },

        addServer: function () {
            this.parentView.getServerEditPanel(null, true);
        },

        editSelectedServer: function () {
            var view = this.parentView || this;
            var selectedServer = view.baseTree.getSelNode();
            if (!Ext.isEmpty(selectedServer))
                view.getServerEditPanel(selectedServer.getId(), false);
        },

        getServerEditPanel: function (serverLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'GetServerEditPanel',
                params: [serverLink, isNew],
                success: function (editPanel) {
                    view.showEditServerPanel(editPanel, serverLink, isNew);
                }
            });
        },

        showEditServerPanel: function (editPanel, serverLink, isNew) {
            if (Ext.isEmpty(editPanel)) return;
            var view = this;
            view.editPanel = view.createTemplateControl(editPanel, 'serverEditPanel');
            view.addPanelItems(editPanel, view.serverEditPanel);
            view.editingServerId = serverLink;
            view.globalIsNew = isNew;
            view.editServerModal = KS.showModal(view.editPanel,
                {
                    title: 'Свойства',
                    autoHeight: true,
                    resizable: false,
                    maximizable: false,
                    layout: 'anchor',
                    width: 600,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function () {
                                view.doEditServer(serverLink, isNew);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function () {
                                view.rejectServerEditing(serverLink, isNew);
                            }
                        }
                    ]
                },
                true);
        },

        doEditServer: function (serverLink, isNew) {
            var view = this;
            var newValues = this.collectServerEditValue();
            view.editServerModal.close();
            view.serverCall({
                method: 'EditServer',
                params: [newValues, serverLink, isNew],
                waitMessage: isNew ? 'Создание ...' : 'Редактирование ...',
                success: function () {
                    view.baseTree.getRootNode().removeAll(true);
                    view.baseTree.fullReload();
                }
            });
        },

        collectServerEditValue: function () {
            return {
                "NAME": this.serverName.getValue(),
                "USER_RIGHTS": this.userRights.getValue()
            }
        },

        rejectServerEditing: function (serverLink, isNew) {
            var view = this;
            view.editServerModal.close();
            view.serverCall({
                method: 'RejectServerChanges',
                params: [serverLink, isNew],
                waitMessage: 'Отмена...'
            });
        },

        deleteSelectedServer: function () {
            var view = this.parentView || this;

            var selectedServer = view.baseTree.getSelNode();

            if (!Ext.isEmpty(selectedServer)) {
                var serverLink = selectedServer.getId();

                KS.confirm("Будет удален сервер \"" + selectedServer.data.text + "\". Продолжить?",
                    "Подтвердите удаление", function (btn) {
                        if (btn === 'yes')
                            view.deleteServerByLink(serverLink);
                    });
            }
        },

        deleteServerByLink: function (serverLink) {
            this.serverCall({
                method: 'DeleteServer',
                params: [serverLink],
                waitMessage: 'Удаление ...',
                success: this.reloadTree
            });
        },

        reloadTree: function () {
            this.baseTree.getRootNode().removeAll(true);
            this.baseTree.fullReload();
        },

        onUsersSelect: function() {
            var view = this.parentView,
                relationId = this.ownerCt.textField.relationId;
            view.serverCall({
                method: 'OnUsersSelect',
                params: [relationId, view.editingServerId, view.globalIsNew]
            });
        },

        onValuesSelected: function (arg) {
            var values = arg[0],
                logins = [];
            Ext.each(values,
                function (user) {
                    logins.push(user['LOGIN']);
                });
            logins = logins.join(", ");
            this.userRights.setValue(logins);
        }
    });
}(ServiceMonitorView.prototype));

//=========================GRID=========================
(function (viewClass) {
    KS.apply(viewClass, {
        addApp: function () {
            var view = this.parentView;
            var nodeId = view.baseTree.getSelNodeId();
            if (nodeId !== null) {
                this.parentView.getAppEditPanel(nodeId, null, true);
            }
        },

        editSelectedApp: function () {
            var view = this.parentView || this;
            var selectedApps = view.mainGrid.getCheckedRows();
            if (!Ext.isEmpty(selectedApps))
                view.getAppEditPanel(selectedApps[0].data.link_server, selectedApps[0].data.link_app, false);
        },

        getAppEditPanel: function (serverLink, appLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'GetAppEditPanel',
                params: [serverLink, appLink, isNew],
                success: function (editPanel) {
                    view.showEditAppPanel(editPanel, serverLink, appLink, isNew);
                }
            });
        },

        showEditAppPanel: function (editPanel, serverLink, appLink, isNew) {
            if (Ext.isEmpty(editPanel)) return;
            var view = this;
            view.appPanel = view.createTemplateControl(editPanel, 'appEditPanel');
            view.addPanelItems(editPanel, view.appEditPanel);
            view.editAppModal = KS.showModal(view.appPanel, {
                title: 'Редактирование приложения',
                autoHeight: true,
                resizable: false,
                maximizable: false,
                layout: 'anchor',
                width: 600,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditApp(appLink, isNew);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.rejectAppEditing(appLink, isNew);
                        }
                    }]
            }, true);
        },

        doEditApp: function (appLink, isNew) {
            var view = this;
            var newValues = view.collectAppEditValue();
            view.serverCall({
                method: 'EditApp',
                waitMessage: 'Сохранение ...',
                params: [newValues, appLink, isNew],
                success: function () {
                    view.editAppModal.close();
                    view.resetGrid();
                }
            });
        },

        collectAppEditValue: function () {
            return {
                "NAME": this.appName.getValue(),
                "APP_URL": this.appUrl.getValue(),
                "DESCRIPTION": this.appDescription.getValue(),
                "DB_TYPE": this.appDbType.getRawValue(),
                "DB_SERVER": this.appDbServer.getValue(),
                "DB_NAME": this.appDbName.getValue(),
                "DB_USER": this.appDbUser.getValue(),
                "DB_PASSWORD": this.appDbPassword.getValue()
            }
        },

        rejectAppEditing: function (appLink, isNew) {
            var view = this;
            view.editAppModal.close();
            view.serverCall({
                method: 'RejectAppChanges',
                params: [appLink, isNew],
                waitMessage: 'Отмена...'
            });
        },

        setGridToolbarVisibilty: function (isRowSelected) {
            var view = this,
                buttons = view.getTbarDepOnGrid();
            Ext.each(buttons,
                function (btn) {
                    if (btn)
                        btn.setDisabled(!isRowSelected);
                });
        },

        getTbarDepOnGrid: function () {
            var view = this;
            return [
                view.getToolbarItem(view.gridPanel, null, 'EDIT_APP'),
                view.getToolbarItem(view.gridPanel, null, 'DELETE_APP'),
                view.getToolbarItem(view.gridPanel, null, 'CHARTS_WINDOW')
            ];
        },

        deleteSelectedApps: function () {
            var view = this.parentView || this,
                appLinks = [],
                selectedApps = view.mainGrid.getCheckedRows();

            if (!Ext.isEmpty(selectedApps)) {
                Ext.each(selectedApps,
                    function(row) {
                        appLinks.push(KS.Grid.getAnyCase(row, "link_app"));
                    });
            }

            if (!Ext.isEmpty(appLinks)) {
                KS.confirm("Выбранные приложения будут удалены. Продолжить?",
                    "Подтвердите удаление", function (btn) {
                        if (btn === 'yes')
                            view.deleteAppsByLinks(appLinks);
                    });
            }
        },

        deleteAppsByLinks: function (appLinks) {
            var view = this;
            this.serverCall({
                method: 'DeleteApps',
                params: [appLinks],
                waitMessage: 'Удаление ...',
                success: view.resetGrid
            });
        },

        gridRowSelected: function (selModel, record) {
            var view = this;
            view.setGridToolbarVisibilty(true);
            view.selectedAppLink = record.data.link_app;
            view.selectedAppName = record.data.NAME;
            var typeValue = view.getToolbarItem(view.chartPanel, null, 'chartTypeEditor').getValue();
            view.getAppDataSeries(record.data.link_app, record.data.NAME, typeValue);
            view.getAppTextInfoPanel(record.data.link_app);
        },

        gridRowDeselected: function (selModel, record) {
            var view = this;
            view.setGridToolbarVisibilty(false);
            view.selectedAppLink = null;
            view.selectedAppName = null;
            var typeValue = view.getToolbarItem(view.chartPanel, null, 'chartTypeEditor').getValue();
            view.getDataSeriesCommon(null, typeValue);
            view.analyticsPanelRenderByTree(null);
        }
    });
}(ServiceMonitorView.prototype));

//=========================CHART========================
(function (viewClass) {
    KS.apply(viewClass, {
        editChartType: function (combo, newType) {
            var view = this;

            if (!Ext.isEmpty(view.selectedAppLink)) {
                view.getAppDataSeries(view.selectedAppLink, view.selectedAppName, newType);
                return;
            }
            else if (!Ext.isEmpty(view.selectedServerLink)) {
                view.getDataSeriesCommon(view.selectedServerLink, newType);
                return;
            }
            else view.getDataSeriesCommon(null, newType);
        },

        getDataSeriesCommon: function (serverLink, chartType) {
            var view = this,
                dateBegin = view.getToolbarItem(view.chartPanel, null, 'beginDate').getValue(),
                dateEnd = view.getToolbarItem(view.chartPanel, null, 'endDate').getValue();
            view.serverCall({
                method: 'GetCommonAppsStat',
                params: [serverLink, chartType, dateBegin, dateEnd],
                success: function (dataSeries) {
                    view.showChart(dataSeries, 'Данные по последним проверкам', 'bar');
                }
            });
        },

        getAppDataSeries: function (appLink, appName, chartType) {
            var view = this,
                dateBegin = view.getToolbarItem(view.chartPanel, null, 'beginDate').getValue(),
                dateEnd = view.getToolbarItem(view.chartPanel, null, 'endDate').getValue();
            view.serverCall({
                method: 'GetSelectedAppStat',
                params: [appLink, chartType, dateBegin, dateEnd],
                success: function (dataSeries) {
                    view.showChart(dataSeries, appName, 'area');
                }
            });
        },

        showChart: function (dataSeries, targetName, seriesType) {
            var view = this;

            if (Ext.isEmpty(dataSeries)) {
                //KS.alert("Нет данных для: " + targetName);
                return;
            }

            var title = targetName + ' | ' + view.getToolbarItem(view.chartPanel, null, 'chartTypeEditor').getRawValue();

            var chart = view.createChart(dataSeries, title, seriesType);
            view.addChartToPanel(chart);
        },

        refreshChart: function () {
            var view = this.parentView || this;
            var typeValue = view.getToolbarItem(view.chartPanel, null, 'chartTypeEditor').getValue();
            view.editChartType(null, typeValue);
        },

        cleanDates: function () {
            var view = this.parentView || this;
            view.getToolbarItem(view.chartPanel, null, 'beginDate').setValue('');
            view.getToolbarItem(view.chartPanel, null, 'endDate').setValue('');
        },

        addChartToPanel: function(chart) {
            var view = this;
            view.chartPanel.removeAll();
            view.chartPanel.add(chart);
        },

        createChart: function (dataSeries, title, seriesType) {

            if (dataSeries === null) return null;

            var fields = Object.getOwnPropertyNames(dataSeries[0]);

            var store = Ext.create('Ext.data.Store', {
                fields: fields,
                data: dataSeries
            });

            var chart = {
                xtype: 'chart',
                width: '100%',
                height: '100%',
                style: {
                    'background': '#fff'
                },
                animate: true,
                shadow: false,
                store: store,
                insetPadding: 40,
                sprites: [{
                    type: 'text',
                    text: title,
                    font: 'bold 14px Segoe UI, Tahoma, verdana, sans-serif',
                    width: 100,
                    height: 30,
                    x: 40,
                    y: 20
                }],
                axes: [{
                    type: 'numeric',
                    fields: fields[1],
                    position: 'left',
                    grid: true
                }, {
                    type: 'category',
                    fields: fields[0],
                    position: 'bottom',
                    grid: true,
                    label: {
                        rotate: {
                            degrees: -45
                        }
                    }
                }],
                series: [{
                    type: seriesType,
                    axis: 'left',
                    xField: fields[0],
                    yField: fields[1],
                    style: {
                        stroke: '#7DA4CD',
                        'stroke-width': 3,
                        opacity: 0.5
                    },
                    subStyle: {
                        fill: '#D1EBFA'
                    },
                    tips: {
                        trackMouse: true,
                        renderer: function (toolTip, record, ctx) {
                            toolTip.setHtml('Значение: ' + record.get(fields[1]) + '<br>' + record.get(fields[0]));
                        }
                    }
                }]
            };
            return chart;
        },

        getAppChartValues: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'GetAppChartValues',
                params: [view.selectedAppLink],
                success: function(valueSeries) {
                    view.createChartsWindow(valueSeries);
                }
            });
        },

        createChartsWindow: function(valueSeries) {
            var view = this,
                panels = [];

            Ext.each(valueSeries, function(serie) {
                var metricName = Object.keys(serie)[0];
                var dataSeries = serie[metricName];
                var chart = view.createChart(dataSeries, metricName, 'area');
                panels.push(view.createTableChartPanel(chart));
            });

            view.showChartsWindow(panels);
        },

        createTableChartPanel: function (chart) {
            return {
                xtype: 'panel',
                layout: 'fit',
                width: 460,
                height: 295,
                items: chart
            };
        },

        showChartsWindow: function(panels) {
            Ext.create('Ext.window.Window', {
                title: 'Графики',
                autoScroll: true,
                width: 1440,
                height: 900,
                layout: {
                    type: 'table',
                    columns: 3
                },
                items: panels
            }).show();
        }
    });
}(ServiceMonitorView.prototype));

//=========================TEXT=========================
(function (viewClass) {
    KS.apply(viewClass, {
        getCommonTextInfoPanel: function (serverLink) {
            var view = this;
            view.serverCall({
                method: 'GetCommonTextInfoPanel',
                params: [serverLink],
                success: function (panel) {
                    view.locateTextInfoPanel(panel);
                }
            });
        },

        getAppTextInfoPanel: function (linkApp) {
            var view = this;
            view.serverCall({
                method: 'GetAppTextInfoPanel',
                params: [linkApp],
                success: function (panel) {
                    view.locateTextInfoPanel(panel);
                }
            });
        },

        locateTextInfoPanel: function (statsPanel) {
            var view = this;
            view.statsPanel = view.createTemplateControl(statsPanel, 'textStats');
            view.addPanelItems(statsPanel, view.statsPanel);
            view.textInfoPanel.removeAll();
            view.textInfoPanel.add(view.statsPanel);
        }
    });
}(ServiceMonitorView.prototype));

function serviceMonitorAvailabilityRenderer(value) {
    var statusIcon;
    if (value === 'true')
        statusIcon = 'import_ok';
    else statusIcon = 'warning';

    return '<div class="ks-icon-'+ statusIcon +'" style="background-position: center;">&nbsp</div>';
}

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();