﻿SelectionResultView = KS.extend(BaseSvodView, {});

// ================ GENERAL ===================
(function (viewClass) {
    KS.apply(viewClass, {
        onInit: function () {
            if (this.data.asyncRead) {
                this.asyncStart();
            } else {
                this.processResult(this.data.resultUrl);
            }

            if (this.data.viewState.SelectionEditViewId)
                this.selectionEditView = KS.getView(this.data.viewState.SelectionEditViewId);
        },

        onTemplateRendered: function () {
            this.childViews = [];
            if (!KS.isEmpty(this.deferredAddChildViews)) {
                for (var idx = 0; idx < this.deferredAddChildViews.length; idx++) {
                    this.addChildView(this.deferredAddChildViews[idx]);
                }
                delete this.deferredAddChildViews;
            }
        },

        processResult: function(result) {
            this.data.resultUrl = result;
            if (!this.data.showResultView) {
                this.openUrl(result);
                this.close();
            }
            else {
                var view = this;
                view.renderViewTemplate();
                view.doLoadSpreadsheetView();
            }
        },

        asyncStart: function () {
            this.waitMsg = 'Формирование результата выборки.';
            this.serverCall({
                method: 'AsyncStart',
                timeout: 1000,
                cancellable: true,
                success: this.processResult,
                delay: this.checkResult
            });
        },

        checkResult: function () {
            this.waitMsg += '.';
            this.containerPanel.update(this.waitMsg);
            this.serverCall({
                method: 'GetResult',
                disableFog: true,
                success: this.checkResultCallback
            });
        },

        doLoadSpreadsheetView: function () {
            var view = this;
            view.serverCall({
                method: 'DoLoadSpreadsheetView'
            });
        },

        checkResultCallback: function (result) {
            if (result === 'error') {
                this.close();
            } else if (!Ext.isEmpty(result)) {
                this.processResult(result);
            } else {
                var view = this;
                view.progressTimerId = setTimeout(function () {
                    view.checkResult();
                }, 3000);
            }
        },

        stopProgressTimer: function () {
            if (this.progressTimerId)
                clearInterval(this.progressTimerId);
        },

        onBeforeClose: function () {
            var view = this;
            view.stopProgressTimer();
            if (view.spreadsheetView && view.spreadsheetView.spreadsheetFrame && view.spreadsheetView.spreadsheetFrame.closeSession)
                view.spreadsheetView.spreadsheetFrame.closeSession();
            return SelectionResultView.superclass.onBeforeClose.call(view);
        },
    });
}(SelectionResultView.prototype));

// ================ TOOLBAR ===================
(function (viewClass) {
    KS.apply(viewClass, {
        saveChanges: function () {
            var view = this.parentView || this;
            view.spreadsheetView.saveDocument(view.doSaveChanges, view);
        },

        createOption: function () {
            var view = this.parentView || this;
            var node = view.spreadsheetOptionsTree.getSelNode();

            if (view.isTreeNodeTableOrTableChild(node)) {
                view.openCreateColumnWin();
            }
            else if (view.isTreeNodeGroupsOrGroupsChild(node)) {
                view.createNewGroup();
            }
        },

        deleteOption: function () {
            var view = this.parentView || this;
            var node = view.spreadsheetOptionsTree.getSelNode();

            if (view.isTreeNodeArea(node)) {
                view.deleteArea(node);
            }
            else if (view.isTreeNodeAreas(node)) {
                view.askDeleteAllAreas();
            }
            else if (view.isTreeNodeTable(node)) {
                view.deleteTable();
            }
            else if (view.isTreeNodeColumn(node)) {
                view.deleteColumn(node);
            }
            else if (view.isTreeNodeGroup(node)) {
                view.deleteGroup(node);
            }
        },

        getSortGrid: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSortGrid',
                success: view.showSortWindow
            });
        },

        setEditMode: function (btn) {
            var view = btn.parentView;
            var isEditMode = btn.pressed;
            view.spreadsheetOptionsPanel.setHidden(!isEditMode);
            view.toggleSaveBtn(!isEditMode);
        },

        toggleSaveBtn: function (disabled) {
            var view = this;
            var saveBtn = view.getToolbarItem(view.selectionResultPanel, null, 'SAVE');
            saveBtn.setDisabled(disabled);
        },

        pasteOptionTreeValue: function (tree, record) {
            var view  = this;
            var nodeLink = record.data.id;

            var constNodeSelected = record.parentNode && record.parentNode.data.text === 'Константы';

            if (!constNodeSelected) return;

            var selection = view.spreadsheetView.getSelection();
            var colIndex = selection.activeCellColumnIndex;
            var rowIndex = selection.activeCellRowIndex;
            view.serverCall({
                method: 'PasteTreeOptionDisplayValue',
                params: [nodeLink, rowIndex, colIndex],
                success: function (optionValue) {
                    if (!optionValue) return;
                    view.reloadOptionsTree();
                    view.modifyAreaInSpreadsheet(colIndex, rowIndex, optionValue);
                }
            });
        }
    });
}(SelectionResultView.prototype));

// ================= SAVE =====================
(function (viewClass) {
    KS.apply(viewClass, {
        touch: function () {
            var view = this;
            view.hasChanges = true;
            view.setSavedState(false);
            view.getToolbarItem(view.selectionResultPanel, null, 'SAVE').setDisabled(false);
        },

        doSaveChanges: function () {
            var view = this;
            view.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение ...',
                success: view.afterSaveChanges
            });
        },

        afterSaveChanges: function (hasSaveErrors) {
            var view = this;
            if (hasSaveErrors === true) {
                KS.alert('Документ не сохранен!');
                return;
            }

            view.hasChanges = false;
            view.setSavedState(true);
            view.getToolbarItem(view.selectionResultPanel, null, 'SAVE').setDisabled(true);

            if (view.selectionEditView)
                view.selectionEditView.touch();
        }
    });
}(SelectionResultView.prototype));

// ================= TREE =====================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadOptionsTree: function () {
            this.spreadsheetOptionsTree.getRootNode().removeAll(true);
            this.spreadsheetOptionsTree.fullReload();
        },

        expandAllTreeNodes: function () {
            var view = this;
            view.spreadsheetOptionsTree.expandAll();
        },

        optionsTreeNodeSelect: function (treeModel, selected) {
            var view = this;
            if (!selected || selected.length === 0) return;
            var nodeLink = selected[0].data.id;
            view.serverCall({
                method: 'GetPropertyDataForSelectedNode',
                params: [nodeLink],
                success: function (settings) {
                    view.optionsPropertyGrid = view.getPropertyGridByOption(settings, 'optionsPropertyGrid', 'Свойства');
                    view.optionsPropertyGrid.on('propertychange', view.optionPropertyChange, view);
                    view.spreadsheetOptionsGridPanel.removeAll();
                    view.spreadsheetOptionsGridPanel.add(view.optionsPropertyGrid);
                }
            });
        },

        optionPropertyChange: function(source, recordId, value) {
            var view = this;
            var code = recordId.split('#')[1];
            var codeParts = code.split('|');

            if (codeParts.length !== 3) return;

            var type = codeParts[0];
            var key = codeParts[1];
            var nodeLink = codeParts[2];

            view.serverCall({
                method: 'SetOptionPropValue',
                disableFog: true,
                params: [type, key, nodeLink, value],
                success: function(result) {
                    if (result && result.newValue) {
                        view.optionsPropertyGrid.setProperty(recordId, result.newValue);

                        if (type === 'Column' && (key === 'Text' || key === 'Formula')) {
                            var text = view.getPropertyValueFromSource(source, 1, type, 'Text', nodeLink);
                            var formula = view.getPropertyValueFromSource(source, 3, type, 'Formula', nodeLink);
                            view.modifyColumnInSpreadsheet(result.additionalObj.columnIndex, result.additionalObj.rowIndex, text, formula, result.additionalObj.constantsDict);
                        }
                        else if (type === 'Area') {
                            var areaFormula = view.getPropertyValueFromSource(source, 1, type, 'Formula', nodeLink);
                            view.modifyAreaInSpreadsheet(result.additionalObj.columnIndex, result.additionalObj.rowIndex, areaFormula)
                        }
                    }
                }
            });
        },

        getPropertyValueFromSource: function (source, propIdx, type, key, nodeLink) {
            var formattedIdx = ("0" + propIdx).slice(-2) + '#';
            return source[formattedIdx + type + '|' + key + '|' + nodeLink];
        },

        isTreeNodeTableOrTableChild: function (node) {
            if (!node) return false;
            return node.data.text === 'Таблица' ||
                (node.parentNode && node.parentNode.data.text === 'Таблица');
        },

        isTreeNodeGroupsOrGroupsChild: function (node) {
            if (!node) return false;
            return node.data.text === 'Группы' ||
                (node.parentNode && node.parentNode.data.text === 'Группы');
        },

        isTreeNodeArea: function (node) {
            if (!node) return false;
            return (node.parentNode && node.parentNode.data.text === 'Области');
        },

        isTreeNodeAreas: function (node) {
            if (!node) return false;
            return (node.data.text === 'Области');
        },

        isTreeNodeTable: function (node) {
            if (!node) return false;
            return (node.data.text === 'Таблица');
        },

        isTreeNodeColumn: function (node) {
            if (!node) return false;
            return (node.parentNode && node.parentNode.data.text === 'Таблица');
        },

        isTreeNodeGroup: function (node) {
            if (!node) return false;
            return (node.parentNode && node.parentNode.data.text === 'Группы');
        },

        openCreateColumnWin: function () {
            var view = this;
            view.serverCall({
                method: 'GetCreateColumnProperties',
                success: function (properties) {
                    view.createColumnGrid = view.getPropertyGridByOption(properties, 'createColumnGrid', 'Свойства');
                    view.openCreateOptionWin(view.createColumnGrid, view.createNewCalcColumn);
                }
            });
        },

        createNewCalcColumn: function () {
            var view = this;
            var source = view.createColumnGrid.getSource();
            var name = source['00#newColumnName'];
            var text = source['01#newColumnText'];
            var formula = source['02#newColumnFormula'];
            view.serverCall({
                method: 'CreateNewCalcColumn',
                params: [name, text, formula],
                success: function (tableColumnCoords) {
                    view.createOptionWin.close();
                    view.afterTreeStoreChange();
                    view.addNewColumnToSpreadsheet(tableColumnCoords.columnIndex, tableColumnCoords.rowIndex, text, formula);
                }
            })
        },

        createNewGroup: function () {
            var view = this;
            view.serverCall({
                method: 'CreateNewGroup',
                success: view.afterTreeStoreChange
            });
        },

        openCreateOptionWin: function (propertyGrid, okHandler) {
            var view = this;
            view.createOptionWin = KS.showModal(propertyGrid, {
                title: 'Свойства',
                autoHeight: false,
                layout: 'anchor',
                height: 400,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            okHandler.call(view);
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.createOptionWin.close();
                        }
                    }]
            }, true);
        },

        deleteArea: function(node) {
            var view = this;
            view.serverCall({
                method: 'DeleteArea',
                params: [node.data.id],
                success: function (result) {
                    if (!result) return;

                    view.afterTreeStoreChange();
                    view.deleteAreaFromSpreadsheet(result.colIndex1, result.rowIndex1, result.colIndex2, result.rowIndex2);
                }
            });
        },

        askDeleteAllAreas: function () {
            var view = this;
            KS.confirm('Удалить все области?', 'Внимание', function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteAllAreas',
                        success: view.afterTreeStoreChange
                    });
                }
            });
        },

        deleteTable: function (node) {
            var view = this;
            view.serverCall({
                method: 'DeleteTable',
                params: [node.data.id],
                success: view.afterTreeStoreChange
            });
        },

        deleteColumn: function (node) {
            var view = this;
            view.serverCall({
                method: 'DeleteColumn',
                params: [node.data.id],
                success: function (result) {
                    if (!result || !result.deleted) return;

                    view.afterTreeStoreChange();
                    view.deleteColumnFromSpreadsheet(result.columnIndex);
                }
            });
        },

        deleteGroup: function (node) {
            var view = this;
            view.serverCall({
                method: 'DeleteGroup',
                params: [node.data.id],
                success: view.afterTreeStoreChange
            });
        },

        afterTreeStoreChange: function () {
            var view = this;
            view.reloadOptionsTree();
            view.expandAllTreeNodes();
        }
    });
}(SelectionResultView.prototype));

// =============== SPREADSHEET ================
(function (viewClass) {
    KS.apply(viewClass, {
        onSpreadsheetDocumentChanged: function (s, e) {
            var view = this;
            var spreadsheetState = s.getSpreadsheetState();
            //view.touch();
        },

        onSpreadsheetCellEndEdit: function (s, e) {
            var view = this;
            var columnIndex = e.columnIndex;
            var rowIndex = e.rowIndex;
            var newValue = e.editorText;
            var formula = e.formula;

            view.serverCall({
                method: 'OnSpreadsheetCellEdit',
                params: [columnIndex, rowIndex, newValue, formula],
                success: view.reloadOptionsTree
            });
        },

        addChildView: function (panel) {
            if (!this.selectionSpreadsheetPanel) {
                // Parent view is not ready, render child later
                if (!this.deferredAddChildViews) {
                    this.deferredAddChildViews = [];
                }
                this.deferredAddChildViews.push(panel);
                return true;
            }
            
            panel.header = false;
            if (this.selectionSpreadsheetPanel) {
                this.selectionSpreadsheetPanel.removeAll();
                this.selectionSpreadsheetPanel.add(panel);
                var childView = eval(panel.classInstance);
                if (childView) {
                    this.childViews = [childView];
                    this.spreadsheetView = childView;
                    childView.parentView = this;
                }
                KS.updateLayout(this.selectionSpreadsheetPanel);
                this.selectionSpreadsheetPanel.unmask();
                return true;
            }

            return false;
        },

        downloadSpreadsheet: function () {
            var view = this.parentView || this;
            //view.spreadsheetView.downloadFile();
            view.openUrl(view.data.resultUrl);
        },

        addNewColumnToSpreadsheet: function (colIndex, rowIndex, columnText, dataFormula) {
            var view = this;
            var spreadsheetState = view.spreadsheetView.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/AddNewColumnToTable',
                data: {
                    spreadsheetState: spreadsheetState,
                    rowIndex: rowIndex,
                    colIndex: colIndex,
                    columnText: columnText,
                    dataFormula: dataFormula
                },
                success: function () {
                    view.spreadsheetView.reloadFrame();
                }
            });
        },

        modifyColumnInSpreadsheet: function (colIndex, rowIndex, columnText, dataFormula, constantsObj) {
            var view = this;
            var spreadsheetState = view.spreadsheetView.spreadsheet.getSpreadsheetState();

            var constantsDict = [];
            Ext.each(Object.keys(constantsObj), function (key) {
                constantsDict.push({key: key, value: constantsObj[key]});
            });

            $.ajax({
                type: 'POST',
                url: 'Devexpress/ModifyExistingColumnInTable',
                data: {
                    spreadsheetState: spreadsheetState,
                    rowIndex: rowIndex,
                    colIndex: colIndex,
                    columnText: columnText,
                    dataFormula: dataFormula,
                    constantsDict: constantsDict
                },
                success: function () {
                    view.spreadsheetView.reloadFrame();
                }
            });
        },

        deleteColumnFromSpreadsheet: function (colIndex, rowIndex) {
            var view = this;
            var spreadsheetState = view.spreadsheetView.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/DeleteColumnFromTable',
                data: {
                    spreadsheetState: spreadsheetState,
                    rowIndex: rowIndex,
                    colIndex: colIndex
                },
                success: function () {
                    view.spreadsheetView.reloadFrame();
                }
            });
        },

        modifyAreaInSpreadsheet: function (colIndex, rowIndex, areaFormula) {
            var view = this;
            var spreadsheetState = view.spreadsheetView.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/ModifyAreaFormula',
                data: {
                    spreadsheetState: spreadsheetState,
                    rowIndex: rowIndex,
                    colIndex: colIndex,
                    areaFormula: areaFormula
                },
                success: function () {
                    view.spreadsheetView.reloadFrame();
                }
            });
        },

        deleteAreaFromSpreadsheet: function (colIndex1, rowIndex1, colIndex2, rowIndex2) {
            var view = this;
            var spreadsheetState = view.spreadsheetView.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/DeleteRangeWithoutShift',
                data: {
                    spreadsheetState: spreadsheetState,
                    colIndex1: colIndex1,
                    rowIndex1: rowIndex1,
                    colIndex2: colIndex2,
                    rowIndex2: rowIndex2
                },
                success: function () {
                    view.spreadsheetView.reloadFrame();
                }
            });
        },

        setTableSorts: function (tableColIndex, tableRowIndex, columnsCount, sorts) {
            var view = this;
            var spreadsheetState = view.spreadsheetView.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/SetTableSorts',
                data: {
                    spreadsheetState: spreadsheetState,
                    tableColIndex: tableColIndex,
                    tableRowIndex: tableRowIndex,
                    columnsCount: columnsCount,
                    sorts: sorts
                },
                success: function () {
                    view.spreadsheetView.reloadFrame();
                }
            });
        }
    });
}(SelectionResultView.prototype));

// ================= SORT =====================
(function (viewClass) {
    KS.apply(viewClass, {
        showSortWindow: function (grid) {
            var view = this;
            view.sortGrid = view.createTemplateControl(grid);
            view.sortWin = KS.showModal(view.sortGrid, {
                title: 'Сортировка',
                autoHeight: false,
                layout: 'anchor',
                height: KS.rootViewport.getHeight() * 0.7,
                width: KS.rootViewport.getWidth() * 0.5,
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.saveSortChanges();
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectSortChanges();
                        }
                    }]
            }, true);
        },

        setCaseSensitiveSort: function (checkbox, checked) {
            var view = this;
            view.serverCall({
                method: 'SetCaseSensitiveSort',
                params: [checked]
            });
        },

        sortGridEditCell: function(edPlugin, context) {
            var view = this;
            var dataIndex = context.field;
            if (context.originalValue !== context.value) {
                var closeCode = KS.Grid.getAnyCase(context.record, view.sortGrid.closeCode);
                var newValue = context.value;
                view.serverCall({
                    method: 'SortGridEditCell',
                    disableFog: true,
                    params: [closeCode, dataIndex, newValue],
                    success: function(result) {
                        if (result === false)
                            context.record.reject();
                    }
                });
            }
        },

        addNewSort: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddNewSort',
                disableFog: true,
                success: function (dataRow) {
                    view.sortGrid.addRecord(dataRow);
                }
            });
        },

        deleteSort: function () {
            var view = this.parentView || this;
            var checkedRow = view.sortGrid.getCheckedRows()[0];
            var key = checkedRow.data["KEY"];
            view.serverCall({
                method: 'DeleteSort',
                params: [key],
                disableFog: true,
                success: function (result) {
                    if (result)
                        view.sortGrid.getStore().remove(checkedRow);
                }
            });
        },

        moveSortUp: function () {
            var view = this.parentView || this;
            view.moveSort(1);
        },

        moveSortDown: function () {
            var view = this.parentView || this;
            view.moveSort(-1);
        },

        moveSort: function (direction) {
            var view = this;
            var checkedRow = view.sortGrid.getCheckedRows()[0];
            if (!checkedRow) return;
            var key = checkedRow.data["KEY"];
            view.serverCall({
                method: 'MoveSort',
                params: [key, direction],
                disableFog: true,
                success: function (newOrder) {
                    if (!Ext.isEmpty(newOrder)) {
                        var replacingRow = view.sortGrid.getStore().getAt(newOrder);
                        view.sortGrid.getStore().remove(checkedRow);
                        checkedRow.set("ORDER", newOrder);
                        view.sortGrid.getStore().insert(newOrder, checkedRow);
                        replacingRow.set("ORDER", newOrder - direction);
                    }
                }
            });
        },

        saveSortChanges: function () {
            var view = this;
            view.serverCall({
                method: 'SaveSortChanges',
                success: function (result) {
                    view.sortWin.close();
                    view.setTableSorts(result.tableColIndex, result.tableRowIndex, result.columnsCount, result.sorts);
                }
            });
        },

        rejectSortChanges: function () {
            var view = this;
            view.serverCall({
                method: 'RejectSortChanges',
                success: function () {
                    view.sortWin.close();
                }
            });
        }
    });
}(SelectionResultView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();