﻿SelectionListView = KS.extend(BaseTreeView, {
    deleteConfirmMsg: 'Удалить выделенные выборки?',

    getTbarClickHandler: function (tbarItem) {
        switch (tbarItem.code) {
            case 'SELECT':
            case 'OPEN_IN_EXCEL':
                return this.execute;

            case 'TEMPLATE_ORG':
                return this.openTemplateOrg;
        }
        return SelectionListView.superclass.getTbarClickHandler.call(this, tbarItem);
    },

    newHandler: function () {
        var view = this.parentView,
            rawAdditional = {
                'GROUP_LINK': view.getSelectedNodeId(),
                'FAKE_LINK': KS.getFakeLink()
            };
        view.backgroundOperation("CREATE_SELECTION", true, 'Создание', null, rawAdditional);
    },

    copyHandler: function () {
        var view = this.parentView,
            ccc = view.mainGrid.getCheckedCodes(true);
        if (Ext.isEmpty(ccc)) return;
        var rawAdditional = {
            'COPY_LINK': ccc[0],
            'GROUP_LINK': view.getSelectedNodeId(),
            'FAKE_LINK': KS.getFakeLink()
        };
        view.backgroundOperation("CREATE_SELECTION", true, 'Копирование', null, rawAdditional);
    },

    execute: function () {
        var view = this.parentView || this,
            grid = view.findOwnerContainer(this, view.isGrid),
            ccc = (grid) ? grid.getCheckedCodes(true) : [];
        if (Ext.isEmpty(ccc)) return;
        this.parentView.backgroundOperation('OPEN_IN_EXCEL', true, 'Выполнение');
    },

    openTemplateOrg: function() {
        var view = this.parentView;
        view.serverCall({
            method: 'OpenTemplateOrg'
        });
    }
});

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();