﻿SavedFormStatusesDictionaryView = KS.extend(BaseDictionaryView, {});

(function (viewClass) {
    var sc = SavedFormStatusesDictionaryView.superclass;

    KS.apply(viewClass, {
        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'NASTR':
                    return this.openStatusDictSettings;
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },
        
        onBeforeClose: function () {
            if (Ext.isEmpty(this.getToolbarItem(this.mainGrid, null, "SAVE"))) { // Если нет кнопки сохранить (не админ), то просто закрываем
                this.close();
                return false;
            }
            return sc.onBeforeClose.call(this);
        },

        addRecordCallback: function(result){
            if (result)
                this.configureNewRow();
        },

        configureNewRow: function(){
            var view = this;
            view.serverCall({
                method: "ConfigureNewRow",
                success: function(){
                    view.resetGrid();
                    if (view.hasSaveButton())
                        view.touch();
                }
            });           
        },

        editGridCell: function(plugin, context) {
            if (context.value === context.originalValue) return false;
            var dataIndex = context.field;
            var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
            this.serverCall({
                method: "EditGridCell",
                disableFog: true,
                params: [context.value, dataIndex, closeCode]
            });
            return true;
        },

        rowDblClickHandler: function(gridView, record, element, rowIndex, e) {
            if (e.position.column.renderer === statusesImageRenderer) {
                this.editImageCell(record, e.position.column.dataIndex);
                return false;
            }
            return true;
        },
        
        editImageCell: function(record, dataIndex){
            var isSystem = KS.Grid.getAnyCase(record, "IS_SYSTEM");
            if (Ext.isEmpty(isSystem) || isSystem == "0"){
                var value = KS.Grid.getAnyCase(record, dataIndex);
                var closeCode = KS.Grid.getAnyCase(record, record.store.grid.closeCode);
                var view = this;
                view.imageCellInfo = {
                    record : record,
                    dataIndex : dataIndex,
                    closeCode : closeCode
                };
                view.serverCall({
                    method: "GetImageCellPanel",
                    disableFog: true,
                    params: [value],
                    success: function(panel){
                        view.showImageCellPanel(panel);
                    }
                });
            } else {
                KS.alert("Редактирование изображений системных статусов запрещено", "Внимание");
            }
        },

        showImageCellPanel: function(imageCellPanel){
            if (Ext.isEmpty(imageCellPanel)) return;
            var view = this;            
            view.imageCellPanel = view.createTemplateControl(imageCellPanel);
            view.imageCellWin = KS.showModal(view.imageCellPanel,{
                layout: 'fit',
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: false,
                minWidth: 350,
                minHeight: 150,
                width: 350,
                height: 150,
                title: "Редактирование изображения...",
                buttonAlign: 'center',
                buttons: new Array({
                    text: 'ОК',
                    cls: 'marked-button',
                    handler: function () {
                        view.imageCellWin.close();
                        view.imageCellInfo = null;
                    }
                })
            }, true);
            
            var selectFileBtn = Ext.getCmp("selectImageFileBtn");
            if (!KS.isEmpty(selectFileBtn)) {
                selectFileBtn.fileInputEl.dom.multiple = false;
                selectFileBtn.fileInputEl.dom.accept = "image/*";
            }
        },

        cleanImageCell: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'ClearImageCell',
                params: [view.imageCellInfo.dataIndex, view.imageCellInfo.closeCode],
                success: function(hasChanged) {
                    if (view.imageCellInfo && hasChanged){
                        view.imageCellPanel.setHtml("");
                        view.imageCellInfo.record.set(view.imageCellInfo.dataIndex, "");
                        view.touch();
                    }
                }
            });
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            var file = fileKeys[0];
            view.serverCall({
                method: 'SaveImageFile',
                params: [file, view.imageCellInfo.dataIndex, view.imageCellInfo.closeCode],
                success: function(imageBase64) {
                    if (view.imageCellInfo && imageBase64){
                        view.imageCellPanel.setHtml("<img width='30' height='30' src='data:image/png;base64," + imageBase64 + "'/>");
                        view.imageCellInfo.record.set(view.imageCellInfo.dataIndex, imageBase64);
                        view.touch();
                    }
                }
            });
        },

        openStatusDictSettings: function(){
            var view = this.parentView || this;
            view.tryExecuteSvodTask(0, 'NASTR');    
        }        
    });
}(SavedFormStatusesDictionaryView.prototype));

function statusesImageRenderer(value) {
    return Ext.isEmpty(value) ? "" : "<img src='data:image/png;base64," + value + "'/>";
}