﻿// ============= VIEW =======================
SavedFormImportView = KS.extend(BaseSvodView, {
    constructor: function (viewId) {
        SavedFormImportView.superclass.constructor.call(this, viewId);
    }
});

// ============= OnTemplateFunction =======================
(function(viewClass) {
    KS.apply(viewClass, {
        
        helpBtn: function () {
            var href = "Docs/html/index.html";
            href += '?' + '2010' + '.htm';
            window.open(href, "_blank", "status=yes,location=yes,toolbar=yes,resizable=yes,menubar=yes,scrollbars=yes");
        }
    });
}(SavedFormImportView.prototype));

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        getOption: function(name) {
            return this.getToolbarItem(this.importPanel, "bottom", "importProps").getComponent(name);
        },

        addExistsCheckHandler: function(ctrl, checked) {
            this.getOption('addMode').setDisabled(!checked);
            KS.updateLayout(this.importPanel);
        },

        onValuesSelected: function (arg) {
            var view = this;
            $.each(arg[0], function (i, v) {
                if ('MODEL_DATA' in v) view.setData(v['MODEL_DATA']);
            });
            var action = arg[0][0]['IMPORT_ACTION'];
            if (action === 'START_IMPORT')
                this.doImport();
        }
    });
}(SavedFormImportView.prototype));

// ============= MAIN GRID =======================
(function (viewClass) {
    KS.apply(viewClass, {
        showDetails: function () {
            var rec = this.mainGrid.getSelectedRecs()[0];
            if (rec) {
                this.detailsPanel.update(KS.Grid.getAnyCase(rec, 'DETAILS'));
                this.displayTables(KS.Grid.getAnyCase(rec, 'LINK_FORM'));
            }
        },

        dblClickHandler: function (gridView, td, cellIndex, record, tr, rowIndex) {
            var grid = gridView.grid;
            var view = this,
                rec = grid.store.getAt(rowIndex),
                formLink = KS.Grid.getAnyCase(rec, 'LINK_FORM'),
                renderer = grid.getColCfgByIndex(cellIndex).renderer;

            switch (renderer) {
                case importBudgetRenderer:
                    view.selectBudget(rowIndex);
                    break;
                case importPeriodRenderer:
                    view.selectPeriod(rec);
                    break;
                case importAttrRenderer:
                    view.selectAttributes(rowIndex);
                    break;
                case importColumnsRenderer:
                    view.displayTables(formLink);
                    view.importPanel.southRegion.expand();
                    break;
            }

            return false;
        },

        findRecByLink: function (link) {
            return this.mainGrid.findRowByField("LINK_IMPORT_SAVED_FORM", link);
        },

        setData: function (data) {
            if (data) {
                Ext.apply(this.data, data);
                this.mainGrid.reload();
            }
        },

        checkValid: function () {
            var view = this,
                grid = view.mainGrid,
                notValidRowCount = 0,
                indexFirstNotValidRow = 0,
                rowCount = grid.store.getCount();

            grid.store.each(function (r) {
                var validateResult = view.validateRow(r);
                r.set("CHECKED", validateResult);
                if (!validateResult) {
                    notValidRowCount++;
                    if (notValidRowCount === 1) {
                        indexFirstNotValidRow = grid.store.indexOf(r);
                    }
                }
            });

            if (rowCount > 0) {
                grid.select(0);
            }

            if (rowCount === 1) {
                var rec = grid.store.getAt(0);
                if (!view.isPeriodSelected(rec)) {
                    view.selectPeriod(rec);
                } else if (!view.isBudgOrgSelected(rec)) {
                    view.selectBudget(0);
                }
            }

            if (notValidRowCount > 0 && rowCount > 1 && view.data.budgetTreeNodeCount > 1) {
                grid.store.each(function (r) {
                    r.set("CHECKED", !r.get("CHECKED"));
                });
                view.selectBudget(indexFirstNotValidRow);
            }
        },

        validateRow: function (rec) {
            if (isValidImportRow(rec)) {
                return true;
            } else {
                var reasons = KS.Grid.getAnyCase(rec, 'INVALID_REASONS');
                if (!Ext.isEmpty(reasons)) {
                    Ext.each(reasons.split(';'), function (reason) {
                        if (!Ext.isEmpty(reason)) {
                            KS.msg(reason);
                        }
                    });
                }
                rec.set("CHECKED", false);
                return false;
            }
        },

        isBudgOrgSelected: function (rec) {
            return KS.Grid.getAnyCase(rec, "INVALID_ORG_ONLY").toLowerCase() !== 'true';
        },

        isPeriodSelected: function (rec) {
            return (KS.Grid.getAnyCase(rec, 'PERIOD_TYPE') > 0 && KS.Grid.getAnyCase(rec, 'PERIOD_YEAR') > 0);
        },

        getAllChecked: function(store) {
            var res = [];
            store.each(function(rec) {
                if (KS.Grid.getAnyCase(rec, "CHECKED") === true) {
                    res.push(rec);
                }
            });
            return res;
        },

        getSelected: function (field) {
            var view = this,
                store = view.mainGrid.getStore();

            var selectedRecords = view.getAllChecked(store);
            if (Ext.isEmpty(selectedRecords)) {
                selectedRecords = view.mainGrid.getSelection();
            }
            var hasErrors = false,
                links = [];
            Ext.each(selectedRecords, function (rec) {
                if (field === 'checked') {
                    links.push(store.indexOf(rec));
                } else {
                    if (view.validateRow(rec)) {
                        links.push(rec.get(field));
                    } else {
                        hasErrors = true;
                    }
                }
            });

            view.mainGrid.getView().refresh();
            if (hasErrors) {
                return [];
            }
            return links;
        },

        selectBudget: function (rowIndex) {
            var chkIndexes = this.getSelected('checked');
            this.serverCall({
                method: 'SelectBudget',
                params: [rowIndex, chkIndexes],
                waitMessage: 'Открытие справочника ...',
                success: this.setData
            });
        },

        selectAttributes: function (rowIndex) {
            var chkIndexes = this.getSelected('checked');
            this.serverCall({
                method: 'SelectAttributes',
                params: [rowIndex, chkIndexes],
                waitMessage: 'Открытие справочника ...',
                success: this.setData
            });
        },

        selectPeriod: function (rec) {
            var view = this;
            view._tplCtrls = [];

            view.winPeriod = new Ext.Window({
                layout: 'fit',
                title: 'Период',
                maximizable: false,
                resizable: false,
                modal: true,
                plain: true,
                frame: true,
                width: 350,
                height: 140,
                link: KS.Grid.getAnyCase(rec, 'LINK_IMPORT_SAVED_FORM'),
                items: view.period = this.createTemplateControl(this.tpl.controls['period']),
                tbar: new Ext.Toolbar({
                    buttonAlign: 'left',
                    items: view.forAllChecked = new Ext.form.Checkbox({
                        xtype : "checkbox", 
                        boxLabel  : 'Для всех отмеченных',
                        checked : true
                    })
                }),
                bbar: new Ext.Toolbar({
                    buttonAlign: 'right',
                    items: ["->", {
                        text: 'Применить',
                        width: 90,
                        cls: 'marked-button',
                        scope: view,
                        handler: view.doSelectPeriod
                    }]
                })
            }).show();

            var pType = +(KS.Grid.getAnyCase(rec, 'PERIOD_TYPE'));
            if (!(pType > 0)) pType = 1;
            view.period.setType(pType);

            var year = +(KS.Grid.getAnyCase(rec, 'PERIOD_YEAR'));
            if (!(year > 0)) year = new Date().getFullYear();
            view.period.setYear(year);

            var pNumber = +(KS.Grid.getAnyCase(rec, 'PERIOD_NUMBER'));
            if (!(pNumber > 0)) pNumber = 1;
            view.period.setNumber(pNumber);
        },

        doSelectPeriod: function () {
            var view = this,
                periodType = view.period.getType(),
                year = view.period.getYear(),
                periodNumber = view.period.getNumber(),
                chkIndexes;
            if (view.forAllChecked && view.forAllChecked.getValue())
                chkIndexes = view.getSelected('checked');
            else
                chkIndexes = [view.grid.store.indexOf(view.grid.getSelectedRecs()[0])];

            view.serverCall({
                method: 'SelectPeriod',
                params: [view.winPeriod.link, chkIndexes, periodType, year, periodNumber],
                waitMessage: 'Установка периода ...',
                success: view.setData
            });
            view.winPeriod.close(true);
        },

        urlClick: function(columnKey, linkImport, fileName){
            var view = this;
            var confirmMsg = "";
            switch (columnKey){
                case 'LINK_REPORT':
                    confirmMsg = "Перейти к отчету?";
                    break;
                case 'LINK_PROTOCOL':
                    confirmMsg = "Открыть протокол импорта отчета?";
                    break;
                case 'FILE_NAME':
                    confirmMsg = "Открыть файл " + fileName + "?";
                    break;
            }
            if (!Ext.isEmpty(confirmMsg)) {
                KS.confirm(confirmMsg, "Подтвердите действие", function (btn) {
                    if (btn === 'yes'){
                        view.serverCall({
                            method: 'UrlClick',
                            params: [columnKey, linkImport]
                        });
                    }
                });
            }
        }
    });
}(SavedFormImportView.prototype));

// ============= TABLES/COLUMNS =======================
(function(viewClass) {
    KS.apply(viewClass, {

        displayTables: function (formLink) {
            var view = this,
                tables = view.findFormTablesList(formLink);
            view.tablesGrid.store.removeAll();
            view.columnsGrid.store.removeAll();

            Ext.each(tables, function (tableDesc) {
                var newRec = {
                        formLink: tableDesc.FormLink,
                        tableLink: tableDesc.TableLink,
                        CHECKED: tableDesc.Checked,
                        Name: tableDesc.Name
                    };
                var newRow = view.tablesGrid.addRecord(newRec);
                view.tablesGrid.checkRecord(newRow, newRec.CHECKED);
            });
        },

        displayTableColumns: function (tableLink) {
            var view = this,
                columns = view.findTableColumnsList(tableLink);
            view.columnsGrid.store.removeAll();

            Ext.each(columns, function (columnDesc) {
                    var newRec = {
                            columnLink: columnDesc.ColumnLink,
                            tableLink: columnDesc.TableLink,
                            CHECKED: columnDesc.Checked,
                            Name: columnDesc.Name
                        };
                    var newRow = view.columnsGrid.addRecord(newRec);
                    view.columnsGrid.checkRecord(newRow, newRec.CHECKED);
                });
        },    
        
        cellClickTablesAndColumns: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            if (cellIndex === 0) {
                if (gridView.grid === this.tablesGrid) {
                    this.checkTable(null, rowIndex, record, KS.Grid.getAnyCase(record, 'CHECKED'));
                } else {
                    this.checkColumn(null, rowIndex, record, KS.Grid.getAnyCase(record, 'CHECKED'));
                }
            } else if (gridView.grid === this.tablesGrid) {
                this.displayTableColumns(KS.Grid.getAnyCase(record, 'tableLink'));
            }
        },

        checkTable: function (sm, rowIndex, rec, checked) {
            var tl = KS.Grid.getAnyCase(rec, 'tableLink'),
                td = this.findTableDescription(tl);
            if (td) {
                td.Checked = checked;
                var columnsList = this.findTableColumnsList(td.TableLink);
                Ext.each(columnsList, function (cd) {
                    cd.Checked = td.Checked;
                });
                
                var selTable = this.tablesGrid.getSelectedRecs()[0];
                if (selTable && selTable.data.tableLink == td.TableLink)
                    this.displayTableColumns(td.TableLink);
            }
        },

        checkColumn: function (sm, rowIndex, rec, checked) {
            var cl = KS.Grid.getAnyCase(rec, 'columnLink'),
                cd = this.findColumnDescription(cl);
            if (cd) {
                cd.Checked = checked;
            }
        },

        getCheckedColumns: function () {
            var view = this,
                formLinks = view.getSelected('LINK_FORM'),
                links = view.getSelected('LINK_IMPORT_SAVED_FORM'),
                hasUnchecked = false,
                res = {};

            Ext.each(links, function (link, idx) {
                var tablesList = view.findFormTablesList(formLinks[idx]),
                    checkedColumns = [];
                Ext.each(tablesList, function (td) {
                    var columnsList = view.findTableColumnsList(td.TableLink);
                    Ext.each(columnsList, function (cd) {
                        if (cd.Checked) {
                            checkedColumns.push(cd.ColumnLink);
                        } else {
                            hasUnchecked = true;
                        }
                    });
                });
                res[link] = checkedColumns;
            });
            return hasUnchecked ? res : null;
        },
 
        findFormTablesList: function (formLink) {
            var res = [];
            Ext.each(this.data.tablesList, function (td) {
                if (formLink == td.FormLink) {
                    res.push(td);
                }
            });
            return res;
        },

        findTableDescription: function (tableLink) {
            var res = null;
            Ext.each(this.data.tablesList, function (td) {
                if (tableLink == td.TableLink) {
                    res = td;
                }
            });
            return res;
        },

        findTableColumnsList: function (tableLink) {
            var td = this.findTableDescription(tableLink);
            return (td) ? td.ColumnsList : null;
        },

        findColumnDescription: function (columnLink) {
            var res = null;
            Ext.each(this.data.tablesList, function (td) {
                Ext.each(td.ColumnsList, function (cd) {
                    if (columnLink == cd.ColumnLink) {
                        res = cd;
                    }
                });
            });
            return res;
        }
    });
}(SavedFormImportView.prototype));

// ============= UPLOAD/ANALYZE/IMPORT =======================
(function(viewClass) {
    KS.apply(viewClass, {
        saveFiles: function (fileKeys,a,file) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DoAnalyze',
                params: [fileKeys, file.lastValue],
                waitMessage: 'Анализ ...',
                success: function(data) {
                    view.hideResultColumns(true);
                    view.setData(data);
                }
            });
        },

        doPrepareImport: function (forceFewVersions) {
            var view = this.parentView || this;
            var addModeValue = null;

            var tempValue = view.getOption('addMode').getValue();
            if (!KS.IsEmpty(tempValue)) {
                for (var fieldName in tempValue) {
                    addModeValue = tempValue[fieldName];
                }
            }

            var options = {
                    'CALC_RESULTS': view.getOption('calcResults').getValue(),
                    'ADD_EXISTS': view.getOption('addExists').getValue(),
                    'CHECK_KS': view.getOption('checkKS').getValue(),
                    'ADD_MODE': addModeValue,
                    'FORCE_FEW_VERSIONS': (forceFewVersions === true)
                },
                columns = view.getCheckedColumns();

            view.linksToProcess = view.getSelected('LINK_IMPORT_SAVED_FORM');
            if (Ext.isEmpty(view.linksToProcess)) return;
            view.allCount = view.linksToProcess.length;

            view.serverCall({
                method: 'DoPrepareImport',
                waitMessage: 'Инициализация ...',
                params: [columns, view.linksToProcess, options],
                success: function (result) {
                    if (result === false) {
                        view.doImport();
                    } else if (result === 1) {
                        KS.confirm('Вы действительно хотите импортировать несколько версий одного отчета на один уровень бюджета?', 'Подтверждение',
                            function (btn) {
                                if (btn === 'yes') view.doPrepareImport(true);
                            });
                    }
                }
            });
        },

        doImport: function () {
            if (Ext.isEmpty(this.linksToProcess)) return;
            this.processingLink = this.linksToProcess.splice(0, 1);
            var rec = this.findRecByLink(this.processingLink);
            if (Ext.isEmpty(this.processingLink) || Ext.isEmpty(rec)) {
                this.processImportResult(this.data);
                return;
            }

            this.serverCall({
                method: 'DoImport',
                waitMessage: 'Импорт файла ' + KS.Grid.getAnyCase(rec, "FILE_NAME") + ' (' + (this.allCount - this.linksToProcess.length) + ' из ' + this.allCount + ')',
                params: [this.processingLink],
                success: this.processImportResult
            });
        },

        processImportResult: function (data) {
            if (this.getOption('checkKS').getValue()) {
                this.serverCall({
                    method: 'CheckKS',
                    waitMessage: 'Проверка КС ...',
                    params: [this.processingLink]
                });
            }

            if (Ext.isEmpty(this.linksToProcess)) {
                this.finalizeImport(data);
            } else {
                this.doImport();
            }
        },

        finalizeImport: function (data) {
            if (!data) return;
            this.mainGrid.reload();
            this.hideResultColumns(false);
            if (data.fullProtocol) {
                KS.showModal({
                    html: data.fullProtocol
                }, {
                    modal: false,
                    title: 'Протокол импорта',
                    tbar: new Array({
                        text: 'Excel',
                        iconCls: 'ks-icon-excel',
                        scope: this,
                        handler: this.getExcelProtocol
                    })
                });
            }
        },

        hideResultColumns: function(hiddenState){
            var linkReportCol = this.mainGrid.getColConfigByKey('LINK_REPORT');
            if (linkReportCol)
                linkReportCol.setHidden(hiddenState);
            var linkProtocolCol = this.mainGrid.getColConfigByKey('LINK_PROTOCOL');
            if (linkProtocolCol)
                linkProtocolCol.setHidden(hiddenState);
        },

        getExcelProtocol: function () {
            this.serverCall({
                method: 'GetExcelProtocol',
                waitMessage: 'Получение протокола ...',
                success: this.openUrl
            });
        },
        
        onServerSelectBudget: function(importRowLink){
            var row = this.mainGrid.findRecord(importRowLink, "LINK_IMPORT_SAVED_FORM");
            if (Ext.isEmpty(row)) return;
            var rowIndex = this.mainGrid.store.indexOf(row);
            this.selectBudget(rowIndex);
        }
    });
}(SavedFormImportView.prototype));

function isValidImportRow(record){
    var validValue = KS.Grid.getAnyCase(record, "IS_VALID");
    return validValue === true || validValue.toLowerCase() == 'true' || validValue == '1';
}

//-----------------------------------------------------------------------------
// RENDERERS

function importStandardRenderer(value, metadata, record) {
    setTooltip(metadata, value + '');
    if (!isValidImportRow(record)) {
        metadata.css += ' error-cell';
    }
    return value;
}

function importBudgetRenderer(value, metadata) {
    setTooltip(metadata, value);
    metadata.css += ' import-dict-cell';
    return value;
}

function importPeriodRenderer(value, metadata) {
    setTooltip(metadata, value);
    metadata.css += ' import-dict-cell';
    return value;
}

function importAttrRenderer(value, metadata) {
    setTooltip(metadata, value);
    metadata.css += ' import-dict-cell';
    return value;
}

function importColumnsRenderer(value, metadata, record) {
    setTooltip(metadata, 'Выбрать колонки для импорта');
    if (!isValidImportRow(record)) {
            metadata.css += ' error-cell';
        } else {
            metadata.css += ' import-dict-cell';
    }
    return ('...');
}

function importValuesListRenderer(value, metadata, record, rowIndex, colIndex, store) {
    value = valuesListRenderer(value, metadata, record, rowIndex, colIndex, store);
    return '<b>' + importStandardRenderer(value, metadata, record) + '</b>';
}

function importLinkRenderer(value, metadata, record, rowIndex, colIndex, store){
    value = value.replace('<A HREF="">', '').replace('</A>', '');
    var viewId = store.grid.parentView.viewID;
    var linkImport = KS.Grid.getAnyCase(record, 'LINK_IMPORT_SAVED_FORM');
    var fileName = KS.Grid.getAnyCase(record, 'FILE_NAME');
    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + viewId + "'" + ').urlClick(\'' + metadata.column.dataIndex + '\',' + linkImport + ', \'' + fileName + '\');return false;"/>' + value + '</span>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();