﻿SavedFormFileListViewView = KS.extend(BaseDictionaryView, {
    onTemplateRendered: function() {
        var view = this.parentView || this;
        var grid = view.mainGrid;
        grid.on("rowdblclick", view.loadFile);
        view.getToolbarItem(view.mainGrid, "bottom", "OrgCodeContainer").setValue(false);
        view.getToolbarItem(view.mainGrid, "bottom", "OrgNameContainer").setValue(false);
    },

    getTbarClickHandler: function (tbarItem) {
        switch (tbarItem.code) {
            case 'DOWNLOAD_FILE':
            case 'DOWNLOAD_MENU':
            case 'DOWNLOAD_ALL_FILES':
                return this.loadFile;

            default:
                return SavedFormFileListViewView.superclass.getTbarClickHandler.call(this, tbarItem);
        }
    },

    loadFile: function () {
        var view = this.parentView || this,
            selRows = view.mainGrid.getCheckedRows(true);
        if (!this.tbarNode || this.tbarNode.code !== 'DOWNLOAD_ALL_FILES') {
            selRows = view.mainGrid.getCheckedRows(true)[0];
        }
        if (Ext.isEmpty(selRows)) return;

        var files = [];
        var orgCodeinFileName = view.getToolbarItem(view.mainGrid, "bottom", "OrgCodeContainer").getValue();
        var orgNameInFileName = view.getToolbarItem(view.mainGrid, "bottom", "OrgNameContainer").getValue();

        Ext.each(selRows, function (rec) {
            var fileName = KS.Grid.getAnyCase(rec, 'NAME') || '',
                lsf = KS.Grid.getAnyCase(rec, 'LINK_SAVED_FORM') || 0,
                organizationCode = KS.Grid.getAnyCase(rec, 'ORGANIZATION_CODE'),
                organizationNameShort = KS.Grid.getAnyCase(rec, 'ORGANIZATION_NAME_SHORT'),
                fileLink = view.mainGrid.getCloseCode(rec) || 0,
                fullName = "";
            if (orgCodeinFileName) {
                fullName += "[" + organizationCode + "]";
            }            
            if (orgNameInFileName) {
                fullName += "[" + organizationNameShort + "]";
            }
            if (!Ext.isEmpty(fullName)) {
                fullName += " ";
            }
            fullName += fileName;
            files.push({
                link : fileLink, 
                savedFormLink : lsf, 
                name : fullName
            });
        });

        view.serverCall({
            method: 'OnLoadFile',
            params: [files],
            waitMessage: 'Получение файл' + (files.length > 1 ? 'ов' : 'а') + '...'
        });
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();