﻿ReportTableStructView = KS.extend(BaseDictionaryView,
    {
        maxCountRowsInHeader: 7
    });
// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            var view = this;
            this.tableName = this.containerPanel.title;
            view.addGeneralPropertyGrid();
            view.setAdditionalStyles();
        },

        getTbarClickHandler: function(tbarItem) {
            var sc = ReportTableStructView.superclass;
            switch (tbarItem.code) {
                case "NEW_MENU":
                case "COLUMNS":
                case "ADDITIONAL":
                case "MENU_ADDITIONAL":
                    return null;

                case "GROUP":
                    return this.addGroupInTree;

                case "PLAIN_COLUMN":
                    return this.addPlainColumn;

                case "SIDEWALL_COLUMN":
                    return this.addSidewallColumn;

                case "GROUP_COLUMN":
                    return this.addGroupColumn;

                case "PLAIN_COLUMN_GROUP":
                    return this.addPlainColumnGroup;

                case "EDIT_MENU":
                case "EDIT":
                    return this.editColumn;

                case "DELETE_COLUMNS":
                    return this.deleteColumns;

                case "SPLIT_MENU":
                case "SPLIT":
                    return this.splitSelectColumn;

                case "SPLIT_STRUCTURE":
                    return this.splitColumnByStructure;

                case "UP":
                case "DOWN":
                    return this.moveColumn;

                case "COLLAPSE":
                    return this.columnsTreeCollapseAll;
                
                case "EXPAND":
                    return this.columnsTreeExpandAll;

                case "TREE":
                    return this.columnsTreeReloadByTBar;

                case "NEW_BUDGET":
                case "NEW_BUDGET_TYPE":
                    return this.newColumnBudgetRow;

                case "NEW_DEPEND_COLUMN":
                    return this.newDependColumn;

                case "OPEN_TABLE":
                    return this.openTableColumn;

                case "COLUMN_NAME":
                    return this.setColumnName;

            default:
                return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        touch: function () {
            this.parentView.touch();
        },

        discardChanges: function () {
            this.parentView.discardChanges();
        },

        isActiveView: function () {
            return (this.parentView &&
                this.parentView.rootTabPanel &&
                this.parentView.rootTabPanel.getActiveTab &&
                this.parentView.rootTabPanel.getActiveTab() &&
                this.parentView.rootTabPanel.getActiveTab().nestedView === this);
        },

        doRefreshTable: function() { // Вызывается из refreshAllTables
            this.serverCall({
                method: "Reload",
                waitMessage: "Обновление таблицы " + (this.tableName || "") + "...",
                success: this.refreshCallBack
            });
        },

        refreshCallBack: function(data) {
            if (typeof (data) == 'object') this.data = data;

            //Обновляем вкладку "Общие"
            this.addGeneralPropertyGrid();

            //Обновляем вкладку "Колонки"
            this.reloadColumnsTree();
            this.columnsAttrGrid.reload();
            this.columnsBudgetGrid.reload();
            this.columnsDependGrid.reload();

            //Обновляем вкладку "Атрибуты"
            this.attributesGrid.reload();

            //Обновляем вкладку "Просмотр"
            this.reloadGridById("viewPanel");

            //Обновляем вкладку "Автозаполнение"
            this.autofillGrid.reload();

            //Обновляем заголовок таблицы
            this.containerPanel.ownerCt.setTitle(this.data.tableDescription.Name);
        },

        onValuesSelected: function() {
            var activeTab = this.tableTabControl.getActiveTab();
            this.reloadGridById(activeTab.ctrlId);
            this.touch();
        },

        reloadGridById: function(gridId) {
            switch(gridId) {
                case "attributesGrid":
                case "autofillGrid":
                    this[gridId].reload();
                    break;

                case "viewPanel":
                    if (this.viewGrid)
                        this.createPreview();
                    break;

                case "columnsPanel":
                    var columnsGridId = this.columnsTabPanel.getActiveTab().ctrlId;
                    switch (columnsGridId) {
                        case "columnsAttrGrid":
                        case "columnsBudgetGrid":
                        case "columnsDependGrid":
                            this[columnsGridId].reload();
                            break;

                        case "mainPanel":
                            this.columnsTreeSelect(null, this.columnsTree.getSelNode());
                            break;

                    }
                    break;
            }
        },

        navigationTabPanelTabChange: function(tabPanel, newCard) {
            if (newCard.ctrlId === "viewPanel") 
                this.createPreview();
        },
        
        getPropertyOptions: function(record) {
            var propGrid = record.store.grid;
            var sourceConfig = propGrid.sourceConfig[record.id];
            var name = sourceConfig.displayName;
            var code = record.id.split("#")[1] || "";
            var items = sourceConfig.items || null;
            var value = propGrid.source[record.id];
            var type = sourceConfig.type;
            var propertyOptions = {
                name: name,
                code: code,
                items: items,
                value: value,
                type: type
            };
            return propertyOptions;
        },

        newHandler: function() {
            var view = this.parentView || this,
                gridId = this.gridPropertyName,
                grid = view[gridId];
            if (grid) 
                view.serverCall({
                    method: 'AddNewRow',
                    disableFog : true,
                    params: [gridId]
                });
        },

        deleteHandler: function() {
            var view = this.parentView || this;
            var gridId = this.gridPropertyName;
            var grid = view[gridId];
            if (!grid) return;
            var ccc = grid.getCheckedCodes(this);
            if (Ext.isEmpty(ccc)) return;
            KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc, gridId);
            });
        },

        deleteHandlerInternal: function (ccc, gridId) {
            var view = this;
            this.serverCall({
                method: 'DeleteRows',
                params: [gridId, ccc],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted) {
                        view[gridId].reload();
                        view.touch();
                    }
                }
            });
        },

        setDefaultsAttrValues: function() {
            var view = this.parentView || this;
            var gridId = this.gridPropertyName;
            var grid = view[gridId];
            if (!grid) return;
            var ccc = grid.getCheckedCodes(this);
            if (Ext.isEmpty(ccc)) return;
            var message = "Установить значение по умолчанию для " + (ccc.length > 1
                ? "выбранных строк?"
                : "выбранной строки?");
            KS.confirm(message, "Внимание", function (btn) {
                if (btn === 'yes')
                    view.serverCall({
                        method: 'SetDefaultsAttrValues',
                        disableFog : true,
                        params: [gridId, ccc],
                        success: function(result) {
                            if (result) {
                                grid.reload();
                                view.touch();
                            }
                        }
                    });
            });
        },
        
        getVisibleColumns: function(grid) {
            var columns = [];
            grid.eachColumnCfg(function (column) {
                if (column.visibility === true) 
                    columns.push(column);
            });
            return columns;
        },

        tableNavigationTreeClick: function(treeView, td, cellIndex, record, tr, rowIndex ) {
            var view = this;
            view.tableTabControl.setActiveTab(rowIndex);
        },

        tableNavigationTreeLoad: function() {
            this.tableNavigationTree.selectFirstNode();
        },
        
        renameTable: function() {
            var view = this.parentView;
            var tableName = view.tableName;
            view.renameTableWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'renameTableArea',
                value: tableName
            }, {
                title: 'Новое наименование таблицы',
                autoHeight: false,    
                layout: "fit",
                height: 150, 
                minHeight: 150,
                width: 400,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'Применить',
                        cls: 'dim-button',
                        handler: function () {
                            var newTableName = view.renameTableWin.getComponent("renameTableArea").getValue();
                            view.setNewTableName(newTableName);
                            view.renameTableWin.close();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.renameTableWin.close();
                        }
                    }]
            }, true);
            view.renameTableWin.getComponent("renameTableArea").selectText(tableName.length);
        },
        
        setNewTableName: function(newTableName){
            var view = this;
            this.serverCall({
                method: 'RenameTable',
                params: [newTableName],
                success: function() {
                    view.tableName = newTableName;
                    view.containerPanel.ownerCt.setTitle(newTableName);
                    view.touch();
                }
            });
        },

        copyTable: function() {
            var view = this.parentView;
            var formView = view.parentView;
            var tableLink = view.data.tableDescription.TableLink;
            if (!Ext.isEmpty(tableLink))
                formView.copyTable(tableLink);
            else
                KS.alert("Таблица не найдена, копирование отменено");
        },

        deleteTable: function() {
            var view = this.parentView;
            KS.confirm("Удалить таблицу " + view.tableName + " ?",
                "Подтвердите удаление", function(btn) {
                    if (btn === 'yes') {
                        var formView = view.parentView;
                        var tableLink = view.data.tableDescription.TableLink;
                        if (!Ext.isEmpty(tableLink))
                            formView.deleteTable(tableLink);
                        else
                            KS.alert("Таблица не найдена, удаление отменено");
                    }
                });
        }
    });
}(ReportTableStructView.prototype));

// ============= BASE PROPERTY GRID FUNCTION =======================
(function(viewClass) {
    KS.apply(viewClass, {
        beforePropertyGridCellClick: function(gridView, td, cellIndex, record) { 
            var propGrid = this;
            var sourceConfig = propGrid.sourceConfig[record.id];
            var description = sourceConfig.description;
            if (this.parentView.descriptionPanel)
                this.parentView.descriptionPanel.setHtml(description);
            return true;
        },

        propertyGridCellClick: function() {
            var view = this.parentView;
            var propGrid = this;
            view.unselectFieldFromOtherPropGrids(propGrid);
            return true;
        },

        unselectFieldFromOtherPropGrids: function(propGrid) {
            Ext.each(propGrid.ownerCt.items.items, function(onePropGrid) {
                if (onePropGrid.itemId !== propGrid.itemId) 
                    onePropGrid.setSelection();
            });
        },

        selectDictionCodeSelect: function(combo, record, index) {
            combo.collapse();
            if (combo.ownerCt && combo.ownerCt.ownerCmp) {
                var propGridId = combo.ownerCt.ownerCmp.itemId;
                var propId = combo.name;
                var view = this.parentView;
                switch(index) {
                    case 0: //Открыть
                        if (!Ext.isEmpty(combo.getValue())) {
                            KS.confirm("Перейти к справочнику " + combo.getValue() + " ?", "Внимание", 
                                function(btn) {
                                    if (btn === 'yes') 
                                        view.selectDictionCode(propGridId, propId, index);
                            });
                        }
                        break;

                    case 1: //Выбрать
                        view.selectDictionCode(propGridId, propId, index);
                        break;
                        
                    case 2: //Удалить
                        if (propGridId.indexOf("generalPropGrid") !== -1) {
                            var msg = propId.indexOf("SidewallCode") !== -1 ? "Удалить боковик?" : "Удалить группы?";
                            KS.confirm(msg, "Внимание",
                                function(btn) {
                                    if (btn === 'yes') 
                                        view.selectDictionCode(propGridId, propId, index);
                                });
                        } else {
                            view.selectDictionCode(propGridId, propId, index);
                        }
                        break;
                }
            }
            return false;
        },

        selectDictionCode: function(propGridId, propId, index) {
            var columnCode = this.columnsTree.getSelNodeId();
            this.serverCall({
                method: 'SelectDictionCode',
                params: [propGridId, propId, index, columnCode]
            });
        },

        correctPropertyValue: function(value, selProp) {
            switch (Ext.typeOf(value)) {
            case "date":
                value = Ext.util.Format.date(value, 'd.m.Y H:i:s');
                break;
            case "number":
                value = value.toString();
                break;
            case "boolean":
                value = value ? "True" : "False";
                break;
            }

            if (selProp && selProp.type) {
                switch (selProp.type) {
                case "dropDownList":
                    if (selProp.items)
                        value = selProp.items.indexOf(value);
                    break;
                }
            }
            return value;
        },

        propertyGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex) {
            var propGrid = this;
            var view = this.parentView;
            var sourceConfig = propGrid.sourceConfig[record.id];
            var settings = propGrid.settings[parseInt(record.id.split('#')[0])];
            if (!KS.isEmpty(sourceConfig)) {
                switch (sourceConfig.type) {
                    case "boolean":
                        var oldValue = propGrid.source[record.id];
                        var newValue = !oldValue;
                        propGrid.setProperty(record.id, newValue);
                        propGrid.getCellEditor(record, 1).completeEdit();
                        break;
                    case "dictionSelect":
                        var isGeneralGrid = propGrid.itemId.indexOf("generalPropGrid") > -1;
                        view.selectPropValueFromDiction(settings.Key, isGeneralGrid);
                        break;
                }
            }
        },

        selectPropValueFromDiction: function(propertyId, isGeneralGrid) {
            var view = this;
            this.serverCall({
                method: 'SelectPropValueFromDiction',
                disableFog: true,
                params: [propertyId, isGeneralGrid],
                success: function(grid) {
                    view.showDictionWithPropValues(grid, propertyId, isGeneralGrid);
                }
            });
        },

        showDictionWithPropValues: function(grid, propertyId, isGeneralGrid) {
            if (Ext.isEmpty(grid)) return;
            var gridControl = this.createTemplateControl(grid);
            var view = this;
            var title = isGeneralGrid ?
                'Фильтр таблицы' :
                propertyId === "DictionFilter" ? 'Фильтр колонки' : 'Выберите значение...'
            this.dictionPropValuesWin = KS.showModal(gridControl,
                {
                    title: title,
                    autoHeight: false,
                    layout: "fit",
                    height: 500,
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                switch (propertyId) {
                                    case "DictionFilter":
                                        view.setDictionFilterValue();
                                        break;

                                    case "TableFilter":
                                        view.setTableFilterValue();
                                        break;

                                    default:
                                        view.setPropValueFromDiction(propertyId);
                                        break;
                                }
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.dictionPropValuesWin.close();
                            }
                        }]
                },
                true);
        }
    });
}(ReportTableStructView.prototype));

// ============= GENERAL_PANEL =======================
(function(viewClass) {
    KS.apply(viewClass, {
        addGeneralPropertyGrid: function() { //Добавить propertyGrid в Общие
            this.serverCall({
                method: 'GetGeneralPanelData',
                waitMessage: 'Загрузка общих настроек колонки...',
                success: this.createPropertyGrids
            });
        },
        
        createPropertyGrids: function(listOptions) {
            if (listOptions) {
                var view = this;
                view.generalPanel.removeAll();
                view.selectedGeneralProperty = {};
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "generalPropGrid" + i++, prop);
                            propertyGrid.on("propertychange", view.generalPropertyGridChange, view);
                            propertyGrid.on("beforeselect", view.generalPropertySelected, view);
                            view.generalPanel.add(propertyGrid);
                        }
                    }
                }
            }
        },

        generalPropertyGridChange: function(source, recordId, value, oldValue) {
            if (!Ext.isEmpty(value) && value.toString() !== oldValue.toString()) {
                value = this.correctPropertyValue(value, this.selectedGeneralProperty);
                var propCode = recordId.split("#")[1] || "";
                var view = this;
                this.serverCall({
                    method: 'GeneralPropertyValueChange',
                    disableFog: true,
                    params: [propCode, value],
                    success: function() {
                        view.generalPropValueChanged(value);
                    }
                });
            }
        },

        generalPropValueChanged: function(newValue) {
            if (!Ext.isEmpty(this.selectedGeneralProperty) &&
                this.selectedGeneralProperty.value !== newValue) {
                this.selectedGeneralProperty.value = newValue;
            }
            this.touch();
        },
        
        generalPropertySelected: function(selModel, record) {
            this.selectedColumnProperty = this.getPropertyOptions(record);
            return true;
        },

        onServerGeneralPropGridReload: function(needColumnTreeReload) {
            this.addGeneralPropertyGrid();
            if (needColumnTreeReload) 
                this.reloadColumnsTree();
        },

        setTableFilterValue: function(){
            var view = this;
            this.serverCall({
                method: 'SetTableFilterValue',
                disableFog: true,
                success: function(filterValue) {
                    if (!Ext.isEmpty(filterValue)) {
                        view.addGeneralPropertyGrid();
                        view.touch();
                    }
                    view.dictionPropValuesWin.close();
                }
            });
        }
    });
}(ReportTableStructView.prototype));

// ============= COLUMNS_TREE =======================
(function(viewClass) {
    KS.apply(viewClass, {

        reloadColumnsTree: function() {
            if (this.columnsTree.getSelNodeId())
                this.selectedColumnsTreeNodeId = this.columnsTree.getSelNodeId(); 
            this.columnsTree.getRootNode().removeAll(true);
            this.columnsTree.fullReload();            
        },

        columnsTreeSelect: function(treeView, record) {
            var code = KS.Grid.getAnyCase(record, "id");
            this.serverCall({
                method: 'GetGeneralColumnProperty',
                disableFog: true,
                params: [code],
                success: this.loadGeneralColumnsPanel
            });
        },

        loadGeneralColumnsPanel: function(listOptions) {
            if (listOptions) {
                var view = this;
                view.generalColumnsPanel.removeAll();
                if (view.descriptionPanel)
                    view.descriptionPanel.setHtml("");
                view.selectedColumnProperty = {};
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "columnsPropGrid" + i++, prop);
                            propertyGrid.on("propertychange", view.columnPropertyChange, view);
                            propertyGrid.on("beforeselect", view.columnsPropertySelected, view);
                            view.generalColumnsPanel.add(propertyGrid);
                        }
                    }

                    view.columnsAttrGrid.needReload = true;
                    view.columnsBudgetGrid.needReload = true;
                    view.columnsDependGrid.needReload = true;
                    var activeTab = view.columnsTabPanel.getActiveTab();
                    if (activeTab && activeTab.ctrlId !== "mainPanel") {
                        activeTab.reload();
                        activeTab.needReload = false;
                    }
                }
            }
        },

        columnPropertyChange: function(source, recordId, value, oldValue) {
            if (oldValue === null || value === null || value.toString() !== oldValue.toString()) {
                value = this.correctPropertyValue(value, this.selectedColumnProperty);
                var code = this.columnsTree.getSelNodeId();
                var propCode = recordId.split("#")[1] || "";
                var view = this;
                this.serverCall({
                    method: 'ChangeColumnPropertyValue',
                    disableFog: true,
                    params: [code, propCode, value],
                    success: function(needRefreshNode) {
                        view.afterColumnPropValueChanged(value, needRefreshNode);
                    }
                });
            }
        },

        afterColumnPropValueChanged: function(newValue, needRefreshNode) {
            if (needRefreshNode) 
                this.columnsTreeSelect(null, this.columnsTree.getSelNode());
            
            if (!Ext.isEmpty(this.selectedColumnProperty) &&
                this.selectedColumnProperty.value !== newValue) {
                this.selectedColumnProperty.value = newValue;
            }
            this.touch();
        },

        columnsPropertySelected: function(selModel, record) {
            this.selectedColumnProperty = this.getPropertyOptions(record);
            return true;
        },

        setPropValueFromDiction: function(propertyId) {
            var view = this;
            var checkedRows = this.dictionPropValuesGrid.getCheckedRows();
            var selectedValues = [];
            Ext.each(checkedRows, function(record) {
                selectedValues.push(record.data);
            });
            this.serverCall({
                method: 'SetPropValueFromDiction',
                disableFog: true,
                params: [selectedValues, propertyId],
                success: function() {
                    view.columnsTreeSelect(null, view.columnsTree.getSelNode());
                    view.touch();
                    view.dictionPropValuesWin.close();
                }
            });
        },

        setDictionFilterValue: function() {
            var view = this;
            this.serverCall({
                method: 'SetDictionFilterValue',
                disableFog: true,
                success: function(filterChanged) {
                    if (filterChanged) {
                        view.columnsTreeSelect(null, view.columnsTree.getSelNode());
                        view.touch();
                    }
                    view.dictionPropValuesWin.close();
                }
            });
        },

        filterGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var dataIndex = e.position.column.dataIndex;
            if (["LEFT_ITEM_VALUE", "RIGHT_ITEM_VALUE", "FILTER_WHERE"].indexOf(dataIndex) !== -1) {
                var leftItemType = KS.Grid.getAnyCase(record, "LEFT_ITEM_TYPE");
                if (dataIndex === "LEFT_ITEM_VALUE" && 
                   (leftItemType === "TaskAttribute" || leftItemType === "Column")) {
                    return this.changeFilterGridCellEditor(gridView.grid, leftItemType);
                }
                var value = KS.Grid.getAnyCase(record, dataIndex);
                this.showPopupFilterEditor(value, record, dataIndex);
                return false;
            }
            return true;
        },

        changeFilterGridCellEditor: function(grid, leftItemType) {
            var column = grid.getColConfigByKey("LEFT_ITEM_VALUE");

            if (leftItemType === "TaskAttribute")
                column.dataIndex = "LEFT_ITEM_VALUE_ATTR";
            else if (leftItemType === "Column")
                column.dataIndex = "LEFT_ITEM_VALUE_COLUMN";

            try {
                column.vlItems = null;
                var editorType = eval(window.valuesListEditor);
                column.editor = new editorType({
                    grid : grid,
                    col : column
                });
                return true;
            } catch (e) {
                return false;
            }
        },

        showPopupFilterEditor: function (originalValue, record, dataIndex) {
            var view = this;
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: originalValue
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 4),
                height: Math.max(300, KS.rootViewport.getHeight() / 3),
                title: "Редактирование...",
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var newValue = view.pseWin.getComponent("pseArea").getValue();
                            record.set(dataIndex, newValue);
                            var context = {
                                originalValue : originalValue,
                                value : newValue,
                                field: dataIndex,
                                record: record
                            }
                            view.filterGridEditCell(null, context);
                            view.pseWin.close(true);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.pseWin.close();
                        }
                    }]
            }, true);

            view.pseWin.getComponent("pseArea").selectText(originalValue.length);
        },

        filterGridEditCell: function(edPlugin, context) {
            var dataIndex = context.field;
            if (dataIndex === "LEFT_ITEM_VALUE_ATTR" || dataIndex === "LEFT_ITEM_VALUE_COLUMN") {
                var colCfg = context.grid.getColConfigByKey(dataIndex);
                dataIndex = "LEFT_ITEM_VALUE";
                colCfg.dataIndex = dataIndex;
            }
            if (context.originalValue !== context.value) {
                var closeCode = KS.Grid.getAnyCase(context.record, this.editFilterGrid.closeCode);
                var newValue = context.value;
                this.serverCall({
                    method: 'FilterGridEditCell',
                    disableFog: true,
                    params: [closeCode, dataIndex, newValue],
                    success: function(result) {
                        if (result === false) 
                            context.record.reject();
                    }
                });
            }
        },

        newFilterRow: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'NewFilterRow',
                disableFog: true,
                success: function(dataRow) {
                    view.editFilterGrid.addRecord(dataRow);
                }
            });
        },

        deleteFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            var checkedRows = view.editFilterGrid.getCheckedRows();
            view.serverCall({
                method: 'DeleteFilterRows',
                params: [closeCodes],
                disableFog: true,
                success: function(result) {
                    if (result) 
                        view.editFilterGrid.getStore().remove(checkedRows);
                }
            });
        },

        copyFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            view.serverCall({
                method: 'CopyFilterRow',
                params: [closeCodes[0]],
                disableFog: true,
                success: function(dataRow) {
                    view.editFilterGrid.addRecord(dataRow);
                }
            });
        },

        upFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            var checkedRows = view.editFilterGrid.getCheckedRows();
            view.serverCall({
                method: 'MoveUpFilterRow',
                params: [closeCodes[0]],
                disableFog: true,
                success: function(newOrder) {
                    if (!Ext.isEmpty(newOrder)) {
                        var topRow = view.editFilterGrid.getStore().getAt(newOrder);
                        view.editFilterGrid.getStore().remove(checkedRows[0]);
                        checkedRows[0].set("ORDER", newOrder);
                        view.editFilterGrid.getStore().insert(newOrder, checkedRows[0]);
                        topRow.set("ORDER", newOrder + 1);
                    }
                }
            });
        },

        downFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            var checkedRows = view.editFilterGrid.getCheckedRows();
            view.serverCall({
                method: 'MoveDownFilterRow',
                params: [closeCodes[0]],
                disableFog: true,
                success: function(newOrder) {
                    if (!Ext.isEmpty(newOrder)) {
                        var bottomRow = view.editFilterGrid.getStore().getAt(newOrder);
                        view.editFilterGrid.getStore().remove(checkedRows[0]);
                        checkedRows[0].set("ORDER", newOrder);
                        view.editFilterGrid.getStore().insert(newOrder, checkedRows[0]);
                        bottomRow.set("ORDER", newOrder - 1);
                    }
                }
            });
        },

        onServerColumnsTreeReload: function(columnsNodeWithCheck) {
            if (!Ext.isEmpty(columnsNodeWithCheck && this.data)) 
                this.data.columnsNodeWithCheck = columnsNodeWithCheck;
            
            this.setColumnsTreeCheckboxs();
            if (this.selectedColumnsTreeNodeId && this.columnsTree.store.getNodeById(this.selectedColumnsTreeNodeId))
                this.columnsTree.setSelected(this.selectedColumnsTreeNodeId)
            else
                this.columnsTree.selectFirstNode();
        },

        setColumnsTreeCheckboxs: function() {
            if (this.data && this.data.columnsNodeWithCheck) {
                var nodesWithCheck = this.data.columnsNodeWithCheck;
                this.columnsTree.store.each(function(node) {
                    if (!Ext.isEmpty(nodesWithCheck[node.get("id")])) 
                        node.set('checked', nodesWithCheck[node.get("id")]);
                });
            }
        },

        columnsTabPanelTabChange: function(tabPanel, newCard) {
            if (newCard.needReload) {
                newCard.reload();
                newCard.needReload = false;
            }
        },

        newColumnBudgetRow: function() {
            var view = this.parentView,
                selColumnId = view.columnsTree.getSelNodeId(),
                operationCode = this.tbarNode.code;
            view.serverCall({
                method: 'NewColumnBudgetRow',
                disableFog: true,
                params: [operationCode, selColumnId]
            });
        },

        newDependColumn: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetDependColumnGrid',
                disableFog: true,
                success: view.showDependColumGrid
            });
        },

        showDependColumGrid: function(grid) {
            if (Ext.isEmpty(grid)) return;
            this.selectDependColumnsGrid = this.createTemplateControl(grid);
            var view = this;
            this.selectDependColumnsWin = KS.showModal(this.selectDependColumnsGrid,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: "fit",
                    height: 500,
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.setNewDependColumns();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.selectDependColumnsWin.close();
                            }
                        }]
                },
                true);
        },

        setNewDependColumns: function() {
            var view = this;
            var checkedCodes = this.selectDependColumnsGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) view.selectDependColumnsWin.close();
            view.serverCall({
                method: 'SetNewDependColumns',
                params: [checkedCodes],
                success: function() {
                    view.columnsDependGrid.reload();
                    view.touch();
                    view.selectDependColumnsWin.close();
                }
            });
        },

        columnsTreeDblClick: function() {
            this.editColumn();
        },

        // Добавить заголовок
        addGroupInTree: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'AddGroupInTree',
                disableFog: true,
                success: function() {
                    view.reloadColumnsTree();
                    view.touch();
                }
            });
        },

        // Обычная колонки
        addPlainColumn: function() {
            var view = this.parentView;
            var index;
            var activeNode = view.columnsTree.getSelNode();
            if (activeNode.parentNode.isRoot()) {
                index = activeNode.parentNode.childNodes.indexOf(activeNode);
            } else {
                while (!activeNode.parentNode.isRoot()) {
                    activeNode = activeNode.parentNode;
                }
                index = activeNode.parentNode.childNodes.indexOf(activeNode);
            }
            if (index === -1) return;
            view.serverCall({
                method: 'AddPlainColumn',
                params: [index],
                disableFog: true,
                success: function() {
                    view.reloadColumnsTree();
                    view.touch();
                }
            });
        },

        //Колонка боковика
        addSidewallColumn: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetSidewallColumnGrid',
                disableFog: true,
                success: view.showSidewallColumnGrid
            });
        },

        showSidewallColumnGrid: function(grid) {
            if (Ext.isEmpty(grid)) return;
            this.addSidewallColumnGrid = this.createTemplateControl(grid);
            var view = this;
            this.addSidewallColumnWin = KS.showModal(this.addSidewallColumnGrid,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: "fit",
                    height: 500,
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doAddSidewallColumn();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.addSidewallColumnWin.close();
                            }
                        }]
                },
                true);
        },

        doAddSidewallColumn: function() {
            var view = this;
            var selectedRows = this.addSidewallColumnGrid.getSelectedRows();
            if (Ext.isEmpty(selectedRows)) return;

            var dict = {
                "NAME": KS.Grid.getAnyCase(selectedRows[0], "NAME"),
                "LENGTH": KS.Grid.getAnyCase(selectedRows[0], "LENGTH"),
                "DICTION_COL_ORDER": KS.Grid.getAnyCase(selectedRows[0], "DICTION_COL_ORDER")
            };

            view.serverCall({
                method: 'AddSidewallColumn',
                params: [dict],
                success: function() {
                    view.reloadColumnsTree();
                    view.addSidewallColumnWin.close();
                    view.touch();
                }
            });
        },

        // Колонка группы
        addGroupColumn: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'AddGroupColumn',
                disableFog: true
            });
        },

        onServerGroupColumAdded: function() {
            this.reloadColumnsTree();
        },

        // Группа обычных колонок
        addPlainColumnGroup: function() {
            var view = this.parentView;
            var index;
            var maxColumn;
            var activeNode = view.columnsTree.getSelNode();
            if (activeNode.parentNode.isRoot()) {
                index = activeNode.parentNode.childNodes.indexOf(activeNode);
                maxColumn = activeNode.parentNode.childNodes.length;
            } else {
                while (!activeNode.parentNode.isRoot()) {
                    activeNode = activeNode.parentNode;
                }
                index = activeNode.parentNode.childNodes.indexOf(activeNode);
                maxColumn = activeNode.parentNode.childNodes.length;
            }
            if (index === -1) return;

            view.plainColumnGroupCount = new Ext.form.field.Number(
                {
                    anchor: '100%',
                    name: 'plainColumnGroupCount',
                    value: 1,
                    maxValue: 255 - maxColumn,
                    minValue: 1
                });

            view.addPlainColumnGroupWin = KS.showModal(view.plainColumnGroupCount,
                {
                    title: 'Количество добавляемых колонок',
                    autoHeight: false,
                    maximizable: false,
                    layout: "fit",
                    height: 100,
                    minHeight: 100,
                    width: 300,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doAddPlainColumnGroup(index, maxColumn);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.addPlainColumnGroupWin.close();
                            }
                        }]
                },
                true);
        },

        doAddPlainColumnGroup: function(index) {
            var view = this;
            var columnCount = view.plainColumnGroupCount.getValue();
            view.serverCall({
                method: 'AddPlainColumnGroup',
                params: [index, columnCount],
                disableFog: true,
                success: function() {
                    view.reloadColumnsTree();
                    view.touch();
                    view.addPlainColumnGroupWin.close();
                }
            });
        },

        editColumn: function(btn) {
            var view = btn ? this.parentView : this;
            var selId = view.columnsTree.getSelNodeId();
            view.serverCall({
                method: 'GetEditColumnPropData',
                params: [selId],
                disableFog: true,
                success: view.showEditColumnPropGrid
            });
        },

        showEditColumnPropGrid: function(listOptions) {
            if (listOptions) {
                var view = this;
                this.editPropertyPanel = new Ext.panel.Panel({
                    layout: 'anchor',
                    width: "100%",
                    height: "100%",
                    scrollable: true
                });
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "editPropGrid" + i++, prop);
                            propertyGrid.on("propertychange", view.editColumnPropertyChange, view);
                            view.editPropertyPanel.add(propertyGrid);
                        }
                    }
                }
                view.editPropertyWin = KS.showModal(view.editPropertyPanel,
                    {
                        title: "Свойства",
                        autoHeight: false,
                        layout: "fit",
                        height: 600,
                        minHeight: 200,
                        width: 600,
                        minWidth: 300,
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function() {
                                    view.doEditColumn();
                                }
                            },
                            { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function() {
                                    view.editPropertyWin.close();
                                }
                            }]
                    },
                    true);
            }
        },

        doEditColumn: function() {
            var view = this;
            // Сделать вариант для выбора нескольких узлов
            var selId = view.columnsTree.getSelNodeId();
            view.serverCall({
                method: 'EditColumn',
                params: [selId],
                disableFog: true,
                success: function(success) {
                    if (success) {
                        view.reloadColumnsTree();
                        view.touch();
                        view.editPropertyWin.close();
                    }
                }
            });
        },

        editColumnPropertyChange: function(source, recordId, value, oldValue) {
            if (!Ext.isEmpty(value) && value.toString() !== oldValue.toString()) {
                value = this.correctPropertyValue(value, this.selectedColumnProperty);
                var code = this.columnsTree.getSelNodeId() + "_edit";
                var propCode = recordId.split("#")[1] || "";
                this.serverCall({
                    method: 'ChangeColumnPropertyValue',
                    disableFog: true,
                    params: [code, propCode, value]
                });
            }
        },

        deleteColumns: function() {
            var view = this.parentView;

            var checkedCodes = [];
            var checkedNodes = view.columnsTree.getChecked();
            Ext.each(checkedNodes, function (node) {
                checkedCodes.push(node.id);
            });

            var selId = view.columnsTree.getSelNodeId();
            view.serverCall({
                method: 'GetDeleteColumnCodesAndMsg',
                params: [checkedCodes, selId],
                disableFog: true,
                success: view.doDeleteColumns
            });
        },

        doDeleteColumns: function (result) {
            var view = this;
            var msg = result["MESSAGE"];
            var codes = result["CODES"];
            if (!Ext.isEmpty(msg) && !Ext.isEmpty(codes)) {
                KS.confirm(msg, "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            view.serverCall({
                                method: 'DoDeleteColumns',
                                params: [codes],
                                disableFog: true,
                                success: function() {
                                    view.reloadColumnsTree();
                                    view.touch();
                                }
                            });
                        }
                    });
            }
        },

        splitSelectColumn: function() {
            var view = this.parentView;
            var selNodeId = view.columnsTree.getSelNodeId();
            view.serverCall({
                method: 'SplitSelectColumn',
                params: [selNodeId],
                disableFog: true,
                success: view.showSplitColumnGrid
            });
        },

        showSplitColumnGrid: function(dict) {
            if (Ext.isEmpty(dict) || Ext.isEmpty(dict["codeLength"]) ||
                Ext.isEmpty(dict["winName"]) || Ext.isEmpty(dict["grid"])) return;
            
            var view = this;
            var codeLength = dict["codeLength"];
            view.codeLength = codeLength;
            if (!Ext.isEmpty(window.dictionCodePositionEditor)) 
                window.dictionCodePositionEditor.prototype.maxValue = codeLength - 1;
            
            var winName = dict["winName"];
            var grid = dict["grid"];
            this.codeSplitGrid = this.createTemplateControl(grid);
            this.codeSplitWin = KS.showModal(this.codeSplitGrid,
            {
                title: winName,
                autoHeight: false,
                layout: "fit",
                height: 500,
                minHeight: 200,
                width: 800,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.doSplitSelectColumn();
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.codeSplitWin.close();
                        }
                    }]
            }, true);
        },

        doSplitSelectColumn: function() {
            var view = this;
            view.serverCall({
                method: 'DoSplitSelectColumn',
                disableFog: true,
                success: function(result) {
                    if (result) {
                        view.reloadColumnsTree();
                        view.touch();
                        view.codeSplitWin.close();
                    }
                }
            });
        },

        newRowCodeSplitGrid: function() {
            var view = this.parentView;
            var grid = view.codeSplitGrid;
            if (grid.store.getCount() !== 0 && KS.Grid.getAnyCase(grid.store.last(), "NAME") === "") {
                view.startEditLastRow(grid);
            } else {
                view.serverCall({
                    method: 'NewRowCodeSplitGrid',
                    params: [view.codeLength],
                    disableFog: true,
                    success: function(dataRow) {
                        if (dataRow) {
                            grid.addRecord(dataRow);
                            view.startEditLastRow(grid);
                        }
                    }
                });
            }
        },

        startEditLastRow: function(grid) {
            var rowIndex = grid.store.getCount() - 1;
            grid.getPlugin('cellediting').startEditByPosition({
                row: rowIndex,
                column: 1
            });
        },

        refreshCodeSplitGrid: function() {
            var view = this.parentView;
            view.codeSplitWin.disable();
            view.serverCall({
                method: 'RefreshCodeSplitGrid',
                waitMessage: 'Обновление...',
                success: function() {
                    view.codeSplitGrid.reload();
                    view.codeSplitWin.enable();
                }
            });
        },

        codeSplitGridEditCell: function(e, context) {
            if (context.value === context.originalValue) return false;
            var closeCode = KS.Grid.getAnyCase(context.record, "ENTITY_CLOSE_CODE");
            var dataIndex = context.field;
            
            this.serverCall({
                method: 'CodeSplitGridEditCell',
                disableFog: true,
                params: [closeCode, dataIndex, context.value]
            });

            return true;
        },
        
        splitColumnByStructure: function() {
            var view = this.parentView;
            KS.confirm("Сформировать кодовый столбец на основании структуры кода справочника боковика?", 
                "Внимание", function (btn) {
                    if (btn === 'yes')
                        view.serverCall({
                            method: 'SplitColumnByStructure',
                            disableFog : true,
                            success: function() {
                                view.reloadColumnsTree();
                                view.touch();
                            }
                        });
                });
        },

        moveColumn: function() {
            var code = this.tbarNode.code;
            var view = this.parentView;
            var selNodeId = view.columnsTree.getSelNodeId();
            view.serverCall({
                method: 'MoveColumn',
                params: [selNodeId, code],
                disableFog: true,
                success: function() {
                    view.reloadColumnsTree();
                    setTimeout(function() {view.columnsTreeExpandNode(view.columnsTree.getRootNode());}, 0); 
                    view.touch();
                }
            });
        },

        columnsTreeCollapseAll: function() {
            var view = this.parentView;
            view.columnsTreeCollapseNode(view.columnsTree.getRootNode());
        },

        columnsTreeCollapseNode: function(node) {
            var view = this;
            if (!node.isRoot())
                node.collapse();
            Ext.each(node.childNodes, function(childNode) {
                view.columnsTreeCollapseNode(childNode);
            });
        },

        columnsTreeExpandAll: function() {
            var view = this.parentView;
            view.columnsTreeExpandNode(view.columnsTree.getRootNode());
        },

        columnsTreeExpandNode: function(node) {
            var view = this;
            if (!node.isRoot())
                node.expand();
            Ext.each(node.childNodes, function(childNode) {
                view.columnsTreeExpandNode(childNode);
            });
        },

        columnsTreeReloadByTBar: function() {
            var view = this.parentView;
            view.reloadColumnsTree();
        },

        openTableColumn: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetTableColumnGrid',
                success: view.showTableColumnGrid
            });
        },

        showTableColumnGrid: function(grid) {
            if (Ext.isEmpty(grid)) return;
            var view = this;
            this.tableColumnGrid = this.createTemplateControl(grid);
            this.tableColumnWin = KS.showModal(this.tableColumnGrid,
            {
                title: "Редактирование колонок",
                autoHeight: false,
                layout: "fit",
                height: 500,
                minHeight: 200,
                width: 800,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.mergeTableColumnChanges();
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.tableColumnWin.close();
                        }
                    }]
            }, true);
        },

        mergeTableColumnChanges: function() {
            var view = this;
            view.serverCall({
                method: 'MergeTableColumnChanges',
                success: function() {
                    view.reloadColumnsTree();
                    view.touch();
                    view.tableColumnWin.close();
                }
            });
        },

        tableColumnGridEditCell: function(e, context) {
            if (context.value === context.originalValue) return false;
            var closeCode = KS.Grid.getAnyCase(context.record, "ENTITY_CLOSE_CODE");
            var dataIndex = context.field;
            
            this.serverCall({
                method: 'TableColumnGridEditCell',
                disableFog: true,
                params: [closeCode, dataIndex, context.value]
            });

            return true;
        },

        setColumnName: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetColumnNameGrid',
                disableFog: true,
                success: view.showColumnNameGrid
            });
        },

        showColumnNameGrid: function(grid) {
            if (Ext.isEmpty(grid)) return;
            var view = this;
            this.columnNameGrid = this.createTemplateControl(grid);
            this.columnNameWin = KS.showModal(this.columnNameGrid,
            {
                title: "Выберите значение...",
                autoHeight: false,
                layout: "fit",
                height: 500,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.doSetColumnName();
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.columnNameWin.close();
                        }
                    }]
            }, true);     
        },

        doSetColumnName: function() {
            var view = this;
            var selected = this.columnNameGrid.getCheckedRows();
            var prefixList = [];
            if (!Ext.isEmpty(selected)) 
                Ext.each(selected, function(record) {
                    prefixList.push(KS.Grid.getAnyCase(record, "prefix"));
                });
            
            view.serverCall({
                method: 'SetColumnName',
                params: [prefixList],
                disableFog: true,
                success: function() {
                    view.reloadColumnsTree();
                    view.columnNameWin.close();
                }
            });
        },

        onServerColumnsTreeReselect: function() {
            this.columnsTreeSelect(null, this.columnsTree.getSelNode());
        }
    });
}(ReportTableStructView.prototype));

// ============= VIEW_GRID =======================
(function(viewClass) {
    KS.apply(viewClass, {
        createPreview: function() {
            var view = this;
            view.serverCall({
                method: 'CreatePreview',
                success: view.addViewGrid
            });
        },

        addViewGrid: function(grid) {
            if (grid) {
                this.viewGrid = this.createTemplateControl(grid);
                this.addLockedGridFilterFunctions(this.viewGrid);
                this.viewPanel.removeAll();
                var view = this;
                setTimeout(function() {
                    view.viewPanel.add(view.viewGrid);
                    view.setCountRowsInHeader();
                }, 0);
            }
        },

        onServerSaveDisabledCells:function(disabledCells) {
            this.disabledCells = disabledCells;
        },

        getCellDisableState: function(record, columnLink) {
            var dcs = this.disabledCells;
            var ldr = KS.Grid.getAnyCase(record, "LINK_DICTION_ROW");
            return dcs != null && dcs.indexOf(ldr + "#" + columnLink) !== -1;
        },

        isCellEmpty: function(value, colDesc) {
            if (colDesc && !colDesc.Type) {
                var fv = parseFloat((('' + value) || '0').replace(',', '.'));
                return (isNaN(fv) === false && fv === 0);
            } else {
                return Ext.isEmpty(value);
            }
        },

        getSelectedCellsViewGrid: function() {
            let selectedCells = [],
                selectedRange,
                selected = this.viewGrid.getSelectionModel().getSelected();
            var view = this;
            if (!KS.isEmpty(selected) && !KS.isEmpty(selected.startCell) && !KS.isEmpty(selected.endCell)) {
                selectedRange = selected.getRange();
                for (let rowIdx = selectedRange[0][1]; rowIdx <= selectedRange[1][1]; rowIdx++) {
                    let rec = view.viewGrid.getStore().getAt(rowIdx),
                        dictionLink = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW');
                    for (var colIdx = selectedRange[0][0]; colIdx <= selectedRange[1][0]; colIdx++) {
                        let column = view.getVisibleColumns(view.viewGrid)[colIdx];
                        if (column && dictionLink > 0) {
                            let dataIndex = column.dataIndex;
                            let value = KS.Grid.getAnyCase(rec, dataIndex);
                            selectedCells.push({
                                LINK_DICTION_ROW: dictionLink,
                                COLUMN_KEY: dataIndex,
                                VALUE: value
                            });
                        }
                    }
                }
            } else if (!KS.isEmpty(selected) && selected.selectedRecords && selected.selectedRecords.length > 0) {
                selected.selectedRecords.each(function(rec) {
                    let dictionLink = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW');
                    let columns = view.getVisibleColumns(view.viewGrid);
                    Ext.each(columns, function(column) {
                        let dataIndex = column.dataIndex;
                        let value = KS.Grid.getAnyCase(rec, dataIndex);
                        selectedCells.push({
                            LINK_DICTION_ROW: dictionLink,
                            COLUMN_KEY: dataIndex,
                            VALUE: value
                        });
                    });
                });
            } else {
                return null;
            }
            
            return selectedCells;
        },

        cellOperationViewGrid: function() {
            var view = this.parentView;
            var operationCode = this.tbarNode.code;
            var selectedCells = view.getSelectedCellsViewGrid();
            if (Ext.isEmpty(selectedCells)) return;
            view.serverCall({
                method: 'CellOperationViewGrid',
                params: [selectedCells, operationCode],
                success: function() {
                    view.touch();
                    view.createPreview();
                }
            });
        },

        clearStaticCellsViewGrid: function() {
            var view = this.parentView;
            KS.confirm("Удалить статичные ячейки?", "Внимание", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'ClearStaticCellsViewGrid',
                        waitMessage: 'Удаление...',
                        success: function() {
                            view.touch();
                            view.createPreview();
                        }
                    });
                }
            });
        },

        setSidewallDate: function(comp, newValue, oldValue) {
            if (newValue !== oldValue) {
                var view = this;
                view.serverCall({
                    method: 'SetSidewallDate',
                    params: [newValue],
                    disableFog: true,
                    success: function() {
                        view.createPreview();
                    }
                });
            }
        },

        cellDblClickViewGrid: function(grid, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var colDesc = column.tag;
            
            if (column.isCheckColumn) return false;
            
            if (this.getCellDisableState(record, colDesc.ColumnLink)) return false;

            return true;
        },

        editTableViewGrid: function(e, context) {
            if (context.value === null) return false;
            if (context.value === context.originalValue) return false;

            var view = this;
            var rec = context.record;
            var dictionLink = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW');
            var dataIndex = context.field;
            var value = KS.Grid.getAnyCase(rec, dataIndex);

            view.serverCall({
                method: 'EditCellGridView',
                disableFog: true,
                params: [dictionLink, dataIndex, value],
                success: function(parsedStaticCells) {
                    view.data.parsedStaticCells = parsedStaticCells;
                    rec.callJoined('afterEdit', []); // Обновляем подкраску в статичных ячейках
                    view.touch();
                }
            });
            
            return true;
        },

        setManualHeaderRowsHeight: function () {
            var view = this.parentView || this;
            var headerRowsHeightWin = KS.showModal({
                xtype: 'numberfield',
                anchor: '100%',
                itemId: 'rowsHeight',
                fieldLabel: 'Число строк в заголовках таблицы:',
                labelWidth: 220,
                padding: 10,
                value: view.data.countRowsInHeader ? view.data.countRowsInHeader : 1,
                maxValue: view.maxCountRowsInHeader,
                minValue: 1
            }, {
                layout: 'vbox',
                plain: true,
                frame: true,
                modal: true,
                minHeight: 110,
                height: 110,
                width: 420,
                resizable: false,
                title: 'Установить высоту заголовков таблицы',
                buttonAlign: 'right',
                buttons: [{
                    text: 'Сохранить',
                    cls: 'marked-button',
                    handler: function () {
                        var rowsCount = headerRowsHeightWin.getComponent('rowsHeight').getValue();
                        view.serverCall({
                            method: 'SetHeaderRowsHeight',
                            disableFog: true,
                            params: [rowsCount]
                        });
                        view.data.countRowsInHeader = rowsCount;
                        view.setCountRowsInHeader();
                        headerRowsHeightWin.close();
                    }
                }, {
                    text: 'Отмена',
                    cls: 'marked-button',
                    handler: function () {
                        headerRowsHeightWin.close();
                    }
                }]
            }, true);
        },

        setAdditionalStyles: function() {
            this.addCountRowsInHeaderStyles();
            this.setRowsHeight();
            this.setColumnsAlign();
        },

        addCountRowsInHeaderStyles: function() {
            if (this.data.countRowsInHeader > 0) {
                if (!window.tableStructCountRowsInHeaderClassAdded) {
                    var rowHeight = KS.theme === 'Classic' ? 13 : 16;
                    for (var countRows = 1; countRows <= this.maxCountRowsInHeader; countRows++) {
                        $("<style type='text/css'>" +
                            ".tableHeaderRows" + countRows + " .ks-column-header-text {" +
                            "white-space: normal !important;" +
                            "overflow: hidden !important;" +
                            "text-align: center;" +
                            "height: auto;" +
                            "max-height: " + (countRows * rowHeight).toString() + "px;" +
                            "}</style>").appendTo("head");
                    }
                    window.tableStructCountRowsInHeaderClassAdded = true;
                }
                this.setCountRowsInHeader();
            }
        },

        setCountRowsInHeader: function() {
            var countRows = this.data.countRowsInHeader;
            if (this.viewGrid && countRows > 0) {
                for (var i = 1; i <= this.maxCountRowsInHeader; i++) {
                    this.viewGrid.removeCls("tableHeaderRows" + i);
                }
                this.viewGrid.addCls("tableHeaderRows" + countRows);
                KS.updateLayout(this.viewGrid);
            }
        },
        
        setRowsHeight: function() {
            var rh = this.data.rowHeight;
            if (!window.tableStructRowClassAdded && rh > 0 && rh !== 20) {
                $("<style type='text/css'>" +
                    ".view-grid .x-grid-row td .x-grid-cell-inner {height:" + rh + "px; white-space : normal; }" +
                    "</style>").appendTo("head");
                window.tableStructRowClassAdded = true;
            }
        },    

        setColumnsAlign: function() {
            if (!window.tableStructColumnAlignClassAdded) {
                $("<style type='text/css'>" +
                    ".view-grid .x-column-header-text-container {text-align: center; }" +
                    "</style>").appendTo("head");
                window.tableStructColumnAlignClassAdded = true;
            }
        }
    });
}(ReportTableStructView.prototype));  

// ============= ATTR_GRID =======================
(function(viewClass) {
    KS.apply(viewClass, {
        celldblclickAttrGrid: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var col = e.position.column;
            if (col.dataIndex === "VISIBLE_VALUE") {
                var linkDiction = KS.Grid.getAnyCase(record, "link_diction");
                if (!Ext.isEmpty(linkDiction)) {
                    var closeCode = KS.Grid.getAnyCase(record, "ENTITY_CLOSE_CODE");
                    var gridId = gridView.grid.ctrlId;
                    this.serverCall({
                        method: 'SelectDictionAttrCell',
                        disableFog: true,
                        params: [closeCode, gridId]
                    });
                    return false;
                }
            }
            return true;
        },

        editAttrGridCell: function(plugin, context) {
            if (context.originalValue !== context.value) {
                var dataIndex = context.field;
                var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
                var newValue = context.value;
                var gridId = context.grid.ctrlId;
                var view = this;
                this.serverCall({
                    method: 'EditAttrGridCell',
                    disableFog: true,
                    params: [closeCode, dataIndex, newValue, gridId],
                    success: function() {
                        view.touch();
                    }
                });
                this.touch();
            }
        }
    });
}(ReportTableStructView.prototype));

Ext.define('dictionCodePositionEditor',
    {
        extend: 'KS.Ext.Grid.numberEditor',
        minValue: 1,
        maxValue: 100,
        allowBlank: false,
        allowDecimals: false,
        allowNegative: false,
        style: 'text-align:right'
    });

Ext.define('ReportTableStruct.numberEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        maskRe: /[0-9.,-]/,
        fieldStyle: {
            textAlign: 'right'
        },
        selectText: selectTextInEditor
    });

// Проверить, является ли ячейка статичной, с введенным значением
function isNonEmptyStaticCell(metadata) {
    var record = metadata.record,
        view = record.store.grid.parentView,
        linkDictionRow = KS.Grid.getAnyCase(record, "LINK_DICTION_ROW"),
        staticCells = view.data.parsedStaticCells;
    if (!Ext.isEmpty(linkDictionRow) && !Ext.isEmpty(staticCells) && !Ext.isEmpty(staticCells[linkDictionRow])) {
        var colLink = metadata.column.tag.ColumnLink;
        if (!Ext.isEmpty(colLink) && !Ext.isEmpty(staticCells[linkDictionRow][colLink])) 
            return true;
    }
    return false;
}

function checkReadOnlyColumnAsStatic(metadata, defaultStyle) {
    var cellCss = defaultStyle;
    if (isNonEmptyStaticCell(metadata)) {
        setSidewallColumnAsStatic(metadata);
    } else if (!metadata.column.editable) {
        cellCss = ' sidewall-cell';
    }
    metadata.css += cellCss;
}

function setSidewallColumnAsStatic(metadata) {
    metadata.css += ' static-cell'; 
    setTooltip(metadata, "Сохранено статичное значение");
}

function getStructTableFormat(value, metadata, record) {
    var view = record.store.grid.parentView;
    var colDesc = metadata.column.tag;
    var isDisabled = view.getCellDisableState(record, colDesc.ColumnLink),
        newValue = value,
        needParse = true,
        cellCss = "";

    if (isDisabled === true) {
        var isEmpty = view.isCellEmpty(value, colDesc);
        if (!isEmpty) {
            metadata.attr = 'ext:qtip=\"В ячейке сохранено значение: (' + value + ")\"";
        }
        cellCss = ' default-cell-disabled x-center-cell-align x-bold-cell';
        needParse = false;
        var disableCellValue = view.data.disableCellValue;
        if (isEmpty && disableCellValue) {
            newValue = disableCellValue;
            needParse = false;
        }
    } else if (isNonEmptyStaticCell(metadata)) {
        setSidewallColumnAsStatic(metadata);
    }

    return {
        newValue: newValue,
        cellCss: cellCss,
        needParseNewValue: needParse
    };
}

function rtsNumberRenderer(value, metadata, record, rowIndex) {
    try {
        var colDesc = metadata.column.tag,
            rtf = getStructTableFormat(value, metadata, record, rowIndex),
            retValue = rtf.newValue || '0';
        if (rtf.cellCss) 
            metadata.css += rtf.cellCss;
        if (!rtf.needParseNewValue) return retValue;
        retValue = KS.Svod.normalizeFloatValue(retValue, colDesc.ActualLength, colDesc.Divider);
        return retValue.replace(/(\d)(?=(\d\d\d)+([^\d]|$))/g, '$1 ');
    } catch (e) {
        var errMsg = ((e.message == null) ? e.toString() : e.message);
        metadata.attr = 'ext:qtip=\"(' + value + ")" + errMsg.replace(/"/g, "'") + '\"';
        return value;
    }
}

function rtsAutoIncrementRenderer(value, metadata) {
    setTooltip(metadata, value);
    checkReadOnlyColumnAsStatic(metadata, ' sidewall-cell');
    return KS.getNbspString(value);
}

function rtsSwallNonCodeDictRenderer(value, metadata) {
    setTooltip(metadata, value);
    checkReadOnlyColumnAsStatic(metadata, ' sidewall-dict-cell');
    return KS.getNbspString(value);
}

function rtsSidewallRenderer(value, metadata) {
    setTooltip(metadata, value);
    checkReadOnlyColumnAsStatic(metadata, ' sidewall-dict-cell');
    return KS.getNbspString(value);
}

function rtsSelectFromDictionRenderer(value, metadata, record) {
    setTooltip(metadata, value);
    var rtf = getStructTableFormat(value, metadata, record);
    if (rtf.cellCss) {
        metadata.css += rtf.cellCss;
    } else {
        if (!metadata.column.editable)
            metadata.css += ' sidewall-cell';
        else
            metadata.css += ' sidewall-dict-cell';
    }
    return KS.getNbspString(rtf.newValue || value);
}

function rtsGroupRenderer(value, metadata) {
    checkReadOnlyColumnAsStatic(metadata, ' group-cell');
    return KS.getNbspString(value);
}

function rtsNonSidewallDictRenderer(value, metadata, record) {
    setTooltip(metadata, value);
    var rtf = getStructTableFormat(value, metadata, record);
    metadata.css = metadata.css ? metadata.css : "";  
    if (rtf.cellCss.substring(14)) 
        metadata.css += rtf.cellCss;
    else 
        metadata.css += ' sidewall-dict-cell';  
    
    var colDesc = metadata.column.tag;
    if (colDesc.SubTable) {
        return (value) ? 'редактировать' : 'добавить';
    }
    return KS.getNbspString(rtf.newValue || value);
}

function rtsStringRenderer(value, metadata, record) {
    setTooltip(metadata, value);
    var rtf = getStructTableFormat(value, metadata, record);
    if (rtf.cellCss) metadata.css += rtf.cellCss;
    return KS.getNbspString(rtf.newValue);
}

function rtsDateTimeRenderer(value, metadata, record) {
    var rtf = getReportTableFormat(value, metadata, record);
    if (rtf.cellCss) metadata.css += rtf.cellCss;
    return KS.getNbspString(rtf.newValue);
}

function rtsAttrRenderer(value, metadata, record) {
    var linkDiction = KS.Grid.getAnyCase(record, "link_diction");
    if (!Ext.isEmpty(linkDiction)) {
        metadata.css += ' sidewall-dict-cell';
    }
    return value;
}

function rtsValuesListRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var vl = store.grid.valueLists;
    if (vl) {
        var colCfg = store.grid.getColCfgByIndex(colIndex);
        var colDataIndex = colCfg.dataIndex;

        var leftItemType = KS.Grid.getAnyCase(record, "LEFT_ITEM_TYPE");
        if (colDataIndex === "LEFT_ITEM_VALUE" &&
            (leftItemType === "TaskAttribute" || leftItemType === "Column")) {
            if (leftItemType === "TaskAttribute")
                colDataIndex = "LEFT_ITEM_VALUE_ATTR";
            else if (leftItemType === "Column")
                colDataIndex= "LEFT_ITEM_VALUE_COLUMN";
            colCfg.vlItems = null;
        }

        if (!colCfg.vlItems) {
            colCfg.vlItems = {};
            Ext.each(vl, function (vlEl) {
                if (vlEl.ColumnKey.toUpperCase() === colDataIndex.toUpperCase()) {
                    Ext.each(vlEl.Items, function (item) {
                        colCfg.vlItems[item.StringDataValue] = item.DisplayText;
                    });
                }
            });
        }
        return colCfg.vlItems[value] || value;
    }
    return value;
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();