﻿ReportStructGroupsDictionaryView = KS.extend(ReportStructDictionaryView, { });

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        resetView: function () {
            this.resetGrid();
            this.baseTree.getRootNode().removeAll(true);
            this.baseTree.fullReload();
            this.discardChanges();
        },

        getTbarClickHandler: function(tbarItem) {
            var sc = ReportStructGroupsDictionaryView.superclass;
            switch (tbarItem.code) {                    
                case "NEW":
                    return this.newHandler;

                case "PopupAddGroup":
                    return null;
                    
                case "MOVE":
                    return this.moveInGroup;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        }
    });
}(ReportStructGroupsDictionaryView.prototype));

// ============= TREE =======================
(function(viewClass) {
    KS.apply(viewClass, {

        exportFormGroups: function() {
            var view = this.parentView || this;
            var checkedNodes = view.baseTree.getChecked();
            if (Ext.isEmpty(checkedNodes)) {
                KS.alert("Не выбран ни один объект");
                return;
            }
            var selectedForms = [];
            Ext.each(checkedNodes, function(node) {
                selectedForms.push(node.getId());
            });
            view.serverCall({
                method: 'ExportFormGroups',
                params: [selectedForms]
            });
        },

        addGroup: function() {
            var view = this.parentView;
            view.showEditGroupPanel(null, true);
        },

        addChildGroup: function() {
            var view = this.parentView;
            var node = view.baseTree.getSelNode();
            if (!Ext.isEmpty(node))
                view.showEditGroupPanel(node.getId(), true);
        },

        editGroup: function() {
            var view = this.parentView;
            var node = view.baseTree.getSelNode();
            if (!Ext.isEmpty(node))
                view.showEditGroupPanel(node.getId(), false);
        },

        showEditGroupPanel: function(groupLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'GetEditGroupProperties',
                params: [groupLink, isNew],
                success: function(settings) {
                    view.showEditGroupPanelCallback(settings, groupLink, isNew);
                }
            });
        },

        showEditGroupPanelCallback: function(settings, groupLink, isNew) {
            if (Ext.isEmpty(settings)) return;
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "1. Общие");
            var view = this;
            this.formEditPanelWin =  KS.showModal(this.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: "anchor",
                height: 400, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditGroup(groupLink, isNew);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectGroup(groupLink, isNew);
                        }
                    }]
            }, true);
        },

        doEditGroup: function(groupLink, isNew) {
            var view = this;
            var newValues = this.propertyGrid.source;
            view.formEditPanelWin.close();
            view.serverCall({
                method: 'EditGroup',
                params: [newValues, groupLink, isNew],
                waitMessage: isNew ?  'Создание ...' : 'Редактрование ...',
                success: function() {
                    view.baseTree.getRootNode().removeAll(true);
                    view.baseTree.fullReload();
                }
            });
        },

        rejectGroup: function(groupLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'RejecGroup',
                params: [groupLink, isNew],
                waitMessage: 'Отмена...',
                success: function() {
                    view.formEditPanelWin.close();
                }
            });
        },

        deleteGroup: function() {
            var view = this.parentView || this;
            var checkedNodes = view.baseTree.getChecked();
            if (Ext.isEmpty(checkedNodes)) {
                var selNode = view.baseTree.getSelNode();
                if (!Ext.isEmpty(selNode)) {
                    checkedNodes.push(selNode);
                }
            }

            if (!Ext.isEmpty(checkedNodes)) {
                var checkedCodes = [];
                Ext.each(checkedNodes, function(node) {
                    checkedCodes.push(node.getId());
                });
                KS.confirm("Будет удалено строк: " + checkedNodes.length + ". Продолжить?",
                    "Подтвердите удаление", function(btn) {
                        if (btn === 'yes')
                            view.deleteGroupInternal(checkedCodes);
                    });
            }
        },

        deleteGroupInternal: function (checkedCodes) {
          this.serverCall({
                method: 'DeleteGroup',
                params: [checkedCodes],
                waitMessage: 'Удаление ...',
                success: this.deleteCallback
            });
        },

        deleteCallback: function(deleted) {
            if (deleted) {
                this.baseTree.getRootNode().removeAll(true);
                this.baseTree.fullReload();
                this.mainGrid.reload();
            }
        },

        changeSearchPanelVisible: function() {
            var view = this.parentView || this;
            if (view.searchPanel.getHidden()) 
                view.searchPanel.setHidden(false);
            else
                view.searchPanel.setHidden(true);
        },

        hideSearchPanel: function() {
            var view = this.parentView || this;
            view.searchPanel.setHidden(true);
        },

        searchFieldChange: function(comp, newVal) {
            this.baseTree.ksObjs.ksProgressBar.showProgressBar();

            if (newVal.indexOf('/') !== -1) {
                var splitted = newVal.split('/ ');
                if (splitted && splitted.length) {
                    newVal = splitted[splitted.length - 1];
                }
            }

            var me = this,
                stringCompare = function(val, filterVal) {
                    return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                },
                store = me.baseTree.store;

            //Фильтрация снизу вверх
            store.filterer = 'bottomup';
            store.filter({
                property: 'text',
                filterFn: function(item) {
                    var ind = stringCompare(item.get('text'), newVal);
                    return Ext.isNumber(ind) && ind !== -1;
                },
                value: newVal
            });

            newVal && newVal.length ? me.baseTree.expandAll() : me.baseTree.collapseAll();

            //Скрытие делаем по таймауту, т.е. пользователь может продолжать вводить значения
            if (me.updateTimeoutId) clearTimeout(me.updateTimeoutId);
            me.updateTimeoutId = setTimeout(function() {
                delete me.updateTimeoutId;
                me.baseTree.ksObjs.ksProgressBar.hideProgressBar();
            }, 1500);
        },

        clearSearchField: function() {
            var view = this.parentView || this;
            var searchBtn = view.getToolbarItem(view.searchPanel, null, "searchField");
            if (searchBtn) {
                searchBtn.setValue("");
            }
        },

        showSystemJournal: function() {
            var view = this.parentView || this;
            var nodeId = view.baseTree.getSelNodeId();
            var checkedNodes = view.baseTree.getChecked();
            var checkedCodes = [];
            Ext.each(checkedNodes, function(checkedNode) {
                checkedCodes.push(checkedNode.id);
            });
            view.serverCall({
                method: 'ShowSystemJournal',
                params: [(nodeId === 'filter_off') ? null : nodeId, checkedCodes]
            });
        }
    });
}(ReportStructGroupsDictionaryView.prototype));

// ============= GRID =======================
(function(viewClass) {
    KS.apply(viewClass, {
        newHandler: function() {
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            if (!Ext.isEmpty(selNode)) {
                var treeLink = selNode.getId();
                view.serverCall({
                    method: 'GetSelectFormsGrid',
                    params: [treeLink],
                    success: view.showSelectFormGrid
                });
            }
        },

        showSelectFormGrid: function(selectFormsGrid) {
            if (Ext.isEmpty(selectFormsGrid)) return;
            var view = this;
            view.selectFormsGrid = this.createTemplateControl(selectFormsGrid);
            view.selectFormsWin = KS.showModal(view.selectFormsGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(600, KS.rootViewport.getWidth() / 2),
                height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', 
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.addFormsToGroup();
                        }
                    }, 
                    {   xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectFormsWin.close();
                        }
                    }]
            }, true);
        },

        addFormsToGroup : function() {
            var view = this;
            var treeLink = this.selectFormsGrid.groupLink;
            var checkedCodes = this.selectFormsGrid.getCheckedCodes();
            this.selectFormsWin.close();
            if (!Ext.isEmpty(checkedCodes)) {
                this.serverCall({
                    method: 'AddFormsToGroup',
                    params: [treeLink, checkedCodes],
                    success: function() {
                        view.setTreeFilter(view.baseTree.getSelNode());
                    }
                });
            }
        },

        deleteHandler: function() {
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            if (selNode) {
                var nodeText = KS.Grid.getAnyCase(selNode, "text");
                var nodeCode = nodeText.substring(nodeText.indexOf("[") + 1, nodeText.indexOf("]"));
                var checkedCodes = view.mainGrid.getCheckedCodes();
                KS.confirm("Исключить выделенные объекты из " + nodeCode + "?",
                    "Внимание", function(btn) {
                        if (btn === 'yes')
                            view.deleteFormsFromGroup(selNode.getId(), checkedCodes);
                    });
            }
        },

        deleteFormsFromGroup: function(treeLink, checkedCodes) {
            var view = this;
            this.serverCall({
                method: 'DeleteFormsFromGroup',
                params: [treeLink, checkedCodes],
                success: function() {
                    view.setTreeFilter(view.baseTree.getSelNode());
                }
            });
        },

        moveInGroup: function(){
            var view = this.parentView || this;
            var oldNodeId = view.baseTree.getSelNodeId();
            var formLinks = view.mainGrid.getCheckedCodes();
            if (!Ext.isEmpty(oldNodeId) && !Ext.isEmpty(formLinks)){
                view.serverCall({
                    method: 'GetSelectGroupsGrid',
                    waitMessage: 'Получение таблицы...',
                    success: function(selectGroupsGrid){
                        view.showSelectGroupsGrid(selectGroupsGrid, oldNodeId, formLinks);
                    }
                });
            }
        },

        showSelectGroupsGrid: function(selectGroupsGrid, oldNodeId, formLinks) {
            if (Ext.isEmpty(selectGroupsGrid)) return;
            var view = this;
            view.selectGroupsGrid = this.createTemplateControl(selectGroupsGrid);
            view.selectGroupsWin = KS.showModal(view.selectGroupsGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(500, KS.rootViewport.getWidth() / 3),
                height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', 
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.moveFormsInGroup(oldNodeId, formLinks);
                        }
                    }, 
                    {   xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectGroupsWin.close();
                        }
                    }]
            }, true);
        },

        moveFormsInGroup: function(oldNodeId, formLinks){
            var checkedLinks = this.selectGroupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedLinks)){
                this.selectGroupsWin.close();
                var newNodeId = checkedLinks[0];
                var view = this;
                this.serverCall({
                    method: 'MoveFormsFromGroup',
                    params: [oldNodeId, newNodeId, formLinks, false],
                    success: function() {
                        view.setTreeFilter(view.baseTree.getSelNode());
                    }
                });
            }
        }
    });
}(ReportStructGroupsDictionaryView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();