﻿ReportStructDictionaryView = KS.extend(BaseTreeView, { });

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        getTbarClickHandler: function(tbarItem) {
            var sc = ReportStructDictionaryView.superclass;
            switch (tbarItem.code) {
                case "NEW":
                case "EDIT":
                case "COPY":
                case "SHOW_ALL":
                case "SHOW_ACTIVE":
                case "CHECK_SUMS_IN_DOCUMENT":
                case "CHECK_SUMS_BETWEEN_DOCUMENT":
                case "EXPORT":
                case "IMPORT":
                case "SYSTEM_JOURNAL":
                case "CHECK_SUMS_BETWEEN_COPY":
                    return this.executeToolbarOperation;

                case "G_FORMS":
                case "K_FORMS":
                case "M_FORMS":
                case "W_FORMS":
                case "D_FORMS":
                case "L_FORMS":
                case "N_FORMS":
                    return this.setFormsFilter;

                case "CHECK_SUMS_OPTIONS":
                case "SERVICE":
                case "SETTINGS":
                    return null;

                case "FILTER":
                    return this.setTreeCollaps;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        executeToolbarOperation: function() {
            var view = this.parentView,
                grid = view.mainGrid;
            if (grid && this.tbarNode) {
                var code = this.tbarNode.code || '';
                view.executeOperation(code, grid);
            }
        },

        executeOperation: function (opCode, grid, additional) {
            var operWithSelectRows = ["EDIT", "COPY", "CHECK_SUMS_IN_DOCUMENT", "CHECK_SUMS_BETWEEN_DOCUMENT", "EXPORT", "CHECK_SUMS_BETWEEN_COPY", "SYSTEM_JOURNAL"],
                rows = [];

            if (operWithSelectRows.indexOf(opCode) !== -1) {
                rows = this.buildChosenRows(grid);
                this.currentOpArgs = [].slice.call(arguments);

                if (Ext.isEmpty(rows) && opCode !== "NEW") {
                    KS.alert("Для выполнения операции необходимо выбрать одну или несколько форм");
                    return;
                }
            }

            this.serverCall({
                method: 'OnExecuteOperation',
                params: [opCode, rows, additional || {}],
                success: this.afterExecuteOperation
            });
        },
        
        reloadGrid: function(){
            this.mainGrid.pageCacheLib.reset(); // При переключении страниц и смене фильтров не обновлялись данные  
            this.resetGrid(); 
        },

        afterExecuteOperation: function(opCode) {
            switch (opCode) {
                case "SHOW_ALL":
                case "SHOW_ACTIVE":
                    this.reloadGrid();
                    break;
            }
        },

        setTreeFilter: function (node) {
            var nodeId = node.id;
            this.serverCall({
                method: 'SetGroupFilter',
                params: [(nodeId === 'filter_off') ? null : nodeId],
                waitMessage: 'Фильтрация ...',
                success: this.reloadGrid
            });
        },

        setFormsFilter: function() {
            var view = this.parentView || this;
            var buttonStates = view.getToogleButtonStates();
            view.serverCall({
                method: 'SetFormsFilter',
                params: [buttonStates],
                waitMessage: 'Фильтрация ...',
                success: view.reloadGrid
            });
        },

        getToogleButtonStates: function() {
            var view = this;
            var buttonStates = {};
            var toolbar = view.getToolbar(view.rootPanel);
            if (!toolbar)
                toolbar = view.getToolbar(view.mainGrid);
            if (toolbar)
                toolbar.items.each(function (item) {
                    if (item.enableToggle) {
                        buttonStates[item.tbarNode.code] = item.pressed;
                    }
                });
            return buttonStates;
        },

        setToggleButtonStates: function () {
            var view = this;
            var toolbar = view.getToolbar(view.rootPanel);
            if (!toolbar)
                toolbar = view.getToolbar(view.mainGrid);
            if (toolbar)
                toolbar.items.each(function (item) {
                    if (item.enableToggle) 
                        item.setPressed(true);
                });
            view.setFormsFilter();
        },

        setTreeCollaps: function(btn) {
            var view = this.parentView || this;
            var tree = view.baseTree;
            if (btn.pressed) 
                tree.expand();
            else 
                tree.collapse();
        },

        onServerCopyCheckSums: function(dict) {
            var view = this;
            KS.confirm(dict["msg"], "Внимание",
                function(btn) {
                    if (btn === 'yes') 
                        view.serverCall({
                            method: 'CopyCheckSums',
                            params: [dict]
                        });
                });
        },

        markInvertHandler: function () {
            this.parentView.mainGrid.markInvert();
        },

        markTopHandler: function() {
            this.parentView.mainGrid.markTop();
        },

        markAllHandler: function() {
            this.parentView.mainGrid.markAll();
        },

        markRestHandler: function() {
            this.parentView.mainGrid.markRest();
        },

        markBetweenHandler: function() {
            this.parentView.mainGrid.markBetween();
        },

        unmarkHandler: function() {
            this.parentView.mainGrid.unmark();
        },
        
        deleteHandler: function() {
            var view = this.parentView || this;
            var ccc = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(ccc)) return;
            KS.confirm(view.deleteConfirmMsg, "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc);
            });
        }
    });
}(ReportStructDictionaryView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();