﻿// ============= VIEW =======================
ReportCreationView2 = KS.extend(BaseSvodView, {
    constructor: function (viewId) {
        ReportCreationView2.superclass.constructor.call(this, viewId);
    },

    onTemplateRendered: function () {
        this.firstStep = (this.data.hasBudgetTreeSettings) ? 0 : 1;
        this.stype = +this.data.identifier.SvodType;
        if (!Ext.isEmpty(this.data.formCodeFilter)) {
            this.filter();
        }
        if (this.stype === 7 && this.data.identifier.TemplateLink) {
            this.svodFromTemplate();
        }
    }
});

// ============= TOOLBAR =======================
(function (viewClass) {
    var sc = ReportCreationView2.superclass;

    KS.apply(viewClass, {
        printGridPropertyName: 'attrGrid',

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'NEW':
                    return this.newHandler;

                case 'COPY':
                    return this.copyHandler;

                case 'DELETE':
                    return this.deleteHandler;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        buildContainerToolbarItemControl: function (tbarItem) {
            switch (tbarItem.code) {
                case 'CALCULATE_RESULTS':
                case 'OVERWRITE':
                case 'CHANGE_STATUS_NASTR':
                case 'REORG_INCLUDE':
                case 'SVOD_WITH_FILES':
                case 'SVOD_ONLY_LIQ':
                case 'HSAG':
                    var inst = new Ext.form.Checkbox({
                            boxLabel: tbarItem.name,
                            checked: tbarItem.checked,
                            disabled: tbarItem.disabled
                        }),
                        item = {
                            type: 'CHECK',
                            code: tbarItem.code,
                            control: inst
                        };
                    if (!this.tbarContainerItems)
                        this.tbarContainerItems = [];
                    this.tbarContainerItems.push(item);
                    return inst;
            }
            return sc.buildContainerToolbarItemControl.apply(this, arguments);
        }
    });
}(ReportCreationView2.prototype));

(function (viewClass) {
    KS.apply(viewClass, {

        svodFromTemplate: function () {
            if (!Ext.isEmpty(this.data.noReportsAvailableMsg)){
                KS.alert(this.data.noReportsAvailableMsg); // Почему то из модели не показывается ChooseBox.Show в нетКоре
                this.close();
                return;
            }

            var fr = this.formsGrid.store.data.items[0];
            if (Ext.isEmpty(fr)) return;
            fr.set('CHECKED', true);

            if (!this.hasVisibleAttributes(fr)) {
                this.setActiveItemInRootPanel(3);
                this.select();
            } else {
                var root = this.selectedFormsTree.getRootNode();
                this.clearSelectedFormsTree();
                root.appendChild({
                    text: KS.Grid.getAnyCase(fr, 'CODE') + ' - ' + KS.Grid.getAnyCase(fr, 'NAME'),
                    id: KS.Grid.getAnyCase(fr, 'LINK_FORM'),
                    leaf: true
                });
                this.setActiveItemInRootPanel(2);
                this.selectedFormsTree.selectFirstNode();
            }
        },

        setActiveItemInRootPanel: function (itemIndex) {
            this.rootPanel.setActiveItem(itemIndex);
            this.rootPanel.activeItem = itemIndex;
        },

        closeButton: function () {
            var view = this.parentView || this;
            view.close();
        },

        helpBtn: function () {
            var href = "Docs/html/index.html";
            href += '?' + '2012' + '.htm';
            window.open(href, "_blank", "status=yes,location=yes,toolbar=yes,resizable=yes,menubar=yes,scrollbars=yes");
        }
    });
}(ReportCreationView2.prototype));

// ============= WIZARD =======================
(function (viewClass) {
    KS.apply(viewClass, {

        getCurrentStep: function () {
            return this.rootPanel.activeItem;
        },

        validateTab: function (dir) {
            var view = this.parentView || this;
            if ((view.stype === 1 || view.stype === 2) &&
                view.getCurrentStep() === 0) {
                var nodeId = view.selectableBudgTree.getSelNodeId();
                if (!Ext.isEmpty(nodeId)) {
                    view.serverCall({
                        method: 'ValidateTypicalAndChecked',
                        params: [nodeId],
                        disableFog: true,
                        success: function (value) {
                            if (value) {
                                KS.confirm(
                                    "Вы действительно хотите выполнить свод из отмеченных на уровень, в котором выбраны отчетные формы?",
                                    "Подтвердите действие",
                                    function (btn) {
                                        if (btn === 'yes') {
                                            view.moveStep(dir);
                                        }
                                        return false;
                                    });
                            } else {
                                view.moveStep(dir);
                            }
                        }
                    });
                } else {
                    KS.alert('Не выбрана организация');
                }
            } else {
                view.moveStep(dir);
            }
            return false;
        },

        getNextStep: function () {
            var currStep = this.getCurrentStep();
            switch (currStep) {
                case 0:
                    if (!this.selectableBudgTree.getSelNode()) {
                        return 'Не выбрана организация';
                    } else if (this.data.hasStandartSvodSettings) {
                        return 1;
                    } else if (!this.allAttributesSelected() && this.hasVisibleAttributes()) {
                        return 2;
                    }
                    break;

                case 1:
                    if (Ext.isEmpty(this.getCheckedForms())) {
                        return 'Не выбрана ни одна форма';
                    } else if (this.hasVisibleAttributes()) {
                        return 2;
                    }
                    break;

                case 2:
                    if (!this.allAttributesSelected()) {
                        return 2;
                    }
                    break;
            }
            return null;
        },

        isCurrentStepLast: function () {
            var currStep = this.getCurrentStep();
            switch (currStep) {
                case 0:
                    return !this.data.hasStandartSvodSettings && this.allAttributesSelected();

                case 1:
                    return !this.hasVisibleAttributes();

                default:
                    return this.allAttributesSelected();
            }
        },

        moveStep: function (dir) {
            var view = this.parentView || this;
            var currStep = view.getCurrentStep(),
                nextStep = view.getNextStep(),
                gotoStep = currStep;

            var action = 'NEXT';
            if (dir.tbarNode) {
                action = dir.tbarNode.code;
            }
            switch (action) {
                case 'BACK':
                    if (currStep > view.firstStep)
                        gotoStep--;
                    break;

                case 'NEXT':
                    if (Ext.isString(nextStep)) {
                        KS.alert(nextStep);
                        return;
                    }
                    if (Ext.isNumber(nextStep)) {
                        gotoStep = nextStep;
                    }
                    if (view.isCurrentStepLast() || nextStep == null) {
                        view.select();
                        return;
                    }
                    break;
            }

            if (gotoStep === currStep) {
                if (gotoStep === 2) {
                    this.loadNextAttributeGrid();
                }
                return;
            }

            if (gotoStep === 2) {
                view.fillSelectedFormsTree();
                view.setActiveItemInRootPanel(gotoStep);
                view.selectedFormsTree.selectFirstNode();
            } else {
                view.setActiveItemInRootPanel(gotoStep);
            }

            view.getToolbarItem(view.rootPanel, 'bottom', 'BACK').setDisabled(gotoStep <= view.firstStep);
            view.setNextBtnText();
        },

        setNextBtnText: function () {
            var text =  this.isCurrentStepLast()
                ? (this.stype === 6 ? 'Создать' : 'Свод')
                : 'Далее';
            var nextBtn = this.getToolbarItem(this.rootPanel, 'bottom', 'NEXT');
            if (nextBtn){
                nextBtn.setText(text);
                nextBtn.setTooltip(text);
            }
        }
    });
}(ReportCreationView2.prototype));

// ============= FORMS/GROUPS =======================
(function (viewClass) {
    KS.apply(viewClass, {

        deleteFormCodeFilter: function () {
            this.parentView.getToolbarItem(this.parentView.formsGrid, null, 'formFilter').setValue('');
        },

        filter: function () {
            var view = this;
            view.saveFilterSettings();
            var formFilter = view.getToolbarItem(view.formsGrid, null, 'formFilter').getValue();
            this.formsGrid.getStore().filters.removeAll();
            if (Ext.isEmpty(view.groupTree.getChecked())) {
                view.formsGrid.getStore().filterBy(function(record) {
                    return !!view.checkFormFilter(record, formFilter);                    
                });
            } else {
                view.formsGrid.getStore().filterBy(function (record) {
                    return !!(view.checkGroup(record) && view.checkFormFilter(record, formFilter));                    
                });
            }
            KS.updateLayout(this.formsGrid);
        },

        saveFilterSettings: function () {
            var formCodeFilter = this.getToolbarItem(this.formsGrid, null, 'formFilter').getValue() || null;
            if (formCodeFilter === this.data.formCodeFilter)
                return;
            this.data.formCodeFilter = formCodeFilter;
            this.saveProfile({
                FormCodeFilter: formCodeFilter
            }, true);
        },

        checkGroup: function (record) {
            var view = this,
                result = false,
                groupLinks = [0],
                checkedNodes = view.groupTree.getChecked();
            if (Ext.isEmpty(record.get('LINK_GROUP'))) {
                return result;
            }
            Ext.each(record.get('LINK_GROUP').split('~'), function (groupLink) {
                if (+groupLink > 0) {
                    groupLinks.push(groupLink);
                }
            });
            Ext.each(groupLinks, function (groupLink) {
                Ext.each(checkedNodes, function (checkedNode) {
                    if (+checkedNode.id <= 0) {
                        result = true;
                    } else if (checkedNode.id === groupLink) {
                        result = view.checkFormLink(record);
                    }
                });
            });
            return result;
        },

        checkFormFilter: function (record, formFilter) {
            var formCode = record.get('CODE');
            return (Ext.isEmpty(formFilter)) ? true : formCode.toUpperCase().indexOf(formFilter.toUpperCase()) !== -1;
        },

        checkFormLink: function (rec) {
            var formLinks = this.data.FormLinks;
            if (Ext.isEmpty(formLinks) && this.data.identifier) {
                formLinks = this.data.identifier.FormLinks;
            }
            if (Ext.isEmpty(formLinks)) return true;
            if (formLinks.length === 1 && formLinks[0] === 0) {
                return true;
            }
            return (jQuery.inArray(+rec.get('LINK_FORM'), formLinks) >= 0);
        }
    });
}(ReportCreationView2.prototype));

// ============= SELECTED FORMS TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {

        clearSelectedFormsTree: function () {
            var view = this,
                root = view.selectedFormsTree.getRootNode();
            Ext.each(root.childNodes, function (on) {
                if (on && on.attrGrid) {
                    on.attrGrid.destroy();
                }
            });
            this.selectedFormsTree.getRootNode().removeAll(true);
        },

        fillSelectedFormsTree: function () {
            var view = this,
                root = view.selectedFormsTree.getRootNode();
            view.clearSelectedFormsTree();
            Ext.each(view.getCheckedForms(), function (fr) {
                if (view.hasVisibleAttributes(fr)) {
                    root.appendChild({
                        text: KS.Grid.getAnyCase(fr, 'CODE') + ' - ' + KS.Grid.getAnyCase(fr, 'NAME'),
                        id: KS.Grid.getAnyCase(fr, 'LINK_FORM'),
                        leaf: true
                    });
                }
            });
        },

        selectedFormsTreeSelect: function (sm, nodeObj) {
            if (Ext.isEmpty(nodeObj)) {
                return;
            } else {
                var node = nodeObj[0] || nodeObj;
                this.loadAttributes(node.id);
            }
        }
    });
}(ReportCreationView2.prototype));

// ============= ATTRIBUTES =======================
(function (viewClass) {
    KS.apply(viewClass, {

        setVisibleAttributesAbility: function () {
            if (this.getToolbarItem(this.rootPanel, null, 'HSAG')) {
                this.getToolbarItem(this.rootPanel, null, 'HSAG').setDisabled(!this.hasSvodAllGroups());
            }
        },

        hasVisibleAttributes: function (rec) {
            var view = this;
            if (rec) {
                var hva = rec.get('HAS_VISIBLE_ATTRIBUTE');
                return (hva && hva.toLowerCase() === 'true');
            }
            var res = false;
            Ext.each(view.getCheckedForms(), function (r) {
                if (r && view.hasVisibleAttributes(r)) {
                    res = true;
                }
            });
            return res;
        },

        loadAttributes: function (formLink) {
            var sbnId = this.selectableBudgTree.getSelNodeId();
            this.serverCall({
                method: 'DoLoadSvodSettings',
                params: [formLink, this.getCheckedBudgetTreeNodesId(), sbnId],
                waitMessage: 'Чтение атрибутов ...',
                success: this.renderAttrGrid
            });
        },

        renderAttrGrid: function (data) {
            if (data && data.attrGrid) {
                data.attrGrid.parentView = this;
                this.attrGrid = KS.create(data.attrGrid);
                this.attrGridContainerPanel.removeAll(false);
                this.attrGridContainerPanel.add(this.attrGrid);
                KS.updateLayout(this.attrGridContainerPanel);
                this.selectedFormsTree.getSelNode().attributeLoaded = true;
                this.setNextBtnText();
            }
        },

        allAttributesSelected: function () {
            var res = true;
            if (!this.selectedFormsTree.getSelNode()) {
                this.selectedFormsTree.selectFirstNode();
                return false;
            }
            this.selectedFormsTree.getStore().each(function(node) {
                if (node.attributeLoaded !== true)
                    res = false;
            });
            return res;
        },

        loadNextAttributeGrid: function() {
            var firstNotLoadedNode = null;
            this.selectedFormsTree.getStore().each(function(node) {
                if (node.attributeLoaded !== true) {
                    firstNotLoadedNode = node;
                    return false;
                }
                return true;
            });
            if (!Ext.isEmpty(firstNotLoadedNode)) {
                firstNotLoadedNode.attributeLoaded = true;
                this.selectedFormsTree.getSelectionModel().select(firstNotLoadedNode);
            }
        },

        attrGridClick: function (gridView, td, iCol, record, tr, rowIndex, e) {
            var col = e.position.column;
            var colKey = col.dataIndex;
            if (colKey === 'CHECKED') {
                var checkState = KS.Grid.getAnyCase(record, colKey);
                var linkRow = KS.Grid.getAnyCase(record, "LINK_ROW");
                this.afterEditHandler({
                    row: linkRow,
                    field: colKey,
                    value: checkState
                });
                return false;
            }
            return true;
        },

        saveCheckedState: function () {
            var checkedRows = this.getCheckedAttrRows();
            var checkedLinkRows = this.getLinkRows(checkedRows);
            this.serverCall({
                method: 'SaveCheckedState',
                disableFog: true,
                params: [checkedLinkRows]
            });
        },

        markInvertHandler: function () {
            var view = this.parentView || this,
                grid = view.attrGrid;

            grid.store.each(function (rec) {
                grid.checkRecord(rec, !rec.get('CHECKED'));
            });
            view.saveCheckedState();
        },

        markTopHandler: function (){
            var view = this.parentView || this,
                grid = view.attrGrid,
                sel = view.getCheckedAttrRows();

            if (sel.length) {
                grid.store.each(function(rec) {
                    if (!sel.length) return false;
                    grid.checkRecord(rec, true);
                    KS.Array.remove(sel, rec);
                    return true;
                });
                view.saveCheckedState();
            } else {
                view.markAllHandler();
            }
        },

        markAllHandler: function(){
            var view = this.parentView || this,
                grid = view.attrGrid;

            grid.store.each(function (rec) {
                grid.checkRecord(rec, true);
            });
            view.saveCheckedState();
        },

        markRestHandler: function(){
            var view = this.parentView || this,
                grid = view.attrGrid,
                sel = view.getCheckedAttrRows(),
                recs = grid.store.getRange();

            if (sel.length) {
                Ext.each(recs, function(rec) {
                    if (!sel.length) return false;
                    grid.checkRecord(rec, true);
                    KS.Array.remove(sel, rec);
                    return true;
                }, grid, true); // true - reverse
                view.saveCheckedState();
            } else {
                view.markAllHandler();
            }
        },

        markBetweenHandler: function(){
            var view = this.parentView || this,
                grid = view.attrGrid,
                store = grid.getStore(),
                frst = false,
                last = false;

            store.each(function(rec) {
                if (rec.get('CHECKED')) {
                    if (!frst) frst = rec;
                    last = rec;
                }
            });

            if (frst) {
                var start = store.indexOf(frst),
                    end = store.indexOf(last);

                Ext.each(store.getRange(start, end), function(rec) { grid.checkRecord(rec, true); });
            }
            view.saveCheckedState();
        },

        unmarkHandler: function () {
            var view = this.parentView || this,
                grid = view.attrGrid;

            grid.store.each(function (rec) {
                grid.checkRecord(rec, false);
            });
            view.saveCheckedState();
        },

        attrRowDblClickHandler: function (gridView, td, cellIndex, record, tr, rowIndex, e) {
            if (e.type === "keydown")
                return false;

            if (!this.attrGrid || !(this.attrGrid.getSelectionModel().selection || this.attrGrid.getSelectionModel().selections))
                return false;
            var cfg = this.attrGrid.columns, 
                col = cfg[cellIndex],
                grid = gridView.grid,                           
                formLinks = parseInt(grid.itemId.split('_')[1], 10);
            if (!formLinks) {
                return false;
            }
            if (col.renderer === dictRenderer) {
                var colkey = col.dataIndex.replace("_CODE", "_TEXT"),
                    sbnId = this.selectableBudgTree.getSelNodeId(),
                    linkRow = KS.Grid.getAnyCase(record, "LINK_ROW");
                this.serverCall({
                    method: 'SelectDiction',
                    params: [linkRow, colkey, formLinks, sbnId],
                    waitMessage: 'Открытие справочника'
                });
                return false;
            }
            return true;
        },

        getCheckedAttrRows: function () {
            var checkedRows = [];
            this.attrGrid.store.each(function (rec) {
                if (KS.Grid.getAnyCase(rec, 'CHECKED'))
                    checkedRows.push(rec);
            });
            return checkedRows;
        },

        getLinkRows: function(rows){
            var linkRows = [];
            Ext.each(rows, function (rec) {
                linkRows.push(KS.Grid.getAnyCase(rec, "LINK_ROW"));
            });
            return linkRows;
        },

        newHandler: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'AddRow',
                disableFog: true,
                success: function (dict) {
                    view.attrGrid.addRecord(dict);
                }
            });
        },

        deleteHandler: function(){
            var view = this.parentView,
                grid = view.attrGrid,
                checkedRows = view.getCheckedAttrRows();
            if (Ext.isEmpty(checkedRows)) return;
            KS.confirm("Будет удалено строк: " + checkedRows.length + ". Продолжить?" , "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    var linkRows = view.getLinkRows(checkedRows);
                    view.serverCall({
                        method: 'DeleteRows',
                        params: [linkRows],
                        waitMessage: 'Удаление ...',
                        success: function () {
                            grid.getStore().remove(checkedRows);
                        }
                    });
                }
            });
        },

        copyHandler: function(){
            var view = this.parentView,
                grid = view.attrGrid,
                checkedRows = view.getCheckedAttrRows();
            if (Ext.isEmpty(checkedRows)) return;
            var linkRows = view.getLinkRows(checkedRows);
            view.serverCall({
                method: 'CopyRow',
                params: [linkRows[0]],
                disableFog: true,
                success: function (dict) {
                    if (dict)
                        grid.addRecord(dict);
                }
            });
        },

        afterEditAttrField: function(e) {
            var context = e.context;
            if (Ext.isEmpty(context)) return;
            var linkRow = KS.Grid.getAnyCase(context.record, "LINK_ROW");
            this.afterEditHandler({
                row: linkRow,
                field: context.field,
                value: context.value
            });
        },

        afterEditHandler: function (e) {
            this.serverCall({
                method: 'SaveCell',
                params: [e.row, e.field, e.value],
                disableFog: true,
                success: this.setNextBtnText
            });
        }
    });
}(ReportCreationView2.prototype));

// ============= SELECT =======================
(function (viewClass) {
    KS.apply(viewClass, {
        getCheckedForms: function () {
            var r = [];
            if (this.stype !== 2 && this.stype !== 7) {
                r = this.formsGrid.checkList;
            } else {
                this.formsGrid.store.each(function (rec) {
                    if (KS.Grid.getAnyCase(rec, 'CHECKED')) 
                        r.push(rec);
                });
            }
            return r;
        },

        getCheckedFormFieldValues: function (field) {
            var r = [];
            Ext.each(this.getCheckedForms(), function (rec) {
                r.push(KS.Grid.getAnyCase(rec, field));
            });
            return r;
        },

        getCheckedFormLinks: function () {
            return this.getCheckedFormFieldValues('LINK_FORM');
        },

        getCheckedBudgetTreeNodesId: function () {
            var r = [];
            Ext.each(this.budgTree.getChecked(), function (node) {
                r.push(node.id);
            });
            return r;
        },

        hasSvodAllGroups: function (rec) {
            var view = this;
            if (rec) {
                var hsag = rec.get('HAS_SVOD_ALL_GROUP');
                return (hsag && hsag.toLowerCase() === 'true');
            }
            var res = false;
            Ext.each(view.getCheckedForms(), function (r) {
                if (r && view.hasSvodAllGroups(r)) {
                    res = true;
                }
            });
            return res;
        },

        select: function () {
            var formLinks = this.getCheckedFormLinks(),
                checkedStdBudgetNodesId = this.getCheckedBudgetTreeNodesId(),
                sbnId = this.selectableBudgTree.getSelNodeId(),
                additional = this.collectContainerItemsValues();
            if (this.getToolbarItem(this.rootPanel, null, 'HSAG')) {
                if (this.hasSvodAllGroups() && this.getToolbarItem(this.rootPanel, null, 'HSAG').getValue()) {
                    additional["SVOD_ONE_GROUP"] = true;
                }
            }
            this.containerPanel.mask("Пожалуйста, подождите...");
            var view = this;
            view.serverCall({
                method: 'Select',
                waitMessage: 'Сбор данных ...',
                params: [formLinks, checkedStdBudgetNodesId, sbnId, additional],
                success: function (action) {
                    if (action === 0) {
                        view.containerPanel.unmask();
                    } else {
                        if (action === 1) view.refreshTaskList();
                    }
                },
                error: view.containerPanel.unmask
            });
        }
    });
}(ReportCreationView2.prototype));

(function (viewClass) {
    KS.apply(viewClass, {
        onValuesSelected: function (arg) {
            var rowIdx = 0;
            var setRow;
            var arguments = arg[0][0];
            for (var itemArg in arguments) {
                if (arguments.hasOwnProperty(itemArg) &&
                    itemArg.indexOf("SET_ROW_") === 0) {
                    setRow = arguments[itemArg];
                    rowIdx = +itemArg.replace("SET_ROW_", "");
                }
            }
            if (setRow) {
                var rec = this.attrGrid.store.getAt(rowIdx);
                for (var field in setRow) {
                    if (setRow.hasOwnProperty(field)) {
                        rec.set(field, setRow[field]);
                    }
                }
            }
            this.attrGrid.reload();
        }
    });
}(ReportCreationView2.prototype));

Ext.define('ReportCreation2.dictionEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        style: 'text-align:center'
    });

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();