﻿PostsDictionaryView = KS.extend(BaseDictionaryView,
    {
        newHandler: function() {
            var view = this.parentView;
            view.getPostGridData("NEW", 0);
        },
        
        editHandler: function() {
            var view = this.parentView;
            var ccc = view.mainGrid.getCheckedCodes(true);
            if (Ext.isEmpty(ccc)) return;
            if (ccc[0]) {
                view.getPostGridData("EDIT", ccc[0]);
            }
        },
        
        getPostGridData: function(mode, postId) {
            var view = this;
            view.serverCall({
                method: 'GetPostGridData',
                waitMessage: 'Открывается ...',
                params: [mode, postId],
                success: function(settings) {
                    view.showCreateNewPost(settings, mode === "EDIT", postId);
                }
            });
        },

        showCreateNewPost: function(settings, isEdit, postId) {
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            var view = this;
            this.postPanelWin =  KS.showModal(this.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: "anchor",
                height: 400, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: new Array('->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditPost(isEdit, postId);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectPost(isEdit, postId);
                        }
                    })
            }, true);
        },

        doEditPost: function(isEdit, postId) {
            var view = this;
            var newValues = this.propertyGrid.source;
            view.postPanelWin.close();
            view.serverCall({
                method: 'EditPost',
                params: [newValues, isEdit, postId],
                waitMessage: isEdit ? 'Редактрование ...' : 'Создание ...',
                success: function(result) {
                    if (result === true) {
                        view.mainGrid.reload();
                    }
                }
            });
        },

        rejectPost: function(isEdit, postId) {
            var view = this;
            view.serverCall({
                method: 'RejectPost',
                params: [isEdit, postId],
                waitMessage: 'Отмена...',
                success: function() {
                    view.postPanelWin.close();
                }
            });
        }

    });

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();