﻿PlannerEditView = KS.extend(BaseSvodView, {});

// ============= COMMON =======================
(function (viewClass) {
    var sc = PlannerEditView.superclass;
    KS.apply(viewClass, {
        
        onTemplateRendered: function () {
            if (!this.data.isNewShedule)
                this.discardChanges();
            this.setCustomComboBoxExpand(this.budgetTreePanel);
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'MENU-1239920700':
                    return null;

                case 'ADD_USER':
                    return this.addUser;
                
                case 'ADD_GROUP':
                    return this.addGroup;
                
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },
        
        saveChanges: function() {
            var view = this.parentView || this;
            var options = view.sheduleProperties.source;
            var checkedBudgets = view.getCheckedBudgetTreeNodesId();
            view.serverCall({
                method: 'SaveSheduleChanges',
                params: [options, checkedBudgets],
                waitMessage: 'Сохранение...'
            });
        },

        onServerIgnoreSaveWarnings: function() {
            var view = this;
            KS.confirm("Игнорировать найденные ошибки?" , "Внимание", function (btn) {
                if (btn === 'yes')
                    view.serverCall({
                        method: 'SaveChanges',
                        waitMessage: 'Сохранение...',
                        success: view.onServerSaveChangesCallback
                    });
            });
        },
        
        onServerSaveChangesCallback: function(hasSaveErrors) {
            if (hasSaveErrors === true) {
                KS.alert('Документ не сохранен!');
                return;
            }
            this.discardChanges();
            this.reload();
        },

        resetView: function () {
            this.loadSheduleProperties();

            this.periodsGrid.reload();
            this.usersGrid.reload();

            this.reloadFormsTree();
            this.reloadBudgetTree();
        },
        
        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        loadSheduleProperties: function() { // beforerender shedulePropertiesPanel
            this.serverCall({
                method: 'GetSheduleProperties',
                success: this.addSheduleProperties
            });
        },

        addSheduleProperties: function(settings) {
            if (settings) {
                this.shedulePropertiesPanel.removeAll();
                this.sheduleProperties = this.getPropertyGridByOption(settings, "sheduleProperties", "Общие");
                this.sheduleProperties.on("propertychange", this.shedulePropertiesChange, this);
                this.shedulePropertiesPanel.add(this.sheduleProperties);
            }
        },

        shedulePropertiesChange: function(source, recordId, value, oldValue) {
            this.touch();
        },

        onValuesSelected: function(args) {
            if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) return;
            if (args[0][0]) {
                switch(args[0][0]["RelationID"]) {
                    case "UNIDICT_SELECT":
                    case "DICTIONARY_FORM_GROUP":
                        this.reloadFormsTree();
                        break;
                }
                this.touch();
            }
        },

        getHistoryLink: function(){
            var historyCombo = this.getToolbarItem(this.budgetTreePanel, null, 'ComboVersions');
            var historyLink = null;
            if (historyCombo)
                historyLink = historyCombo.getValue();
            return historyLink;
        },
    });
}(PlannerEditView.prototype));

// ============= PERIODS =======================
(function (viewClass) {
    KS.apply(viewClass, {

        addPeriod: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddPeriod',
                disableFog: true,
                success: function(dataRow) {
                    view.periodsGrid.addRecord(dataRow);
                    view.touch();
                }
            });
        },

        copyPeriod: function() {
            var view = this.parentView || this;
            var checkedCodes = view.periodsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'CopyPeriod',
                    params: [checkedCodes[0]],
                    disableFog: true,
                    success: function(dataRow) {
                        if (!Ext.isEmpty(dataRow)) {
                            var newRec = view.periodsGrid.addRecord(dataRow);
                            view.periodsGrid.getSelectionModel().select([newRec]);
                            view.touch();
                        }
                    }
                });
            }
        },

        deletePeriods: function() {
            var view = this.parentView || this;
            var checkedRows = view.periodsGrid.getCheckedRows();
            var checkedCodes = view.periodsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                KS.confirm("Будет удалено строк: " + checkedCodes.length + ". Продолжить?" , "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.doDeletePeriods(checkedCodes, checkedRows);
                });
            }
        },

        doDeletePeriods: function(checkedCodes, checkedRows) {
            var view = this;
            view.serverCall({
                method: 'DeletePeriods',
                params: [checkedCodes],
                disableFog: true,
                success: function() {
                    view.periodsGrid.getStore().remove(checkedRows);
                    view.touch();
                }
            });
        },

        editPeriodsGridCell: function(e, context) {
            if (context.value === null) return false;
            if (context.value === context.originalValue) return false;
            var dataIndex = context.column.dataIndex;
            var closeCode = KS.Grid.getAnyCase(context.record, "ENTITY_CLOSE_CODE");
            var newValue = context.value;
            var view = this;
            view.serverCall({
                method: 'EditPeriod',
                params: [dataIndex, closeCode, newValue],
                disableFog: true,
                success: function(result) {
                    if (result)
                        view.touch();
                }
            });
            return true;
        },
        
        periodsGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var dataIndex = column.dataIndex;
            if (dataIndex === "PERIOD_NUMBER") {
                var periodType = KS.Grid.getAnyCase(record, "PERIOD_TYPE");
                    
                switch(periodType) {
                    case "2":
                    case 2:
                    case "4":
                    case 4:
                        try {
                            var valuesListEditor = eval(window.periodNumberValuesListEditor);
                            column.setEditor(new valuesListEditor({
                                    grid : gridView.grid,
                                    col : column
                                }));
                            return true;
                        } catch (e) {
                            return false;
                        }

                    default:
                        try {
                            var numberEditor = eval(KS.Ext.Grid.numberEditor);
                            var columnEditor = new numberEditor();
                            columnEditor.setMinValue(0);
                            columnEditor.setHideTrigger(true);
                            column.setEditor(columnEditor);
                            return true;
                        } catch (e) {
                            return false;
                        }
                }
            }
            return true;
        }
    });
}(PlannerEditView.prototype));

// ============= USERS =======================
(function (viewClass) {
    KS.apply(viewClass, {

        addUser: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddUser',
                params: [view.getHistoryLink()]
            });
        },

        addGroup: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddGroup',
                params: [view.getHistoryLink()]
            });
        },

        onServerShowAddUsersGrid: function(addUsersGrid, title){
            if (Ext.isEmpty(addUsersGrid)) return;
            var view = this;
            this.addUsersGrid = this.createTemplateControl(addUsersGrid);
            this.addUsersWin = KS.showModal(this.addUsersGrid,
                {
                    title: title,
                    autoHeight: false,
                    layout: "fit",
                    minWidth: 400,
                    minHeight: 300,
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.addSelectedUsers();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.addUsersWin.close();
                            }
                        }]
                }, true);
        },

        addSelectedUsers: function() {
            var view = this;
            var selectedRows = view.addUsersGrid.getCheckedRows();
            if (!Ext.isEmpty(selectedRows)) {
                view.addUsersWin.close();
                var usersData = [];
                Ext.each(selectedRows, function(userRow){
                    usersData.push({
                        "LINK_USER" : KS.Grid.getAnyCase(userRow, "LINK_USER"),
                        "LOGIN" : KS.Grid.getAnyCase(userRow, "LOGIN"),
                        "FIO" : KS.Grid.getAnyCase(userRow, "FIO") || ""
                    });
                });
                view.serverCall({
                    method: 'AddSelectedUsers',
                    params: [usersData],
                    success: function() {
                        view.usersGrid.reload();
                        view.touch();
                    }
                });
            }
        },

        deleteUsers: function() {
            var view = this.parentView || this;
            var checkedRows = view.usersGrid.getCheckedRows();
            var checkedCodes = view.usersGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                KS.confirm("Будет удалено строк: " + checkedCodes.length + ". Продолжить?" , "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.doDeleteUsers(checkedCodes, checkedRows);
                });
            }
        },

        doDeleteUsers: function(checkedCodes, checkedRows) {
            var view = this;
            view.serverCall({
                method: 'DeleteUsers',
                params: [checkedCodes],
                disableFog: true,
                success: function() {
                    view.usersGrid.getStore().remove(checkedRows);
                    view.touch();
                }
            });
        }
    });
}(PlannerEditView.prototype));

// ============= BUDGET_TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {

        reloadBudgetTree: function() {
            this.budgetTree.getRootNode().removeAll(true);
            this.budgetTree.fullReload();
        },

        budgetTreeCheckChange: function() {
            this.touch();
        },
        
        getCheckedBudgetTreeNodesId: function () {
            var r = [];
            Ext.each(this.budgetTree.getChecked(), function (node) {
                r.push(node.id);
            });
            return r;
        },

        markInvertHandler: function() {
            var view = this.parentView || this;
            var grid = this.parentView.findOwnerGrid(this);
            if (grid) 
                grid.markInvert();
            else
                view.budgetTree.invertAll();
        },

        markAllHandler: function() {
            var view = this.parentView || this;
            var grid = this.parentView.findOwnerGrid(this);
            if (grid) 
                grid.markAll();
            else
                view.budgetTree.checkAll();
        },

        unmarkHandler: function() {
           var view = this.parentView || this;
           var grid = this.parentView.findOwnerGrid(this);
           if (grid) 
               grid.unmark();
           else
               view.budgetTree.uncheckAll();
        },

        checkChildrenNodes: function() {
           var view = this.parentView || this;
           view.budgetTree.checkAllChildren();
        },

        checkDirectChildrenNodes: function() {
           var view = this.parentView || this;
           view.budgetTree.checkDirectChildren();
        },

        checkLeafNodes: function() {
           var view = this.parentView || this;
           view.budgetTree.checkAllLeafs();
        },

        collapseAllNodes: function() {
           var view = this.parentView || this;
           view.budgetTree.collapseAll();
        },

        expandAllNodes: function() {
           var view = this.parentView || this;
           view.budgetTree.expandAll();
        },
        
        changeSearchPanelVisible: function() {
            var view = this.parentView || this;
            var searchPanel = view[this.panelId];
            if (searchPanel) {
                if (searchPanel.getHidden())
                    searchPanel.setHidden(false);
                else
                    searchPanel.setHidden(true);
            }
        },

        hideSearchPanel: function() {
            var view = this.parentView || this;
            var searchPanel = view[this.panelId];
            if (searchPanel) {
                searchPanel.setHidden(true);
            }
        },

        // Поиск запускается только при клике на кнопку поиска, 
        // т.к. слишком много узлов и если делать поиск при каждом изменении, сильно подвисает
        searchFieldChange: function() {
            var view = this.parentView || this;
            var searchPanel = view[this.panelId];
            if (!searchPanel) return;

            var searchField = view.getToolbarItem(searchPanel, null, "searchField_" + this.panelId);
            if (searchField) {
                var newVal = searchField.getValue();

                var tree = view[this.treeId];

                if (!tree) return;

                tree.ksObjs.ksProgressBar.showProgressBar();

                if (newVal.indexOf('/') !== -1) {
                    var splitted = newVal.split('/ ');
                    if (splitted && splitted.length) {
                        newVal = splitted[splitted.length - 1];
                    }
                }

                if (Ext.isEmpty(newVal)) {
                    tree.store.clearFilter();
                    tree.collapseAll();
                } else {
                    var stringCompare = function(val, filterVal) {
                            return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                        },
                        store = tree.store;

                    //Фильтрация снизу вверх
                    store.filterer = 'bottomup';
                    store.filter({
                        property: 'text',
                        filterFn: function(item) {
                            var ind = stringCompare(item.get('text'), newVal);
                            return Ext.isNumber(ind) && ind !== -1;
                        },
                        value: newVal
                    });

                    tree.expandAll(); // При вводе одного знака подвисает
                }

                if (view.updateTimeoutId) clearTimeout(view.updateTimeoutId);
                view.updateTimeoutId = setTimeout(
                    function() {
                        delete view.updateTimeoutId;
                        tree.ksObjs.ksProgressBar.hideProgressBar();
                    },
                    1500);
            }
        },

        clearSearchField: function() {
            var view = this.parentView || this;
            var searchPanel = view[this.panelId];
            if (!searchPanel) return;
            var searchField = view.getToolbarItem(searchPanel, null, "searchField_" + this.panelId);
            if (searchField) {
                searchField.setValue("");
                view.searchFieldChange.call(this);
            }
        },

        onlyCheckedChange: function(component, newValue) {
            var view = this.parentView || this;
            var filters = view.budgetTree.store.getFilters();
            if (newValue) 
                filters.add(view.applyFilterToNodes);
            else
                filters.remove(view.applyFilterToNodes);
        },

        applyFilterToNodes: function(node) {
            var isNodeHasCheckedChild = false;
            var hasCheckedChildNodes = function(node) {
                if (node.get("checked") === true) {
                    isNodeHasCheckedChild = true;
                } else {
                    if (node.hasChildNodes()) {
                        Ext.each(node.childNodes,
                            function(childNode) {
                                hasCheckedChildNodes(childNode);
                            });
                    }
                }
            };
            hasCheckedChildNodes(node);
            return !!(node.get("checked") || node.isRoot() || isNodeHasCheckedChild);
        },
        
        selectBudgetTreeVersion: function(combo, newValue) {
            var view = this.parentView || this;
            var selectRecord = combo.findRecord(combo.valueField, newValue);
            if (selectRecord) {
                view.serverCall({
                    method: 'SelectBudgetTreeVersion',
                    params: [newValue],
                    waitMessage: 'Загрузка дерева бюджетов...',
                    success: function() {
                        view.budgetTree.getRootNode().removeAll(true);
                        view.budgetTree.fullReload();
                    }
                });
            }
        }
    });
}(PlannerEditView.prototype));

// ============= FORMS_TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {

        reloadFormsTree: function() {
            this.formsTree.getRootNode().removeAll(true);
            this.formsTree.fullReload();
        },

        formsTreeRendered: function(comp) {
            var view = this;
            // Для обработки кликов по гиперссылкам(атрибуты и автозаполнение)
            comp.body.on('click', function(event) {
                view.formsTreeLinkClick(event);
            });
        },

        formsTreeLinkClick: function(e) {
            if (e.target.href) {
                e.preventDefault();
                this.serverCall({
                    method: 'FormsTreeLinkClicked',
                    params: [e.target.href],             
                    disableFog: true
                });
            }
        },

        onServerShowAutofillGrid: function(autofillGrid) {
            if (Ext.isEmpty(autofillGrid)) return;
            var view = this;
            this.autofillGrid = this.createTemplateControl(autofillGrid);
            this.autofillWin = KS.showModal(this.autofillGrid,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: "fit",
                    minWidth: 400,
                    minHeight: 300,
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.setAutofill();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.autofillWin.close();
                            }
                        }]
                }, true);
        },

        setAutofill: function() {
            var view = this;
            var selectedRows = view.autofillGrid.getCheckedRows();
            if (!Ext.isEmpty(selectedRows) && view.autofillGrid.link) {
                var link = view.autofillGrid.link;
                var linkGroup = KS.Grid.getAnyCase(selectedRows[0], "LINK_GROUP");
                view.autofillWin.close();
                view.serverCall({
                    method: 'SetAutofill',
                    params: [link, linkGroup],             
                    success: function() {
                        view.reloadFormsTree();
                        view.touch();
                    }
                });
            }
        },

        addForms: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddForms'
            });
        },

        copyForm: function() {
            var view = this.parentView || this;
            var selNodeId = view.formsTree.getSelNodeId();
            if (!Ext.isEmpty(selNodeId)) {
                view.serverCall({
                    method: 'CopyForm',
                    params: [selNodeId],
                    success: function(result) {
                        if (result) {
                            view.reloadFormsTree();
                            view.touch();
                        }
                    }
                });
            }
        },

        deleteForms: function() {
            var view = this.parentView || this;
            var checkedNodes = view.formsTree.getChecked();
            var checkedCodes = [];
            Ext.each(checkedNodes, function(node) {
                if (Ext.isNumeric(node.id))
                    checkedCodes.push(node.id);
            });

            if (Ext.isEmpty(checkedCodes) && Ext.isNumeric(view.formsTree.getSelNodeId())) {
                checkedCodes.push(view.formsTree.getSelNodeId());
            }

            if (!Ext.isEmpty(checkedCodes)) {
                KS.confirm("Будет удалено строк: " + checkedCodes.length + ". Продолжить?" , "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.doDeleteForms(checkedCodes);
                });
            }
        },

        doDeleteForms: function(checkedCodes) {
            var view = this;
            view.serverCall({
                method: 'DeleteForms',
                params: [checkedCodes],
                success: function() {
                    view.reloadFormsTree();
                    view.touch();
                }
            });
        },

        invertFormsNodes: function() {
            var view = this.parentView || this;
            var rootNode = view.formsTree.getRootNode();
            if (rootNode && !Ext.isEmpty(rootNode.childNodes)) {
                Ext.each(rootNode.childNodes, function(node) {
                    node.set('checked', !node.data.checked);
                });
            }
        },

        uncheckFormsNodes: function() {
            var view = this.parentView || this;
            var rootNode = view.formsTree.getRootNode();
            if (rootNode && !Ext.isEmpty(rootNode.childNodes)) {
                Ext.each(rootNode.childNodes, function(node) {
                    node.set('checked', false);
                });
            }
        },
        
        collapseAllFormsNodes: function() {
            var view = this.parentView || this;
            view.formsTree.collapseAll();
        },

        expandAllFormsNodes: function() {
            var view = this.parentView || this;
            view.formsTree.expandAll();
        },

        formsTreeCheckChange: function(node, checked) {
            if (node.id.indexOf("_Attr") !== -1 ||
                node.id.indexOf("_KS") !== -1) {
                var view = this;
                view.serverCall({
                    method: 'FormsTreeCheckChange',
                    params: [node.id, checked],
                    disableFog: true,
                    success: function() {
                        view.reloadFormsTree();
                        view.touch();
                    }
                });
            }
        },

        onServerNumericAttrEditor: function(link, decimalLength) {
            var view = this;
            var numberCfg = {
                maxValue: 99999999,
                minValue: -99999999,
                value: 0,
                fieldStyle: {
                    textAlign: 'right'
                }
            };

            if (decimalLength > 0) {
                numberCfg.allowDecimals = true;
                numberCfg.decimalPrecision = decimalLength;
            } 

            this.numericAttrEditor = new Ext.form.field.Number(numberCfg);

            this.numericAttrWin = KS.showModal(this.numericAttrEditor,
                {
                    title: 'Введите значение',
                    autoHeight: false,
                    layout: "fit",
                    resizable: false,
                    minWidth: 200,
                    minHeight: 105,
                    width: 200,
                    height: 105,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.setNumericAttrValue(link);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.numericAttrWin.close();
                            }
                        }]
                }, true);
        },

        setNumericAttrValue: function(link) {
            var view = this;
            var attrValue = this.numericAttrEditor.getValue();
            view.serverCall({
                method: 'SetNumericAttrValue',
                params: [link, attrValue],
                disableFog: true,
                success: function() {
                    view.numericAttrWin.close();
                    view.reloadFormsTree();
                    view.touch();
                }
            });
        },

        onServerStringAttrEditor: function(link, maxLength) {
            var view = this;
            var stringCfg = {
                maxLength : maxLength
            };
            
            this.stringAttrEditor = new Ext.form.field.TextArea(stringCfg);

            this.stringAttrWin = KS.showModal(this.stringAttrEditor,
                {
                    title: 'Введите значение',
                    autoHeight: false,
                    layout: "fit",
                    minWidth: 300,
                    minHeight: 400,
                    width: Math.max(400, KS.rootViewport.getWidth() / 3),
                    height: 400,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.setStringAttrValue(link);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.stringAttrWin.close();
                            }
                        }]
                }, true);
        },

        setStringAttrValue: function(link) {
            var view = this;
            var attrValue = this.stringAttrEditor.getValue();
            view.serverCall({
                method: 'SetStringAttrValue',
                params: [link, attrValue],
                disableFog: true,
                success: function() {
                    view.stringAttrWin.close();
                    view.reloadFormsTree();
                    view.touch();
                }
            });
        },
    });
}(PlannerEditView.prototype));

function periodNumberValuesListRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var vl = store.grid.valueLists;
    if (vl) {
        var colCfg = store.grid.getColCfgByIndex(colIndex);
        var colDataIndex = colCfg.dataIndex;

        var periodType = KS.Grid.getAnyCase(record, "PERIOD_TYPE");

        switch(periodType) {
            case "2":
            case 2:
                colDataIndex = "QUARTER_PERIOD";
                break;
            
            case "4":
            case 4:
                colDataIndex = "MONTH_PERIOD";
                break;
        }

        colCfg.vlItems = {};
        Ext.each(vl, function (vlEl) {
            if (vlEl.ColumnKey.toUpperCase() === colDataIndex.toUpperCase()) {
                Ext.each(vlEl.Items, function (item) {
                    colCfg.vlItems[item.StringDataValue] = item.DisplayText;
                });
            }
        });
        return colCfg.vlItems[value] || value;
    }
    return value;
}

Ext.define('periodNumberValuesListEditor',
    {
        extend: 'Ext.form.ComboBox',
        displayField: 'text',
        valueField: 'value',
        editable: false,
        constructor: function(cfg) {
            var grid = cfg.grid,
                view = grid.parentView,
                vl = grid.valueLists,
                comboData = [];
            var colCfg = cfg.col;
            if (!colCfg.vlItems) {
                colCfg.vlItems = {};
                Ext.each(vl, function(vlEl) {
                    if (vlEl.ColumnKey.toUpperCase() === colCfg.dataIndex.toUpperCase()) {
                        Ext.each(vlEl.Items, function(item) {
                            colCfg.vlItems[item.StringDataValue] = item.DisplayText;
                        });
                    }
                });
            }
            
            for (var item in colCfg.vlItems) {
                if (colCfg.vlItems.hasOwnProperty(item)) {
                    comboData.push({
                        "value": item,
                        "text": colCfg.vlItems[item]
                    });
                }
            }

            KS.apply(cfg, {
                comboData: comboData,
                parentView: view,
                displayField: 'text',
                valueField: 'value'
            });

            cfg.store = Ext.create('Ext.data.Store', {
                fields: ['value', 'text'],
                data: comboData
            });

            window.periodNumberValuesListEditor.superclass.constructor.call(this, cfg);
        }
    });

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();